/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import weixin.cms.common.CmsDataContent;
import weixin.cms.util.CmsCollectExcutor;
import weixin.cms.util.CmsFreemarkerHelper;
import weixin.guanjia.account.entity.WeixinAccountEntity;

public abstract class CmsIdeaController
extends BaseController {
    public static final String ROOT_URL = "/template/common";
    public static final String DEFAULT_STYLE = "";
    public static final String PAGE_INDEX = ".html";
    @Autowired
    private SystemService systemService;
    private static Map<String, Object> dataCollectContent = new HashMap<String, Object>();

    @RequestMapping(params={"goPage"})
    public void goPage(HttpServletRequest request, HttpServletResponse response, @RequestParam String page) {
        Map<String, String> params = this.paramsToMap(request);
        ResourceUtil.initQianTaiRequestAccountId((HttpServletRequest)request);
        String accountId = request.getParameter("accountid");
        String openId = request.getParameter("openId");
        HttpSession session = request.getSession();
        if (StringUtils.isNotEmpty((String)accountId)) {
            WeixinAccountEntity weixinAccount = (WeixinAccountEntity)this.systemService.getEntity(WeixinAccountEntity.class, (Serializable)((Object)accountId));
            session.setAttribute("WEIXIN_ACCOUNT", (Object)weixinAccount);
        }
        if (StringUtils.isNotEmpty((String)openId)) {
            session.setAttribute("USER_OPENID", (Object)openId);
        }
        if (CmsCollectExcutor.get("cms", page) != null) {
            CmsCollectExcutor.collect("cms", page, params);
        }
        CmsFreemarkerHelper cmsFreemarkerHelper = new CmsFreemarkerHelper();
        String pageUrl = "/template/common/" + page + PAGE_INDEX;
        String html = cmsFreemarkerHelper.parseTemplate(pageUrl, CmsDataContent.loadContent());
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-store");
        try {
            PrintWriter writer = response.getWriter();
            writer.println(html);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Map<String, String> paramsToMap(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration em = request.getParameterNames();
        while (em.hasMoreElements()) {
            String paramName = (String)em.nextElement();
            String paramValue = request.getParameter(paramName);
            params.put(paramName, paramValue);
        }
        return params;
    }
}

