/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.awardquestion.controller;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.web.system.pojo.base.TSBaseUser;
import org.jeecgframework.web.system.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import weixin.idea.awardquestion.entity.WeixinAwardQuestionEntity;
import weixin.idea.awardquestion.entity.WeixinAwardQuestionMainEntity;
import weixin.idea.awardquestion.entity.WeixinAwardQuestionRecordEntity;
import weixin.idea.awardquestion.entity.WeixinAwardQuestionRecordExportView;
import weixin.idea.awardquestion.service.WeixinAwardQuestionMainServiceI;
import weixin.idea.awardquestion.service.WeixinAwardQuestionRecordServiceI;
import weixin.idea.awardquestion.service.WeixinAwardQuestionServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinAwardQuestionRecordController"})
public class WeixinAwardQuestionRecordController
extends BaseController {
    @Autowired
    private WeixinAwardQuestionRecordServiceI weixinAwardQuestionRecordService;
    @Autowired
    private WeixinAwardQuestionMainServiceI weixinAwardQuestionMainService;
    @Autowired
    private WeixinAwardQuestionServiceI weixinAwardQuestionService;
    @Autowired
    private UserService userService;

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinAwardQuestionRecordEntity weixinAwardQuestionRecord, HttpServletRequest request, HttpServletResponse response) {
        CriteriaQuery cq = new CriteriaQuery(WeixinAwardQuestionRecordEntity.class);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinAwardQuestionRecord, (Map)request.getParameterMap());
        try {
            cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List recordlist = this.weixinAwardQuestionRecordService.getListByCriteriaQuery(cq, false);
        ArrayList<WeixinAwardQuestionRecordExportView> viewlist = new ArrayList<WeixinAwardQuestionRecordExportView>();
        List weixinAwardQuestionMainList = this.weixinAwardQuestionMainService.findByProperty(WeixinAwardQuestionMainEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
        List awardQuestionlist = this.weixinAwardQuestionService.findByProperty(WeixinAwardQuestionEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
        List userlist = this.userService.loadAll(TSBaseUser.class);
        for (WeixinAwardQuestionRecordEntity r : recordlist) {
            WeixinAwardQuestionRecordExportView exportView = new WeixinAwardQuestionRecordExportView();
            exportView.setMainTitle("\u5df2\u5220\u9664\u95ee\u5377\u3002");
            exportView.setAnswers(r.getAnswer());
            exportView.setAwardQuestionDate(r.getCreateDate());
            exportView.setAwardQuestionTitle("\u5df2\u5220\u9664\u9898\u76ee");
            exportView.setUsername("\u533f\u540d\u7528\u6237");
            for (WeixinAwardQuestionMainEntity main : weixinAwardQuestionMainList) {
                if (!r.getMainid().equals(main.getId())) continue;
                exportView.setMainTitle(main.getAwardQuestionTitle());
                break;
            }
            for (WeixinAwardQuestionEntity awardQuestion : awardQuestionlist) {
                if (!r.getAwardQuestionid().equals(awardQuestion.getId())) continue;
                exportView.setAwardQuestionTitle(awardQuestion.getAwardQuestionTitle());
                break;
            }
            for (TSBaseUser u : userlist) {
                if (!r.getAwardQuestionid().equals(u.getId()) || StringUtil.isEmpty((String)u.getUserName())) continue;
                exportView.setUsername(u.getUserName());
                break;
            }
            viewlist.add(exportView);
        }
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5fae\u8c03\u7814\u56de\u7b54\u8bb0\u5f55 ";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5fae\u8c03\u7814 \u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinAwardQuestionRecordExportView.class, viewlist);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }
}

