/*
 * Decompiled with CFR 0.152.
 */
package weixin.idea.audio.controller;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.idea.audio.entity.WeixinAudioEntity;
import weixin.idea.audio.entity.WeixinAudioGroupEntity;
import weixin.idea.audio.service.WeixinAudioGroupServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinAudioGroupController"})
public class WeixinAudioGroupController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinAudioGroupController.class);
    @Autowired
    private WeixinAudioGroupServiceI weixinAudioGroupService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinAudioGroup"})
    public ModelAndView weixinAudioGroup(HttpServletRequest request, WeixinAudioGroupEntity weixinAudioGroup) {
        CriteriaQuery cq = new CriteriaQuery(WeixinAudioGroupEntity.class);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinAudioGroup, (Map)request.getParameterMap());
        List groups = this.weixinAudioGroupService.getListByCriteriaQuery(cq, false);
        request.setAttribute("groups", (Object)groups);
        return new ModelAndView("weixin/idea/audio/weixinAudioGroupList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinAudioGroupEntity weixinAudioGroup, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinAudioGroupEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinAudioGroup, (Map)request.getParameterMap());
        this.weixinAudioGroupService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinAudioGroupEntity weixinAudioGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        weixinAudioGroup = (WeixinAudioGroupEntity)this.systemService.getEntity(WeixinAudioGroupEntity.class, (Serializable)((Object)id));
        this.weixinAudioGroupService.deleteFiles(weixinAudioGroup);
        this.message = "\u5fae\u97f3\u9891\u5e93\u5220\u9664\u6210\u529f";
        this.weixinAudioGroupService.delete(weixinAudioGroup);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"delAudio"})
    @ResponseBody
    public AjaxJson delAudio(WeixinAudioEntity weixinAudio, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinAudio = (WeixinAudioEntity)this.systemService.getEntity(WeixinAudioEntity.class, (Serializable)((Object)weixinAudio.getId()));
        this.weixinAudioGroupService.deleteFile(weixinAudio);
        this.message = "\u97f3\u9891\u5220\u9664\u6210\u529f";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinAudioGroupEntity weixinAudioGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String groupId = null;
        if (StringUtil.isNotEmpty((Object)weixinAudioGroup.getId())) {
            this.message = "\u5fae\u97f3\u9891\u5e93\u66f4\u65b0\u6210\u529f";
            groupId = weixinAudioGroup.getId();
            WeixinAudioGroupEntity t = (WeixinAudioGroupEntity)this.weixinAudioGroupService.get(WeixinAudioGroupEntity.class, (Serializable)((Object)weixinAudioGroup.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinAudioGroup, (Object)t);
                this.weixinAudioGroupService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u97f3\u9891\u5e93\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            String accountId = ResourceUtil.getShangJiaAccountId();
            weixinAudioGroup.setAccountid(accountId);
            this.message = "\u5fae\u97f3\u9891\u5e93\u6dfb\u52a0\u6210\u529f";
            groupId = (String)((Object)this.weixinAudioGroupService.save(weixinAudioGroup));
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("groupId", groupId);
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"saveAudio"})
    @ResponseBody
    public AjaxJson saveAudio(WeixinAudioEntity weixinAudio, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)weixinAudio.getId())) {
            this.message = "\u97f3\u9891\u66f4\u65b0\u6210\u529f";
            WeixinAudioEntity t = (WeixinAudioEntity)this.systemService.get(WeixinAudioEntity.class, (Serializable)((Object)weixinAudio.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinAudio, (Object)t);
                this.weixinAudioGroupService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u97f3\u9891\u66f4\u65b0\u5931\u8d25";
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinAudioGroupEntity weixinAudioGroup, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinAudioGroup.getId())) {
            weixinAudioGroup = (WeixinAudioGroupEntity)this.weixinAudioGroupService.getEntity(WeixinAudioGroupEntity.class, (Serializable)((Object)weixinAudioGroup.getId()));
            req.setAttribute("weixinAudioGroupPage", (Object)weixinAudioGroup);
        }
        return new ModelAndView("weixin/idea/audio/weixinAudioGroup");
    }

    @RequestMapping(params={"goEditAudio"})
    public ModelAndView goEditAudio(WeixinAudioEntity weixinAudio, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinAudio.getId())) {
            weixinAudio = (WeixinAudioEntity)this.weixinAudioGroupService.getEntity(WeixinAudioEntity.class, (Serializable)((Object)weixinAudio.getId()));
            req.setAttribute("weixinAudio", (Object)weixinAudio);
        }
        return new ModelAndView("weixin/idea/audio/weixinAudio");
    }

    @RequestMapping(params={"uploadAudioInit"})
    public ModelAndView uploadAudioInit(HttpServletRequest request) {
        request.setAttribute("groupId", (Object)request.getParameter("groupId"));
        return new ModelAndView("weixin/idea/audio/uploadAudio");
    }

    @RequestMapping(params={"viewAudios"})
    public ModelAndView viewAudios(HttpServletRequest request) {
        String id = request.getParameter("id");
        request.setAttribute("id", (Object)id);
        WeixinAudioGroupEntity weixinAudioGroup = (WeixinAudioGroupEntity)this.weixinAudioGroupService.getEntity(WeixinAudioGroupEntity.class, (Serializable)((Object)id));
        List<WeixinAudioEntity> audios = weixinAudioGroup.getAudios();
        if (weixinAudioGroup.getAudio() != null) {
            request.setAttribute("audioId", (Object)weixinAudioGroup.getAudio().getId());
        } else {
            request.setAttribute("audioId", (Object)"");
        }
        request.setAttribute("audios", audios);
        return new ModelAndView("weixin/idea/audio/viewAudios");
    }

    @RequestMapping(params={"saveFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveFiles(HttpServletRequest request, HttpServletResponse response, WeixinAudioEntity audio) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String groupId = oConvertUtils.getString((String)request.getParameter("groupId"));
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            audio.setId(fileKey);
            audio = (WeixinAudioEntity)this.systemService.getEntity(WeixinAudioEntity.class, (Serializable)((Object)fileKey));
        }
        WeixinAudioGroupEntity group = (WeixinAudioGroupEntity)this.systemService.getEntity(WeixinAudioGroupEntity.class, (Serializable)((Object)groupId));
        audio.setGroup(group);
        audio.setName("\u672a\u547d\u540d");
        UploadFile uploadFile = new UploadFile(request, (Object)audio);
        uploadFile.setCusPath("audio");
        uploadFile.setSwfpath("swfpath");
        uploadFile.setByteField(null);
        audio = (WeixinAudioEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", audio.getId());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + audio.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + audio.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"setGroupFace"})
    @ResponseBody
    public AjaxJson setGroupFace(WeixinAudioGroupEntity weixinAudioGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String audioId = request.getParameter("audioId");
        WeixinAudioEntity audio = (WeixinAudioEntity)this.systemService.get(WeixinAudioEntity.class, (Serializable)((Object)audioId));
        WeixinAudioGroupEntity t = (WeixinAudioGroupEntity)this.weixinAudioGroupService.get(WeixinAudioGroupEntity.class, (Serializable)((Object)weixinAudioGroup.getId()));
        t.setAudio(audio);
        this.weixinAudioGroupService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u8bbe\u7f6e\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"cancelGroupFace"})
    @ResponseBody
    public AjaxJson cancelGroupFace(WeixinAudioGroupEntity weixinAudioGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        WeixinAudioGroupEntity t = (WeixinAudioGroupEntity)this.weixinAudioGroupService.get(WeixinAudioGroupEntity.class, (Serializable)((Object)weixinAudioGroup.getId()));
        t.setAudio(null);
        this.weixinAudioGroupService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u53d6\u6d88\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"playAudio"})
    public ModelAndView playAudio(HttpServletRequest request) {
        return new ModelAndView("weixin/idea/audio/playAudio");
    }
}

