/*
 * Decompiled with CFR 0.152.
 */
package weixin.huodong.controller;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.UUIDGenerator;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;
import weixin.huodong.entity.WxHuodongEntity;
import weixin.huodong.entity.WxZhongjiangEntity;
import weixin.huodong.service.WxHuodongServiceI;
import weixin.huodong.service.WxZhongjiangServiceI;
import weixin.huodong.view.WxZhongjiangEntityVo;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/wxZhongjiangController"})
public class WxZhongjiangController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WxZhongjiangController.class);
    @Autowired
    private WxZhongjiangServiceI wxZhongjiangService;
    @Autowired
    private SystemService systemService;
    private String message;
    @Autowired
    private WxHuodongServiceI wxHuodongService;
    private static final String POINT = ".";

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"goSendGoods"})
    public ModelAndView goSendGoods(HttpServletRequest request, WxZhongjiangEntity record) {
        record = (WxZhongjiangEntity)this.wxZhongjiangService.get(WxZhongjiangEntity.class, (Serializable)((Object)record.getId()));
        request.setAttribute("record", (Object)record);
        return new ModelAndView("weixin/huodong/sendgoods");
    }

    @RequestMapping(params={"doSendGoods"})
    @ResponseBody
    public AjaxJson doSendGoods(HttpServletRequest request, WxZhongjiangEntity record) {
        AjaxJson json = new AjaxJson();
        WxZhongjiangEntity record2 = (WxZhongjiangEntity)this.wxZhongjiangService.get(WxZhongjiangEntity.class, (Serializable)((Object)record.getId()));
        record2.setExpressname(record.getExpressname());
        record2.setExpressnumber(record.getExpressnumber());
        record2.setSendstatus("1");
        record2.setSendtime(new Date());
        record2.setSenduser(ResourceUtil.getSessionUserName().getRealName());
        this.systemService.updateEntitie((Object)record2);
        json.setSuccess(true);
        json.setMsg("\u53d1\u8d27\u6210\u529f");
        return json;
    }

    @RequestMapping(params={"wxZhongjiang"})
    public ModelAndView wxZhongjiang(HttpServletRequest request) {
        return new ModelAndView("weixin/huodong/wxZhongjiangList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WxZhongjiangEntity wxZhongjiang, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WxZhongjiangEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)wxZhongjiang, (Map)request.getParameterMap());
        cq.add();
        this.wxZhongjiangService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WxZhongjiangEntity wxZhongjiang, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        wxZhongjiang = (WxZhongjiangEntity)this.systemService.getEntity(WxZhongjiangEntity.class, (Serializable)((Object)wxZhongjiang.getId()));
        this.message = "\u4e2d\u5956\u8bb0\u5f55\u5220\u9664\u6210\u529f";
        try {
            this.wxZhongjiangService.delete(wxZhongjiang);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e2d\u5956\u8bb0\u5f55\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4e2d\u5956\u8bb0\u5f55\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WxZhongjiangEntity wxZhongjiang = (WxZhongjiangEntity)this.systemService.getEntity(WxZhongjiangEntity.class, (Serializable)((Object)id));
                this.wxZhongjiangService.delete(wxZhongjiang);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e2d\u5956\u8bb0\u5f55\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WxZhongjiangEntity wxZhongjiang, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4e2d\u5956\u8bb0\u5f55\u6dfb\u52a0\u6210\u529f";
        try {
            wxZhongjiang.setJpFlag(0);
            wxZhongjiang.setSendstatus("0");
            this.wxZhongjiangService.save(wxZhongjiang);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e2d\u5956\u8bb0\u5f55\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WxZhongjiangEntity wxZhongjiang, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u4e2d\u5956\u8bb0\u5f55\u66f4\u65b0\u6210\u529f";
        WxZhongjiangEntity t = (WxZhongjiangEntity)this.wxZhongjiangService.get(WxZhongjiangEntity.class, (Serializable)((Object)wxZhongjiang.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)wxZhongjiang, (Object)t);
            this.wxZhongjiangService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u4e2d\u5956\u8bb0\u5f55\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WxZhongjiangEntity wxZhongjiang, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)wxZhongjiang.getId())) {
            wxZhongjiang = (WxZhongjiangEntity)this.wxZhongjiangService.getEntity(WxZhongjiangEntity.class, (Serializable)((Object)wxZhongjiang.getId()));
            req.setAttribute("wxZhongjiangPage", (Object)wxZhongjiang);
        }
        List huodongEntities = this.systemService.getList(WxHuodongEntity.class);
        req.setAttribute("huodongEntities", (Object)huodongEntities);
        return new ModelAndView("weixin/huodong/wxZhongjiang-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WxZhongjiangEntity wxZhongjiang, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)wxZhongjiang.getId())) {
            wxZhongjiang = (WxZhongjiangEntity)this.wxZhongjiangService.getEntity(WxZhongjiangEntity.class, (Serializable)((Object)wxZhongjiang.getId()));
            req.setAttribute("wxZhongjiangPage", (Object)wxZhongjiang);
        }
        List huodongEntities = this.systemService.getList(WxHuodongEntity.class);
        req.setAttribute("huodongEntities", (Object)huodongEntities);
        return new ModelAndView("weixin/huodong/wxZhongjiang-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/huodong/wxZhongjiangUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WxZhongjiangEntity wxZhongjiang, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u7528\u6237\u4e2d\u5956\u90ae\u5bc4\u4fe1\u606f";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WxZhongjiangEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)wxZhongjiang, (Map)request.getParameterMap());
                List wxZhongjiangs = this.wxZhongjiangService.getListByCriteriaQuery(cq, false);
                ArrayList<WxZhongjiangEntityVo> wxZhongjiangEntityVos = new ArrayList<WxZhongjiangEntityVo>();
                for (WxZhongjiangEntity wxZhongjiangEntity : wxZhongjiangs) {
                    WxZhongjiangEntityVo vo = new WxZhongjiangEntityVo();
                    BeanUtils.copyProperties((Object)vo, (Object)wxZhongjiangEntity);
                    WxHuodongEntity entity = (WxHuodongEntity)this.systemService.getEntity(WxHuodongEntity.class, (Serializable)((Object)wxZhongjiangEntity.getHuoddongId()));
                    vo.setHuoddongName(entity.getHdName());
                    List typeList = (List)TSTypegroup.allTypes.get("pf_code");
                    for (TSType tsType : typeList) {
                        if (!tsType.getTypecode().equals(wxZhongjiangEntity.getPlatformCode().toString())) continue;
                        vo.setPlatformName(tsType.getTypename());
                    }
                    typeList = (List)TSTypegroup.allTypes.get("jp_level");
                    for (TSType tsType : typeList) {
                        if (!tsType.getTypecode().equals(wxZhongjiangEntity.getJpLevel().toString())) continue;
                        vo.setJpLevel(tsType.getTypename());
                    }
                    typeList = (List)TSTypegroup.allTypes.get("jp_flag");
                    for (TSType tsType : typeList) {
                        if (!tsType.getTypecode().equals(wxZhongjiangEntity.getJpFlag().toString())) continue;
                        vo.setJpFlag(tsType.getTypename());
                    }
                    wxZhongjiangEntityVos.add(vo);
                }
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u7528\u6237\u4e2d\u5956\u90ae\u5bc4\u4fe1\u606f", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u7528\u6237\u4e2d\u5956\u90ae\u5bc4\u4fe1\u606f"), WxZhongjiangEntityVo.class, wxZhongjiangEntityVos);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WxZhongjiangEntity wxZhongjiang, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u4e2d\u5956\u8bb0\u5f55";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u4e2d\u5956\u8bb0\u5f55\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WxZhongjiangEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            try {
                try {
                    ArrayList<WxZhongjiangEntity> listWxZhongjiangEntitys = new ArrayList<WxZhongjiangEntity>();
                    HSSFWorkbook book = null;
                    InputStream inputstream = file.getInputStream();
                    if (!inputstream.markSupported()) {
                        inputstream = new PushbackInputStream(inputstream, 8);
                    }
                    if (POIFSFileSystem.hasPOIFSHeader((InputStream)inputstream)) {
                        book = new HSSFWorkbook(inputstream);
                    } else if (POIXMLDocument.hasOOXMLHeader((InputStream)inputstream)) {
                        book = new XSSFWorkbook(OPCPackage.open((InputStream)inputstream));
                    }
                    Iterator rows = book.getSheetAt(0).rowIterator();
                    rows.next();
                    while (rows.hasNext()) {
                        Row row = (Row)rows.next();
                        WxZhongjiangEntity entityWxZhongjiangEntity = new WxZhongjiangEntity();
                        String platformName = row.getCell(0).toString();
                        if (StringUtil.isEmpty((String)platformName)) continue;
                        List typeList = (List)TSTypegroup.allTypes.get("pf_code");
                        for (TSType tsType : typeList) {
                            if (!tsType.getTypename().equals(platformName)) continue;
                            entityWxZhongjiangEntity.setPlatformCode(Integer.valueOf(tsType.getTypecode()));
                        }
                        entityWxZhongjiangEntity.setUserAccount(row.getCell(1) == null ? "" : row.getCell(1).toString());
                        String hdName = row.getCell(2) == null ? "" : row.getCell(2).toString();
                        WxHuodongEntity huodongEntity = (WxHuodongEntity)this.systemService.findUniqueByProperty(WxHuodongEntity.class, "hdName", (Object)hdName);
                        if (huodongEntity != null) {
                            entityWxZhongjiangEntity.setHuoddongId(huodongEntity.getId());
                        }
                        entityWxZhongjiangEntity.setJpName(row.getCell(3) == null ? "" : row.getCell(3).toString());
                        entityWxZhongjiangEntity.setJpCode(row.getCell(4) == null ? "" : row.getCell(4).toString());
                        entityWxZhongjiangEntity.setJpLevel(row.getCell(5) == null ? 0 : Double.valueOf(row.getCell(5).getNumericCellValue()).intValue());
                        entityWxZhongjiangEntity.setJpFlag(0);
                        listWxZhongjiangEntitys.add(entityWxZhongjiangEntity);
                    }
                    for (WxZhongjiangEntity wxZhongjiang : listWxZhongjiangEntitys) {
                        this.wxZhongjiangService.save(wxZhongjiang);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }

    @RequestMapping(params={"index"}, method={RequestMethod.GET})
    public ModelAndView index() {
        ModelAndView modelAndView = new ModelAndView("weixin/huodong/wxHuoDong");
        List list = this.wxHuodongService.getList(WxHuodongEntity.class);
        ArrayList<WxHuodongEntity> wxhoudongList = new ArrayList<WxHuodongEntity>();
        for (Object object : list) {
            WxHuodongEntity wxhuodong = (WxHuodongEntity)object;
            wxhoudongList.add(wxhuodong);
        }
        modelAndView.addObject("wxhuodongList", wxhoudongList);
        return modelAndView;
    }

    @RequestMapping(params={"validate"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson validate(HttpServletRequest request) {
        WxZhongjiangEntity wxZhongjiangEntity;
        AjaxJson j = new AjaxJson();
        String jpCode = request.getParameter("jpCode");
        String hdid = request.getParameter("hdid");
        String platform = request.getParameter("platform");
        if ("wx".equals(platform)) {
            String userAccount = request.getParameter("userName");
            LogUtil.info((Object)("-----\u5151\u5956\u7528\u6237\u540d----------------------------" + userAccount));
            wxZhongjiangEntity = this.wxZhongjiangService.getWxZhongjiangEntitybyUserAccount(userAccount);
        } else {
            wxZhongjiangEntity = this.wxZhongjiangService.getWxZhongjiangEntitybyJpCodeAndHdId(jpCode, hdid);
        }
        if (wxZhongjiangEntity != null) {
            if (wxZhongjiangEntity.getJpFlag() != 0) {
                j.setSuccess(false);
                j.setMsg("\u5df2\u7ecf\u5151\u5956\uff0c\u4e0d\u80fd\u91cd\u590d\u5151\u5956!");
            } else {
                j.setObj((Object)wxZhongjiangEntity.getId());
                j.setSuccess(true);
            }
        } else {
            j.setSuccess(false);
            j.setMsg("\u5151\u5956\u4fe1\u606f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165!");
        }
        return j;
    }

    @RequestMapping(params={"next"}, method={RequestMethod.GET})
    public ModelAndView next(HttpServletRequest request) {
        ModelAndView modelAndView = new ModelAndView("weixin/huodong/wxHuoDongNext");
        String id = request.getParameter("id");
        WxZhongjiangEntity wxZhongjiangEntity = (WxZhongjiangEntity)this.wxZhongjiangService.get(WxZhongjiangEntity.class, (Serializable)((Object)id));
        modelAndView.addObject("wxZhongjiangEntity", (Object)wxZhongjiangEntity);
        return modelAndView;
    }

    @RequestMapping(params={"saveAndUpload"}, method={RequestMethod.POST})
    public ModelAndView saveAndUpload(@ModelAttribute(value="wxZhongjiangEntity") WxZhongjiangEntity wxZhongjiangEntity, @RequestParam(value="file") CommonsMultipartFile[] files, HttpServletRequest request) {
        ModelAndView modelAndView = new ModelAndView("weixin/huodong/success");
        WxZhongjiangEntity wxZhongjiangEntity2 = (WxZhongjiangEntity)this.wxZhongjiangService.get(WxZhongjiangEntity.class, (Serializable)((Object)wxZhongjiangEntity.getId()));
        if (wxZhongjiangEntity2.getJpFlag() == 1) {
            modelAndView.setView((View)new RedirectView("wxZhongjiangController.do?index"));
            return modelAndView;
        }
        wxZhongjiangEntity2.setJpFlag(1);
        wxZhongjiangEntity2.setSendstatus("0");
        wxZhongjiangEntity2.setUpdateDate(new Date());
        wxZhongjiangEntity2.setUserTelphone(wxZhongjiangEntity.getUserTelphone());
        wxZhongjiangEntity2.setUserAnme(wxZhongjiangEntity.getUserAnme());
        wxZhongjiangEntity2.setUserAddress(wxZhongjiangEntity.getUserAddress());
        wxZhongjiangEntity2.setContent(wxZhongjiangEntity.getContent());
        String contextUploadPath = "upload" + File.separator + "zhongjiang";
        String path = request.getSession().getServletContext().getRealPath(contextUploadPath);
        if (files != null && files.length > 0) {
            int i = 0;
            while (i < files.length) {
                if (!files[i].isEmpty()) {
                    try {
                        String originalFilename = files[i].getOriginalFilename();
                        String kname = StringUtils.substringAfterLast((String)originalFilename, (String)POINT);
                        String fileName = String.valueOf(UUIDGenerator.generate()) + POINT + kname;
                        String filePath = String.valueOf(contextUploadPath) + File.separator + fileName;
                        File targetFile = new File(path, fileName);
                        if (!targetFile.exists()) {
                            targetFile.mkdirs();
                        }
                        files[i].transferTo(targetFile);
                        if (i == 0) {
                            wxZhongjiangEntity2.setIdcardAFile(filePath);
                        } else {
                            wxZhongjiangEntity2.setIdcardBFile(filePath);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LogUtil.info((Object)"\u4e0a\u4f20\u51fa\u9519");
                    }
                }
                ++i;
            }
        }
        this.wxZhongjiangService.updateEntitie(wxZhongjiangEntity2);
        return modelAndView;
    }

    @RequestMapping(params={"save"}, method={RequestMethod.POST})
    public ModelAndView save(@ModelAttribute(value="wxZhongjiangEntity") WxZhongjiangEntity wxZhongjiangEntity) {
        ModelAndView modelAndView = new ModelAndView("weixin/huodong/success");
        WxZhongjiangEntity wxZhongjiangEntity2 = (WxZhongjiangEntity)this.wxZhongjiangService.get(WxZhongjiangEntity.class, (Serializable)((Object)wxZhongjiangEntity.getId()));
        if (wxZhongjiangEntity2.getJpFlag() == 1) {
            modelAndView.setView((View)new RedirectView("wxZhongjiangController.do?index"));
            return modelAndView;
        }
        wxZhongjiangEntity2.setJpFlag(1);
        wxZhongjiangEntity2.setUpdateDate(new Date());
        wxZhongjiangEntity2.setUserTelphone(wxZhongjiangEntity.getUserTelphone());
        wxZhongjiangEntity2.setUserAnme(wxZhongjiangEntity.getUserAnme());
        wxZhongjiangEntity2.setUserAddress(wxZhongjiangEntity.getUserAddress());
        wxZhongjiangEntity2.setContent(wxZhongjiangEntity.getContent());
        this.wxZhongjiangService.updateEntitie(wxZhongjiangEntity2);
        return modelAndView;
    }
}

