/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.videosucai.controller;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.videosucai.entity.WeixinVideosucaiEntity;
import weixin.guanjia.videosucai.entity.WeixinVideosucaiGroupEntity;
import weixin.guanjia.videosucai.service.WeixinVideosucaiGroupServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinVideosucaiGroupController"})
public class WeixinVideosucaiGroupController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinVideosucaiGroupController.class);
    @Autowired
    private WeixinVideosucaiGroupServiceI weixinVideosucaiGroupService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinVideosucaiGroup"})
    public ModelAndView weixinVideosucaiGroup(HttpServletRequest request, WeixinVideosucaiGroupEntity weixinVideosucaiGroup) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVideosucaiGroupEntity.class);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinVideosucaiGroup, (Map)request.getParameterMap());
        List groups = this.weixinVideosucaiGroupService.getListByCriteriaQuery(cq, false);
        request.setAttribute("groups", (Object)groups);
        return new ModelAndView("weixin/guanjia/videosucai/weixinVideosucaiGroupList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinVideosucaiGroupEntity weixinVideosucaiGroup, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinVideosucaiGroupEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinVideosucaiGroup, (Map)request.getParameterMap());
        this.weixinVideosucaiGroupService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinVideosucaiGroupEntity weixinVideosucaiGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        weixinVideosucaiGroup = (WeixinVideosucaiGroupEntity)this.systemService.getEntity(WeixinVideosucaiGroupEntity.class, (Serializable)((Object)id));
        this.weixinVideosucaiGroupService.deleteFiles(weixinVideosucaiGroup);
        this.message = "\u5fae\u89c6\u9891\u5e93\u5220\u9664\u6210\u529f";
        this.weixinVideosucaiGroupService.delete(weixinVideosucaiGroup);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"delVideosucai"})
    @ResponseBody
    public AjaxJson delVideosucai(WeixinVideosucaiEntity weixinVideosucai, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinVideosucai = (WeixinVideosucaiEntity)this.systemService.getEntity(WeixinVideosucaiEntity.class, (Serializable)((Object)weixinVideosucai.getId()));
        this.weixinVideosucaiGroupService.deleteFile(weixinVideosucai);
        this.message = "\u89c6\u9891\u5220\u9664\u6210\u529f";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"synchVideosucai"})
    @ResponseBody
    public AjaxJson synchVideosucai(WeixinVideosucaiEntity weixinVideosucai, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinVideosucai = (WeixinVideosucaiEntity)this.systemService.getEntity(WeixinVideosucaiEntity.class, (Serializable)((Object)weixinVideosucai.getId()));
        String accessToken = this.weixinAccountService.getAccessToken();
        String url = String.valueOf(request.getSession().getServletContext().getRealPath("")) + System.getProperty("file.separator") + weixinVideosucai.getRealpath();
        JSONObject jsonObj = WeixinUtil.sendMedia("video", url, accessToken);
        if (jsonObj != null) {
            if (jsonObj.containsKey((Object)"errcode")) {
                String errcode = jsonObj.getString("errcode");
                String errmsg = jsonObj.getString("errmsg");
                j.setSuccess(false);
                this.message = "\u89c6\u9891\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5931\u8d25\u3010errcode=" + errcode + "\u3011\u3010errmsg=" + errmsg + "\u3011";
                this.systemService.addLog("\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\uff1a" + this.message, Globals.Log_Type_OTHER, Globals.Log_Leavel_INFO);
            } else {
                this.message = "\u89c6\u9891\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u6210\u529f";
                String media_id = jsonObj.getString("media_id");
                String created_at = jsonObj.getString("created_at");
                weixinVideosucai.setMediaId(media_id);
                weixinVideosucai.setSynchDate(new Date());
                weixinVideosucai.setSynchFlag("true");
                this.weixinVideosucaiGroupService.saveOrUpdate(weixinVideosucai);
                this.systemService.addLog("\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\uff1a" + this.message + "\u3010media_id=" + media_id + "\u3011\u3010created_at=" + created_at + "\u3011", Globals.Log_Type_OTHER, Globals.Log_Leavel_INFO);
                j.setSuccess(true);
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"batchSynchSucai"})
    @ResponseBody
    public AjaxJson batchSynchSucai(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String[] idarray = ids.split(",");
        int succ = 0;
        int error = 0;
        String[] stringArray = idarray;
        int n = idarray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            WeixinVideosucaiEntity sucai = (WeixinVideosucaiEntity)this.systemService.getEntity(WeixinVideosucaiEntity.class, (Serializable)((Object)id));
            List sucais = this.systemService.findByQueryString("from WeixinVideosucaiEntity where code='" + sucai.getCode() + "' and postcode like '" + sucai.getPostcode() + "%'");
            for (WeixinVideosucaiEntity sc : sucais) {
                String accessToken = this.weixinAccountService.getAccessToken(sc.getAccountid());
                String url = String.valueOf(request.getSession().getServletContext().getRealPath("")) + System.getProperty("file.separator") + sc.getRealpath();
                JSONObject jsonObj = WeixinUtil.sendMedia("video", url, accessToken);
                if (jsonObj == null) continue;
                if (jsonObj.containsKey((Object)"errcode")) {
                    String errcode = jsonObj.getString("errcode");
                    String errmsg = jsonObj.getString("errmsg");
                    j.setSuccess(false);
                    this.message = "\u89c6\u9891\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5931\u8d25\u3010errcode=" + errcode + "\u3011\u3010errmsg=" + errmsg + "\u3011";
                    this.systemService.addLog("\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\uff1a" + this.message, Globals.Log_Type_OTHER, Globals.Log_Leavel_INFO);
                    ++error;
                    continue;
                }
                this.message = "\u89c6\u9891\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u6210\u529f";
                String media_id = jsonObj.getString("media_id");
                String created_at = jsonObj.getString("created_at");
                sc.setMediaId(media_id);
                sc.setSynchDate(new Date());
                sc.setSynchFlag("true");
                this.weixinVideosucaiGroupService.saveOrUpdate(sc);
                this.systemService.addLog("\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\uff1a" + this.message + "\u3010media_id=" + media_id + "\u3011\u3010created_at=" + created_at + "\u3011", Globals.Log_Type_OTHER, Globals.Log_Leavel_INFO);
                j.setSuccess(true);
                ++succ;
            }
            ++n2;
        }
        j.setSuccess(true);
        this.message = "\u64cd\u4f5c\u5b8c\u6210";
        if (succ > 0) {
            this.message = String.valueOf(this.message) + "\uff0c\u6210\u529f\u4e0a\u4f20" + succ + "\u4e2a";
        }
        if (error > 0) {
            this.message = String.valueOf(this.message) + "\uff0c\u5931\u8d25\u4e0a\u4f20" + error + "\u4e2a";
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinVideosucaiGroupEntity weixinVideosucaiGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String groupId = null;
        if (StringUtil.isNotEmpty((Object)weixinVideosucaiGroup.getId())) {
            this.message = "\u5fae\u89c6\u9891\u5e93\u66f4\u65b0\u6210\u529f";
            groupId = weixinVideosucaiGroup.getId();
            WeixinVideosucaiGroupEntity t = (WeixinVideosucaiGroupEntity)this.weixinVideosucaiGroupService.get(WeixinVideosucaiGroupEntity.class, (Serializable)((Object)weixinVideosucaiGroup.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinVideosucaiGroup, (Object)t);
                this.weixinVideosucaiGroupService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u89c6\u9891\u5e93\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            String accountId = ResourceUtil.getShangJiaAccountId();
            weixinVideosucaiGroup.setAccountid(accountId);
            this.message = "\u5fae\u89c6\u9891\u5e93\u6dfb\u52a0\u6210\u529f";
            groupId = (String)((Object)this.weixinVideosucaiGroupService.save(weixinVideosucaiGroup));
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("groupId", groupId);
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"saveVideosucai"})
    @ResponseBody
    public AjaxJson saveVideosucai(WeixinVideosucaiEntity weixinVideosucai, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)weixinVideosucai.getId())) {
            this.message = "\u89c6\u9891\u66f4\u65b0\u6210\u529f";
            WeixinVideosucaiEntity t = (WeixinVideosucaiEntity)this.systemService.get(WeixinVideosucaiEntity.class, (Serializable)((Object)weixinVideosucai.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinVideosucai, (Object)t);
                this.weixinVideosucaiGroupService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u89c6\u9891\u66f4\u65b0\u5931\u8d25";
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinVideosucaiGroupEntity weixinVideosucaiGroup, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinVideosucaiGroup.getId())) {
            weixinVideosucaiGroup = (WeixinVideosucaiGroupEntity)this.weixinVideosucaiGroupService.getEntity(WeixinVideosucaiGroupEntity.class, (Serializable)((Object)weixinVideosucaiGroup.getId()));
            req.setAttribute("weixinVideosucaiGroupPage", (Object)weixinVideosucaiGroup);
        }
        return new ModelAndView("weixin/guanjia/videosucai/weixinVideosucaiGroup");
    }

    @RequestMapping(params={"goEditVideosucai"})
    public ModelAndView goEditVideosucai(WeixinVideosucaiEntity weixinVideosucai, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinVideosucai.getId())) {
            weixinVideosucai = (WeixinVideosucaiEntity)this.weixinVideosucaiGroupService.getEntity(WeixinVideosucaiEntity.class, (Serializable)((Object)weixinVideosucai.getId()));
            req.setAttribute("weixinVideosucai", (Object)weixinVideosucai);
        }
        return new ModelAndView("weixin/guanjia/videosucai/weixinVideosucai");
    }

    @RequestMapping(params={"uploadVideosucaiInit"})
    public ModelAndView uploadVideosucaiInit(HttpServletRequest request) {
        request.setAttribute("groupId", (Object)request.getParameter("groupId"));
        String accountId = ResourceUtil.getShangJiaAccountId();
        String postCode = ResourceUtil.getShangJiaAccount().getPostCode();
        request.setAttribute("accountId", (Object)accountId);
        request.setAttribute("postCode", (Object)postCode);
        return new ModelAndView("weixin/guanjia/videosucai/uploadVideosucai");
    }

    @RequestMapping(params={"viewVideosucais"})
    public ModelAndView viewVideosucais(HttpServletRequest request) {
        List l = this.weixinVideosucaiGroupService.getList(WeixinVideosucaiGroupEntity.class);
        WeixinVideosucaiGroupEntity weixinVideosucaiGroup = (WeixinVideosucaiGroupEntity)l.get(0);
        String titleName = request.getParameter("titleName");
        List videosucais = this.weixinVideosucaiGroupService.getVideosucaisList(titleName);
        request.setAttribute("id", (Object)weixinVideosucaiGroup.getId());
        if (weixinVideosucaiGroup.getVideosucai() != null) {
            request.setAttribute("videosucaiId", (Object)weixinVideosucaiGroup.getVideosucai().getId());
        } else {
            request.setAttribute("videosucaiId", (Object)"");
        }
        request.setAttribute("videosucais", videosucais);
        return new ModelAndView("weixin/guanjia/videosucai/viewVideosucais");
    }

    @RequestMapping(params={"saveFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveFiles(HttpServletRequest request, HttpServletResponse response, WeixinVideosucaiEntity videosucai) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String shareStatus = oConvertUtils.getString((String)request.getParameter("shareStatus"));
        String groupId = oConvertUtils.getString((String)request.getParameter("groupId"));
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            videosucai.setId(fileKey);
            videosucai = (WeixinVideosucaiEntity)this.systemService.getEntity(WeixinVideosucaiEntity.class, (Serializable)((Object)fileKey));
        }
        WeixinVideosucaiGroupEntity group = (WeixinVideosucaiGroupEntity)this.systemService.getEntity(WeixinVideosucaiGroupEntity.class, (Serializable)((Object)groupId));
        videosucai.setGroup(group);
        videosucai.setName("\u672a\u547d\u540d");
        videosucai.setCode(DataUtils.getDateUUID((String)"yyyyMMddHHmmssSSS"));
        videosucai.setSourceType("1");
        videosucai.setShareStatus(shareStatus);
        String accountId = ResourceUtil.getShangJiaAccountId();
        if (accountId.equals("NULL-NULL-NULL-NULL-NULL-NULL-NULL-NULL-NULL")) {
            accountId = oConvertUtils.getString((String)request.getParameter("accountId"));
            String postCode = oConvertUtils.getString((String)request.getParameter("postCode"));
            videosucai.setPostcode(postCode);
        }
        videosucai.setAccountid(accountId);
        videosucai.setSynchFlag("false");
        UploadFile uploadFile = new UploadFile(request, (Object)videosucai);
        uploadFile.setCusPath("videosucai");
        uploadFile.setSwfpath("swfpath");
        uploadFile.setByteField(null);
        videosucai = (WeixinVideosucaiEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", videosucai.getId());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + videosucai.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + videosucai.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"setGroupFace"})
    @ResponseBody
    public AjaxJson setGroupFace(WeixinVideosucaiGroupEntity weixinVideosucaiGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String videosucaiId = request.getParameter("videosucaiId");
        WeixinVideosucaiEntity videosucai = (WeixinVideosucaiEntity)this.systemService.get(WeixinVideosucaiEntity.class, (Serializable)((Object)videosucaiId));
        WeixinVideosucaiGroupEntity t = (WeixinVideosucaiGroupEntity)this.weixinVideosucaiGroupService.get(WeixinVideosucaiGroupEntity.class, (Serializable)((Object)weixinVideosucaiGroup.getId()));
        t.setVideosucai(videosucai);
        this.weixinVideosucaiGroupService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u8bbe\u7f6e\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"cancelGroupFace"})
    @ResponseBody
    public AjaxJson cancelGroupFace(WeixinVideosucaiGroupEntity weixinVideosucaiGroup, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        WeixinVideosucaiGroupEntity t = (WeixinVideosucaiGroupEntity)this.weixinVideosucaiGroupService.get(WeixinVideosucaiGroupEntity.class, (Serializable)((Object)weixinVideosucaiGroup.getId()));
        t.setVideosucai(null);
        this.weixinVideosucaiGroupService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u53d6\u6d88\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"playVideosucai"})
    public ModelAndView playVideosucai(HttpServletRequest request) {
        return new ModelAndView("weixin/guanjia/videosucai/playVideosucai");
    }

    @RequestMapping(params={"copyData"})
    @ResponseBody
    public AjaxJson copyData(HttpServletRequest req, String weixinVideosucaiId, String accountId) {
        AjaxJson j = new AjaxJson();
        try {
            WeixinAccountEntity accountEntity = (WeixinAccountEntity)this.systemService.getEntity(WeixinAccountEntity.class, (Serializable)((Object)accountId));
            WeixinVideosucaiEntity videosucaiEntity = (WeixinVideosucaiEntity)this.systemService.getEntity(WeixinVideosucaiEntity.class, (Serializable)((Object)weixinVideosucaiId));
            WeixinVideosucaiEntity videosucaiEntityCopyData = new WeixinVideosucaiEntity();
            MyBeanUtils.copyBeanNotNull2Bean((Object)videosucaiEntity, (Object)videosucaiEntityCopyData);
            videosucaiEntityCopyData.setId(null);
            videosucaiEntityCopyData.setAccountid(accountId);
            videosucaiEntityCopyData.setPostcode(accountEntity.getPostCode());
            this.systemService.saveOrUpdate((Object)videosucaiEntityCopyData);
            j.setSuccess(true);
            j.setMsg("\u4e00\u952e\u590d\u5236\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u4e00\u952e\u590d\u5236\u5931\u8d25");
        }
        return j;
    }
}

