/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.tj.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.RoletoJson;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.easyui.TreeGridModel;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.tj.entity.WeixinDataGraphicAnalysisEntity;
import weixin.guanjia.tj.service.WeixinDataGraphicAnalysisServiceI;
import weixin.util.DateUtils;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinDataGraphicAnalysisController"})
public class WeixinDataGraphicAnalysisController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinDataGraphicAnalysisController.class);
    @Autowired
    private WeixinDataGraphicAnalysisServiceI weixinDataGraphicAnalysisService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinDataGraphicAnalysis"})
    public ModelAndView weixinDataGraphicAnalysis(HttpServletRequest request) {
        List weixinAccountList = this.systemService.getList(WeixinAccountEntity.class);
        request.setAttribute("weixinAccountsReplace", (Object)RoletoJson.listToReplaceStr((List)weixinAccountList, (String)"accountname", (String)"id"));
        return new ModelAndView("weixin/guanjia/tj/graphicanalysis/weixinDataGraphicAnalysisList");
    }

    @RequestMapping(params={"weixinAccountTree"})
    @ResponseBody
    public List<TreeGrid> weixinAccountTree(TreeGrid treegrid, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinAccountEntity.class);
        if (treegrid.getId() != null) {
            cq.eq("parentAccount.id", (Object)treegrid.getId());
        } else {
            cq.eq("id", (Object)ResourceUtil.getShangJiaAccount().getId());
        }
        cq.eq("userName", (Object)ResourceUtil.getSessionUserName().getUserName());
        cq.add();
        List menuList = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("accountname");
        treeGridModel.setParentText("parentAccount_accountname");
        treeGridModel.setParentId("parentAccount_id");
        treeGridModel.setSrc("");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("accountlist");
        treeGrids = this.systemService.treegrid(menuList, treeGridModel);
        return treeGrids;
    }

    @RequestMapping(params={"jump2FineReport"})
    public ModelAndView jump2FineReport(String type, String id, String accountid, HttpServletRequest request) {
        HashMap<String, String> modelMap = new HashMap<String, String>();
        if ("detail".equals(type)) {
            WeixinDataGraphicAnalysisEntity tjGraphicAnalysisEntity = (WeixinDataGraphicAnalysisEntity)this.systemService.get(WeixinDataGraphicAnalysisEntity.class, (Serializable)((Object)id));
            modelMap.put("msgid", tjGraphicAnalysisEntity.getMsgid());
            if (!oConvertUtils.isEmpty((Object)request.getParameter("start"))) {
                modelMap.put("start", oConvertUtils.getString((String)request.getParameter("start")));
            } else {
                modelMap.put("start", DateUtils.formatDate(tjGraphicAnalysisEntity.getRefDate()));
            }
            if (!oConvertUtils.isEmpty((Object)request.getParameter("end"))) {
                modelMap.put("end", oConvertUtils.getString((String)request.getParameter("end")));
            } else {
                modelMap.put("end", DateUtils.formatDate());
            }
            return new ModelAndView("redirect:ReportServer?reportlet=GraphicAnalysisSingle.cpt&op=view", modelMap);
        }
        return null;
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinDataGraphicAnalysisEntity weixinDataGraphicAnalysis, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinDataGraphicAnalysisEntity.class, dataGrid);
        String queryAccountIds = request.getParameter("queryAccountIds");
        if (!oConvertUtils.isNullOrEmpty((Object)queryAccountIds)) {
            Object[] accountIds = StringUtil.splitString((String)queryAccountIds.substring(1), (String)",");
            cq.in("accountId", accountIds);
        } else {
            cq.eq("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        }
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinDataGraphicAnalysis, (Map)request.getParameterMap());
        cq.add();
        this.weixinDataGraphicAnalysisService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinDataGraphicAnalysisEntity weixinDataGraphicAnalysis, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinDataGraphicAnalysis = (WeixinDataGraphicAnalysisEntity)this.systemService.getEntity(WeixinDataGraphicAnalysisEntity.class, (Serializable)((Object)weixinDataGraphicAnalysis.getId()));
        this.message = "weixin_data_graphic_analysis\u5220\u9664\u6210\u529f";
        try {
            this.weixinDataGraphicAnalysisService.delete(weixinDataGraphicAnalysis);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_data_graphic_analysis\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "weixin_data_graphic_analysis\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinDataGraphicAnalysisEntity weixinDataGraphicAnalysis = (WeixinDataGraphicAnalysisEntity)this.systemService.getEntity(WeixinDataGraphicAnalysisEntity.class, (Serializable)((Object)id));
                this.weixinDataGraphicAnalysisService.delete(weixinDataGraphicAnalysis);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_data_graphic_analysis\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinDataGraphicAnalysisEntity weixinDataGraphicAnalysis, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "weixin_data_graphic_analysis\u6dfb\u52a0\u6210\u529f";
        try {
            this.weixinDataGraphicAnalysisService.save(weixinDataGraphicAnalysis);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_data_graphic_analysis\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinDataGraphicAnalysisEntity weixinDataGraphicAnalysis, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "weixin_data_graphic_analysis\u66f4\u65b0\u6210\u529f";
        WeixinDataGraphicAnalysisEntity t = (WeixinDataGraphicAnalysisEntity)this.weixinDataGraphicAnalysisService.get(WeixinDataGraphicAnalysisEntity.class, (Serializable)((Object)weixinDataGraphicAnalysis.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinDataGraphicAnalysis, (Object)t);
            this.weixinDataGraphicAnalysisService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "weixin_data_graphic_analysis\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinDataGraphicAnalysisEntity weixinDataGraphicAnalysis, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinDataGraphicAnalysis.getId())) {
            weixinDataGraphicAnalysis = (WeixinDataGraphicAnalysisEntity)this.weixinDataGraphicAnalysisService.getEntity(WeixinDataGraphicAnalysisEntity.class, (Serializable)((Object)weixinDataGraphicAnalysis.getId()));
            req.setAttribute("weixinDataGraphicAnalysisPage", (Object)weixinDataGraphicAnalysis);
        }
        return new ModelAndView("weixin/guanjia/tj/graphicanalysis/weixinDataGraphicAnalysis-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinDataGraphicAnalysisEntity weixinDataGraphicAnalysis, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinDataGraphicAnalysis.getId())) {
            weixinDataGraphicAnalysis = (WeixinDataGraphicAnalysisEntity)this.weixinDataGraphicAnalysisService.getEntity(WeixinDataGraphicAnalysisEntity.class, (Serializable)((Object)weixinDataGraphicAnalysis.getId()));
            req.setAttribute("weixinDataGraphicAnalysisPage", (Object)weixinDataGraphicAnalysis);
        }
        return new ModelAndView("weixin/guanjia/tj/graphicanalysis/weixinDataGraphicAnalysis-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/guanjia/tj/graphicanalysis/weixinDataGraphicAnalysisUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinDataGraphicAnalysisEntity weixinDataGraphicAnalysis, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "weixin_data_graphic_analysis";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinDataGraphicAnalysisEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinDataGraphicAnalysis, (Map)request.getParameterMap());
                List weixinDataGraphicAnalysiss = this.weixinDataGraphicAnalysisService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("weixin_data_graphic_analysis\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinDataGraphicAnalysisEntity.class, (Collection)weixinDataGraphicAnalysiss);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinDataGraphicAnalysisEntity weixinDataGraphicAnalysis, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "weixin_data_graphic_analysis";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("weixin_data_graphic_analysis\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinDataGraphicAnalysisEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinDataGraphicAnalysisEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinDataGraphicAnalysisEntity.class, (ImportParams)params);
                    for (WeixinDataGraphicAnalysisEntity weixinDataGraphicAnalysis : listWeixinDataGraphicAnalysisEntitys) {
                        this.weixinDataGraphicAnalysisService.save(weixinDataGraphicAnalysis);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

