/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.task;

import java.util.Date;
import java.util.List;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.report.datastatistics.useranalysis.JwUserAnalysisAPI;
import org.jeewx.api.report.datastatistics.useranalysis.model.UserAnalysisRtnInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.dao.WxAccountDao;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.groupmessage.service.GroupMessageTemlateI;
import weixin.guanjia.tj.entity.GzUsertotalEntity;
import weixin.util.DateUtils;

@Service(value="userCumulateSynchTask")
public class UserCumulateSynchTask {
    @Autowired
    private SystemService systemService;
    @Autowired
    private WxAccountDao wxAccountDao;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private GroupMessageTemlateI groupMessageTemplateService;
    private String message;

    public void run() {
        long start = System.currentTimeMillis();
        LogUtil.info((Object)"===================\u83b7\u53d6\u7d2f\u8ba1\u7528\u6237\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===================");
        this.systemService.addLog("======\u83b7\u53d6\u7d2f\u8ba1\u7528\u6237\u6570\u636e\u5b9a\u65f6\u4efb\u52a1========\u5f00\u59cb\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        String yesterday = DateUtils.date_sdf.format(new Date(System.currentTimeMillis() - 86400000L));
        this.synch(yesterday, yesterday);
        LogUtil.info((Object)"===================\u83b7\u53d6\u7d2f\u8ba1\u7528\u6237\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===================");
        this.systemService.addLog("======\u83b7\u53d6\u7d2f\u8ba1\u7528\u6237\u6570\u636e\u5b9a\u65f6\u4efb\u52a1========\u7ed3\u675f\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        long end = System.currentTimeMillis();
        long times = end - start;
        LogUtil.info((Object)("\u603b\u8017\u65f6" + times + "\u6beb\u79d2"));
    }

    private void synch(String startdate, String enddate) {
        LogUtil.info((Object)"====\u540c\u6b65\u5f00\u59cb====");
        List accountList = this.systemService.findHql("from WeixinAccountEntity t", new Object[0]);
        for (WeixinAccountEntity account : accountList) {
            try {
                List gzUsers;
                List rtnInfoList;
                String accessToken = this.weixinAccountService.getAccessToken(account.getId());
                int i = this.wxAccountDao.findGzUsertotalData(account.getId(), DateUtils.getDataString(DateUtils.date_sdf));
                if (i == 0) {
                    int yesDaysumGuanZhu = 0;
                    String hql2 = "from GzUsertotalEntity where accountId='" + account.getId() + "' and time='" + startdate + "'";
                    List tempList2 = this.systemService.findByQueryString(hql2);
                    GzUsertotalEntity totalRecord2 = null;
                    if (tempList2 != null && tempList2.size() > 0) {
                        totalRecord2 = (GzUsertotalEntity)tempList2.get(0);
                    }
                    if (totalRecord2 != null && oConvertUtils.isNotEmpty((Object)totalRecord2.getCumulateNum())) {
                        yesDaysumGuanZhu = Integer.parseInt(totalRecord2.getCumulateNum());
                    }
                    GzUsertotalEntity t = new GzUsertotalEntity();
                    t.setAccountId(account.getId());
                    t.setCancelnum("0");
                    t.setNum("0");
                    t.setTime(new Date());
                    t.setPostCode(account.getPostCode());
                    t.setCumulateNum(String.valueOf(yesDaysumGuanZhu));
                    this.systemService.saveOrUpdate((Object)t);
                }
                if ((rtnInfoList = JwUserAnalysisAPI.getUserCumulate((String)accessToken, (String)startdate, (String)enddate)) == null || rtnInfoList.size() == 0) continue;
                for (UserAnalysisRtnInfo info : rtnInfoList) {
                    String date = info.getRef_date();
                    int cumulate = info.getCumulate_user();
                    gzUsers = this.systemService.findHql("from GzUsertotalEntity t where t.accountId = '" + account.getId() + "' and t.time = '" + date + "'", new Object[0]);
                    if (gzUsers == null || gzUsers.size() == 0) {
                        GzUsertotalEntity v = new GzUsertotalEntity();
                        v.setAccountId(account.getId());
                        v.setCancelnum("" + info.getCancel_user());
                        v.setNum("" + info.getNew_user());
                        v.setTime(new Date(System.currentTimeMillis() - 86400000L));
                        v.setPostCode(account.getPostCode());
                        v.setCumulateNum(String.valueOf(cumulate));
                        this.systemService.saveOrUpdate((Object)v);
                    }
                    for (GzUsertotalEntity gzUser : gzUsers) {
                        gzUser.setCumulateNum(String.valueOf(cumulate));
                        this.systemService.saveOrUpdate((Object)gzUser);
                    }
                }
                List dataList = JwUserAnalysisAPI.getUserSummary((String)accessToken, (String)startdate, (String)enddate);
                for (UserAnalysisRtnInfo info : dataList) {
                    String date = info.getRef_date();
                    gzUsers = this.systemService.findHql("from GzUsertotalEntity t where t.accountId = '" + account.getId() + "' and t.time = '" + date + "'", new Object[0]);
                    for (GzUsertotalEntity gzUser : gzUsers) {
                        gzUser.setCancelnum(String.valueOf(info.getCancel_user() + Integer.parseInt(gzUser.getCancelnum() == null ? "0" : gzUser.getCancelnum())));
                        gzUser.setNum(String.valueOf(info.getNew_user() + Integer.parseInt(gzUser.getNum() == null ? "0" : gzUser.getNum())));
                        this.systemService.saveOrUpdate((Object)gzUser);
                    }
                }
                this.systemService.addLog("\u83b7\u53d6\u7d2f\u8ba1\u7528\u6237\u6570\u636e(\u5b9a\u65f6\u4efb\u52a1)\uff1a" + account.getAccountname() + "\u83b7\u53d6\u6210\u529f", Globals.Log_Type_OTHER, Globals.Log_Leavel_INFO);
            }
            catch (WexinReqException e) {
                e.printStackTrace();
                this.systemService.addLog("\u83b7\u53d6\u7d2f\u8ba1\u7528\u6237\u6570\u636e(\u5b9a\u65f6\u4efb\u52a1)\uff1a" + account.getAccountname() + "\u83b7\u53d6\u5931\u8d25", Globals.Log_Type_OTHER, Globals.Log_Leavel_INFO);
            }
        }
        LogUtil.info((Object)"====\u540c\u6b65\u7ed3\u675f====");
    }

    public static void main(String[] args) throws WexinReqException {
        List rtnInfoList = JwUserAnalysisAPI.getUserCumulate((String)"K5i9E7j59cw1iPBH7eHmtFudAFwCzPn6Bpq2xv9tR_zx3xAjOgUWq4UzuW6igCsNbt6prhryNtpURlDVrBZGBGNhBGhZkkoubmmH8c4sydQ", (String)"2015-03-19", (String)"2015-03-21");
        for (UserAnalysisRtnInfo info : rtnInfoList) {
            String date = info.getRef_date();
            int cumulate = info.getCumulate_user();
            System.out.println(String.valueOf(date) + ":" + cumulate);
        }
    }
}

