/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.task;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONObject;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.audiosucai.entity.WeixinAudiosucaiEntity;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.groupmessage.entity.GroupMessageNews;
import weixin.guanjia.groupmessage.entity.GroupMessageNewsTemplate;
import weixin.guanjia.groupmessage.model.BaseGraphic;
import weixin.guanjia.groupmessage.model.UploadGraphic;
import weixin.guanjia.groupmessage.service.GroupMessageTemlateI;
import weixin.guanjia.photosucai.entity.WeixinPhotosucaiEntity;
import weixin.guanjia.videosucai.entity.WeixinVideosucaiEntity;
import weixin.util.DateUtils;

@Service(value="sucaiSynchTask")
public class SucaiSynchTask {
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private GroupMessageTemlateI groupMessageTemplateService;
    private String message;

    public void run() {
        long start = System.currentTimeMillis();
        LogUtil.info((Object)"===================\u591a\u5a92\u4f53\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===================");
        this.systemService.addLog("======\u591a\u5a92\u4f53\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5b9a\u65f6\u4efb\u52a1========\u5f00\u59cb\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        this.synchAudiosucai();
        this.synchVideosucai();
        this.synchPhotosucai();
        this.synchGroupMessageNews();
        LogUtil.info((Object)"===================\u591a\u5a92\u4f53\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===================");
        this.systemService.addLog("======\u591a\u5a92\u4f53\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5b9a\u65f6\u4efb\u52a1=======\u7ed3\u675f\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        long end = System.currentTimeMillis();
        long times = end - start;
        LogUtil.info((Object)("\u603b\u8017\u65f6" + times + "\u6beb\u79d2"));
    }

    private void synchAudiosucai() {
        LogUtil.info((Object)"====\u540c\u6b65\u8bed\u8a00\u7d20\u6750\u5f00\u59cb====");
        String before2Day = DateUtils.datetimeFormat.format(new Date(System.currentTimeMillis() - 172800000L));
        List sucaiList = this.systemService.findHql("from WeixinAudiosucaiEntity t where synchFlag = 'false' or t.synchDate < '" + before2Day + "'", new Object[0]);
        for (WeixinAudiosucaiEntity sucai : sucaiList) {
            String accessToken = this.weixinAccountService.getAccessToken(sucai.getAccountid());
            String classPath = ResourceUtil.getClassPath();
            String url = String.valueOf(classPath.substring(0, classPath.indexOf("WEB-INF"))) + sucai.getRealpath();
            JSONObject jsonObj = WeixinUtil.sendMedia("voice", url, accessToken);
            if (jsonObj != null) {
                if (jsonObj.containsKey((Object)"errcode")) {
                    String errcode = jsonObj.getString("errcode");
                    String errmsg = jsonObj.getString("errmsg");
                    this.message = "\u97f3\u9891\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5931\u8d25\u3010errcode=" + errcode + "\u3011\u3010errmsg=" + errmsg + "\u3011\u3010\u6587\u4ef6\u540d=" + sucai.getName() + "\u3011";
                    sucai.setSynchFlag("false");
                } else {
                    this.message = "\u97f3\u9891\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u6210\u529f\u3010\u6587\u4ef6\u540d=" + sucai.getName() + "\u3011";
                    String media_id = jsonObj.getString("media_id");
                    String created_at = jsonObj.getString("created_at");
                    sucai.setMediaId(media_id);
                    sucai.setSynchDate(new Date());
                    sucai.setSynchFlag("true");
                }
            } else {
                this.message = "\u97f3\u9891\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\u3010\u6587\u4ef6\u540d=" + sucai.getName() + "\u3011";
                sucai.setSynchFlag("false");
            }
            this.systemService.addLog("\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668(\u5b9a\u65f6\u4efb\u52a1)\uff1a" + this.message, Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
            LogUtil.info((Object)this.message);
            this.systemService.saveOrUpdate((Object)sucai);
        }
        LogUtil.info((Object)"====\u540c\u6b65\u8bed\u8a00\u7d20\u6750\u7ed3\u675f====");
    }

    private void synchVideosucai() {
        LogUtil.info((Object)"====\u540c\u6b65\u89c6\u9891\u7d20\u6750\u5f00\u59cb====");
        String before2Day = DateUtils.datetimeFormat.format(new Date(System.currentTimeMillis() - 172800000L));
        List sucaiList = this.systemService.findHql("from WeixinVideosucaiEntity t where synchFlag = 'false' or t.synchDate < '" + before2Day + "'", new Object[0]);
        for (WeixinVideosucaiEntity sucai : sucaiList) {
            String accessToken = this.weixinAccountService.getAccessToken(sucai.getAccountid());
            String classPath = ResourceUtil.getClassPath();
            String url = String.valueOf(classPath.substring(0, classPath.indexOf("WEB-INF"))) + sucai.getRealpath();
            JSONObject jsonObj = WeixinUtil.sendMedia("video", url, accessToken);
            if (jsonObj != null) {
                if (jsonObj.containsKey((Object)"errcode")) {
                    String errcode = jsonObj.getString("errcode");
                    String errmsg = jsonObj.getString("errmsg");
                    this.message = "\u89c6\u9891\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5931\u8d25\u3010errcode=" + errcode + "\u3011\u3010errmsg=" + errmsg + "\u3011\u3010\u6587\u4ef6\u540d=" + sucai.getName() + "\u3011";
                    sucai.setSynchFlag("false");
                } else {
                    this.message = "\u89c6\u9891\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u6210\u529f\u3010\u6587\u4ef6\u540d=" + sucai.getName() + "\u3011";
                    String media_id = jsonObj.getString("media_id");
                    String created_at = jsonObj.getString("created_at");
                    sucai.setMediaId(media_id);
                    sucai.setSynchDate(new Date());
                    sucai.setSynchFlag("true");
                }
            } else {
                this.message = "\u97f3\u9891\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\u3010\u6587\u4ef6\u540d=" + sucai.getName() + "\u3011";
                sucai.setSynchFlag("false");
            }
            this.systemService.addLog("\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668(\u5b9a\u65f6\u4efb\u52a1)\uff1a" + this.message, Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
            LogUtil.info((Object)this.message);
            this.systemService.saveOrUpdate((Object)sucai);
        }
        LogUtil.info((Object)"====\u540c\u6b65\u89c6\u9891\u7d20\u6750\u7ed3\u675f====");
    }

    private void synchPhotosucai() {
        LogUtil.info((Object)"====\u540c\u6b65\u56fe\u7247\u7d20\u6750\u5f00\u59cb====");
        String before2Day = DateUtils.datetimeFormat.format(new Date(System.currentTimeMillis() - 172800000L));
        List sucaiList = this.systemService.findHql("from WeixinPhotosucaiEntity t where synchFlag = 'false' or t.synchDate < '" + before2Day + "'", new Object[0]);
        for (WeixinPhotosucaiEntity sucai : sucaiList) {
            String accessToken = this.weixinAccountService.getAccessToken(sucai.getAccountid());
            String classPath = ResourceUtil.getClassPath();
            String url = String.valueOf(classPath.substring(0, classPath.indexOf("WEB-INF"))) + sucai.getRealpath();
            JSONObject jsonObj = WeixinUtil.sendMedia("image", url, accessToken);
            if (jsonObj != null) {
                if (jsonObj.containsKey((Object)"errcode")) {
                    String errcode = jsonObj.getString("errcode");
                    String errmsg = jsonObj.getString("errmsg");
                    this.message = "\u56fe\u7247\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5931\u8d25\u3010errcode=" + errcode + "\u3011\u3010errmsg=" + errmsg + "\u3011\u3010\u6587\u4ef6\u540d=" + sucai.getName() + "\u3011";
                    sucai.setSynchFlag("false");
                } else {
                    this.message = "\u56fe\u7247\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u6210\u529f\u3010\u6587\u4ef6\u540d=" + sucai.getName() + "\u3011";
                    String media_id = jsonObj.getString("media_id");
                    String created_at = jsonObj.getString("created_at");
                    sucai.setMediaId(media_id);
                    sucai.setSynchDate(new Date());
                    sucai.setSynchFlag("true");
                }
            } else {
                this.message = "\u56fe\u7247\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\u3010\u6587\u4ef6\u540d=" + sucai.getName() + "\u3011";
                sucai.setSynchFlag("false");
            }
            this.systemService.addLog("\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668(\u5b9a\u65f6\u4efb\u52a1)\uff1a" + this.message, Globals.Log_Type_OTHER, Globals.Log_Leavel_INFO);
            LogUtil.info((Object)this.message);
            this.systemService.saveOrUpdate((Object)sucai);
        }
        LogUtil.info((Object)"====\u540c\u6b65\u56fe\u7247\u7d20\u6750\u7ed3\u675f====");
    }

    private void synchGroupMessageNews() {
        LogUtil.info((Object)"====\u540c\u6b65\u7fa4\u53d1\u56fe\u6587\u7d20\u6750\u5f00\u59cb====");
        List sucaiList = this.systemService.findHql("from GroupMessageNewsTemplate t where isUpload = '0'", new Object[0]);
        for (GroupMessageNewsTemplate sucai : sucaiList) {
            List news = this.systemService.findByQueryString("from GroupMessageNews where groupMessageNewsTemplate.id='" + sucai.getId() + "'");
            if (news.size() > 0) {
                ArrayList<BaseGraphic> baseGraphicList = new ArrayList<BaseGraphic>();
                int i = 0;
                while (i < news.size()) {
                    GroupMessageNews newItem = (GroupMessageNews)((Object)news.get(i));
                    BaseGraphic baseGraphic = new BaseGraphic();
                    baseGraphic.setAuthor(newItem.getAuthor());
                    baseGraphic.setContent(newItem.getContent());
                    baseGraphic.setContent_source_url(newItem.getOriginalLink());
                    baseGraphic.setDigest(newItem.getDescription());
                    baseGraphic.setShow_cover_pic(newItem.getDisplayCoverFlag());
                    baseGraphic.setThumb_media_id(newItem.getMedia_id());
                    baseGraphic.setTitle(newItem.getTitle());
                    baseGraphicList.add(baseGraphic);
                    ++i;
                }
                UploadGraphic graphic = new UploadGraphic();
                graphic.setArticles(baseGraphicList);
                JSONObject resultJson = this.groupMessageTemplateService.uploadGroupNewsTemplate(graphic, sucai.getAccountId());
                if (resultJson.containsKey((Object)"media_id")) {
                    sucai.setMedia_id(resultJson.getString("media_id"));
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    sucai.setAddTime(sdf.format(new Date()));
                    sucai.setIsUpload("1");
                    this.groupMessageTemplateService.updateEntitie((Object)sucai);
                    this.message = "\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u6210\u529f\u3010\u6587\u4ef6\u540d=" + sucai.getTemplateName() + "\u3011";
                } else {
                    this.message = "\u540c\u6b65\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f" + resultJson.toString();
                }
            } else {
                this.message = String.valueOf(sucai.getTemplateName()) + " \u8be5\u56fe\u6587\u6a21\u677f\u5c1a\u672a\u6dfb\u52a0\u56fe\u6587\u6d88\u606f";
            }
            this.systemService.addLog("\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668(\u5b9a\u65f6\u4efb\u52a1)\uff1a\u7fa4\u53d1\u56fe\u6587\u7d20\u6750 " + this.message, Globals.Log_Type_OTHER, Globals.Log_Leavel_INFO);
            LogUtil.info((Object)this.message);
            this.systemService.saveOrUpdate((Object)sucai);
        }
        LogUtil.info((Object)"====\u540c\u6b65\u7fa4\u53d1\u56fe\u6587\u7d20\u6750\u7ed3\u675f====");
    }
}

