/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.task;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.httpclient.util.DateUtil;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.report.datacube.JwDataCubeAPI;
import org.jeewx.api.report.datacube.model.WxDataCubeStreamMsgInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.util.DateUtils;

@Service(value="jwDataCubeTask")
public class JwDataCubeTask {
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;

    public void run() {
        long start = System.currentTimeMillis();
        this.systemService.addLog("======\u83b7\u53d6\u6628\u65e5\u6d88\u606f\u6570\u636e\u5b9a\u65f6\u4efb\u52a1========\u5f00\u59cb\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        LogUtil.info((Object)"==================\u83b7\u53d6\u6d88\u606f\u7edf\u8ba1\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===================");
        List accountEntities = this.systemService.findHql(" from WeixinAccountEntity", new Object[0]);
        for (WeixinAccountEntity weixinAccountEntity : accountEntities) {
            String appid = weixinAccountEntity.getAccountappid();
            String appscret = weixinAccountEntity.getAccountappsecret();
            if (oConvertUtils.isEmpty((Object)appid) || oConvertUtils.isEmpty((Object)appscret)) continue;
            String accessToken = this.weixinAccountService.getAccessToken(weixinAccountEntity.getId());
            this.getDayData(new Date(), accessToken, weixinAccountEntity.getId());
        }
        LogUtil.info((Object)"===================\u83b7\u53d6\u6d88\u606f\u7edf\u8ba1\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===================");
        this.systemService.addLog("======\u83b7\u53d6\u6628\u65e5\u6d88\u606f\u6570\u636e\u5b9a\u65f6\u4efb\u52a1========\u7ed3\u675f\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        long end = System.currentTimeMillis();
        long times = end - start;
        LogUtil.info((Object)("\u603b\u8017\u65f6" + times + "\u6beb\u79d2"));
    }

    private void getDayData(Date date, String accessToken, String accountId) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(5, -1);
            String dateStr = DateUtil.formatDate((Date)cal.getTime(), (String)"yyyy-MM-dd");
            List cubeStreamMsgInfos = JwDataCubeAPI.getWxDataCubeStreamMsgInfo((String)accessToken, (String)dateStr, (String)dateStr);
            String sql = "";
            String delSql = " delete from weixin_data_cube_day where account_id = '" + accountId + "' and ref_date = '" + dateStr + "'";
            this.systemService.executeSql(delSql, new Object[0]);
            if (oConvertUtils.isNotEmpty((Object)cubeStreamMsgInfos) && cubeStreamMsgInfos.size() > 0) {
                for (WxDataCubeStreamMsgInfo wxDataCubeStreamMsgInfo : cubeStreamMsgInfos) {
                    sql = "INSERT INTO weixin_data_cube_day (ID, account_id, msg_type, msg_user, msg_count, ref_date) VALUES (replace(uuid(),'-',''), '" + accountId + "', '" + wxDataCubeStreamMsgInfo.getMsg_type() + "', '" + wxDataCubeStreamMsgInfo.getMsg_user() + "', '" + wxDataCubeStreamMsgInfo.getMsg_count() + "', '" + dateStr + "')";
                }
            } else {
                LogUtil.info((Object)("===================" + dateStr + "," + accountId + "\u6ca1\u6709\u83b7\u53d6\u5230\u6570\u636e==================="));
                sql = "INSERT INTO weixin_data_cube_day (ID, account_id, msg_type, msg_user, msg_count, ref_date) VALUES (replace(uuid(),'-',''), '" + accountId + "', '0', '0', '0', '" + dateStr + "')";
            }
            this.systemService.executeSql(sql, new Object[0]);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }
}

