/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.task;

import java.util.List;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.jeewx.api.core.exception.WexinReqException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.account.service.WeixinReportServiceI;
import weixin.guanjia.groupmessage.service.GroupMessageTemlateI;
import weixin.util.DateUtils;

@Service(value="graphicAnalysisSynchTask")
public class GraphicAnalysisSynchTask {
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private GroupMessageTemlateI groupMessageTemplateService;
    @Autowired
    private WeixinReportServiceI weixinReportService;

    public void run() {
        long start = System.currentTimeMillis();
        this.systemService.addLog("======\u83b7\u53d6\u6628\u65e5\u56fe\u6587\u5206\u6790\u6570\u636e\u5b9a\u65f6\u4efb\u52a1========\u5f00\u59cb\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        LogUtil.info((Object)"===================\u83b7\u53d6\u6628\u65e5\u56fe\u6587\u5206\u6790\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===================");
        try {
            String yesterday = DateUtils.formatDate(DateUtils.getCurrentTimestampExpiredDay(-1));
            this.saveArticle2LocalDB(yesterday);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
            LogUtil.info((Object)("\u56fe\u6587\u5206\u6790\u6570\u636e\u63a5\u53e3\u8c03\u7528\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.systemService.addLog("======\u83b7\u53d6\u6628\u65e5\u56fe\u6587\u5206\u6790\u6570\u636e\u5b9a\u65f6=======\u7ed3\u675f\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        LogUtil.info((Object)"===================\u83b7\u53d6\u6628\u65e5\u56fe\u6587\u5206\u6790\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===================");
        long end = System.currentTimeMillis();
        long times = end - start;
        LogUtil.info((Object)("\u603b\u8017\u65f6" + times + "\u6beb\u79d2"));
    }

    private void saveArticle2LocalDB(String yesterday) throws Exception {
        List weixinAccountList = this.systemService.getList(WeixinAccountEntity.class);
        for (WeixinAccountEntity weixinAccountEntity : weixinAccountList) {
            String accountId = weixinAccountEntity.getId();
            this.weixinReportService.saveArticleTotalLocalDB(accountId, yesterday);
            this.weixinReportService.saveOneDayArticleSummaryLocalDB(accountId, yesterday);
        }
    }
}

