/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.task;

import java.util.List;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.report.datastatistics.graphicanalysis.JwGraphicAnalysisAPI;
import org.jeewx.api.report.datastatistics.graphicanalysis.model.GraphicAnalysisRtnInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.groupmessage.service.GroupMessageTemlateI;
import weixin.guanjia.tj.entity.WeixinDataGraphicAnalysisEntity;
import weixin.util.DateUtils;

@Service(value="graphicAnalysisCunstomDefineSynchTask")
public class GraphicAnalysisCunstomDefineSynchTask {
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private GroupMessageTemlateI groupMessageTemplateService;
    private static final int beforeDate = 30;

    public void run() {
        long start = System.currentTimeMillis();
        LogUtil.info((Object)"===================\u83b7\u53d630\u5929\u5185\u5fae\u4fe1\u7aef\u5386\u53f2\u7fa4\u53d1\u56fe\u6587\u5206\u6790\u6570\u636e\u63a5\u53e3\u5f00\u59cb===================");
        this.systemService.addLog("======\u83b7\u53d630\u5929\u5185\u5fae\u4fe1\u7aef\u5386\u53f2\u7fa4\u53d1\u56fe\u6587\u5206\u6790\u6570\u636e\u63a5\u53e3========\u5f00\u59cb\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        try {
            int i = 30;
            while (i >= 0) {
                String queryDate = DateUtils.formatDate(DateUtils.getCurrentTimestampExpiredDay(-i));
                this.saveOneDayArticleSummaryLocalDB(queryDate);
                --i;
            }
        }
        catch (WexinReqException e) {
            e.printStackTrace();
            LogUtil.info((Object)("\u81ea\u5b9a\u4e49\u65f6\u95f4\u56fe\u6587\u5206\u6790\u6570\u636e\u63a5\u53e3\u8c03\u7528\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LogUtil.info((Object)"===================\u83b7\u53d630\u5929\u5185\u5fae\u4fe1\u7aef\u5386\u53f2\u7fa4\u53d1\u56fe\u6587\u5206\u6790\u6570\u636e\u63a5\u53e3\u7ed3\u675f===================");
        this.systemService.addLog("======\u83b7\u53d630\u5929\u5185\u5fae\u4fe1\u7aef\u5386\u53f2\u7fa4\u53d1\u56fe\u6587\u5206\u6790\u6570\u636e\u63a5\u53e3========\u7ed3\u675f\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        long end = System.currentTimeMillis();
        long times = end - start;
        LogUtil.info((Object)("\u603b\u8017\u65f6" + times + "\u6beb\u79d2"));
    }

    private void saveOneDayArticleSummaryLocalDB(String queryDate) throws Exception {
        List weixinAccountList = this.systemService.getList(WeixinAccountEntity.class);
        for (WeixinAccountEntity weixinAccountEntity : weixinAccountList) {
            String accountId = weixinAccountEntity.getId();
            String accessToken = this.weixinAccountService.getAccessToken(weixinAccountEntity.getId());
            List graphicAnalysisRtnInfoList = JwGraphicAnalysisAPI.getArticleSummary((String)accessToken, (String)queryDate, (String)queryDate);
            if (oConvertUtils.isNullOrEmpty((Object)graphicAnalysisRtnInfoList)) continue;
            for (GraphicAnalysisRtnInfo graphicAnalysisRtnInfo : graphicAnalysisRtnInfoList) {
                WeixinDataGraphicAnalysisEntity tjGraphicAnalysisEntity = new WeixinDataGraphicAnalysisEntity();
                tjGraphicAnalysisEntity.setAddToFavCount(graphicAnalysisRtnInfo.getAdd_to_fav_count());
                tjGraphicAnalysisEntity.setAddToFavUser(graphicAnalysisRtnInfo.getAdd_to_fav_user());
                tjGraphicAnalysisEntity.setIntPageReadCount(graphicAnalysisRtnInfo.getInt_page_read_count());
                tjGraphicAnalysisEntity.setIntPageReadUser(graphicAnalysisRtnInfo.getInt_page_read_user());
                tjGraphicAnalysisEntity.setMsgid(graphicAnalysisRtnInfo.getMsgid());
                tjGraphicAnalysisEntity.setOriPageReadCount(graphicAnalysisRtnInfo.getOri_page_read_count());
                tjGraphicAnalysisEntity.setOriPageReadUser(graphicAnalysisRtnInfo.getOri_page_read_user());
                tjGraphicAnalysisEntity.setRefDate(DateUtils.str2Date(graphicAnalysisRtnInfo.getRef_date(), DateUtils.date_sdf));
                tjGraphicAnalysisEntity.setShareCount(graphicAnalysisRtnInfo.getShare_count());
                tjGraphicAnalysisEntity.setShareUser(graphicAnalysisRtnInfo.getShare_user());
                tjGraphicAnalysisEntity.setTargetUser(graphicAnalysisRtnInfo.getTarget_user());
                tjGraphicAnalysisEntity.setTitle(graphicAnalysisRtnInfo.getTitle());
                tjGraphicAnalysisEntity.setAccountId(accountId);
                this.systemService.save((Object)tjGraphicAnalysisEntity);
            }
        }
    }
}

