/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.task;

import java.util.Date;
import java.util.List;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinReportServiceI;
import weixin.util.DateUtils;

@Service(value="fetchWxDataTask")
public class FetchWeixinDataTask {
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinReportServiceI weixinReportService;

    public void run() {
        long start = System.currentTimeMillis();
        this.systemService.addLog("======\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u6628\u65e5\u4fe1\u606f\u6570\u636e\uff0c\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb========\u5f00\u59cb\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        LogUtil.info((Object)"===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u4fe1\u606f\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===================");
        try {
            List accountList = this.systemService.findHql("from WeixinAccountEntity t", new Object[0]);
            for (WeixinAccountEntity account : accountList) {
                Date date = new Date();
                date = DateUtils.getAddDate(date, -1);
                date = DateUtils.getDayMinTime(date);
                this.fetchFocuseUserData(account.getId(), date, account.getAccountname());
                this.fetchMessageDayData(account.getId(), date, account.getAccountname());
                this.fetchArticleDayData(account.getId(), date, account.getAccountname());
                this.fetchArticleTotalData(account.getId(), date, account.getAccountname());
            }
        }
        catch (Exception accountList) {
            // empty catch block
        }
        LogUtil.info((Object)"===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u4fe1\u606f\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===================");
        this.systemService.addLog("======\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u6628\u65e5\u4fe1\u606f\u6570\u636e\u5b9a\u65f6\u4efb\u52a1========\u7ed3\u675f\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        long end = System.currentTimeMillis();
        long times = end - start;
        LogUtil.info((Object)("\u603b\u8017\u65f6" + times + "\u6beb\u79d2"));
    }

    public void installMonthData() {
        long start = System.currentTimeMillis();
        this.systemService.addLog("======\u65b0\u5efa\u516c\u4f17\u8d26\u53f7\uff0c\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u5b9a\u65f6\u4efb\u52a1========\u5f00\u59cb\u65f6\u95f4==={" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        LogUtil.info((Object)"===================\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===================");
        List accountList = this.systemService.findHql("from WeixinAccountEntity t where initDataFlag = 0", new Object[0]);
        for (WeixinAccountEntity account : accountList) {
            try {
                String sql1 = "delete from weixin_gzuser_total where accountid = ? ";
                String sql2 = "delete from weixin_data_cube_day where account_id = ? ";
                String sql3 = "delete from weixin_data_graphic_analysis where account_id = ? ";
                String sql4 = "delete from weixin_data_graphic_total where account_id = ? ";
                this.systemService.executeSql(sql1, new Object[]{account.getId()});
                this.systemService.executeSql(sql2, new Object[]{account.getId()});
                this.systemService.executeSql(sql3, new Object[]{account.getId()});
                this.systemService.executeSql(sql4, new Object[]{account.getId()});
                int focusUserCountSum = 0;
                int dayUserDataCountSum = 0;
                int oneDayArticleCountSum = 0;
                int articleTotalCountSum = 0;
                Date date = new Date();
                date = DateUtils.getAddDate(date, -31);
                date = DateUtils.getDayMinTime(date);
                int i = 1;
                while (i <= 30) {
                    focusUserCountSum += this.weixinReportService.saveOneDayFocusUserDataLocalDB(date, account.getId());
                    dayUserDataCountSum += this.weixinReportService.saveOneDayUserDataLocalDB(date, account.getId());
                    String queryDate = DateUtils.datetoStr(date, "yyyy-MM-dd");
                    oneDayArticleCountSum += this.weixinReportService.saveOneDayArticleSummaryLocalDB(account.getId(), queryDate);
                    articleTotalCountSum += this.weixinReportService.saveArticleTotalLocalDB(account.getId(), queryDate);
                    date = DateUtils.getAddDate(date, 1);
                    date = DateUtils.getDayMinTime(date);
                    ++i;
                }
                String sql = "update weixin_account set init_data_flag = 1 where id = ?";
                this.systemService.executeSql(sql, new Object[]{account.getId()});
                this.systemService.addLog("===\u516c\u4f17\u53f7\u3010" + account.getAccountname() + "\u3011,\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u5b9a\u65f6\u4efb\u52a1-\u6210\u529f,\u8dd1\u6279\u65f6\u95f4\u3010" + DateUtils.getDataString(DateUtils.time_sdf) + "\u3011\uff0c\u5173\u6ce8\u7c89\u4e1d\u62a5\u8868\u6570\u636e\u3010" + focusUserCountSum + "\u3011\u7528\u6237\u53d1\u9001\u6d88\u606f\u62a5\u8868\u6570\u636e\u3010" + dayUserDataCountSum + "\u3011\u6bcf\u65e5\u56fe\u6587\u62a5\u8868\u6570\u636e\u3010" + oneDayArticleCountSum + "\u3011\u56fe\u6587\u603b\u8bbf\u95ee\u62a5\u8868\u6570\u636e\u3010" + articleTotalCountSum + "\u3011========", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                this.systemService.addLog("===\u516c\u4f17\u53f7\u3010" + account.getAccountname() + "\u3011,\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u5b9a\u65f6\u5931\u8d25, \u8dd1\u6279\u65f6\u95f4\u3010" + DateUtils.getDataString(DateUtils.time_sdf) + "\u3011\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.toString() + "\u3011========", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
            }
        }
        LogUtil.info((Object)"===================\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===================");
        this.systemService.addLog("======\u65b0\u5efa\u516c\u4f17\u8d26\u53f7\uff0c\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u5b9a\u65f6\u4efb\u52a1========\u7ed3\u675f\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        long end = System.currentTimeMillis();
        long times = end - start;
        LogUtil.info((Object)("\u603b\u8017\u65f6" + times + "\u6beb\u79d2"));
    }

    private int fetchFocuseUserData(String accountId, Date date, String accountname) {
        int dataCount = 0;
        try {
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u5173\u6ce8\u7c89\u4e1d\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
            String queryDate = DateUtils.datetoStr(date, "yyyy-MM-dd");
            String sql = "select count(*) from  weixin_gzuser_total t where t.accountid='" + accountId + "' and t.time='" + queryDate + "'";
            long count = this.systemService.getCountForJdbc(sql);
            if (count <= 0L) {
                dataCount = this.weixinReportService.saveOneDayFocusUserDataLocalDB(date, accountId);
                this.systemService.addLog("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + accountname + "\u3011\u6628\u65e5\u5173\u6ce8\u7c89\u4e1d\u6570\u636e\u5b9a\u65f6\u4efb\u52a1-\u6210\u529f,\u6293\u53d6\u6761\u6570:" + dataCount + "===========accountId\uff1a" + accountId + ";Date:" + date + "========", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
                String totalSql = "update weixin_gzuser_total a,weixin_gzuser_total b   set b.cumulate_num = (a.cumulate_num +  b.num -  b.cancelnum) where a.time = CURDATE()-1  and b.time = CURDATE() and b.accountid = a.accountid and a.accountid='" + accountId + "'";
                this.systemService.executeSql(totalSql, new Object[0]);
            } else {
                LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u5173\u6ce8\u7c89\u4e1d\u6570\u636e\u5b9a\u65f6\u4efb\u52a1,\u6570\u636e\u5df2\u5b58\u5728===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
            }
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u5173\u6ce8\u7c89\u4e1d\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
        }
        catch (Exception e) {
            this.systemService.addLog("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + accountname + "\u3011\u6628\u65e5\u5173\u6ce8\u7c89\u4e1d\u6570\u636e\u5b9a\u65f6\u4efb\u52a1-\u5931\u8d25===================" + e.getMessage(), Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        }
        return dataCount;
    }

    private int fetchMessageDayData(String accountId, Date date, String accountname) {
        int dataCount = 0;
        try {
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u6bcf\u65e5\u6d88\u606f\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
            String queryDate = DateUtils.datetoStr(date, "yyyy-MM-dd");
            String sql = "select count(*) from weixin_data_cube_day where account_id = '" + accountId + "' and ref_date = '" + queryDate + "'";
            long count = this.systemService.getCountForJdbc(sql);
            if (count <= 0L) {
                dataCount = this.weixinReportService.saveOneDayUserDataLocalDB(date, accountId);
                this.systemService.addLog("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + accountname + "\u3011\u6628\u65e5\u6d88\u606f\u6570\u636e\u5b9a\u65f6\u4efb\u52a1-\u6210\u529f,\u6293\u53d6\u6761\u6570:" + dataCount + "===========accountId\uff1a" + accountId + ";Date:" + date + "========", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
            } else {
                LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u6bcf\u65e5\u6d88\u606f\u6570\u636e\u5b9a\u65f6\u4efb\u52a1,\u6570\u636e\u5df2\u5b58\u5728===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
            }
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u6bcf\u65e5\u6d88\u606f\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
        }
        catch (Exception e) {
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u6bcf\u65e5\u6d88\u606f\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38===========" + e.getMessage()));
            this.systemService.addLog("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + accountname + "\u3011\u6628\u65e5\u6d88\u606f\u6570\u636e-\u5931\u8d25===================" + e.getMessage(), Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        }
        return dataCount;
    }

    private int fetchArticleDayData(String accountId, Date date, String accountname) {
        int dataCount = 0;
        try {
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7fa4\u53d1\u56fe\u6587\u6bcf\u5929\u7684\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
            String queryDate = DateUtils.datetoStr(date, "yyyy-MM-dd");
            String sql = "select count(*) from weixin_data_graphic_analysis where account_id = '" + accountId + "' and ref_date = '" + queryDate + "'";
            long count = this.systemService.getCountForJdbc(sql);
            if (count <= 0L) {
                dataCount = this.weixinReportService.saveOneDayArticleSummaryLocalDB(accountId, queryDate);
                this.systemService.addLog("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + accountname + "\u3011,\u6628\u65e5\u7fa4\u53d1\u56fe\u6587\u6bcf\u5929\u7684\u6570\u636e\u5b9a\u65f6\u4efb\u52a1,\u6293\u53d6\u6761\u6570:" + dataCount + "===========accountId\uff1a" + accountId + ";Date:" + date + "========", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
            } else {
                LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7fa4\u53d1\u56fe\u6587\u6bcf\u5929\u7684\u6570\u636e\u5b9a\u65f6\u4efb\u52a1,\u6570\u636e\u5df2\u5b58\u5728===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
            }
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7fa4\u53d1\u56fe\u6587\u6bcf\u5929\u7684\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
        }
        catch (Exception e) {
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7fa4\u53d1\u56fe\u6587\u6bcf\u5929\u7684\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38===========" + e.getMessage()));
            this.systemService.addLog("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + accountname + "\u3011\u6628\u65e5\u7fa4\u53d1\u56fe\u6587\u6570\u636e-\u5931\u8d25===================" + e.getMessage(), Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        }
        return dataCount;
    }

    private int fetchArticleTotalData(String accountId, Date date, String accountname) {
        int dataCount = 0;
        try {
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7fa4\u53d1\u56fe\u6587\u5f53\u5929\u7d2f\u8ba1\u7684\u91cf\u7684\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
            String queryDate = DateUtils.datetoStr(date, "yyyy-MM-dd");
            String sql = "select count(*) from weixin_data_graphic_total where account_id = '" + accountId + "' and ref_date = '" + queryDate + "'";
            long count = this.systemService.getCountForJdbc(sql);
            if (count <= 0L) {
                dataCount = this.weixinReportService.saveArticleTotalLocalDB(accountId, queryDate);
                this.systemService.addLog("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + accountname + "\u3011,\u6628\u65e5\u7fa4\u53d1\u56fe\u6587\u7d2f\u8ba1\u7684\u91cf\u7684\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u6210\u529f,\u6293\u53d6\u6761\u6570:" + dataCount + "===========accountId\uff1a" + accountId + ";Date:" + date + "========", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
            } else {
                LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7fa4\u53d1\u56fe\u6587\u5f53\u5929\u7d2f\u8ba1\u7684\u91cf\u7684\u6570\u636e\u5b9a\u65f6\u4efb\u52a1,\u6570\u636e\u5df2\u5b58\u5728===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
            }
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7fa4\u53d1\u56fe\u6587\u5f53\u5929\u7d2f\u8ba1\u7684\u91cf\u7684\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
        }
        catch (Exception e) {
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7fa4\u53d1\u56fe\u6587\u5f53\u5929\u7d2f\u8ba1\u7684\u91cf\u7684\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38===========" + e.getMessage()));
            this.systemService.addLog("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + accountname + "\u3011\u6628\u65e5\u7fa4\u53d1\u56fe\u6587\u5f53\u5929\u7d2f\u8ba1\u7684\u91cf\u7684\u6570\u636e-\u5931\u8d25===================" + e.getMessage(), Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        }
        return dataCount;
    }
}

