/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.task;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinReportServiceI;
import weixin.guanjia.tj.entity.WeixinDataBindingPhoneEntity;
import weixin.util.DateUtils;

@Service(value="fetchWeixinBindingPhoneDataTask")
public class FetchWeixinBindingPhoneDataTask {
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinReportServiceI weixinReportService;

    public void run() {
        long start = System.currentTimeMillis();
        this.systemService.addLog("======\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u6628\u65e5\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e\uff0c\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb========\u5f00\u59cb\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        LogUtil.info((Object)"===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===================");
        try {
            Map historyDate = this.systemService.findOneForJdbc("select * from weixin_data_binding_phone limit 1 ", new Object[0]);
            if (historyDate == null) {
                this.loadWeixinVipMemberOprData();
            }
            List accountList = this.systemService.findHql("from WeixinAccountEntity t", new Object[0]);
            for (WeixinAccountEntity account : accountList) {
                Date date = new Date();
                date = DateUtils.getAddDate(date, -1);
                date = DateUtils.getDayMinTime(date);
                this.fetchBindingPhoneData(account.getId(), date, account.getAccountname());
            }
            if (historyDate == null) {
                this.installMonthData();
            }
        }
        catch (Exception historyDate) {
            // empty catch block
        }
        LogUtil.info((Object)"===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===================");
        this.systemService.addLog("======\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u6628\u65e5\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e\u5b9a\u65f6\u4efb\u52a1========\u7ed3\u675f\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        long end = System.currentTimeMillis();
        long times = end - start;
        LogUtil.info((Object)("\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e\u603b\u8017\u65f6" + times + "\u6beb\u79d2"));
    }

    private void installMonthData() {
        long start = System.currentTimeMillis();
        this.systemService.addLog("======\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e,\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u5b9a\u65f6\u4efb\u52a1========\u5f00\u59cb\u65f6\u95f4==={" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        LogUtil.info((Object)"===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e,\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===================");
        Map historyDate = this.systemService.findOneForJdbc("select * from weixin_data_binding_phone limit 1 ", new Object[0]);
        if (historyDate != null) {
            List accountList = this.systemService.findHql("from WeixinAccountEntity t", new Object[0]);
            for (WeixinAccountEntity account : accountList) {
                try {
                    String sql1 = "delete from weixin_data_binding_phone where sys_accountid = ? ";
                    this.systemService.executeSql(sql1, new Object[]{account.getId()});
                    Date date = new Date();
                    date = DateUtils.getAddDate(date, -31);
                    date = DateUtils.getDayMinTime(date);
                    int i = 0;
                    while (i <= 30) {
                        this.fetchBindingPhoneData(account.getId(), date, account.getAccountname());
                        date = DateUtils.getAddDate(date, 1);
                        date = DateUtils.getDayMinTime(date);
                        ++i;
                    }
                    this.systemService.addLog("===\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e\u3010" + account.getAccountname() + "\u3011,\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u5b9a\u65f6\u4efb\u52a1-\u6210\u529f========", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
                }
                catch (Exception e) {
                    this.systemService.addLog("===\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e\u3010" + account.getAccountname() + "\u3011,\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u5b9a\u65f6\u5931\u8d25, \u8dd1\u6279\u65f6\u95f4\u3010" + DateUtils.getDataString(DateUtils.time_sdf) + "\u3011\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.toString() + "\u3011========", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
                }
            }
            LogUtil.info((Object)"===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e,\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===================");
        }
        this.systemService.addLog("======\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e,\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u5b9a\u65f6\u4efb\u52a1========\u7ed3\u675f\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        long end = System.currentTimeMillis();
        long times = end - start;
        LogUtil.info((Object)("\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e,\u521d\u59cb\u531630\u5929\u62a5\u8868\u6570\u636e\u603b\u8017\u65f6" + times + "\u6beb\u79d2"));
    }

    private int fetchBindingPhoneData(String accountId, Date date, String accountname) {
        int dataCount = 0;
        try {
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u6628\u65e5\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
            List tempList = this.systemService.findHql(" from WeixinDataBindingPhoneEntity  where refDate = ?  and sysAccountid= ? ", new Object[]{date, accountId});
            if (tempList.size() <= 0) {
                WeixinDataBindingPhoneEntity weixinDataBindingPhoneEntity = this.weixinReportService.saveWeixinDataBindingPhoneDB(date, accountId);
                this.systemService.addLog("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + accountname + "\u3011\u6628\u65e5\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e\u5b9a\u65f6\u4efb\u52a1-\u6210\u529f" + weixinDataBindingPhoneEntity, Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
            } else {
                LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u6628\u65e5\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e\u5b9a\u65f6\u4efb\u52a1,\u6570\u636e\u5df2\u5b58\u5728===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
            }
            LogUtil.info((Object)("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u6628\u65e5\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f===========accountId\uff1a" + accountId + ";Date:" + date + "========"));
        }
        catch (Exception e) {
            this.systemService.addLog("===================\u6293\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + accountname + "\u3011\u6628\u65e5\u7ed1\u5b9a\u624b\u673a\u53f7\u6570\u636e\u5b9a\u65f6\u4efb\u52a1-\u5931\u8d25===================" + e.getMessage(), Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        }
        return dataCount;
    }

    public void loadWeixinVipMemberOprData() {
        long start = System.currentTimeMillis();
        this.systemService.addLog("======\u540c\u6b65\u5386\u53f2\u6570\u636e\u4f1a\u5458\u7ed1\u5b9a\u624b\u673a\u53f7\u64cd\u4f5c\u8bb0\u5f55\u4efb\u52a1========\u5f00\u59cb\u65f6\u95f4==={" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        LogUtil.info((Object)"===================\u540c\u6b65\u5386\u53f2\u6570\u636e\u4f1a\u5458\u7ed1\u5b9a\u624b\u673a\u53f7\u64cd\u4f5c\u8bb0\u5f55\u4efb\u52a1\u5f00\u59cb===================");
        List accountList = this.systemService.findHql("from WeixinAccountEntity t", new Object[0]);
        String endDate = this.getEndDate();
        for (WeixinAccountEntity account : accountList) {
            try {
                String sql1 = "delete from weixin_vip_member_opr  where sys_accountid = ? and version = 0 ";
                this.systemService.executeSql(sql1, new Object[]{account.getId()});
                int count = this.weixinReportService.loadWeixinVipMemberOprDB(account.getId(), 1000, endDate);
                this.systemService.addLog("===\u516c\u4f17\u53f7\u3010" + account.getAccountname() + "\u3011,\u540c\u6b65\u5386\u53f2\u6570\u636e\u4f1a\u5458\u7ed1\u5b9a\u624b\u673a\u53f7\u64cd\u4f5c\u8bb0\u5f55\u4efb\u52a1-\u6210\u529f==accountId\uff1a" + account.getId() + "===\u6267\u884c\u6761\u6570\uff1a" + count + ";endDate:" + endDate + "===", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                this.systemService.addLog("===\u516c\u4f17\u53f7\u3010" + account.getAccountname() + "\u3011,\u540c\u6b65\u5386\u53f2\u6570\u636e\u4f1a\u5458\u7ed1\u5b9a\u624b\u673a\u53f7\u64cd\u4f5c\u8bb0\u5f55\u4efb\u52a1\u5931\u8d25, \u8dd1\u6279\u65f6\u95f4\u3010" + DateUtils.getDataString(DateUtils.time_sdf) + "\u3011\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.toString() + "\u3011========", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
            }
        }
        LogUtil.info((Object)"===================\u540c\u6b65\u5386\u53f2\u6570\u636e\u4f1a\u5458\u7ed1\u5b9a\u624b\u673a\u53f7\u64cd\u4f5c\u8bb0\u5f55\u4efb\u52a1\u7ed3\u675f===================");
        this.systemService.addLog("======\u540c\u6b65\u5386\u53f2\u6570\u636e\u4f1a\u5458\u7ed1\u5b9a\u624b\u673a\u53f7\u64cd\u4f5c\u8bb0\u5f55\u4efb\u52a1========\u7ed3\u675f\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        long end = System.currentTimeMillis();
        long times = end - start;
        LogUtil.info((Object)("\u603b\u8017\u65f6" + times + "\u6beb\u79d2"));
    }

    private String getEndDate() {
        String endDate = DateUtils.datetoStr(new Date(), "yyyy-MM-dd HH:mm:ss");
        Map minDate = this.systemService.findOneForJdbc("select binding_member_phone_date from weixin_vip_member_opr where version= 1 order by binding_member_phone_date limit 1 ", new Object[0]);
        if (minDate != null && (endDate = DateUtils.datetoStr(new Date(((Timestamp)minDate.get("binding_member_phone_date")).getTime()), "yyyy-MM-dd HH:mm:ss")) == null) {
            endDate = DateUtils.datetoStr(new Date(), "yyyy-MM-dd HH:mm:ss");
        }
        return endDate;
    }
}

