/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.recept.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.recept.entity.WeixinReceptTasksEntity;
import weixin.guanjia.recept.service.WeixinReceptTasksServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinReceptTasksController"})
public class WeixinReceptTasksController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinReceptTasksController.class);
    @Autowired
    private WeixinReceptTasksServiceI weixinReceptTasksService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinReceptTasks"})
    public ModelAndView weixinReceptTasks(HttpServletRequest request) {
        return new ModelAndView("weixin/guanjia/recept/weixinReceptTasksList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinReceptTasksEntity weixinReceptTasks, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinReceptTasksEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinReceptTasks, (Map)request.getParameterMap());
        cq.add();
        this.weixinReceptTasksService.getDataGridReturn(cq, true);
        List list = dataGrid.getResults();
        SessionFactory sessionFactory = (SessionFactory)ApplicationContextUtil.getContext().getBean("sessionFactory");
        Session session = sessionFactory.getCurrentSession();
        session.close();
        for (WeixinReceptTasksEntity temp : list) {
            String nickName = temp.getNickname();
            if (!oConvertUtils.isNotEmpty((Object)temp.getNickname())) continue;
            temp.setDisplayNickName(new String(WeixinUtil.decode(temp.getNickname())));
        }
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinReceptTasksEntity weixinReceptTasks, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinReceptTasks = (WeixinReceptTasksEntity)this.systemService.getEntity(WeixinReceptTasksEntity.class, (Serializable)((Object)weixinReceptTasks.getId()));
        this.message = "\u5ba2\u670d\u63a5\u5f85\u5386\u53f2\u4efb\u52a1\u5220\u9664\u6210\u529f";
        try {
            this.weixinReceptTasksService.delete(weixinReceptTasks);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5ba2\u670d\u63a5\u5f85\u5386\u53f2\u4efb\u52a1\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5ba2\u670d\u63a5\u5f85\u5386\u53f2\u4efb\u52a1\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinReceptTasksEntity weixinReceptTasks = (WeixinReceptTasksEntity)this.systemService.getEntity(WeixinReceptTasksEntity.class, (Serializable)((Object)id));
                this.weixinReceptTasksService.delete(weixinReceptTasks);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5ba2\u670d\u63a5\u5f85\u5386\u53f2\u4efb\u52a1\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinReceptTasksEntity weixinReceptTasks, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5ba2\u670d\u63a5\u5f85\u5386\u53f2\u4efb\u52a1\u6dfb\u52a0\u6210\u529f";
        try {
            this.weixinReceptTasksService.save(weixinReceptTasks);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5ba2\u670d\u63a5\u5f85\u5386\u53f2\u4efb\u52a1\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinReceptTasksEntity weixinReceptTasks, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5ba2\u670d\u63a5\u5f85\u5386\u53f2\u4efb\u52a1\u66f4\u65b0\u6210\u529f";
        WeixinReceptTasksEntity t = (WeixinReceptTasksEntity)this.weixinReceptTasksService.get(WeixinReceptTasksEntity.class, (Serializable)((Object)weixinReceptTasks.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinReceptTasks, (Object)t);
            this.weixinReceptTasksService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5ba2\u670d\u63a5\u5f85\u5386\u53f2\u4efb\u52a1\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinReceptTasksEntity weixinReceptTasks, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinReceptTasks.getId())) {
            weixinReceptTasks = (WeixinReceptTasksEntity)this.weixinReceptTasksService.getEntity(WeixinReceptTasksEntity.class, (Serializable)((Object)weixinReceptTasks.getId()));
            req.setAttribute("weixinReceptTasksPage", (Object)weixinReceptTasks);
        }
        return new ModelAndView("weixin/guanjia/recept/weixinReceptTasks-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinReceptTasksEntity weixinReceptTasks, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinReceptTasks.getId())) {
            if (oConvertUtils.isNotEmpty((Object)(weixinReceptTasks = (WeixinReceptTasksEntity)this.weixinReceptTasksService.getEntity(WeixinReceptTasksEntity.class, (Serializable)((Object)weixinReceptTasks.getId()))).getNickname())) {
                weixinReceptTasks.setDisplayNickName(new String(WeixinUtil.decode(weixinReceptTasks.getNickname())));
            }
            req.setAttribute("weixinReceptTasksPage", (Object)weixinReceptTasks);
        }
        return new ModelAndView("weixin/guanjia/recept/weixinReceptTasks-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/guanjia/recept/weixinReceptTasksUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinReceptTasksEntity weixinReceptTasks, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5ba2\u670d\u63a5\u5f85\u5386\u53f2\u4efb\u52a1";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinReceptTasksEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinReceptTasks, (Map)request.getParameterMap());
                List weixinReceptTaskss = this.weixinReceptTasksService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5ba2\u670d\u63a5\u5f85\u5386\u53f2\u4efb\u52a1\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinReceptTasksEntity.class, (Collection)weixinReceptTaskss);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinReceptTasksEntity weixinReceptTasks, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5ba2\u670d\u63a5\u5f85\u5386\u53f2\u4efb\u52a1";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5ba2\u670d\u63a5\u5f85\u5386\u53f2\u4efb\u52a1\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinReceptTasksEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinReceptTasksEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinReceptTasksEntity.class, (ImportParams)params);
                    for (WeixinReceptTasksEntity weixinReceptTasks : listWeixinReceptTasksEntitys) {
                        this.weixinReceptTasksService.save(weixinReceptTasks);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

