/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.photosucai.controller;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.photosucai.entity.WeixinPhotosucaiAlbumEntity;
import weixin.guanjia.photosucai.entity.WeixinPhotosucaiEntity;
import weixin.guanjia.photosucai.service.WeixinPhotosucaiAlbumServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinPhotosucaiAlbumController"})
public class WeixinPhotosucaiAlbumController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinPhotosucaiAlbumController.class);
    @Autowired
    private WeixinPhotosucaiAlbumServiceI weixinPhotosucaiAlbumService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinPhotosucaiAlbum"})
    public ModelAndView weixinPhotosucaiAlbum(HttpServletRequest request, WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum) {
        CriteriaQuery cq = new CriteriaQuery(WeixinPhotosucaiAlbumEntity.class);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.addOrder("createDate", SortDirection.desc);
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinPhotosucaiAlbum, (Map)request.getParameterMap());
        List albums = this.weixinPhotosucaiAlbumService.getListByCriteriaQuery(cq, false);
        request.setAttribute("albums", (Object)albums);
        return new ModelAndView("weixin/guanjia/photosucai/weixinPhotosucaiAlbumList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinPhotosucaiAlbumEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinPhotosucaiAlbum, (Map)request.getParameterMap());
        this.weixinPhotosucaiAlbumService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        weixinPhotosucaiAlbum = (WeixinPhotosucaiAlbumEntity)this.systemService.getEntity(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)id));
        this.weixinPhotosucaiAlbumService.deleteFiles(weixinPhotosucaiAlbum);
        this.message = "\u5fae\u76f8\u518c\u5220\u9664\u6210\u529f";
        this.weixinPhotosucaiAlbumService.delete(weixinPhotosucaiAlbum);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"delPhotosucai"})
    @ResponseBody
    public AjaxJson delPhotosucai(WeixinPhotosucaiEntity weixinPhotosucai, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinPhotosucai = (WeixinPhotosucaiEntity)this.systemService.getEntity(WeixinPhotosucaiEntity.class, (Serializable)((Object)weixinPhotosucai.getId()));
        this.weixinPhotosucaiAlbumService.deleteFile(weixinPhotosucai);
        this.message = "\u76f8\u7247\u5220\u9664\u6210\u529f";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"synchPhotosucai"})
    @ResponseBody
    public AjaxJson synchPhotosucai(WeixinPhotosucaiEntity weixinPhotosucai, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinPhotosucai = (WeixinPhotosucaiEntity)this.systemService.getEntity(WeixinPhotosucaiEntity.class, (Serializable)((Object)weixinPhotosucai.getId()));
        String accessToken = this.weixinAccountService.getAccessToken();
        String url = String.valueOf(request.getSession().getServletContext().getRealPath("")) + System.getProperty("file.separator") + weixinPhotosucai.getRealpath();
        JSONObject jsonObj = WeixinUtil.sendMedia("image", url, accessToken);
        if (jsonObj != null) {
            if (jsonObj.containsKey((Object)"errcode")) {
                String errcode = jsonObj.getString("errcode");
                String errmsg = jsonObj.getString("errmsg");
                j.setSuccess(false);
                this.message = "\u56fe\u7247\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5931\u8d25\u3010errcode=" + errcode + "\u3011\u3010errmsg=" + errmsg + "\u3011";
                this.systemService.addLog("\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\uff1a" + this.message, Globals.Log_Type_OTHER, Globals.Log_Leavel_INFO);
            } else {
                this.message = "\u56fe\u7247\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u6210\u529f";
                String media_id = jsonObj.getString("media_id");
                String created_at = jsonObj.getString("created_at");
                weixinPhotosucai.setMediaId(media_id);
                weixinPhotosucai.setSynchDate(new Date());
                weixinPhotosucai.setSynchFlag("true");
                this.weixinPhotosucaiAlbumService.saveOrUpdate(weixinPhotosucai);
                this.systemService.addLog("\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\uff1a" + this.message + "\u3010media_id=" + media_id + "\u3011\u3010created_at=" + created_at + "\u3011", Globals.Log_Type_OTHER, Globals.Log_Leavel_INFO);
                j.setSuccess(true);
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"batchSynchSucai"})
    @ResponseBody
    public AjaxJson batchSynchSucai(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String[] idarray = ids.split(",");
        int succ = 0;
        int error = 0;
        String[] stringArray = idarray;
        int n = idarray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            WeixinPhotosucaiEntity sucai = (WeixinPhotosucaiEntity)this.systemService.getEntity(WeixinPhotosucaiEntity.class, (Serializable)((Object)id));
            List sucais = this.systemService.findByQueryString("from WeixinPhotosucaiEntity where code='" + sucai.getCode() + "' and postcode like '" + sucai.getPostcode() + "%'");
            for (WeixinPhotosucaiEntity sc : sucais) {
                String accessToken = this.weixinAccountService.getAccessToken(sc.getAccountid());
                String url = String.valueOf(request.getSession().getServletContext().getRealPath("")) + System.getProperty("file.separator") + sc.getRealpath();
                JSONObject jsonObj = WeixinUtil.sendMedia("image", url, accessToken);
                if (jsonObj == null) continue;
                if (jsonObj.containsKey((Object)"errcode")) {
                    String errcode = jsonObj.getString("errcode");
                    String errmsg = jsonObj.getString("errmsg");
                    j.setSuccess(false);
                    this.message = "\u56fe\u7247\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5931\u8d25\u3010errcode=" + errcode + "\u3011\u3010errmsg=" + errmsg + "\u3011";
                    this.systemService.addLog("\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\uff1a" + this.message, Globals.Log_Type_OTHER, Globals.Log_Leavel_INFO);
                    ++error;
                    continue;
                }
                this.message = "\u56fe\u7247\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u6210\u529f";
                String media_id = jsonObj.getString("media_id");
                String created_at = jsonObj.getString("created_at");
                sc.setMediaId(media_id);
                sc.setSynchDate(new Date());
                sc.setSynchFlag("true");
                this.weixinPhotosucaiAlbumService.saveOrUpdate(sc);
                this.systemService.addLog("\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\uff1a" + this.message + "\u3010media_id=" + media_id + "\u3011\u3010created_at=" + created_at + "\u3011", Globals.Log_Type_OTHER, Globals.Log_Leavel_INFO);
                j.setSuccess(true);
                ++succ;
            }
            ++n2;
        }
        j.setSuccess(true);
        this.message = "\u64cd\u4f5c\u5b8c\u6210";
        if (succ > 0) {
            this.message = String.valueOf(this.message) + "\uff0c\u6210\u529f\u4e0a\u4f20" + succ + "\u4e2a";
        }
        if (error > 0) {
            this.message = String.valueOf(this.message) + "\uff0c\u5931\u8d25\u4e0a\u4f20" + error + "\u4e2a";
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String albumId = null;
        if (StringUtil.isNotEmpty((Object)weixinPhotosucaiAlbum.getId())) {
            this.message = "\u5fae\u76f8\u518c\u66f4\u65b0\u6210\u529f";
            albumId = weixinPhotosucaiAlbum.getId();
            WeixinPhotosucaiAlbumEntity t = (WeixinPhotosucaiAlbumEntity)this.weixinPhotosucaiAlbumService.get(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)weixinPhotosucaiAlbum.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinPhotosucaiAlbum, (Object)t);
                this.weixinPhotosucaiAlbumService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u76f8\u518c\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            String accountId = ResourceUtil.getShangJiaAccountId();
            weixinPhotosucaiAlbum.setAccountid(accountId);
            this.message = "\u5fae\u76f8\u518c\u6dfb\u52a0\u6210\u529f";
            albumId = (String)((Object)this.weixinPhotosucaiAlbumService.save(weixinPhotosucaiAlbum));
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("albumId", albumId);
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"savePhotosucai"})
    @ResponseBody
    public AjaxJson savePhotosucai(WeixinPhotosucaiEntity weixinPhotosucai, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)weixinPhotosucai.getId())) {
            this.message = "\u76f8\u7247\u66f4\u65b0\u6210\u529f";
            WeixinPhotosucaiEntity t = (WeixinPhotosucaiEntity)this.systemService.get(WeixinPhotosucaiEntity.class, (Serializable)((Object)weixinPhotosucai.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinPhotosucai, (Object)t);
                this.weixinPhotosucaiAlbumService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u76f8\u7247\u66f4\u65b0\u5931\u8d25";
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinPhotosucaiAlbum.getId())) {
            weixinPhotosucaiAlbum = (WeixinPhotosucaiAlbumEntity)this.weixinPhotosucaiAlbumService.getEntity(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)weixinPhotosucaiAlbum.getId()));
            req.setAttribute("weixinPhotosucaiAlbumPage", (Object)weixinPhotosucaiAlbum);
        }
        return new ModelAndView("weixin/guanjia/photosucai/weixinPhotosucaiAlbum");
    }

    @RequestMapping(params={"goEditPhotosucai"})
    public ModelAndView goEditPhotosucai(WeixinPhotosucaiEntity weixinPhotosucai, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinPhotosucai.getId())) {
            weixinPhotosucai = (WeixinPhotosucaiEntity)this.weixinPhotosucaiAlbumService.getEntity(WeixinPhotosucaiEntity.class, (Serializable)((Object)weixinPhotosucai.getId()));
            req.setAttribute("weixinPhotosucai", (Object)weixinPhotosucai);
        }
        return new ModelAndView("weixin/guanjia/photosucai/weixinPhotosucai");
    }

    @RequestMapping(params={"uploadPhotosucaiInit"})
    public ModelAndView uploadPhotosucaiInit(HttpServletRequest request) {
        request.setAttribute("albumId", (Object)request.getParameter("albumId"));
        String accountId = ResourceUtil.getShangJiaAccountId();
        String postCode = ResourceUtil.getShangJiaAccount().getPostCode();
        request.setAttribute("accountId", (Object)accountId);
        request.setAttribute("postCode", (Object)postCode);
        return new ModelAndView("weixin/guanjia/photosucai/uploadPhotosucai");
    }

    @RequestMapping(params={"viewPhotosucais"})
    public ModelAndView viewPhotosucais(HttpServletRequest request) {
        String id = request.getParameter("id");
        request.setAttribute("id", (Object)id);
        WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum = (WeixinPhotosucaiAlbumEntity)this.weixinPhotosucaiAlbumService.getEntity(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)id));
        if (weixinPhotosucaiAlbum.getPhotosucai() != null) {
            request.setAttribute("photosucaiId", (Object)weixinPhotosucaiAlbum.getPhotosucai().getId());
        } else {
            request.setAttribute("photosucaiId", (Object)"");
        }
        String titleName = request.getParameter("titleName");
        List photosucais = this.weixinPhotosucaiAlbumService.getPhotoSucaiList(titleName, id);
        request.setAttribute("photosucais", photosucais);
        List albums = this.weixinPhotosucaiAlbumService.findByProperty(WeixinPhotosucaiAlbumEntity.class, "accountid", ResourceUtil.getShangJiaAccountId());
        request.setAttribute("albums", (Object)albums);
        request.setAttribute("weixinPhotosucaiAlbum", (Object)weixinPhotosucaiAlbum);
        return new ModelAndView("weixin/guanjia/photosucai/viewPhotosucais");
    }

    @RequestMapping(params={"changeAlbum"})
    public ModelAndView changeAlbum(HttpServletRequest request, String ids) {
        String[] idarray;
        String AlbumId = request.getParameter("id");
        WeixinPhotosucaiAlbumEntity album = (WeixinPhotosucaiAlbumEntity)this.weixinPhotosucaiAlbumService.getEntity(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)AlbumId));
        String[] stringArray = idarray = ids.split(",");
        int n = idarray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!StringUtil.isEmpty((String)id)) {
                WeixinPhotosucaiEntity photosucaiEntity = (WeixinPhotosucaiEntity)this.weixinPhotosucaiAlbumService.getEntity(WeixinPhotosucaiEntity.class, (Serializable)((Object)id));
                photosucaiEntity.setAlbum(album);
                this.weixinPhotosucaiAlbumService.saveOrUpdate(photosucaiEntity);
            }
            ++n2;
        }
        return this.viewPhotosucais(request);
    }

    @RequestMapping(params={"saveFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveFiles(HttpServletRequest request, HttpServletResponse response, WeixinPhotosucaiEntity photosucai) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String shareStatus = oConvertUtils.getString((String)request.getParameter("shareStatus"));
        String albumId = oConvertUtils.getString((String)request.getParameter("albumId"));
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            photosucai.setId(fileKey);
            photosucai = (WeixinPhotosucaiEntity)this.systemService.getEntity(WeixinPhotosucaiEntity.class, (Serializable)((Object)fileKey));
        }
        WeixinPhotosucaiAlbumEntity album = (WeixinPhotosucaiAlbumEntity)this.systemService.getEntity(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)albumId));
        photosucai.setAlbum(album);
        photosucai.setName("\u672a\u547d\u540d");
        photosucai.setCode(DataUtils.getDateUUID((String)"yyyyMMddHHmmssSSS"));
        photosucai.setSourceType("1");
        photosucai.setShareStatus(shareStatus);
        String accountId = ResourceUtil.getShangJiaAccountId();
        if (accountId.equals("NULL-NULL-NULL-NULL-NULL-NULL-NULL-NULL-NULL")) {
            accountId = oConvertUtils.getString((String)request.getParameter("accountId"));
            String postCode = oConvertUtils.getString((String)request.getParameter("postCode"));
            photosucai.setPostcode(postCode);
        }
        photosucai.setAccountid(accountId);
        photosucai.setSynchFlag("false");
        UploadFile uploadFile = new UploadFile(request, (Object)photosucai);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        uploadFile.setByteField(null);
        photosucai = (WeixinPhotosucaiEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", photosucai.getId());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + photosucai.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + photosucai.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"setAlbumFace"})
    @ResponseBody
    public AjaxJson setAlbumFace(WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String photosucaiId = request.getParameter("photosucaiId");
        WeixinPhotosucaiEntity photosucai = (WeixinPhotosucaiEntity)this.systemService.get(WeixinPhotosucaiEntity.class, (Serializable)((Object)photosucaiId));
        WeixinPhotosucaiAlbumEntity t = (WeixinPhotosucaiAlbumEntity)this.weixinPhotosucaiAlbumService.get(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)weixinPhotosucaiAlbum.getId()));
        t.setPhotosucai(photosucai);
        this.weixinPhotosucaiAlbumService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u8bbe\u7f6e\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"cancelAlbumFace"})
    @ResponseBody
    public AjaxJson cancelAlbumFace(WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        WeixinPhotosucaiAlbumEntity t = (WeixinPhotosucaiAlbumEntity)this.weixinPhotosucaiAlbumService.get(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)weixinPhotosucaiAlbum.getId()));
        t.setPhotosucai(null);
        this.weixinPhotosucaiAlbumService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u53d6\u6d88\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }
}

