/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.photosucai.controller;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.util.CmsFreemarkerHelper;
import weixin.guanjia.photosucai.common.PhotosucaiConstant;
import weixin.guanjia.photosucai.entity.WeixinPhotosucaiAlbumEntity;
import weixin.guanjia.photosucai.entity.WeixinPhotosucaiEntity;
import weixin.guanjia.photosucai.service.WeixinPhotosucaiAlbumServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/frontPhotosucaiAlbumController"})
public class FrontPhotosucaiAlbumController
extends BaseController
implements PhotosucaiConstant {
    private static final Logger logger = Logger.getLogger(FrontPhotosucaiAlbumController.class);
    @Autowired
    private WeixinPhotosucaiAlbumServiceI weixinPhotosucaiAlbumService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private Map<String, String> paramsToMap(HttpServletRequest request) {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration em = request.getParameterNames();
        while (em.hasMoreElements()) {
            String paramName = (String)em.nextElement();
            String paramValue = request.getParameter(paramName);
            params.put(paramName, paramValue);
        }
        if (!params.containsKey("accountid")) {
            params.put("accountid", ResourceUtil.getShangJiaAccountId());
        }
        return params;
    }

    @RequestMapping(params={"goPage"})
    public void goPage(HttpServletRequest request, HttpServletResponse response, @RequestParam String page) {
        Map<String, String> params = this.paramsToMap(request);
        String styleUrl = "/template/photosucai";
        WeixinPhotosucaiAlbumEntity photosucaiAlbum = (WeixinPhotosucaiAlbumEntity)this.weixinPhotosucaiAlbumService.findUniqueByProperty(WeixinPhotosucaiAlbumEntity.class, "accountid", params.get("accountid"));
        styleUrl = photosucaiAlbum != null ? String.valueOf(styleUrl) + "/" + "default" : String.valueOf(styleUrl) + "/" + "default";
        HashMap<String, Object> data = new HashMap<String, Object>();
        String res = "template/photosucai/default";
        data.put("res", res);
        List photosucaiAlbums = this.weixinPhotosucaiAlbumService.getList(WeixinPhotosucaiAlbumEntity.class);
        data.put("photosucaiAlbumData", photosucaiAlbums);
        if (photosucaiAlbums != null && photosucaiAlbums.size() > 0) {
            List<WeixinPhotosucaiEntity> photosucais = ((WeixinPhotosucaiAlbumEntity)photosucaiAlbums.get(0)).getPhotosucais();
            data.put("photosucaiData", photosucais);
        }
        String pageUrl = String.valueOf(styleUrl) + "/" + "html" + "/" + page + ".html";
        CmsFreemarkerHelper cmsFreemarkerHelper = new CmsFreemarkerHelper();
        String html = cmsFreemarkerHelper.parseTemplate(pageUrl, data);
        response.setContentType("text/html");
        response.setHeader("Cache-Control", "no-store");
        PrintWriter writer = null;
        try {
            try {
                writer = response.getWriter();
                writer.println(html);
                writer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinPhotosucaiAlbumEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinPhotosucaiAlbum, (Map)request.getParameterMap());
        this.weixinPhotosucaiAlbumService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        weixinPhotosucaiAlbum = (WeixinPhotosucaiAlbumEntity)this.systemService.getEntity(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)id));
        this.weixinPhotosucaiAlbumService.deleteFiles(weixinPhotosucaiAlbum);
        this.message = "\u5fae\u76f8\u518c\u5220\u9664\u6210\u529f";
        this.weixinPhotosucaiAlbumService.delete(weixinPhotosucaiAlbum);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"delPhotosucai"})
    @ResponseBody
    public AjaxJson delPhotosucai(WeixinPhotosucaiEntity weixinPhotosucai, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinPhotosucai = (WeixinPhotosucaiEntity)this.systemService.getEntity(WeixinPhotosucaiEntity.class, (Serializable)((Object)weixinPhotosucai.getId()));
        this.weixinPhotosucaiAlbumService.deleteFile(weixinPhotosucai);
        this.message = "\u76f8\u7247\u5220\u9664\u6210\u529f";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String albumId = null;
        if (StringUtil.isNotEmpty((Object)weixinPhotosucaiAlbum.getId())) {
            this.message = "\u5fae\u76f8\u518c\u66f4\u65b0\u6210\u529f";
            albumId = weixinPhotosucaiAlbum.getId();
            WeixinPhotosucaiAlbumEntity t = (WeixinPhotosucaiAlbumEntity)this.weixinPhotosucaiAlbumService.get(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)weixinPhotosucaiAlbum.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinPhotosucaiAlbum, (Object)t);
                this.weixinPhotosucaiAlbumService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u76f8\u518c\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            String accountId = ResourceUtil.getShangJiaAccount().getAccountappid();
            weixinPhotosucaiAlbum.setAccountid(accountId);
            this.message = "\u5fae\u76f8\u518c\u6dfb\u52a0\u6210\u529f";
            albumId = (String)((Object)this.weixinPhotosucaiAlbumService.save(weixinPhotosucaiAlbum));
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("albumId", albumId);
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"savePhotosucai"})
    @ResponseBody
    public AjaxJson savePhotosucai(WeixinPhotosucaiEntity weixinPhotosucai, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)weixinPhotosucai.getId())) {
            this.message = "\u76f8\u7247\u66f4\u65b0\u6210\u529f";
            WeixinPhotosucaiEntity t = (WeixinPhotosucaiEntity)this.systemService.get(WeixinPhotosucaiEntity.class, (Serializable)((Object)weixinPhotosucai.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinPhotosucai, (Object)t);
                this.weixinPhotosucaiAlbumService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u76f8\u7247\u66f4\u65b0\u5931\u8d25";
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinPhotosucaiAlbum.getId())) {
            weixinPhotosucaiAlbum = (WeixinPhotosucaiAlbumEntity)this.weixinPhotosucaiAlbumService.getEntity(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)weixinPhotosucaiAlbum.getId()));
            req.setAttribute("weixinPhotosucaiAlbumPage", (Object)weixinPhotosucaiAlbum);
        }
        return new ModelAndView("weixin/guanjia/photosucai/weixinPhotosucaiAlbum");
    }

    @RequestMapping(params={"goEditPhotosucai"})
    public ModelAndView goEditPhotosucai(WeixinPhotosucaiEntity weixinPhotosucai, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinPhotosucai.getId())) {
            weixinPhotosucai = (WeixinPhotosucaiEntity)this.weixinPhotosucaiAlbumService.getEntity(WeixinPhotosucaiEntity.class, (Serializable)((Object)weixinPhotosucai.getId()));
            req.setAttribute("weixinPhotosucai", (Object)weixinPhotosucai);
        }
        return new ModelAndView("weixin/guanjia/photosucai/weixinPhotosucai");
    }

    @RequestMapping(params={"uploadPhotosucaiInit"})
    public ModelAndView uploadPhotosucaiInit(HttpServletRequest request) {
        request.setAttribute("albumId", (Object)request.getParameter("albumId"));
        return new ModelAndView("weixin/guanjia/photosucai/uploadPhotosucai");
    }

    @RequestMapping(params={"viewPhotosucais"})
    public ModelAndView viewPhotosucais(HttpServletRequest request) {
        String id = request.getParameter("id");
        request.setAttribute("id", (Object)id);
        WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum = (WeixinPhotosucaiAlbumEntity)this.weixinPhotosucaiAlbumService.getEntity(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)id));
        List<WeixinPhotosucaiEntity> photosucais = weixinPhotosucaiAlbum.getPhotosucais();
        if (weixinPhotosucaiAlbum.getPhotosucai() != null) {
            request.setAttribute("photosucaiId", (Object)weixinPhotosucaiAlbum.getPhotosucai().getId());
        } else {
            request.setAttribute("photosucaiId", (Object)"");
        }
        request.setAttribute("photosucais", photosucais);
        return new ModelAndView("weixin/guanjia/photosucai/viewPhotosucais");
    }

    @RequestMapping(params={"saveFiles"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson saveFiles(HttpServletRequest request, HttpServletResponse response, WeixinPhotosucaiEntity photosucai) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String albumId = oConvertUtils.getString((String)request.getParameter("albumId"));
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            photosucai.setId(fileKey);
            photosucai = (WeixinPhotosucaiEntity)this.systemService.getEntity(WeixinPhotosucaiEntity.class, (Serializable)((Object)fileKey));
        }
        WeixinPhotosucaiAlbumEntity album = (WeixinPhotosucaiAlbumEntity)this.systemService.getEntity(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)albumId));
        photosucai.setAlbum(album);
        photosucai.setName("\u672a\u547d\u540d");
        UploadFile uploadFile = new UploadFile(request, (Object)photosucai);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        uploadFile.setByteField(null);
        photosucai = (WeixinPhotosucaiEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", photosucai.getId());
        attributes.put("viewhref", "commonController.do?objfileList&fileKey=" + photosucai.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + photosucai.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"setAlbumFace"})
    @ResponseBody
    public AjaxJson setAlbumFace(WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String photosucaiId = request.getParameter("photosucaiId");
        WeixinPhotosucaiEntity photosucai = (WeixinPhotosucaiEntity)this.systemService.get(WeixinPhotosucaiEntity.class, (Serializable)((Object)photosucaiId));
        WeixinPhotosucaiAlbumEntity t = (WeixinPhotosucaiAlbumEntity)this.weixinPhotosucaiAlbumService.get(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)weixinPhotosucaiAlbum.getId()));
        t.setPhotosucai(photosucai);
        this.weixinPhotosucaiAlbumService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u8bbe\u7f6e\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"cancelAlbumFace"})
    @ResponseBody
    public AjaxJson cancelAlbumFace(WeixinPhotosucaiAlbumEntity weixinPhotosucaiAlbum, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        WeixinPhotosucaiAlbumEntity t = (WeixinPhotosucaiAlbumEntity)this.weixinPhotosucaiAlbumService.get(WeixinPhotosucaiAlbumEntity.class, (Serializable)((Object)weixinPhotosucaiAlbum.getId()));
        t.setPhotosucai(null);
        this.weixinPhotosucaiAlbumService.saveOrUpdate(t);
        this.message = "\u6210\u529f\u53d6\u6d88\u5c01\u9762";
        j.setMsg(this.message);
        return j;
    }
}

