/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.message.service.impl;

import java.io.Serializable;
import java.util.List;
import org.hibernate.Criteria;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.YouBianCodeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.message.entity.TextTemplate;
import weixin.guanjia.message.service.TextTemplateServiceI;

@Service(value="textTemplateService")
@Transactional
public class TextTemplateServiceImpl
extends CommonServiceImpl
implements TextTemplateServiceI {
    @Autowired
    private WeixinAccountServiceI weixinAccountService;

    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((TextTemplate)((Object)entity));
    }

    @Override
    public <T> Serializable save(T entity) {
        ((TextTemplate)((Object)entity)).setAccountId(ResourceUtil.getShangJiaAccountId());
        Serializable t = super.save(entity);
        this.doAddSql((TextTemplate)((Object)entity));
        return t;
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        super.saveOrUpdate(entity);
        this.doUpdateSql((TextTemplate)((Object)entity));
    }

    @Override
    public boolean doAddSql(TextTemplate t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(TextTemplate t) {
        return true;
    }

    @Override
    public boolean doDelSql(TextTemplate t) {
        return true;
    }

    @Override
    public <T> List<T> getTextTemplateList() {
        CriteriaQuery cq = new CriteriaQuery(TextTemplate.class);
        cq.eq("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        cq.eq("shareStatus", (Object)"Y");
        cq.in("postcode", (Object[])YouBianCodeUtil.cutYouBianCode((String)ResourceUtil.getShangJiaAccount().getPostCode()));
        cq.add(cq.or(cq.and(cq, 1, 2), cq, 0));
        Criteria criteria = cq.getDetachedCriteria().getExecutableCriteria(this.getSession());
        List list = criteria.list();
        return list;
    }
}

