/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.message.service.impl;

import java.io.Serializable;
import java.util.List;
import jodd.util.StringUtil;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.message.dao.ReceiveTextDao;
import weixin.guanjia.message.entity.ReceiveText;
import weixin.guanjia.message.service.ReceiveTextServiceI;

@Service(value="receiveTextService")
@Transactional
public class ReceiveTextServiceImpl
extends CommonServiceImpl
implements ReceiveTextServiceI {
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private ReceiveTextDao receiveTextDao;

    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((ReceiveText)((Object)entity));
    }

    @Override
    public <T> Serializable save(T entity) {
        Serializable t = super.save(entity);
        this.doAddSql((ReceiveText)((Object)entity));
        return t;
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        super.saveOrUpdate(entity);
        this.doUpdateSql((ReceiveText)((Object)entity));
    }

    @Override
    public boolean doAddSql(ReceiveText t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(ReceiveText t) {
        return true;
    }

    @Override
    public boolean doDelSql(ReceiveText t) {
        return true;
    }

    @Override
    public List<ReceiveText> queryNewMessageGroup(ReceiveText receiveText, int page, int rows) {
        if (!StringUtil.isBlank((String)receiveText.getNickName())) {
            receiveText.setNickName(WeixinUtil.encode(receiveText.getNickName().getBytes()));
        }
        if (!StringUtil.isBlank((String)receiveText.getFromUserName())) {
            receiveText.setFromUserName(receiveText.getFromUserName());
        }
        return this.receiveTextDao.queryNewMessageGroup(receiveText, page, rows);
    }

    @Override
    public int getCountQueryNewMessageGroup(ReceiveText receiveText) {
        return this.receiveTextDao.getCountQueryNewMessageGroup(receiveText);
    }

    @Override
    public List<ReceiveText> queryNewTwoHourMessageGroup(ReceiveText receiveText, int page, int row) {
        if (!StringUtil.isBlank((String)receiveText.getNickName())) {
            receiveText.setNickName(WeixinUtil.encode(receiveText.getNickName().getBytes()));
        }
        return this.receiveTextDao.queryNewTwoHourMessageGroup(receiveText, page, row);
    }

    @Override
    public int getCountQueryNewTwoHourMessageGroup(ReceiveText receiveText) {
        return this.receiveTextDao.getCountQueryNewTwoHourMessageGroup(receiveText);
    }

    @Override
    public List<ReceiveText> queryWaiterReceptMessage(ReceiveText receiveText, String userId, int page, int row) {
        return this.receiveTextDao.queryWaiterReceptMessage(receiveText, userId, page, row);
    }

    @Override
    public int getCountQueryWaiterReceptMessage(ReceiveText receiveText, String userId) {
        return this.receiveTextDao.getCountQueryWaiterReceptMessage(receiveText, userId);
    }
}

