/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.message.service.impl;

import java.io.Serializable;
import java.util.List;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.YouBianCodeUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.message.entity.NewsTemplate;
import weixin.guanjia.message.service.NewsTemplateServiceI;

@Service(value="newsTemplateService")
@Transactional
public class NewsTemplateServiceImpl
extends CommonServiceImpl
implements NewsTemplateServiceI {
    @Autowired
    private WeixinAccountServiceI weixinAccountService;

    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((NewsTemplate)((Object)entity));
    }

    @Override
    public <T> Serializable save(T entity) {
        ((NewsTemplate)((Object)entity)).setAccountId(ResourceUtil.getShangJiaAccountId());
        Serializable t = super.save(entity);
        this.doAddSql((NewsTemplate)((Object)entity));
        return t;
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        super.saveOrUpdate(entity);
        this.doUpdateSql((NewsTemplate)((Object)entity));
    }

    @Override
    public boolean doAddSql(NewsTemplate t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(NewsTemplate t) {
        return true;
    }

    @Override
    public boolean doDelSql(NewsTemplate t) {
        return true;
    }

    @Override
    public List<NewsTemplate> findByAccountidWithShare(String accountid) {
        CriteriaQuery cq = new CriteriaQuery(NewsTemplate.class);
        cq.eq("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        cq.eq("shareStatus", (Object)"Y");
        cq.in("postcode", (Object[])YouBianCodeUtil.cutYouBianCode((String)ResourceUtil.getShangJiaAccount().getPostCode()));
        cq.add(cq.or(cq.and(cq, 1, 2), cq, 0));
        return this.getListByCriteriaQuery(cq, false);
    }
}

