/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.message.service.impl;

import java.util.List;
import javax.annotation.Resource;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.jeewx.api.wxbase.wxmedia.JwMediaAPI;
import org.jeewx.api.wxbase.wxmedia.model.WxDwonload;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.message.entity.ReceiveText;
import weixin.idea.video.common.FFMpegUtil;
import weixin.util.DateUtils;

@Service(value="downMediaTimer")
public class DownMediaTimerJob {
    private static final String mediaUploadPath = "upload/weixin/media/";
    @Resource
    private SystemService systemService;
    @Resource
    private WeixinAccountServiceI weixinAccountService;

    public void downMedia() {
        long start = System.currentTimeMillis();
        this.systemService.addLog("======\u4e0b\u8f7d\u591a\u5a92\u4f53\u8d44\u6e90\u5230\u672c\u5730\u5b9a\u65f6\u4efb\u52a1========\u5f00\u59cb\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        LogUtil.info((Object)"===================\u4e0b\u8f7d\u591a\u5a92\u4f53\u8d44\u6e90\u5230\u672c\u5730\u5b9a\u65f6\u4efb\u52a1\u5f00\u59cb===================");
        List receiveList = this.systemService.findHql("from ReceiveText where mediaId is not null and mediaUrl is null", null);
        String mediaId = "";
        for (ReceiveText rt : receiveList) {
            mediaId = rt.getMediaId();
            if (!oConvertUtils.isNotEmpty((Object)mediaId)) continue;
            try {
                WeixinAccountEntity weixinAccount = (WeixinAccountEntity)this.systemService.findUniqueByProperty(WeixinAccountEntity.class, "weixinOriginalAccountid", (Object)rt.getToUserName());
                if (weixinAccount == null) continue;
                String accessToke = this.weixinAccountService.getAccessToken(weixinAccount.getId());
                String filePath = String.valueOf(System.getProperty("jeecg")) + mediaUploadPath;
                WxDwonload wxDwonload = JwMediaAPI.downMedia((String)accessToke, (String)mediaId, (String)(filePath = filePath.replace("\\", "/")));
                String fileName = wxDwonload.getFileName();
                if (oConvertUtils.isNotEmpty((Object)fileName) && fileName.endsWith(".")) {
                    fileName = fileName.substring(0, fileName.length() - 1);
                }
                if ("voice".equals(rt.getMsgType())) {
                    String basePath = String.valueOf(System.getProperty("jeecg").replace("\\", "/")) + ResourceUtil.getConfigByName((String)"ffmpeg.dir");
                    FFMpegUtil ffMpegUtil = new FFMpegUtil(String.valueOf(basePath) + "ffmpeg", String.valueOf(filePath) + fileName);
                    fileName = String.valueOf(fileName) + ".mp3";
                    ffMpegUtil.amr2mp3(String.valueOf(filePath) + fileName);
                }
                rt.setMediaUrl(mediaUploadPath + fileName);
                this.systemService.addLog("======\u6210\u529f\u4e0b\u8f7d\u591a\u5a92\u4f53\u8d44\u6e90=======\uff1aupload/weixin/media/" + fileName, Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
                this.systemService.updateEntitie((Object)rt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        long end = System.currentTimeMillis();
        long times = end - start;
        LogUtil.info((Object)("\u603b\u8017\u65f6" + times + "\u6beb\u79d2"));
        this.systemService.addLog("======\u4e0b\u8f7d\u591a\u5a92\u4f53\u8d44\u6e90\u5230\u672c\u5730\u5b9a\u65f6\u4efb\u52a1=======\u7ed3\u675f\u65f6\u95f4{" + DateUtils.getDataString(DateUtils.time_sdf) + "}" + "\u603b\u8017\u65f6" + times + "\u6beb\u79d2", Globals.Log_Type_DINGSHI, Globals.Log_Leavel_INFO);
        LogUtil.info((Object)"===================\u4e0b\u8f7d\u591a\u5a92\u4f53\u8d44\u6e90\u5230\u672c\u5730\u5b9a\u65f6\u4efb\u52a1===================");
    }
}

