/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.message.controller;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSDocument;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.service.WeixinCmsStyleServiceI;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.message.entity.NewsItem;
import weixin.guanjia.message.entity.NewsTemplate;
import weixin.guanjia.message.service.NewsItemServiceI;
import weixin.util.DateUtils;

@Controller
@RequestMapping(value={"/weixinArticleController"})
public class WeixinArticleController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinArticleController.class);
    @Autowired
    private NewsItemServiceI newsItemService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private WeixinCmsStyleServiceI weixinCmsStyleService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"goMessage"})
    public ModelAndView goMessage(HttpServletRequest request) {
        String templateId = request.getParameter("templateId");
        if (StringUtil.isNotEmpty((Object)templateId)) {
            String hql = "from NewsItem where newsTemplate.id='" + templateId + "' order by orders asc";
            LogUtil.info((Object)("...hql..." + hql));
            List headerList = this.systemService.findByQueryString(hql);
            if (headerList.size() > 0) {
                request.setAttribute("headerNews", headerList.get(0));
                if (headerList.size() > 1) {
                    ArrayList list = new ArrayList(headerList);
                    list.remove(0);
                    request.setAttribute("newsList", list);
                }
            }
            NewsTemplate newsTemplate = (NewsTemplate)((Object)this.systemService.getEntity(NewsTemplate.class, (Serializable)((Object)templateId)));
            String temp = newsTemplate.getAddTime().replace("-", "/");
            Date addTime = new Date(temp);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
            request.setAttribute("addtime", (Object)sdf.format(addTime));
        }
        return new ModelAndView("weixin/guanjia/newstemplate/showmessage");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(NewsItem weixinArticle, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(NewsItem.class, dataGrid);
        cq.eq("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)((Object)weixinArticle), (Map)request.getParameterMap());
        cq.add();
        this.newsItemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(NewsItem weixinArticle, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinArticle = (NewsItem)((Object)this.systemService.getEntity(NewsItem.class, (Serializable)((Object)weixinArticle.getId())));
        this.message = "\u5fae\u4fe1\u5355\u56fe\u6d88\u606f\u5220\u9664\u6210\u529f";
        try {
            this.newsItemService.delete(weixinArticle);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u4fe1\u5355\u56fe\u6d88\u606f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u4fe1\u5355\u56fe\u6d88\u606f\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                NewsItem weixinArticle = (NewsItem)((Object)this.systemService.getEntity(NewsItem.class, (Serializable)((Object)id)));
                this.newsItemService.delete(weixinArticle);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u4fe1\u5355\u56fe\u6d88\u606f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(NewsItem weixinArticle, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u4fe1\u5355\u56fe\u6d88\u606f\u6dfb\u52a0\u6210\u529f";
        try {
            String templateId = request.getParameter("templateId");
            NewsTemplate temp1 = (NewsTemplate)((Object)this.systemService.getEntity(NewsTemplate.class, (Serializable)((Object)templateId)));
            weixinArticle.setNewsTemplate(temp1);
            weixinArticle.setInterviewCount(0);
            weixinArticle.setPraiseCount(0);
            weixinArticle.setComplainCount(0);
            String accountId = ResourceUtil.getShangJiaAccountId();
            if (!"-1".equals(accountId)) {
                this.newsItemService.save(weixinArticle);
            } else {
                j.setSuccess(false);
                j.setMsg("\u8bf7\u6dfb\u52a0\u4e00\u4e2a\u516c\u4f17\u5e10\u53f7\u3002");
            }
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u4fe1\u5355\u56fe\u6d88\u606f\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(NewsItem weixinArticle, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u4fe1\u5355\u56fe\u6d88\u606f\u66f4\u65b0\u6210\u529f";
        if (!"1".equals(weixinArticle.getDisplayCoverFlag())) {
            weixinArticle.setDisplayCoverFlag("0");
        }
        NewsItem t = (NewsItem)((Object)this.newsItemService.get(NewsItem.class, (Serializable)((Object)weixinArticle.getId())));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)((Object)weixinArticle), (Object)((Object)t));
            this.newsItemService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u4fe1\u5355\u56fe\u6d88\u606f\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(NewsItem weixinArticle, HttpServletRequest req) {
        String templateId = req.getParameter("templateId");
        req.setAttribute("templateId", (Object)templateId);
        if (StringUtil.isNotEmpty((Object)weixinArticle.getId())) {
            weixinArticle = (NewsItem)((Object)this.newsItemService.getEntity(NewsItem.class, (Serializable)((Object)weixinArticle.getId())));
            req.setAttribute("weixinArticlePage", (Object)weixinArticle);
        }
        return new ModelAndView("weixin/guanjia/newstemplate/weixinArticle-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(NewsItem weixinArticle, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinArticle.getId())) {
            weixinArticle = (NewsItem)((Object)this.newsItemService.getEntity(NewsItem.class, (Serializable)((Object)weixinArticle.getId())));
            req.setAttribute("weixinArticle", (Object)weixinArticle);
        }
        req.setAttribute("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        return new ModelAndView("weixin/guanjia/newstemplate/weixinArticle-update");
    }

    @RequestMapping(params={"upload"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson upload(MultipartHttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        TSTypegroup tsTypegroup = this.systemService.getTypeGroup("fieltype", "\u6587\u6863\u5206\u7c7b");
        TSType tsType = this.systemService.getType("files", "\u9644\u4ef6", tsTypegroup);
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String documentTitle = oConvertUtils.getString((String)request.getParameter("documentTitle"));
        TSDocument document = new TSDocument();
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            document.setId(fileKey);
            document = (TSDocument)this.systemService.getEntity(TSDocument.class, (Serializable)((Object)fileKey));
            document.setDocumentTitle(documentTitle);
        }
        document.setSubclassname(MyClassLoader.getPackPath((Object)document));
        document.setCreatedate(DateUtils.gettimestamp());
        document.setTSType(tsType);
        UploadFile uploadFile = new UploadFile((HttpServletRequest)request, (Object)document);
        uploadFile.setCusPath("weixin/images");
        document = (TSDocument)this.systemService.uploadFile(uploadFile);
        attributes.put("url", document.getRealpath());
        attributes.put("fileKey", document.getId());
        attributes.put("name", document.getAttachmenttitle());
        attributes.put("viewhref", "commonController.do?openViewFile&fileid=" + document.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + document.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"copyContent"})
    public ModelAndView copyContent(String url, HttpServletRequest req) {
        req.setAttribute("copyContent", (Object)url);
        return new ModelAndView("weixin/guanjia/newstemplate/copyContent");
    }
}

