/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.message.controller;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.YouBianCodeUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.message.dao.TextTemplateDao;
import weixin.guanjia.message.entity.TextTemplate;
import weixin.guanjia.message.service.TextTemplateServiceI;
import weixin.util.PostCodeUtil;

@Controller
@RequestMapping(value={"/textTemplateController"})
public class TextTemplateController {
    @Autowired
    private TextTemplateDao textTemplateDao;
    @Autowired
    private TextTemplateServiceI textTemplateService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private String message;

    @RequestMapping(params={"list"})
    public ModelAndView list() {
        return new ModelAndView("weixin/guanjia/texttemplate/textTemplateList");
    }

    @RequestMapping(params={"datagrid"})
    @ResponseBody
    public void datagrid(TextTemplate textTemplate, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TextTemplate.class, dataGrid);
        cq.eq("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        cq.eq("shareStatus", (Object)"Y");
        cq.in("postcode", (Object[])YouBianCodeUtil.cutYouBianCode((String)ResourceUtil.getShangJiaAccount().getPostCode()));
        cq.addOrder("addTime", SortDirection.desc);
        if (!ResourceUtil.onlineShangJiaAccountIdIsNull()) {
            cq.add(cq.or(cq.and(cq, 1, 2), cq, 0));
        } else {
            cq.add();
        }
        this.textTemplateService.getDataGridReturn(cq, true);
        List accountList = this.weixinAccountService.loadAll(WeixinAccountEntity.class);
        PostCodeUtil.appendPostcodeName(dataGrid.getResults(), "postcode", "postcodeName", accountList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"privateList"})
    public ModelAndView privateList() {
        return new ModelAndView("weixin/guanjia/texttemplate/privateTextTemplateList");
    }

    @RequestMapping(params={"privateDatagrid"})
    @ResponseBody
    public void privateDatagrid(TextTemplate textTemplate, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TextTemplate.class, dataGrid);
        cq.eq("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)((Object)textTemplate));
        this.textTemplateService.getDataGridReturn(cq, true);
        List accountList = this.weixinAccountService.loadAll(WeixinAccountEntity.class);
        PostCodeUtil.appendPostcodeName(dataGrid.getResults(), "postcode", "postcodeName", accountList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"shareList"})
    public ModelAndView shareList() {
        return new ModelAndView("weixin/guanjia/texttemplate/shareTextTemplateList");
    }

    @RequestMapping(params={"shareDatagrid"})
    @ResponseBody
    public void shareDatagrid(TextTemplate textTemplate, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(TextTemplate.class, dataGrid);
        cq.eq("shareStatus", (Object)"Y");
        cq.in("postcode", (Object[])YouBianCodeUtil.cutYouBianCode((String)ResourceUtil.getShangJiaAccount().getPostCode()));
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)((Object)textTemplate));
        this.textTemplateService.getDataGridReturn(cq, true);
        List accountList = this.weixinAccountService.loadAll(WeixinAccountEntity.class);
        PostCodeUtil.appendPostcodeName(dataGrid.getResults(), "postcode", "postCodeName", accountList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"copyData"})
    @ResponseBody
    public AjaxJson copyData(HttpServletRequest req, String textTemplateId, String accountId) {
        AjaxJson j = new AjaxJson();
        try {
            TextTemplate textTemplate = (TextTemplate)((Object)this.textTemplateService.getEntity(TextTemplate.class, (Serializable)((Object)textTemplateId)));
            WeixinAccountEntity accountEntity = (WeixinAccountEntity)this.textTemplateService.getEntity(WeixinAccountEntity.class, (Serializable)((Object)accountId));
            TextTemplate textTemplateCopyData = new TextTemplate();
            textTemplateCopyData.setAccountId(accountId);
            textTemplateCopyData.setContent(textTemplate.getContent());
            textTemplateCopyData.setAddTime(textTemplate.getAddTime());
            textTemplateCopyData.setPostcode(accountEntity.getPostCode());
            textTemplateCopyData.setShareStatus(textTemplate.getShareStatus());
            textTemplateCopyData.setTemplateName(textTemplate.getTemplateName());
            this.textTemplateService.saveOrUpdate(textTemplateCopyData);
            j.setSuccess(true);
            j.setMsg("\u4e00\u952e\u590d\u5236\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u4e00\u952e\u590d\u5236\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(TextTemplate textTemplate, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        if (!(textTemplate = (TextTemplate)((Object)this.textTemplateService.getEntity(TextTemplate.class, (Serializable)((Object)textTemplate.getId())))).getAccountId().equals(ResourceUtil.getShangJiaAccountId())) {
            this.message = "\u4e0a\u7ea7\u8d26\u53f7\u5171\u4eab\u7684\u7d20\u6750\u5b50\u4e0d\u80fd\u64cd\u4f5c";
        } else {
            this.textTemplateService.delete(textTemplate);
            this.message = "\u5220\u9664{\u6587\u672c\u7d20\u6750}\u4fe1\u606f\u6570\u636e\u6210\u529f\uff01";
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5220\u9664\u4fe1\u606f\u6570\u636e\u6210\u529f";
        int succeed = 0;
        int error = 0;
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                TextTemplate textTemplate = (TextTemplate)((Object)this.textTemplateService.getEntity(TextTemplate.class, (Serializable)((Object)id)));
                if (textTemplate.getAccountId().equals(ResourceUtil.getShangJiaAccountId())) {
                    this.textTemplateService.delete(textTemplate);
                    ++succeed;
                    this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ++error;
            this.message = "\u5220\u9664\u4fe1\u606f\u6570\u636e\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        this.message = "\u5220\u9664\u4fe1\u606f\u6570\u636e\u6210\u529f" + succeed + "\u6761\uff0c\u5931\u8d25" + error + "\u6761";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorUpdate"})
    public ModelAndView addorUpdate(HttpServletRequest req) {
        WeixinAccountEntity weixinAccount = (WeixinAccountEntity)req.getSession().getAttribute("WEIXIN_ACCOUNT");
        String id = req.getParameter("id");
        req.setAttribute("id", (Object)id);
        if (StringUtil.isNotEmpty((Object)id)) {
            TextTemplate textTemplate = (TextTemplate)((Object)this.textTemplateService.getEntity(TextTemplate.class, (Serializable)((Object)id)));
            String templateName = textTemplate.getTemplateName();
            String content = textTemplate.getContent();
            req.setAttribute("accountId", (Object)ResourceUtil.getShangJiaAccountId());
            req.setAttribute("templateName", (Object)templateName);
            req.setAttribute("content", (Object)content);
        }
        return new ModelAndView("weixin/guanjia/texttemplate/textTemplateInfo");
    }

    @RequestMapping(params={"doSave"})
    @ResponseBody
    public AjaxJson doSave(TextTemplate textTemplate, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        String id = textTemplate.getId();
        if (StringUtil.isNotEmpty((Object)id)) {
            TextTemplate tempAutoResponse = (TextTemplate)((Object)this.textTemplateService.getEntity(TextTemplate.class, (Serializable)((Object)textTemplate.getId())));
            if (!tempAutoResponse.getAccountId().equals(ResourceUtil.getShangJiaAccountId())) {
                this.message = "\u4e0a\u7ea7\u8d26\u53f7\u5171\u4eab\u7684\u7d20\u6750\u5b50\u4e0d\u80fd\u64cd\u4f5c";
                j.setMsg(this.message);
                return j;
            }
            this.message = "\u4fee\u6539\u5173\u6587\u672c\u6a21\u677f\u6210\u529f\uff01";
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)((Object)textTemplate), (Object)((Object)tempAutoResponse));
                this.textTemplateService.saveOrUpdate(tempAutoResponse);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            String accountId = ResourceUtil.getShangJiaAccountId();
            if (!"-1".equals(accountId)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                textTemplate.setAddTime(sdf.format(new Date()));
                this.textTemplateService.save(textTemplate);
            } else {
                j.setSuccess(false);
                j.setMsg("\u8bf7\u6dfb\u52a0\u4e00\u4e2a\u516c\u4f17\u5e10\u53f7\u3002");
            }
        }
        return j;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

