/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.message.controller;

import java.io.File;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.guanjia.message.entity.ReceiveText;
import weixin.guanjia.message.model.TextItem;
import weixin.guanjia.message.model.TextMessageKf;
import weixin.guanjia.message.service.CustomerMessageService;
import weixin.guanjia.message.service.ReceiveTextServiceI;
import weixin.guanjia.recept.entity.WeixinReceptTasksEntity;
import weixin.util.DateUtils;
import weixin.util.FreemarkerUtil;

@Controller
@RequestMapping(value={"/receiveTextController"})
public class ReceiveTextController {
    private SystemService systemService;
    private String message;
    private CustomerMessageService customerMessageService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private ReceiveTextServiceI receiveTextService;
    private static final String CS = "\u5ba2\u670d";
    private static FreemarkerUtil util = null;
    private static final String AJAXMESSAGETPLPATH = "/webpage/weixin/guanjia/receivetext";
    private static final String AJAXMESSAGETPLNAME = "ajaxMessageTpl.ftl";

    @Autowired
    public void setCustomerMessageService(CustomerMessageService customerMessageService) {
        this.customerMessageService = customerMessageService;
    }

    @Resource(name="systemService")
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @RequestMapping(params={"list"})
    public ModelAndView list() {
        return new ModelAndView("weixin/guanjia/receivetext/receivetextlist");
    }

    @RequestMapping(params={"datagrid"})
    @ResponseBody
    public void datagrid(ReceiveText receiveText, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(ReceiveText.class, dataGrid);
        WeixinAccountEntity weixinAccountEntity = ResourceUtil.getShangJiaAccount();
        if (weixinAccountEntity != null) {
            receiveText.setAccountId(weixinAccountEntity.getId());
        }
        List<ReceiveText> list = this.receiveTextService.queryNewMessageGroup(receiveText, dataGrid.getPage(), dataGrid.getRows());
        int count = this.receiveTextService.getCountQueryNewMessageGroup(receiveText);
        SessionFactory sessionFactory = (SessionFactory)ApplicationContextUtil.getContext().getBean("sessionFactory");
        Session session = sessionFactory.getCurrentSession();
        session.close();
        for (ReceiveText rt : list) {
            if (oConvertUtils.isNotEmpty((Object)rt.getNickName())) {
                rt.setDisplayNickName(new String(WeixinUtil.decode(rt.getNickName())));
            }
            if (oConvertUtils.isEmpty((Object)rt.getContent())) {
                rt.setDisplayContent(rt.getMsgType());
                continue;
            }
            rt.setDisplayContent(rt.getContent());
        }
        dataGrid.setTotal(count);
        dataGrid.setResults(list);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"lasttwohourlist"})
    public ModelAndView lasttwohourlist() {
        return new ModelAndView("weixin/guanjia/receivetext/lasttwohourlist");
    }

    @RequestMapping(params={"lasttwohourDatagrid"})
    @ResponseBody
    public void lasttwohourDatagrid(ReceiveText receiveText, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        WeixinAccountEntity weixinAccountEntity = ResourceUtil.getShangJiaAccount();
        if (weixinAccountEntity != null) {
            receiveText.setAccountId(weixinAccountEntity.getId());
        }
        List<ReceiveText> list = this.receiveTextService.queryNewTwoHourMessageGroup(receiveText, dataGrid.getPage(), dataGrid.getRows());
        for (ReceiveText rt : list) {
            if (oConvertUtils.isNotEmpty((Object)rt.getNickName())) {
                rt.setDisplayNickName(new String(WeixinUtil.decode(rt.getNickName())));
            }
            if (oConvertUtils.isEmpty((Object)rt.getContent())) {
                rt.setDisplayContent(rt.getMsgType());
                continue;
            }
            rt.setDisplayContent(rt.getContent());
        }
        int count = this.receiveTextService.getCountQueryNewTwoHourMessageGroup(receiveText);
        dataGrid.setTotal(count);
        dataGrid.setResults(list);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson deleteSmsGroup(ReceiveText receiveText, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        receiveText = (ReceiveText)((Object)this.systemService.getEntity(ReceiveText.class, (Serializable)((Object)receiveText.getId())));
        this.systemService.delete((Object)receiveText);
        this.message = "\u5220\u9664{\u7528\u6237\u53d1\u9001\u6d88\u606f}\u4fe1\u606f\u6570\u636e\u6210\u529f\uff01";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"jumpsendmessage"})
    public ModelAndView responseMessage(HttpServletRequest req) {
        String id = req.getParameter("id");
        req.setAttribute("id", (Object)id);
        String fromUserName = req.getParameter("fromUserName");
        req.setAttribute("fromUserName", (Object)fromUserName);
        String toUserName = req.getParameter("toUserName");
        req.setAttribute("toUserName", (Object)toUserName);
        return new ModelAndView("weixin/guanjia/receivetext/messageinfo");
    }

    @RequestMapping(params={"update"})
    @ResponseBody
    public AjaxJson updateAndSave(ReceiveText receiveText, HttpServletRequest req, String toUserName) {
        AjaxJson j = new AjaxJson();
        this.message = "\u56de\u590d\u4fe1\u606f\u6210\u529f\uff01";
        try {
            receiveText.setResponse("1");
            Timestamp temp = Timestamp.valueOf(DateUtils.getDate("yyyy-MM-dd HH:mm:ss"));
            receiveText.setCreateTime(temp);
            receiveText.setAccountId(ResourceUtil.getShangJiaAccountId());
            receiveText.setMsgType("text");
            TSUser waiter = ResourceUtil.getSessionUserName();
            receiveText.setNickName(WeixinUtil.encode(waiter.getRealName().getBytes()));
            this.systemService.save((Object)receiveText);
            String openId = receiveText.getFromUserName();
            TextMessageKf customMessage = new TextMessageKf();
            customMessage.setMsgtype("text");
            TextItem textItem = new TextItem();
            textItem.setContent(receiveText.getContent());
            customMessage.setText(textItem);
            customMessage.setTouser(openId);
            JSONObject jsonObj = JSONObject.fromObject((Object)customMessage);
            LogUtil.info((Object)("......jsonObj..." + jsonObj.toString()));
            this.customerMessageService.sendMessage(jsonObj.toString());
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goDetailMessage"})
    public ModelAndView goDetailMessage(HttpServletRequest request) {
        ModelAndView mv = new ModelAndView();
        String fromUserName = request.getParameter("fromUserName");
        String toUserName = request.getParameter("toUserName");
        request.setAttribute("fromUserName", (Object)fromUserName);
        request.setAttribute("toUserName", (Object)toUserName);
        String hql = "from ReceiveText where fromUserName='" + fromUserName + "' order by createTime asc";
        List list = this.receiveTextService.findByQueryString(hql);
        Long lastCreateTime = null;
        for (ReceiveText t : list) {
            if (CS.equals(t.getNickName())) continue;
            if (oConvertUtils.isEmpty((Object)t.getOldMsg())) {
                t.setOldMsg("1");
                this.receiveTextService.saveOrUpdate(t);
            }
            if (!oConvertUtils.isNotEmpty((Object)t.getCreateTime())) continue;
            lastCreateTime = t.getCreateTime().getTime();
        }
        SessionFactory sessionFactory = (SessionFactory)ApplicationContextUtil.getContext().getBean("sessionFactory");
        Session session = sessionFactory.getCurrentSession();
        session.close();
        for (ReceiveText t : list) {
            if (CS.equals(t.getNickName()) || !oConvertUtils.isNotEmpty((Object)t.getNickName())) continue;
            t.setNickName(new String(WeixinUtil.decode(t.getNickName())));
        }
        mv.addObject("listRec", (Object)list);
        lastCreateTime = this.formatMysqlTime(lastCreateTime);
        mv.addObject("lastCreateTime", (Object)lastCreateTime);
        mv.setViewName("weixin/guanjia/receivetext/detailMessageNew");
        return mv;
    }

    @RequestMapping(params={"detailMessage"})
    @ResponseBody
    public void detailMessage(ReceiveText receiveText, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(ReceiveText.class, dataGrid);
        String fromUserName = request.getParameter("fromUserName");
        cq.eq("fromUserName", (Object)fromUserName);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("createTime", "desc");
        cq.setOrder(map);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)((Object)receiveText));
        this.systemService.getDataGridReturn(cq, true);
        List list = dataGrid.getResults();
        for (ReceiveText temp : list) {
            String nickName = temp.getNickName();
            if (!StringUtil.isNotEmpty((Object)nickName) || CS.equals(nickName)) continue;
            if (oConvertUtils.isEmpty((Object)temp.getOldMsg())) {
                temp.setOldMsg("1");
                this.receiveTextService.saveOrUpdate(temp);
            }
            temp.setDisplayNickName(new String(WeixinUtil.decode(nickName)));
        }
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"waiterReceptlist"})
    public ModelAndView waiterReceptlist() {
        return new ModelAndView("weixin/guanjia/receivetext/waiterReceptlist");
    }

    @RequestMapping(params={"waiterReceptDatagrid"})
    @ResponseBody
    public void waiterReceptDatagrid(ReceiveText receiveText, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        TSUser waiter = ResourceUtil.getSessionUserName();
        WeixinAccountEntity weixinAccountEntity = ResourceUtil.getShangJiaAccount();
        if (weixinAccountEntity != null) {
            receiveText.setAccountId(weixinAccountEntity.getId());
        }
        List<ReceiveText> list = this.receiveTextService.queryWaiterReceptMessage(receiveText, waiter.getId(), dataGrid.getPage(), dataGrid.getRows());
        int count = this.receiveTextService.getCountQueryWaiterReceptMessage(receiveText, waiter.getId());
        SessionFactory sessionFactory = (SessionFactory)ApplicationContextUtil.getContext().getBean("sessionFactory");
        Session session = sessionFactory.getCurrentSession();
        session.close();
        for (ReceiveText rt : list) {
            if (oConvertUtils.isNotEmpty((Object)rt.getNickName())) {
                String dsname = new String(WeixinUtil.decode(rt.getNickName()));
                if (oConvertUtils.isNotEmpty((Object)dsname)) {
                    dsname = dsname.replace("%", "").replace("\ufffd", "").replace("\u000f", "");
                }
                rt.setDisplayNickName(dsname);
            }
            if (oConvertUtils.isEmpty((Object)rt.getContent())) {
                rt.setDisplayContent(rt.getMsgType());
            } else {
                rt.setDisplayContent(rt.getContent());
            }
            if (oConvertUtils.isNullOrEmpty((Object)rt.getOldMsg())) {
                rt.setDisplayOldMsg("plug-in/weixin/images/newmsg.gif");
                continue;
            }
            rt.setDisplayOldMsg("plug-in/weixin/images/oldmsg.gif");
        }
        dataGrid.setTotal(count);
        dataGrid.setResults(list);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doReceptTask"})
    @ResponseBody
    public AjaxJson doReceptTask(String fromusername, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        TSUser waiter = ResourceUtil.getSessionUserName();
        GzUserInfoYw gzUser = (GzUserInfoYw)((Object)this.systemService.findUniqueByProperty(GzUserInfoYw.class, "openid", (Object)fromusername));
        gzUser.setReceptStatus(1);
        gzUser.setReceptWaiterid(waiter.getId());
        this.systemService.updateEntitie((Object)gzUser);
        WeixinReceptTasksEntity receptTask = new WeixinReceptTasksEntity();
        receptTask.setNickname(gzUser.getNickname());
        receptTask.setOpenid(gzUser.getOpenid());
        receptTask.setReceptBegintime(new Date());
        receptTask.setReceptWaiterid(waiter.getId());
        receptTask.setReceptWaitername(waiter.getRealName());
        this.systemService.save((Object)receptTask);
        this.message = "\u5ba2\u670d\u63a5\u5f85\u4efb\u52a1\u6210\u529f\uff01";
        this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"completeReceptTask"})
    @ResponseBody
    public AjaxJson completeReceptTask(String fromusername, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        GzUserInfoYw gzUser = (GzUserInfoYw)((Object)this.systemService.findUniqueByProperty(GzUserInfoYw.class, "openid", (Object)fromusername));
        gzUser.setReceptStatus(0);
        gzUser.setReceptWaiterid(null);
        gzUser.setReceptLasttime(new Date());
        this.systemService.updateEntitie((Object)gzUser);
        CriteriaQuery cq = new CriteriaQuery(WeixinReceptTasksEntity.class);
        cq.isNull("receptEndtime");
        cq.eq("openid", (Object)fromusername);
        cq.add();
        List receptTaskList = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        if (receptTaskList != null && receptTaskList.size() > 0) {
            WeixinReceptTasksEntity receptTask = (WeixinReceptTasksEntity)receptTaskList.get(0);
            receptTask.setReceptEndtime(new Date());
            this.systemService.updateEntitie((Object)receptTask);
        }
        this.message = "\u5173\u95ed\u4f1a\u8bdd\u4efb\u52a1\u6210\u529f\uff01";
        this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"ajaxMessageTpl"})
    @ResponseBody
    public Map<String, Object> ajaxMessageTpl(ReceiveText receiveText, Long lastCreateTime, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        String fromUserName = request.getParameter("fromUserName");
        String toUserName = request.getParameter("toUserName");
        lastCreateTime = this.formatMysqlTime(lastCreateTime);
        String hql = "from ReceiveText where fromUserName='" + fromUserName + "' and createTime > from_unixtime(" + lastCreateTime + ") order by createTime asc";
        List list = this.receiveTextService.findByQueryString(hql);
        for (ReceiveText t : list) {
            if (CS.equals(t.getNickName()) || !oConvertUtils.isEmpty((Object)t.getOldMsg())) continue;
            t.setOldMsg("1");
            this.receiveTextService.saveOrUpdate(t);
        }
        SessionFactory sessionFactory = (SessionFactory)ApplicationContextUtil.getContext().getBean("sessionFactory");
        Session session = sessionFactory.getCurrentSession();
        session.close();
        for (ReceiveText t : list) {
            if (CS.equals(t.getNickName())) continue;
            if (oConvertUtils.isNotEmpty((Object)t.getNickName())) {
                t.setNickName(new String(WeixinUtil.decode(t.getNickName())));
            }
            if (!oConvertUtils.isNotEmpty((Object)t.getCreateTime())) continue;
            lastCreateTime = t.getCreateTime().getTime();
        }
        data.put("html", this.getAjaxHtml(list, request));
        data.put("lastCreateTime", this.formatMysqlTime(lastCreateTime));
        return data;
    }

    private Long formatMysqlTime(Long lastCreateTime) {
        if (lastCreateTime != null) {
            if (lastCreateTime.toString().length() > 10) {
                lastCreateTime = Long.valueOf(lastCreateTime.toString().substring(0, 10));
            }
        } else {
            lastCreateTime = new Long(0L);
        }
        return lastCreateTime;
    }

    private String getAjaxHtml(List<ReceiveText> list, HttpServletRequest request) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("listRec", list);
        String html = this.getFreemarker(request).parseTemplate(AJAXMESSAGETPLNAME, "utf-8", paras);
        return html;
    }

    private FreemarkerUtil getFreemarker(HttpServletRequest request) {
        if (oConvertUtils.isEmpty((Object)util)) {
            String dirPath = request.getSession().getServletContext().getRealPath(AJAXMESSAGETPLPATH);
            File dir = new File(dirPath);
            util = new FreemarkerUtil(dir);
        }
        return util;
    }
}

