/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.message.controller;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.YouBianCodeUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.groupmessage.entity.GroupMessageNews;
import weixin.guanjia.groupmessage.entity.GroupMessageNewsTemplate;
import weixin.guanjia.message.entity.NewsItem;
import weixin.guanjia.message.entity.NewsTemplate;
import weixin.guanjia.message.service.AutoResponseServiceI;
import weixin.guanjia.message.service.NewsItemServiceI;
import weixin.guanjia.message.service.NewsTemplateServiceI;
import weixin.util.PostCodeUtil;

@Controller
@RequestMapping(value={"/newsTemplateController"})
public class NewsTemplateController {
    @Autowired
    private NewsTemplateServiceI newsTemplateService;
    @Autowired
    private NewsItemServiceI newsItemService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private AutoResponseServiceI autoResponseService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private String message;

    @RequestMapping(params={"list"})
    public ModelAndView list() {
        return new ModelAndView("weixin/guanjia/newstemplate/newsTemplateList");
    }

    @RequestMapping(params={"datagrid"})
    @ResponseBody
    public void datagrid(NewsTemplate newsTemplate, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(NewsTemplate.class, dataGrid);
        cq.eq("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        cq.eq("shareStatus", (Object)"Y");
        cq.in("postcode", (Object[])YouBianCodeUtil.cutYouBianCode((String)ResourceUtil.getShangJiaAccount().getPostCode()));
        cq.addOrder("addTime", SortDirection.desc);
        if (!ResourceUtil.onlineShangJiaAccountIdIsNull()) {
            cq.add(cq.or(cq.and(cq, 1, 2), cq, 0));
        } else {
            cq.add();
        }
        this.newsTemplateService.getDataGridReturn(cq, true);
        List accountList = this.weixinAccountService.loadAll(WeixinAccountEntity.class);
        PostCodeUtil.appendPostcodeName(dataGrid.getResults(), "postcode", "postcodeName", accountList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"copyToGroupMessageNews"})
    @ResponseBody
    public AjaxJson copyToGroupMessageNews(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u590d\u5236\u5230\u7fa4\u53d1\u56fe\u6587\u7d20\u6750\u6570\u636e\u6210\u529f";
        int succeed = 0;
        int error = 0;
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                NewsTemplate newsTemplate = (NewsTemplate)((Object)this.newsTemplateService.getEntity(NewsTemplate.class, (Serializable)((Object)id)));
                GroupMessageNewsTemplate groupMessageNewsTemplate = new GroupMessageNewsTemplate();
                groupMessageNewsTemplate.setAccountId(newsTemplate.getAccountId());
                groupMessageNewsTemplate.setPostcode(newsTemplate.getPostcode());
                groupMessageNewsTemplate.setAddTime(newsTemplate.getAddTime());
                groupMessageNewsTemplate.setShareStatus(newsTemplate.getShareStatus());
                groupMessageNewsTemplate.setTemplateName(newsTemplate.getTemplateName());
                groupMessageNewsTemplate.setType(newsTemplate.getType());
                groupMessageNewsTemplate.setIsUpload("0");
                groupMessageNewsTemplate.setId(newsTemplate.getId());
                this.systemService.save((Object)groupMessageNewsTemplate);
                List list = this.systemService.findHql(" from  NewsItem where templateid = ? ", new Object[]{newsTemplate});
                if (list.size() > 0) {
                    for (NewsItem newsItem : list) {
                        GroupMessageNews gmn = new GroupMessageNews();
                        gmn.setAuthor(newsItem.getAuthor());
                        gmn.setContent(newsItem.getContent());
                        gmn.setImagePath(newsItem.getImagePath());
                        gmn.setTitle(newsItem.getTitle());
                        gmn.setOrders(newsItem.getOrders());
                        gmn.setOriginalLink(newsItem.getOriginalLink());
                        gmn.setDisplayCoverFlag(newsItem.getDisplayCoverFlag());
                        gmn.setGroupMessageNewsTemplate(groupMessageNewsTemplate);
                        this.systemService.saveOrUpdate((Object)gmn);
                    }
                }
                ++succeed;
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ++error;
            this.message = "\u590d\u5236\u5230\u7fa4\u53d1\u56fe\u6587\u7d20\u6750\u6570\u636e\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        this.message = "\u590d\u5236\u5230\u7fa4\u53d1\u56fe\u6587\u7d20\u6750\u6570\u636e\u6210\u529f" + succeed + "\u6761\uff0c\u5931\u8d25" + error + "\u6761";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"privateList"})
    public ModelAndView privateList() {
        return new ModelAndView("weixin/guanjia/newstemplate/privateNewsTemplateList");
    }

    @RequestMapping(params={"privateDatagrid"})
    @ResponseBody
    public void privateDatagrid(NewsTemplate newsTemplate, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(NewsTemplate.class, dataGrid);
        cq.eq("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)((Object)newsTemplate));
        this.newsTemplateService.getDataGridReturn(cq, true);
        List accountList = this.weixinAccountService.loadAll(WeixinAccountEntity.class);
        PostCodeUtil.appendPostcodeName(dataGrid.getResults(), "postcode", "postcodeName", accountList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"shareList"})
    public ModelAndView shareList() {
        return new ModelAndView("weixin/guanjia/newstemplate/shareNewsTemplateList");
    }

    @RequestMapping(params={"shareDatagrid"})
    @ResponseBody
    public void shareDatagrid(NewsTemplate newsTemplate, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(NewsTemplate.class, dataGrid);
        cq.eq("shareStatus", (Object)"Y");
        cq.in("postcode", (Object[])YouBianCodeUtil.cutYouBianCode((String)ResourceUtil.getShangJiaAccount().getPostCode()));
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)((Object)newsTemplate));
        this.newsTemplateService.getDataGridReturn(cq, true);
        List accountList = this.weixinAccountService.loadAll(WeixinAccountEntity.class);
        PostCodeUtil.appendPostcodeName(dataGrid.getResults(), "postcode", "postcodeName", accountList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"copyData"})
    @ResponseBody
    public AjaxJson copyData(HttpServletRequest req, String newsTemplateId, String accountId) {
        AjaxJson j = new AjaxJson();
        try {
            NewsTemplate newsTemplate = (NewsTemplate)((Object)this.newsTemplateService.getEntity(NewsTemplate.class, (Serializable)((Object)newsTemplateId)));
            WeixinAccountEntity accountEntity = (WeixinAccountEntity)this.newsTemplateService.getEntity(WeixinAccountEntity.class, (Serializable)((Object)accountId));
            NewsTemplate newsTemplateCopyData = new NewsTemplate();
            ArrayList<NewsItem> newsItemList = new ArrayList<NewsItem>();
            newsTemplateCopyData.setAccountId(accountId);
            newsTemplateCopyData.setAddTime(newsTemplate.getAddTime());
            newsTemplateCopyData.setPostcode(accountEntity.getPostCode());
            newsTemplateCopyData.setShareStatus(newsTemplate.getShareStatus());
            newsTemplateCopyData.setTemplateName(newsTemplate.getTemplateName());
            newsTemplateCopyData.setType(newsTemplate.getType());
            for (NewsItem newsItem : newsTemplate.getNewsItemList()) {
                NewsItem newsItemCopyData = new NewsItem();
                newsItemCopyData.setAccountId(accountId);
                newsItemCopyData.setAccounturl(newsItem.getAccounturl());
                newsItemCopyData.setAuthor(newsItem.getAuthor());
                newsItemCopyData.setComplainCount(newsItem.getComplainCount());
                newsItemCopyData.setContent(newsItem.getContent());
                newsItemCopyData.setCreateDate(newsItem.getCreateDate());
                newsItemCopyData.setDescription(newsItem.getDescription());
                newsItemCopyData.setImagePath(newsItem.getImagePath());
                newsItemCopyData.setInterviewCount(newsItem.getInterviewCount());
                newsItemCopyData.setNewsTemplate(newsTemplateCopyData);
                newsItemCopyData.setOrders(newsItem.getOrders());
                newsItemCopyData.setOriginalLink(newsItem.getOriginalLink());
                newsItemCopyData.setPraiseCount(newsItem.getPraiseCount());
                newsItemCopyData.setTitle(newsItem.getTitle());
                newsItemCopyData.setUrl(newsItem.getUrl());
                newsItemList.add(newsItemCopyData);
            }
            newsTemplateCopyData.setNewsItemList(newsItemList);
            this.newsTemplateService.saveOrUpdate(newsTemplateCopyData);
            j.setSuccess(true);
            j.setMsg("\u4e00\u952e\u590d\u5236\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u4e00\u952e\u590d\u5236\u5931\u8d25");
        }
        return j;
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(NewsTemplate newsTemplate, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        if (!(newsTemplate = (NewsTemplate)((Object)this.newsTemplateService.getEntity(NewsTemplate.class, (Serializable)((Object)newsTemplate.getId())))).getAccountId().equals(ResourceUtil.getShangJiaAccountId())) {
            this.message = "\u7236\u7ea7\u5171\u4eab\u7684\u6570\u636e\u5b50\u516c\u4f17\u5e10\u53f7\u4e0d\u80fd\u64cd\u4f5c";
        } else {
            this.newsTemplateService.delete(newsTemplate);
            this.message = "\u5220\u9664{\u56fe\u6587\u7d20\u6750}\u4fe1\u606f\u6570\u636e\u6210\u529f\uff01";
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5220\u9664\u4fe1\u606f\u6570\u636e\u6210\u529f";
        int succeed = 0;
        int error = 0;
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                NewsTemplate newsTemplate = (NewsTemplate)((Object)this.newsTemplateService.getEntity(NewsTemplate.class, (Serializable)((Object)id)));
                if (newsTemplate.getAccountId().equals(ResourceUtil.getShangJiaAccountId())) {
                    this.newsTemplateService.delete(newsTemplate);
                    ++succeed;
                    this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            ++error;
            this.message = "\u5220\u9664\u4fe1\u606f\u6570\u636e\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        this.message = "\u5220\u9664\u4fe1\u606f\u6570\u636e\u6210\u529f" + succeed + "\u6761\uff0c\u5931\u8d25" + error + "\u6761";
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goSuView"})
    public ModelAndView goSuView(HttpServletRequest req) {
        String id = req.getParameter("id");
        req.setAttribute("id", (Object)id);
        if (StringUtil.isNotEmpty((Object)id)) {
            NewsTemplate newsTemplate = (NewsTemplate)((Object)this.newsTemplateService.getEntity(NewsTemplate.class, (Serializable)((Object)id)));
            String type = newsTemplate.getType();
            String shareStatus = newsTemplate.getShareStatus();
            req.setAttribute("type", (Object)type);
            req.setAttribute("shareStatus", (Object)shareStatus);
            req.setAttribute("tempateName", (Object)newsTemplate.getTemplateName());
        }
        return new ModelAndView("weixin/guanjia/newstemplate/newsTemplateInfo");
    }

    @RequestMapping(params={"doSave"})
    @ResponseBody
    public AjaxJson doSave(NewsTemplate newsTemplate, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        String id = newsTemplate.getId();
        if (StringUtil.isNotEmpty((Object)id)) {
            NewsTemplate tempAutoResponse = (NewsTemplate)((Object)this.newsTemplateService.getEntity(NewsTemplate.class, (Serializable)((Object)newsTemplate.getId())));
            this.message = "\u4fee\u6539\u56fe\u6587\u6a21\u677f\u6210\u529f\uff01";
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)((Object)newsTemplate), (Object)((Object)tempAutoResponse));
                this.newsTemplateService.saveOrUpdate(tempAutoResponse);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            newsTemplate.setAddTime(sdf.format(new Date()));
            String accountId = ResourceUtil.getShangJiaAccountId();
            if (!"-1".equals(accountId)) {
                this.newsTemplateService.save(newsTemplate);
            } else {
                j.setSuccess(false);
                j.setMsg("\u8bf7\u6dfb\u52a0\u4e00\u4e2a\u516c\u4f17\u5e10\u53f7\u3002");
            }
        }
        return j;
    }

    @RequestMapping(params={"goNewsItem"})
    public ModelAndView goNewsItem(HttpServletRequest req) {
        String templateId = req.getParameter("templateId");
        req.setAttribute("templateId", (Object)templateId);
        if (StringUtil.isNotEmpty((Object)templateId)) {
            NewsTemplate newsTemplate = (NewsTemplate)((Object)this.newsTemplateService.getEntity(NewsTemplate.class, (Serializable)((Object)templateId)));
            req.setAttribute("type", (Object)newsTemplate.getType());
        }
        String id = req.getParameter("id");
        req.setAttribute("id", (Object)id);
        if (StringUtil.isNotEmpty((Object)id)) {
            NewsItem newsItem = (NewsItem)((Object)this.newsTemplateService.getEntity(NewsItem.class, (Serializable)((Object)id)));
            req.setAttribute("title", (Object)newsItem.getTitle());
            req.setAttribute("content", (Object)newsItem.getContent());
            req.setAttribute("author", (Object)newsItem.getAuthor());
            req.setAttribute("imagePath", (Object)newsItem.getImagePath());
            req.setAttribute("description", (Object)newsItem.getDescription());
            req.setAttribute("templateId", (Object)newsItem.getNewsTemplate().getId());
            req.setAttribute("type", (Object)newsItem.getNewsTemplate().getType());
            req.setAttribute("orders", (Object)newsItem.getOrders());
            req.setAttribute("accounturl", (Object)newsItem.getAccounturl());
        } else {
            List newsItemList = this.newsTemplateService.findByProperty(NewsItem.class, "newsTemplate.id", templateId);
            req.setAttribute("orders", (Object)(newsItemList.size() + 1));
        }
        return new ModelAndView("weixin/guanjia/newstemplate/itemInfo");
    }

    @RequestMapping(params={"jumpupload"})
    public ModelAndView jumpUpload(HttpServletRequest req) {
        return new ModelAndView("weixin/guanjia/newstemplate/upload");
    }

    @RequestMapping(params={"saveNewsTemplate"})
    @ResponseBody
    public AjaxJson saveNewsTemplate(NewsItem newsItem, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        String id = newsItem.getId();
        if (StringUtil.isEmpty((String)newsItem.getAccounturl())) {
            newsItem.setAccounturl("#");
        }
        if (!"1".equals(newsItem.getDisplayCoverFlag())) {
            newsItem.setDisplayCoverFlag("0");
        }
        if (StringUtil.isNotEmpty((Object)id)) {
            NewsItem tempAutoResponse = (NewsItem)((Object)this.newsTemplateService.getEntity(NewsItem.class, (Serializable)((Object)newsItem.getId())));
            this.message = "\u4fee\u6539\u56fe\u6587\u4fe1\u606f\u6210\u529f\uff01";
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)((Object)newsItem), (Object)((Object)tempAutoResponse));
                this.newsItemService.saveOrUpdate(tempAutoResponse);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            String templateId = req.getParameter("templateId");
            NewsTemplate newsTemplate = (NewsTemplate)((Object)this.newsTemplateService.getEntity(NewsTemplate.class, (Serializable)((Object)templateId)));
            newsItem.setNewsTemplate(newsTemplate);
            this.newsItemService.save(newsItem);
        }
        return j;
    }

    @RequestMapping(params={"hasNewsItem"})
    @ResponseBody
    public AjaxJson hasNewsItem(HttpServletRequest req, String templateId) {
        AjaxJson j = new AjaxJson();
        j.setMsg("\u56fe\u6587\u4e3a\u7a7a\uff0c\u8bf7\u6dfb\u52a0\u56fe\u6587");
        j.setSuccess(false);
        if (StringUtil.isNotEmpty((Object)templateId)) {
            String hql = "from NewsItem where newsTemplate.id='" + templateId + "' order by orders asc";
            LogUtil.info((Object)("...hql..." + hql));
            List headerList = this.systemService.findByQueryString(hql);
            if (headerList.size() > 0) {
                j.setSuccess(true);
            } else {
                j.setSuccess(false);
            }
        }
        return j;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

