/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.message.controller;

import java.io.Serializable;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jodd.util.StringUtil;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.entity.JsapiTicket;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.message.entity.MessageComplainRecord;
import weixin.guanjia.message.entity.MessageInterviewRecord;
import weixin.guanjia.message.entity.MessagePraiseRecord;
import weixin.guanjia.message.entity.NewsItem;
import weixin.guanjia.message.service.MessageComplainService;
import weixin.guanjia.message.service.MessageInterviewService;
import weixin.guanjia.message.service.MessagePraiseService;
import weixin.guanjia.message.service.NewsItemServiceI;

@Controller
@RequestMapping(value={"/newsItemController"})
public class NewsItemController {
    @Autowired
    private SystemService systemService;
    @Autowired
    private NewsItemServiceI newsItemService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private String message;
    @Autowired
    private MessageInterviewService messageInterviewService;
    @Autowired
    private MessagePraiseService messagePraiseService;
    @Autowired
    private MessageComplainService messageComplainService;

    @RequestMapping(params={"goComplain"})
    public ModelAndView goComplain(HttpServletRequest request, MessageComplainRecord record) {
        request.setAttribute("record", (Object)record);
        TSTypegroup group = this.systemService.getTypeGroupByCode("complain");
        if (group != null) {
            request.setAttribute("dictlist", (Object)group.getTSTypes());
        }
        return new ModelAndView("weixin/guanjia/newsitem/selectcomplainlist");
    }

    @RequestMapping(params={"doComplain"})
    @ResponseBody
    public AjaxJson doComplain(MessageComplainRecord record, HttpServletRequest request) {
        AjaxJson json = new AjaxJson();
        try {
            this.messageComplainService.operate(record);
            json.setSuccess(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            json.setSuccess(false);
            json.setMsg("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c");
        }
        return json;
    }

    @RequestMapping(params={"doPraise"})
    @ResponseBody
    public AjaxJson doPraise(String messageid, String openid, HttpServletRequest request) {
        AjaxJson json = new AjaxJson();
        try {
            MessagePraiseRecord record = this.messagePraiseService.checkOperate(messageid, openid);
            if (record != null) {
                json.setSuccess(false);
                json.setMsg("\u60a8\u5df2\u7ecf\u70b9\u8fc7\u8d5e\u4e86");
                return json;
            }
            this.messagePraiseService.operate(messageid, openid);
            json.setSuccess(true);
        }
        catch (Exception e) {
            json.setSuccess(false);
            json.setMsg("\u64cd\u4f5c\u5f02\u5e38\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c");
        }
        return json;
    }

    @RequestMapping(params={"list"})
    public ModelAndView list(HttpServletRequest request) {
        String templateId = request.getParameter("templateId");
        request.setAttribute("templateId", (Object)templateId);
        return new ModelAndView("weixin/guanjia/newsitem/newsItemList");
    }

    @RequestMapping(params={"datagrid"})
    @ResponseBody
    public void datagrid(NewsItem newsItem, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        String templateId = request.getParameter("templateId");
        CriteriaQuery cq = new CriteriaQuery(NewsItem.class, dataGrid);
        cq.eq("newsTemplate.id", (Object)templateId);
        cq.eq("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)((Object)newsItem));
        this.newsItemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(NewsItem newsItem, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        newsItem = (NewsItem)((Object)this.systemService.getEntity(NewsItem.class, (Serializable)((Object)newsItem.getId())));
        this.newsItemService.delete(newsItem);
        this.message = "\u5220\u9664{\u56fe\u6587\u660e\u7ec6}\u4fe1\u606f\u6570\u636e\u6210\u529f\uff01";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goContent"})
    public ModelAndView goContent(HttpServletRequest request) {
        MessageInterviewRecord record;
        ResourceBundle bundler = ResourceBundle.getBundle("sysConfig");
        String id = request.getParameter("id");
        String openid = request.getParameter("openid");
        NewsItem newsItem = (NewsItem)((Object)this.newsItemService.getEntity(NewsItem.class, (Serializable)((Object)id)));
        request.setAttribute("newsItem", (Object)newsItem);
        request.setAttribute("accountid", (Object)newsItem.getAccountId());
        String accountid = newsItem.getAccountId();
        WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
        request.setAttribute("accountname", (Object)account.getAccountname());
        request.setAttribute("accountnumber", (Object)account.getAccountnumber());
        request.setAttribute("openid", (Object)openid);
        String url = String.valueOf(bundler.getString("domain")) + "/newsItemController.do?goContent&id=" + id + "&accountid=" + accountid;
        request.setAttribute("url", (Object)url);
        if (!StringUtil.isEmpty((String)openid) && (record = this.messageInterviewService.check(id, openid)) == null) {
            this.messageInterviewService.operate(id, openid);
        }
        return new ModelAndView("weixin/guanjia/newsitem/newsContent2");
    }

    @RequestMapping(params={"goContent4"})
    public ModelAndView goContent4(HttpServletRequest request) {
        MessageInterviewRecord record;
        ResourceBundle bundler = ResourceBundle.getBundle("sysConfig");
        String id = request.getParameter("id");
        String openid = request.getParameter("openid");
        NewsItem newsItem = (NewsItem)((Object)this.newsItemService.getEntity(NewsItem.class, (Serializable)((Object)id)));
        request.setAttribute("newsItem", (Object)newsItem);
        request.setAttribute("accountid", (Object)newsItem.getAccountId());
        String accountid = newsItem.getAccountId();
        WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
        request.setAttribute("accountname", (Object)account.getAccountname());
        request.setAttribute("accountnumber", (Object)account.getAccountnumber());
        request.setAttribute("openid", (Object)openid);
        String url = String.valueOf(bundler.getString("domain")) + "/newsItemController.do?goContent&id=" + id + "&accountid=" + accountid;
        request.setAttribute("url", (Object)url);
        if (!StringUtil.isEmpty((String)openid) && (record = this.messageInterviewService.check(id, openid)) == null) {
            this.messageInterviewService.operate(id, openid);
        }
        return new ModelAndView("weixin/guanjia/newsitem/newsContent4");
    }

    @RequestMapping(params={"jsapiTicket"})
    @ResponseBody
    public JsapiTicket jsapiTicket(NewsItem newsItem, HttpServletRequest req, String url, String accountid) {
        JsapiTicket jsapiTicket = this.weixinAccountService.getJsapiticket(accountid, url);
        return jsapiTicket;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

