/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.message.controller;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.message.entity.AutoResponse;
import weixin.guanjia.message.entity.NewsTemplate;
import weixin.guanjia.message.entity.TextTemplate;
import weixin.guanjia.message.service.AutoResponseServiceI;

@Controller
@RequestMapping(value={"/autoResponseController"})
public class AutoResponseController {
    @Autowired
    private SystemService systemService;
    @Autowired
    private AutoResponseServiceI autoResponseService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private String message;

    @RequestMapping(params={"goSynchronousToAccount"})
    public ModelAndView goSynchronousToAccount(HttpServletRequest request, String ids) {
        String accountid = ResourceUtil.getShangJiaAccountId();
        request.setAttribute("accountid", (Object)accountid);
        request.setAttribute("ids", (Object)ids);
        return new ModelAndView("weixin/guanjia/autoresponse/accountlist");
    }

    @RequestMapping(params={"cancelSynchronous"})
    @ResponseBody
    public AjaxJson cancelSynchronous(HttpServletRequest request, String ids) {
        String[] idarray;
        AjaxJson json = new AjaxJson();
        String[] stringArray = idarray = ids.split(",");
        int n = idarray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            AutoResponse ar = (AutoResponse)((Object)this.autoResponseService.get(AutoResponse.class, (Serializable)((Object)id)));
            List<AutoResponse> alst = this.autoResponseService.findByCode(ar.getCode(), id);
            this.systemService.deleteAllEntitie(alst);
            ++n2;
        }
        json.setSuccess(true);
        json.setMsg("\u53d6\u6d88\u540c\u6b65\u6210\u529f");
        return json;
    }

    @RequestMapping(params={"doSynchronousToAccount"})
    @ResponseBody
    public AjaxJson doSynchronousToAccount(HttpServletRequest request, String ids, String accountids) {
        String[] accountidarray;
        AjaxJson json = new AjaxJson();
        String[] aridarray = ids.split(",");
        String[] stringArray = accountidarray = accountids.split(",");
        int n = accountidarray.length;
        int n2 = 0;
        while (n2 < n) {
            String accid = stringArray[n2];
            String[] stringArray2 = aridarray;
            int n3 = aridarray.length;
            int n4 = 0;
            while (n4 < n3) {
                String rid = stringArray2[n4];
                AutoResponse autoResponse = (AutoResponse)((Object)this.autoResponseService.get(AutoResponse.class, (Serializable)((Object)rid)));
                AutoResponse newauto = new AutoResponse();
                try {
                    MyBeanUtils.copyBeanNotNull2Bean((Object)((Object)autoResponse), (Object)((Object)newauto));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                newauto.setAccountId(accid);
                newauto.setId(null);
                newauto.setSourceType("2");
                this.autoResponseService.save(newauto);
                ++n4;
            }
            ++n2;
        }
        json.setSuccess(true);
        json.setMsg("\u540c\u6b65\u6210\u529f");
        return json;
    }

    @RequestMapping(params={"list"})
    public ModelAndView list() {
        return new ModelAndView("weixin/guanjia/autoresponse/autoresponselist");
    }

    @RequestMapping(params={"datagrid"})
    @ResponseBody
    public void datagrid(AutoResponse autoResponse, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(AutoResponse.class, dataGrid);
        cq.eq("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        cq.addOrder("addTime", SortDirection.desc);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)((Object)autoResponse));
        this.autoResponseService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(AutoResponse autoResponse, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        autoResponse = (AutoResponse)((Object)this.autoResponseService.getEntity(AutoResponse.class, (Serializable)((Object)autoResponse.getId())));
        this.autoResponseService.delete(autoResponse);
        this.message = "\u5220\u9664{\u5173\u952e\u5b57\u56de\u590d}\u4fe1\u606f\u6570\u636e\u6210\u529f\uff01";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addOrUpdate"})
    public ModelAndView addOrUpdate(HttpServletRequest req) {
        String id = req.getParameter("id");
        req.setAttribute("id", (Object)id);
        if (StringUtil.isNotEmpty((Object)id)) {
            AutoResponse autoResponse = (AutoResponse)((Object)this.autoResponseService.getEntity(AutoResponse.class, (Serializable)((Object)id)));
            String msgType = autoResponse.getMsgType();
            String resContent = autoResponse.getResContent();
            String keyWord = autoResponse.getKeyWord();
            String templateName = autoResponse.getTemplateName();
            req.setAttribute("msgType", (Object)msgType);
            req.setAttribute("resContent", (Object)resContent);
            req.setAttribute("keyWord", (Object)keyWord);
            req.setAttribute("templateName", (Object)templateName);
        }
        return new ModelAndView("weixin/guanjia/autoresponse/autoresponseinfo");
    }

    @RequestMapping(params={"doSave"})
    @ResponseBody
    public AjaxJson doSave(AutoResponse autoResponse, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        String id = autoResponse.getId();
        if (StringUtil.isNotEmpty((Object)id)) {
            AutoResponse tempAutoResponse = (AutoResponse)((Object)this.autoResponseService.getEntity(AutoResponse.class, (Serializable)((Object)autoResponse.getId())));
            this.message = "\u4fee\u6539\u5173\u952e\u5b57\u56de\u590d\u6210\u529f\uff01";
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)((Object)autoResponse), (Object)((Object)tempAutoResponse));
                this.autoResponseService.saveOrUpdate(tempAutoResponse);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            autoResponse.setAddTime(sdf.format(new Date()));
            String accountId = ResourceUtil.getShangJiaAccountId();
            if (!"-1".equals(accountId)) {
                autoResponse.setAccountId(ResourceUtil.getShangJiaAccountId());
                autoResponse.setCode(DataUtils.getDateUUID((String)"yyyyMMddHHmmss"));
                autoResponse.setSourceType("1");
                this.autoResponseService.save(autoResponse);
            } else {
                j.setSuccess(false);
                j.setMsg("\u8bf7\u6dfb\u52a0\u4e00\u4e2a\u516c\u4f17\u5e10\u53f7\u3002");
            }
        }
        return j;
    }

    private String getTempName(String msgType, String templateId) {
        NewsTemplate newsTemplate;
        String templateName = "";
        if ("text".equals(msgType)) {
            TextTemplate textTemplate = (TextTemplate)((Object)this.autoResponseService.getEntity(TextTemplate.class, (Serializable)((Object)templateId)));
            if (textTemplate != null) {
                templateName = textTemplate.getTemplateName();
            }
        } else if ("news".equals(msgType) && (newsTemplate = (NewsTemplate)((Object)this.autoResponseService.getEntity(NewsTemplate.class, (Serializable)((Object)templateId)))) != null) {
            templateName = newsTemplate.getTemplateName();
        }
        return templateName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

