/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.linksucai.service.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.hibernate.Criteria;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.YouBianCodeUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.wxuser.user.JwUserAPI;
import org.jeewx.api.wxuser.user.model.Wxuser;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.cms.util.CmsFreemarkerHelper;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.linksucai.entity.WeixinLinksucaiEntity;
import weixin.guanjia.linksucai.service.WeixinLinksucaiServiceI;
import weixin.vip.entity.WeixinVipMemberEntity;

@Service(value="weixinLinksucaiService")
@Transactional
public class WeixinLinksucaiServiceImpl
extends CommonServiceImpl
implements WeixinLinksucaiServiceI {
    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((WeixinLinksucaiEntity)entity);
    }

    @Override
    public <T> Serializable save(T entity) {
        Serializable t = super.save(entity);
        this.doAddSql((WeixinLinksucaiEntity)entity);
        return t;
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        super.saveOrUpdate(entity);
        this.doUpdateSql((WeixinLinksucaiEntity)entity);
    }

    @Override
    public boolean doAddSql(WeixinLinksucaiEntity t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(WeixinLinksucaiEntity t) {
        return true;
    }

    @Override
    public boolean doDelSql(WeixinLinksucaiEntity t) {
        return true;
    }

    public String replaceVal(String sql, WeixinLinksucaiEntity t) {
        sql = sql.replace("#{id}", String.valueOf(t.getId()));
        sql = sql.replace("#{create_name}", String.valueOf(t.getCreateName()));
        sql = sql.replace("#{create_date}", String.valueOf(t.getCreateDate()));
        sql = sql.replace("#{update_name}", String.valueOf(t.getUpdateName()));
        sql = sql.replace("#{update_date}", String.valueOf(t.getUpdateDate()));
        sql = sql.replace("#{name}", String.valueOf(t.getName()));
        sql = sql.replace("#{outer_link}", String.valueOf(t.getOuterLink()));
        sql = sql.replace("#{content}", String.valueOf(t.getContent()));
        sql = sql.replace("#{inner_link}", String.valueOf(t.getInnerLink()));
        sql = sql.replace("#{transfer_sign}", String.valueOf(t.getTransferSign()));
        sql = sql.replace("#{accountid}", String.valueOf(t.getAccountid()));
        sql = sql.replace("#{post_code}", String.valueOf(t.getPostcode()));
        sql = sql.replace("#{share_status}", String.valueOf(t.getShareStatus()));
        sql = sql.replace("#{UUID}", UUID.randomUUID().toString());
        return sql;
    }

    @Override
    public <T> List<T> getLinksucaiList() {
        CriteriaQuery cq = new CriteriaQuery(WeixinLinksucaiEntity.class);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.eq("shareStatus", (Object)"Y");
        cq.in("postcode", (Object[])YouBianCodeUtil.cutYouBianCode((String)ResourceUtil.getShangJiaAccount().getPostCode()));
        cq.add(cq.or(cq.and(cq, 1, 2), cq, 0));
        Criteria criteria = cq.getDetachedCriteria().getExecutableCriteria(this.getSession());
        List list = criteria.list();
        return list;
    }

    @Override
    public String installOuterLinkWithSysParams(String url, String openid, String accountid, String wxcontent) {
        List ls;
        WeixinAccountEntity weixinAccount;
        CmsFreemarkerHelper cmsFreemarkerHelper = new CmsFreemarkerHelper();
        HashMap<String, Object> mpLinkPrams = new HashMap<String, Object>();
        mpLinkPrams.put("openid", oConvertUtils.getString((String)openid));
        mpLinkPrams.put("accountid", accountid);
        mpLinkPrams.put("wxcontent", wxcontent);
        if (oConvertUtils.isNotEmpty((Object)accountid) && (weixinAccount = (WeixinAccountEntity)this.get(WeixinAccountEntity.class, (Serializable)((Object)accountid))) != null) {
            mpLinkPrams.put("wxid", weixinAccount.getWeixinOriginalAccountid());
            mpLinkPrams.put("wxname", weixinAccount.getAccountname());
            mpLinkPrams.put("wxcode", weixinAccount.getAccountnumber());
            mpLinkPrams.put("appid", weixinAccount.getAccountappid());
            mpLinkPrams.put("appsecret", weixinAccount.getAccountappsecret());
            mpLinkPrams.put("accesstoken", weixinAccount.getAccounttoken());
            try {
                Wxuser wxuser = JwUserAPI.getWxuser((String)weixinAccount.getAccountaccesstoken(), (String)oConvertUtils.getString((String)openid));
                mpLinkPrams.put("subscribe", wxuser.getSubscribe());
                mpLinkPrams.put("nickname", wxuser.getNickname());
            }
            catch (WexinReqException e) {
                e.printStackTrace();
            }
        }
        if (!oConvertUtils.isNullOrEmpty((Object)(ls = this.findByProperty(WeixinVipMemberEntity.class, "openid", oConvertUtils.getString((String)openid))))) {
            WeixinVipMemberEntity e = (WeixinVipMemberEntity)ls.get(0);
            mpLinkPrams.put("telphone", e.getMemberMobile());
        } else {
            mpLinkPrams.put("telphone", "");
        }
        return cmsFreemarkerHelper.parseTemplateContent(url, mpLinkPrams);
    }

    @Override
    public String getInnerLink(String linkSucaiId) {
        String baseurl = ResourceUtil.getConfigByName((String)"domain");
        String inner_link = String.valueOf(baseurl) + "/weixinLinksucaiController.do?link&id=" + linkSucaiId + "&accountid=" + ResourceUtil.getShangJiaAccountId();
        return inner_link;
    }
}

