/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.linksucai.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.PropertiesUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.YouBianCodeUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.core.wxRule.impl.RemoteWeixinMethod;
import weixin.guanjia.linksucai.entity.WeixinLinksucaiEntity;
import weixin.guanjia.linksucai.service.WeixinLinksucaiServiceI;
import weixin.util.PostCodeUtil;

@Controller
@RequestMapping(value={"/weixinLinksucaiController"})
public class WeixinLinksucaiController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinLinksucaiController.class);
    @Autowired
    private WeixinLinksucaiServiceI weixinLinksucaiService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private RemoteWeixinMethod remoteWeixinMethod;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private String message;
    private static final PropertiesUtil util = new PropertiesUtil("sysConfig.properties");

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinLinksucai"})
    public ModelAndView weixinLinksucai(HttpServletRequest request) {
        return new ModelAndView("weixin/guanjia/linksucai/weixinLinksucaiList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinLinksucaiEntity weixinLinksucai, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinLinksucaiEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.eq("shareStatus", (Object)"Y");
        cq.in("postcode", (Object[])YouBianCodeUtil.cutYouBianCode((String)ResourceUtil.getShangJiaAccount().getPostCode()));
        cq.addOrder("createDate", SortDirection.desc);
        if (!ResourceUtil.onlineShangJiaAccountIdIsNull()) {
            cq.add(cq.or(cq.and(cq, 1, 2), cq, 0));
        } else {
            cq.add();
        }
        this.weixinLinksucaiService.getDataGridReturn(cq, true);
        String baseurl = ResourceUtil.getConfigByName((String)"domain");
        int i = 0;
        while (i < dataGrid.getResults().size()) {
            WeixinLinksucaiEntity t = (WeixinLinksucaiEntity)dataGrid.getResults().get(i);
            String inner_link = String.valueOf(baseurl) + "/weixinLinksucaiController.do?link&id=" + t.getId();
            t.setInnerLink(inner_link);
            ++i;
        }
        List accountList = this.weixinAccountService.loadAll(WeixinAccountEntity.class);
        PostCodeUtil.appendPostcodeName(dataGrid.getResults(), "postcode", "postcodeName", accountList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"privateList"})
    public ModelAndView privateList() {
        return new ModelAndView("weixin/guanjia/linksucai/privateWeixinLinksucaiList");
    }

    @RequestMapping(params={"privateDatagrid"})
    @ResponseBody
    public void privateDatagrid(WeixinLinksucaiEntity weixinLinksucai, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinLinksucaiEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinLinksucai);
        this.weixinLinksucaiService.getDataGridReturn(cq, true);
        String baseurl = ResourceUtil.getConfigByName((String)"domain");
        int i = 0;
        while (i < dataGrid.getResults().size()) {
            WeixinLinksucaiEntity t = (WeixinLinksucaiEntity)dataGrid.getResults().get(i);
            String inner_link = String.valueOf(baseurl) + "/weixinLinksucaiController.do?link&id=" + t.getId();
            t.setInnerLink(inner_link);
            ++i;
        }
        List accountList = this.weixinAccountService.loadAll(WeixinAccountEntity.class);
        PostCodeUtil.appendPostcodeName(dataGrid.getResults(), "postcode", "postcodeName", accountList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"shareList"})
    public ModelAndView shareList() {
        return new ModelAndView("weixin/guanjia/linksucai/shareWeixinLinksucaiList");
    }

    @RequestMapping(params={"shareDatagrid"})
    @ResponseBody
    public void shareDatagrid(WeixinLinksucaiEntity weixinLinksucai, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinLinksucaiEntity.class, dataGrid);
        cq.eq("shareStatus", (Object)"Y");
        cq.in("postcode", (Object[])YouBianCodeUtil.cutYouBianCode((String)ResourceUtil.getShangJiaAccount().getPostCode()));
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinLinksucai);
        this.weixinLinksucaiService.getDataGridReturn(cq, true);
        String baseurl = ResourceUtil.getConfigByName((String)"domain");
        int i = 0;
        while (i < dataGrid.getResults().size()) {
            WeixinLinksucaiEntity t = (WeixinLinksucaiEntity)dataGrid.getResults().get(i);
            String inner_link = String.valueOf(baseurl) + "/weixinLinksucaiController.do?link&id=" + t.getId();
            t.setInnerLink(inner_link);
            ++i;
        }
        List accountList = this.weixinAccountService.loadAll(WeixinAccountEntity.class);
        PostCodeUtil.appendPostcodeName(dataGrid.getResults(), "postcode", "postcodeName", accountList);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"link"})
    public void link(WeixinLinksucaiEntity weixinLinksucai, HttpServletRequest request, HttpServletResponse response) {
        String backUrl = WeixinUtil.getRequestUrlWithParams(request);
        String id = request.getParameter("id");
        weixinLinksucai = (WeixinLinksucaiEntity)this.systemService.getEntity(WeixinLinksucaiEntity.class, (Serializable)((Object)id));
        String accountid = weixinLinksucai.getAccountid();
        String openid = ResourceUtil.getUserOpenId();
        String outer_link_deal = null;
        if (oConvertUtils.isEmpty((Object)openid)) {
            outer_link_deal = this.remoteWeixinMethod.callWeixinAuthor2ReturnUrl(request, accountid, backUrl);
        }
        if (oConvertUtils.isEmpty(outer_link_deal)) {
            openid = ResourceUtil.getUserOpenId();
            String outUrl = weixinLinksucai.getOuterLink();
            outer_link_deal = this.weixinLinksucaiService.installOuterLinkWithSysParams(outUrl, openid, accountid, null);
        }
        try {
            response.sendRedirect(outer_link_deal);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinLinksucaiEntity weixinLinksucai, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinLinksucai = (WeixinLinksucaiEntity)this.systemService.getEntity(WeixinLinksucaiEntity.class, (Serializable)((Object)weixinLinksucai.getId()));
        this.message = "\u94fe\u63a5\u7d20\u6750\u5220\u9664\u6210\u529f";
        if (!weixinLinksucai.getAccountid().equals(ResourceUtil.getShangJiaAccountId())) {
            this.message = "\u7236\u7ea7\u5171\u4eab\u7684\u6570\u636e\u5b50\u516c\u4f17\u5e10\u53f7\u4e0d\u80fd\u64cd\u4f5c";
        } else {
            try {
                this.weixinLinksucaiService.delete(weixinLinksucai);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u94fe\u63a5\u7d20\u6750\u5220\u9664\u5931\u8d25";
                throw new BusinessException(e.getMessage());
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u94fe\u63a5\u7d20\u6750\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinLinksucaiEntity weixinLinksucai = (WeixinLinksucaiEntity)this.systemService.getEntity(WeixinLinksucaiEntity.class, (Serializable)((Object)id));
                if (weixinLinksucai.getAccountid().equals(ResourceUtil.getShangJiaAccountId())) {
                    this.weixinLinksucaiService.delete(weixinLinksucai);
                    this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u94fe\u63a5\u7d20\u6750\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinLinksucaiEntity weixinLinksucai, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u94fe\u63a5\u7d20\u6750\u6dfb\u52a0\u6210\u529f";
        try {
            this.weixinLinksucaiService.save(weixinLinksucai);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u94fe\u63a5\u7d20\u6750\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinLinksucaiEntity weixinLinksucai, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u94fe\u63a5\u7d20\u6750\u66f4\u65b0\u6210\u529f";
        WeixinLinksucaiEntity t = (WeixinLinksucaiEntity)this.weixinLinksucaiService.get(WeixinLinksucaiEntity.class, (Serializable)((Object)weixinLinksucai.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinLinksucai, (Object)t);
            this.weixinLinksucaiService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u94fe\u63a5\u7d20\u6750\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinLinksucaiEntity weixinLinksucai, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinLinksucai.getId())) {
            weixinLinksucai = (WeixinLinksucaiEntity)this.weixinLinksucaiService.getEntity(WeixinLinksucaiEntity.class, (Serializable)((Object)weixinLinksucai.getId()));
            req.setAttribute("weixinLinksucaiPage", (Object)weixinLinksucai);
        }
        req.setAttribute("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        return new ModelAndView("weixin/guanjia/linksucai/weixinLinksucai-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinLinksucaiEntity weixinLinksucai, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinLinksucai.getId())) {
            weixinLinksucai = (WeixinLinksucaiEntity)this.weixinLinksucaiService.getEntity(WeixinLinksucaiEntity.class, (Serializable)((Object)weixinLinksucai.getId()));
            req.setAttribute("weixinLinksucaiPage", (Object)weixinLinksucai);
        }
        req.setAttribute("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        return new ModelAndView("weixin/guanjia/linksucai/weixinLinksucai-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/guanjia/linksucai/weixinLinksucaiUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinLinksucaiEntity weixinLinksucai, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u94fe\u63a5\u7d20\u6750";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinLinksucaiEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinLinksucai, (Map)request.getParameterMap());
                List weixinLinksucais = this.weixinLinksucaiService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u94fe\u63a5\u7d20\u6750\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinLinksucaiEntity.class, (Collection)weixinLinksucais);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinLinksucaiEntity weixinLinksucai, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u94fe\u63a5\u7d20\u6750";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u94fe\u63a5\u7d20\u6750\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinLinksucaiEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinLinksucaiEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinLinksucaiEntity.class, (ImportParams)params);
                    for (WeixinLinksucaiEntity weixinLinksucai : listWeixinLinksucaiEntitys) {
                        this.weixinLinksucaiService.save(weixinLinksucai);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }

    @RequestMapping(params={"poplink"})
    public ModelAndView poplink(ModelMap modelMap, @RequestParam String id) {
        ResourceBundle bundler = ResourceBundle.getBundle("sysConfig");
        String absolutePathUrl = String.valueOf(bundler.getString("domain")) + "/weixinLinksucaiController.do?link&id=" + id;
        modelMap.put((Object)"url", (Object)absolutePathUrl);
        return new ModelAndView("weixin/guanjia/linksucai/poplinksucai");
    }
}

