/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.gzuserinfo.service;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.guanjia.gzuserinfo.model.GzUserInfo;
import weixin.util.DateUtils;

@Service(value="gzUserInfoService")
public class GzUserInfoService {
    public static final String user_info_url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=ACCESS_TOKEN&openid=OPENID&lang=zh_CN";
    public static final String user_List_url = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=ACCESS_TOKEN";
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private SystemService systemService;

    @Autowired
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public GzUserInfo getGzUserInfo(String openId) {
        String accessToken = this.weixinAccountService.getAccessToken();
        String requestUrl = user_info_url.replace("ACCESS_TOKEN", accessToken).replace("OPENID", openId);
        LogUtil.info((Object)requestUrl);
        JSONObject jsonObj = WeixinUtil.httpRequest(requestUrl, "GET", requestUrl);
        LogUtil.info((Object)jsonObj);
        if (jsonObj != null) {
            String subscribe = jsonObj.getString("subscribe");
            String openid = jsonObj.getString("openid");
            if (oConvertUtils.isEmpty((Object)openid)) {
                return null;
            }
            String nickname = null;
            try {
                nickname = jsonObj.getString("nickname");
            }
            catch (Exception e) {
                return null;
            }
            String sex = jsonObj.getString("sex");
            String city = jsonObj.getString("city");
            String province = jsonObj.getString("province");
            String country = jsonObj.getString("country");
            String headimgurl = jsonObj.getString("headimgurl");
            String subscribe_time = jsonObj.getString("subscribe_time");
            GzUserInfo userInfo = new GzUserInfo(subscribe, openid, nickname, sex, city, province, country, headimgurl, subscribe_time);
            return userInfo;
        }
        return null;
    }

    public GzUserInfo getGzUserInfo(String openId, String accountId) {
        String accessToken = oConvertUtils.getString((String)this.weixinAccountService.getAccessTokenNoCheck(accountId));
        String requestUrl = user_info_url.replace("ACCESS_TOKEN", accessToken);
        JSONObject jsonObj = WeixinUtil.httpRequest(requestUrl = requestUrl.replace("OPENID", openId), "GET", requestUrl);
        if (jsonObj != null && !jsonObj.containsKey((Object)"errcode")) {
            String subscribe = jsonObj.getString("subscribe");
            String openid = jsonObj.getString("openid");
            if (oConvertUtils.isEmpty((Object)openid)) {
                return null;
            }
            String nickname = null;
            try {
                nickname = jsonObj.getString("nickname");
            }
            catch (Exception e) {
                return null;
            }
            String sex = jsonObj.getString("sex");
            String city = jsonObj.getString("city");
            String province = jsonObj.getString("province");
            String country = jsonObj.getString("country");
            String headimgurl = jsonObj.getString("headimgurl");
            String subscribe_time = jsonObj.getString("subscribe_time");
            GzUserInfo userInfo = new GzUserInfo(subscribe, openid, nickname, sex, city, province, country, headimgurl, subscribe_time);
            String groupid = jsonObj.getString("groupid");
            userInfo.setGroupid(groupid);
            return userInfo;
        }
        return null;
    }

    public synchronized String getGzUserList(String next_openid, String accountId) {
        String returnMsg = "\u7c89\u4e1d\u540c\u6b65\u6210\u529f\uff0c\u540c\u6b65\u7c89\u4e1d\u6761\u6570\uff1a";
        int actionDataCount = 0;
        HashMap<String, String> accountWeixinFenSiMap = new HashMap<String, String>();
        String allhql = "from GzUserInfoYw where accountId='" + accountId + "'";
        List gzListAll = this.systemService.findByQueryString(allhql);
        for (GzUserInfoYw po : gzListAll) {
            accountWeixinFenSiMap.put(po.getOpenid(), po.getOpenid());
        }
        String accessToken = this.weixinAccountService.getAccessToken(accountId);
        ArrayList<GzUserInfoYw> tempList = new ArrayList<GzUserInfoYw>();
        if (StringUtil.isNotEmpty((Object)accessToken)) {
            String requestUrl = user_List_url.replace("NEXT_OPENID", "").replace("ACCESS_TOKEN", accessToken);
            while (oConvertUtils.isNotEmpty((Object)next_openid)) {
                JSONObject jsonObj = WeixinUtil.httpRequest(requestUrl, "GET", "");
                if (jsonObj == null) continue;
                Boolean result = jsonObj.containsKey((Object)"errmsg");
                if (!result.booleanValue()) {
                    next_openid = jsonObj.getString("next_openid");
                    int count = jsonObj.getInt("count");
                    if (count == 0) continue;
                    JSONArray openIdArr = jsonObj.getJSONObject("data").getJSONArray("openid");
                    int i = 0;
                    while (i < openIdArr.size()) {
                        String openId = openIdArr.get(i).toString();
                        if (!accountWeixinFenSiMap.containsKey(openId)) {
                            GzUserInfoYw gzUserInfo_new = new GzUserInfoYw();
                            gzUserInfo_new.setAddtime(DateUtils.getDateTime());
                            gzUserInfo_new.setAccountId(accountId);
                            gzUserInfo_new.setLettecount(0);
                            gzUserInfo_new.setOpenid(openId);
                            tempList.add(gzUserInfo_new);
                            ++actionDataCount;
                            accountWeixinFenSiMap.put(openId, openId);
                            if (i % 100 == 0) {
                                this.systemService.batchSave(tempList);
                                tempList.clear();
                            }
                        }
                        ++i;
                    }
                    accessToken = this.weixinAccountService.getAccessToken(accountId);
                    requestUrl = String.valueOf(user_List_url.replace("ACCESS_TOKEN", accessToken)) + "&next_openid=" + next_openid;
                    continue;
                }
                returnMsg = "\u540c\u6b65\u5931\u8d25\uff1a" + jsonObj.toString();
                LogUtil.error((String)returnMsg);
                break;
            }
        } else {
            returnMsg = "\u540c\u6b65\u5931\u8d25\uff1aaccessToken\u4e3a\u7a7a";
            LogUtil.error((String)returnMsg);
        }
        this.systemService.batchSave(tempList);
        accountWeixinFenSiMap.clear();
        return String.valueOf(returnMsg) + actionDataCount;
    }

    public void deleteGzUserInfoByOpenId(String openId) {
        GzUserInfoYw gzUser = (GzUserInfoYw)((Object)this.systemService.findUniqueByProperty(GzUserInfoYw.class, "openid", (Object)openId));
        if (gzUser != null) {
            this.systemService.delete((Object)gzUser);
        }
    }

    public void saveGzUserInfoByOpenId(String openid, String weixinOriginalAccountid) {
        String hql = "from GzUserInfoYw where openid='" + openid + "'";
        List gzList = this.systemService.findByQueryString(hql);
        if (gzList.size() == 0) {
            WeixinAccountEntity accountInfo = this.weixinAccountService.findByToUsername(weixinOriginalAccountid);
            GzUserInfo gzUserInfo = this.getGzUserInfo(openid, accountInfo.getId());
            if (gzUserInfo != null) {
                GzUserInfoYw temp = new GzUserInfoYw();
                temp.setCity(gzUserInfo.getCity());
                temp.setCountry(gzUserInfo.getCountry());
                temp.setHeadimgurl(gzUserInfo.getHeadimgurl());
                String nickName = WeixinUtil.encode(gzUserInfo.getNickname().getBytes());
                temp.setNickname(nickName);
                temp.setOpenid(gzUserInfo.getOpenid());
                temp.setProvince(gzUserInfo.getProvince());
                temp.setSex(gzUserInfo.getSex());
                temp.setSubscribe(gzUserInfo.getSubscribe());
                temp.setSubscribe_time(gzUserInfo.getSubscribe_time());
                temp.setAddtime(new Date(new java.util.Date().getTime()));
                temp.setAccountId(accountInfo.getId());
                temp.setLettecount(0);
                this.systemService.save((Object)temp);
            } else {
                GzUserInfoYw temp = new GzUserInfoYw();
                temp.setOpenid(openid);
                temp.setSubscribe("1");
                temp.setSubscribe_time(DateUtils.formatDate());
                temp.setAddtime(new java.util.Date(new java.util.Date().getTime()));
                temp.setAccountId(accountInfo.getId());
                temp.setLettecount(0);
                this.systemService.save((Object)temp);
            }
        } else {
            GzUserInfoYw userinfo = (GzUserInfoYw)((Object)gzList.get(0));
            userinfo.setSubscribe("1");
            this.systemService.updateEntitie((Object)userinfo);
        }
    }

    public GzUserInfoYw getLocalUserinfoSubscribe(String openid, String accountid) {
        CriteriaQuery cq = new CriteriaQuery(GzUserInfoYw.class);
        try {
            cq.eq("accountId", (Object)accountid);
            cq.eq("openid", (Object)openid);
            cq.eq("subscribe", (Object)"1");
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List userlist = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        if (userlist != null && userlist.size() != 0) {
            return (GzUserInfoYw)((Object)userlist.get(0));
        }
        return null;
    }

    public GzUserInfoYw getLocalUserinfoAll(String openid, String accountid) {
        CriteriaQuery cq = new CriteriaQuery(GzUserInfoYw.class);
        try {
            cq.eq("accountId", (Object)accountid);
            cq.eq("openid", (Object)openid);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        List userlist = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        if (userlist != null && userlist.size() != 0) {
            return (GzUserInfoYw)((Object)userlist.get(0));
        }
        return null;
    }
}

