/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.groupmessage.service.impl;

import net.sf.json.JSONObject;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.LogUtil;
import org.jeewx.api.core.exception.WexinReqException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.groupmessage.model.UploadGraphic;
import weixin.guanjia.groupmessage.service.GroupMessageTemlateI;

@Service(value="groupMessageTemplateService")
@Transactional
public class GroupMessageTemplateServiceImpl
extends CommonServiceImpl
implements GroupMessageTemlateI {
    private static String upload_group_news_url = "https://api.weixin.qq.com/cgi-bin/media/uploadnews?access_token=ACCESS_TOKEN";
    private static String group_message_send_url = "https://api.weixin.qq.com/cgi-bin/message/mass/sendall?access_token=ACCESS_TOKEN";
    @Autowired
    private WeixinAccountServiceI weixinAccountService;

    @Override
    public JSONObject uploadGroupNewsTemplate(UploadGraphic graphic) {
        String accessToken = this.weixinAccountService.getAccessToken();
        if (accessToken != null) {
            String requestUrl = upload_group_news_url.replace("ACCESS_TOKEN", accessToken);
            JSONObject obj = JSONObject.fromObject((Object)graphic);
            LogUtil.info((Object)obj.toString());
            JSONObject result = WeixinUtil.httpRequest(requestUrl, "POST", obj.toString());
            LogUtil.info((Object)result.toString());
            return result;
        }
        return null;
    }

    @Override
    public JSONObject uploadGroupNewsTemplate(UploadGraphic graphic, String accountid) {
        String accessToken = this.weixinAccountService.getAccessToken(accountid);
        if (accessToken != null) {
            String requestUrl = upload_group_news_url.replace("ACCESS_TOKEN", accessToken);
            JSONObject obj = JSONObject.fromObject((Object)graphic);
            LogUtil.info((Object)obj.toString());
            JSONObject result = WeixinUtil.httpRequest(requestUrl, "POST", obj.toString());
            return result;
        }
        return null;
    }

    @Override
    public JSONObject sendGroupMessage(JSONObject jsonObj) {
        String accessToken = this.weixinAccountService.getAccessToken();
        if (accessToken != null) {
            String requestUrl = group_message_send_url.replace("ACCESS_TOKEN", accessToken);
            JSONObject result = WeixinUtil.httpRequest(requestUrl, "POST", jsonObj.toString());
            LogUtil.info((Object)result.toString());
            return result;
        }
        return null;
    }

    @Override
    public JSONObject sendGroupMessage(JSONObject jsonObj, String accountid) throws Exception {
        String accessToken = this.weixinAccountService.getAccessToken(accountid);
        if (accessToken != null) {
            String requestUrl = group_message_send_url.replace("ACCESS_TOKEN", accessToken);
            JSONObject result = WeixinUtil.httpRequest(requestUrl, "POST", jsonObj.toString());
            if (result.getInt("errcode") != 0) {
                throw new WexinReqException("httpRequest Method\uff01errcode=" + result.getString("errcode") + ",errmsg = " + result.getString("errmsg"));
            }
            return result;
        }
        return null;
    }
}

