/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.groupmessage.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSRoleUser;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.groupmessage.entity.GroupMessageSendLogEntity;
import weixin.guanjia.groupmessage.service.GroupMessageSendLogServiceI;
import weixin.util.WeixinConfigUtil;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/groupMessageSendLogController"})
public class GroupMessageSendLogController
extends BaseController {
    private static final Logger logger = Logger.getLogger(GroupMessageSendLogController.class);
    @Autowired
    private GroupMessageSendLogServiceI groupMessageSendLogService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"groupMessageSendLog"})
    public ModelAndView groupMessageSendLog(HttpServletRequest request) {
        return new ModelAndView("weixin/guanjia/groupmessage/groupMessageSendLogList");
    }

    @RequestMapping(params={"groupMessageSendTaskLog"})
    public ModelAndView groupMessageSendTaskLog(HttpServletRequest request) {
        request.setAttribute("task", (Object)"true");
        return new ModelAndView("weixin/guanjia/groupmessage/groupMessageSendTaskLogList");
    }

    @RequestMapping(params={"groupMessageSendSubmiLog"})
    public ModelAndView groupMessageSendSubmiLog(HttpServletRequest request) {
        return new ModelAndView("weixin/guanjia/groupmessage/groupMessageSendSubmiLog");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(GroupMessageSendLogEntity groupMessageSendLog, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(GroupMessageSendLogEntity.class, dataGrid);
        groupMessageSendLog.setAccountid(ResourceUtil.getShangJiaAccountId());
        groupMessageSendLog.setAuditStatus("0,1,2,3");
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)groupMessageSendLog, (Map)request.getParameterMap());
        cq.add();
        this.groupMessageSendLogService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"taskDatagrid"})
    public void taskDatagrid(GroupMessageSendLogEntity groupMessageSendLog, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(GroupMessageSendLogEntity.class, dataGrid);
        groupMessageSendLog.setAccountid(ResourceUtil.getShangJiaAccountId());
        if (StringUtils.isEmpty((CharSequence)groupMessageSendLog.getAuditStatus())) {
            groupMessageSendLog.setAuditStatus("0,1,2");
        }
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)groupMessageSendLog, (Map)request.getParameterMap());
        cq.add();
        this.groupMessageSendLogService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"submitDatagrid"})
    public void submitDatagrid(GroupMessageSendLogEntity groupMessageSendLog, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(GroupMessageSendLogEntity.class, dataGrid);
        groupMessageSendLog.setAccountid(ResourceUtil.getShangJiaAccountId());
        if (StringUtils.isEmpty((CharSequence)groupMessageSendLog.getAuditStatus())) {
            groupMessageSendLog.setAuditStatus("0,3");
        }
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)groupMessageSendLog, (Map)request.getParameterMap());
        cq.add();
        this.groupMessageSendLogService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    private boolean isWeixinAdmin() {
        boolean result = false;
        TSUser currentUser = ResourceUtil.getSessionUserName();
        List roleUser = this.systemService.findByProperty(TSRoleUser.class, "TSUser.id", (Object)currentUser.getId());
        if (roleUser.size() > 0) {
            for (TSRoleUser ru : roleUser) {
                if (!WeixinConfigUtil.getConfigByName("weixin_quifa_admin").equals(ru.getTSRole().getRoleCode())) continue;
                return true;
            }
        }
        return result;
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(GroupMessageSendLogEntity groupMessageSendLog, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        groupMessageSendLog = (GroupMessageSendLogEntity)this.systemService.getEntity(GroupMessageSendLogEntity.class, (Serializable)((Object)groupMessageSendLog.getId()));
        this.message = "\u7fa4\u53d1\u8bb0\u5f55\u67e5\u8be2\u5220\u9664\u6210\u529f";
        try {
            this.groupMessageSendLogService.delete(groupMessageSendLog);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u7fa4\u53d1\u8bb0\u5f55\u67e5\u8be2\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u7fa4\u53d1\u8bb0\u5f55\u67e5\u8be2\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                GroupMessageSendLogEntity groupMessageSendLog = (GroupMessageSendLogEntity)this.systemService.getEntity(GroupMessageSendLogEntity.class, (Serializable)((Object)id));
                this.groupMessageSendLogService.delete(groupMessageSendLog);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u7fa4\u53d1\u8bb0\u5f55\u67e5\u8be2\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(GroupMessageSendLogEntity groupMessageSendLog, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u7fa4\u53d1\u8bb0\u5f55\u67e5\u8be2\u6dfb\u52a0\u6210\u529f";
        try {
            this.groupMessageSendLogService.save(groupMessageSendLog);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u7fa4\u53d1\u8bb0\u5f55\u67e5\u8be2\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(GroupMessageSendLogEntity groupMessageSendLog, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u7fa4\u53d1\u8bb0\u5f55\u67e5\u8be2\u66f4\u65b0\u6210\u529f";
        GroupMessageSendLogEntity t = (GroupMessageSendLogEntity)this.groupMessageSendLogService.get(GroupMessageSendLogEntity.class, (Serializable)((Object)groupMessageSendLog.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)groupMessageSendLog, (Object)t);
            this.groupMessageSendLogService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u7fa4\u53d1\u8bb0\u5f55\u67e5\u8be2\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(GroupMessageSendLogEntity groupMessageSendLog, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)groupMessageSendLog.getId())) {
            groupMessageSendLog = (GroupMessageSendLogEntity)this.groupMessageSendLogService.getEntity(GroupMessageSendLogEntity.class, (Serializable)((Object)groupMessageSendLog.getId()));
            req.setAttribute("groupMessageSendLogPage", (Object)groupMessageSendLog);
        }
        return new ModelAndView("com/buss/weixin.guanjia.groupmessage/groupMessageSendLog-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(GroupMessageSendLogEntity groupMessageSendLog, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)groupMessageSendLog.getId())) {
            groupMessageSendLog = (GroupMessageSendLogEntity)this.groupMessageSendLogService.getEntity(GroupMessageSendLogEntity.class, (Serializable)((Object)groupMessageSendLog.getId()));
            req.setAttribute("groupMessageSendLogPage", (Object)groupMessageSendLog);
        }
        return new ModelAndView("weixin/guanjia/groupmessage/groupMessageSendLog-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("com/buss/weixin.guanjia.groupmessage/groupMessageSendLogUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(GroupMessageSendLogEntity groupMessageSendLog, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u7fa4\u53d1\u8bb0\u5f55\u67e5\u8be2";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(GroupMessageSendLogEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)groupMessageSendLog, (Map)request.getParameterMap());
                List groupMessageSendLogs = this.groupMessageSendLogService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u7fa4\u53d1\u8bb0\u5f55\u67e5\u8be2\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), GroupMessageSendLogEntity.class, (Collection)groupMessageSendLogs);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(GroupMessageSendLogEntity groupMessageSendLog, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u7fa4\u53d1\u8bb0\u5f55\u67e5\u8be2";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u7fa4\u53d1\u8bb0\u5f55\u67e5\u8be2\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), GroupMessageSendLogEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listgroupMessageSendLogEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), GroupMessageSendLogEntity.class, (ImportParams)params);
                    for (GroupMessageSendLogEntity groupMessageSendLog : listgroupMessageSendLogEntitys) {
                        this.groupMessageSendLogService.save(groupMessageSendLog);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

