/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.groupmessage.controller;

import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSDocument;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.groupmessage.entity.GroupMessageNews;
import weixin.guanjia.groupmessage.entity.GroupMessageNewsTemplate;
import weixin.guanjia.groupmessage.model.BaseGraphic;
import weixin.guanjia.groupmessage.model.UploadGraphic;
import weixin.guanjia.groupmessage.service.GroupMessageTemlateI;

@Controller
@RequestMapping(value={"/groupMessageNewsTemplateController"})
public class GroupMessageNewsTemplateController {
    private SystemService systemService;
    private GroupMessageTemlateI groupMessageTemplateService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    private ResourceBundle bundle = ResourceBundle.getBundle("sysConfig");
    private String message;

    @Resource(name="systemService")
    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    @Resource(name="groupMessageTemplateService")
    public void setGroupMessageTemplateService(GroupMessageTemlateI groupMessageTemplateService) {
        this.groupMessageTemplateService = groupMessageTemplateService;
    }

    @RequestMapping(params={"list"})
    public ModelAndView jumpList() {
        return new ModelAndView("weixin/guanjia/weixinnewstemplate/weixinnewsTemplateList");
    }

    @RequestMapping(params={"datagrid"})
    @ResponseBody
    public void datagrid(GroupMessageNewsTemplate newsTemplate, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(GroupMessageNewsTemplate.class, dataGrid);
        cq.eq("accountId", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)((Object)newsTemplate));
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson deleteSmsGroup(GroupMessageNewsTemplate newsTemplate, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        newsTemplate = (GroupMessageNewsTemplate)((Object)this.systemService.getEntity(GroupMessageNewsTemplate.class, (Serializable)((Object)newsTemplate.getId())));
        this.systemService.delete((Object)newsTemplate);
        this.message = "\u5220\u9664{\u7fa4\u53d1\u56fe\u6587\u7d20\u6750}\u4fe1\u606f\u6570\u636e\u6210\u529f\uff01";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"jumpSuView"})
    public ModelAndView responseMessage(HttpServletRequest req) {
        String id = req.getParameter("id");
        req.setAttribute("id", (Object)id);
        if (StringUtil.isNotEmpty((Object)id)) {
            GroupMessageNewsTemplate newsTemplate = (GroupMessageNewsTemplate)((Object)this.systemService.getEntity(GroupMessageNewsTemplate.class, (Serializable)((Object)id)));
            String type = newsTemplate.getType();
            req.setAttribute("type", (Object)type);
            req.setAttribute("tempateName", (Object)newsTemplate.getTemplateName());
        }
        return new ModelAndView("weixin/guanjia/weixinnewstemplate/weixinnewsTemplateInfo");
    }

    @RequestMapping(params={"su"})
    @ResponseBody
    public AjaxJson updateAndSave(GroupMessageNewsTemplate newsTemplate, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        String id = newsTemplate.getId();
        if (StringUtil.isNotEmpty((Object)id)) {
            GroupMessageNewsTemplate tempAutoResponse = (GroupMessageNewsTemplate)((Object)this.systemService.getEntity(GroupMessageNewsTemplate.class, (Serializable)((Object)newsTemplate.getId())));
            this.message = "\u4fee\u6539\u5173\u952e\u5b57\u56de\u590d\u6210\u529f\uff01";
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)((Object)newsTemplate), (Object)((Object)tempAutoResponse));
                this.systemService.saveOrUpdate((Object)tempAutoResponse);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            newsTemplate.setIsUpload("0");
            newsTemplate.setAddTime(sdf.format(new Date()));
            newsTemplate.setAccountId(ResourceUtil.getShangJiaAccountId());
            newsTemplate.setCode(DataUtils.getDateUUID((String)"yyyyMMddHHmmssSSS"));
            newsTemplate.setSourceType("1");
            this.systemService.save((Object)newsTemplate);
        }
        return j;
    }

    @RequestMapping(params={"upload"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson upload(MultipartHttpServletRequest request, HttpServletResponse response) {
        String type = request.getParameter("type");
        LogUtil.info((Object)("....type..." + type));
        String msg = "";
        String media_id = "";
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        TSTypegroup tsTypegroup = this.systemService.getTypeGroup("fieltype", "\u6587\u6863\u5206\u7c7b");
        TSType tsType = this.systemService.getType("files", "\u9644\u4ef6", tsTypegroup);
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String documentTitle = oConvertUtils.getString((String)request.getParameter("documentTitle"));
        TSDocument document = new TSDocument();
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            document.setId(fileKey);
            document = (TSDocument)this.systemService.getEntity(TSDocument.class, (Serializable)((Object)fileKey));
            document.setDocumentTitle(documentTitle);
        }
        document.setSubclassname(MyClassLoader.getPackPath((Object)document));
        document.setCreatedate(DataUtils.gettimestamp());
        document.setTSType(tsType);
        UploadFile uploadFile = new UploadFile((HttpServletRequest)request, (Object)document);
        uploadFile.setCusPath("picture");
        uploadFile.setSwfpath("swfpath");
        document = (TSDocument)this.systemService.uploadFile(uploadFile);
        String url = document.getRealpath();
        attributes.put("url", url);
        LogUtil.info((Object)("-------\u9879\u76ee\u591a\u5a92\u4f53\u8def\u5f84-----------" + url));
        attributes.put("fileKey", document.getId());
        attributes.put("name", document.getAttachmenttitle());
        attributes.put("viewhref", "commonController.do?openViewFile&fileid=" + document.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + document.getId());
        url = String.valueOf(request.getSession().getServletContext().getRealPath("/")) + System.getProperty("file.separator") + url;
        url = "\\".equals(File.separator) ? url.replace("/", "\\") : url.replace("\\", "/");
        String accessToken = this.weixinAccountService.getAccessToken();
        LogUtil.info((Object)("....\u7edd\u5bf9\u8def\u5f84\u4e0a\u4f20\u591a\u5a92\u4f53\u8def\u5f84.....url\uff1a" + url));
        JSONObject jsonObj = WeixinUtil.sendMedia(type, url, accessToken);
        LogUtil.info((Object)("------------------jsonObj---------------" + jsonObj));
        if (jsonObj != null) {
            if (jsonObj.containsKey((Object)"errcode")) {
                j.setSuccess(false);
                msg = "\u56fe\u7247\u4e0a\u4f20\u5fae\u4fe1\u670d\u52a1\u5668\u5931\u8d25";
                String errcode = jsonObj.getString("errcode");
                LogUtil.info((Object)("------------------errcode---------------" + errcode));
            } else {
                j.setSuccess(true);
                msg = "\u56fe\u7247\u4e0a\u4f20\u5fae\u4fe1\u670d\u52a1\u5668\u6210\u529f";
                media_id = jsonObj.getString("media_id");
                LogUtil.info((Object)("-------media_id-----------" + media_id));
            }
        }
        attributes.put("media_id", media_id);
        j.setMsg(msg);
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"douploadwx"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson doUploadwx(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        String tempid = request.getParameter("tempid");
        GroupMessageNewsTemplate groupMessageNewsTemplate = (GroupMessageNewsTemplate)((Object)this.groupMessageTemplateService.getEntity(GroupMessageNewsTemplate.class, (Serializable)((Object)tempid)));
        this.message = "\u4e0a\u4f20\u56fe\u6587\u4fe1\u606f\u6210\u529f\uff01";
        if (StringUtil.isNotEmpty((Object)tempid)) {
            String hql = "from GroupMessageNews where groupMessageNewsTemplate.id='" + tempid + "' order by orders asc";
            LogUtil.info((Object)("...hql..." + hql));
            List weixinnewsitem = this.systemService.findByQueryString(hql);
            int size = weixinnewsitem.size();
            if (size > 0) {
                ArrayList<BaseGraphic> baseGraphicList = new ArrayList<BaseGraphic>();
                int i = 0;
                while (i < size) {
                    GroupMessageNews newItem = (GroupMessageNews)((Object)weixinnewsitem.get(i));
                    BaseGraphic baseGraphic = new BaseGraphic();
                    baseGraphic.setAuthor(newItem.getAuthor());
                    baseGraphic.setContent(newItem.getContent());
                    baseGraphic.setContent_source_url(newItem.getOriginalLink());
                    baseGraphic.setDigest(newItem.getDescription());
                    baseGraphic.setShow_cover_pic(newItem.getDisplayCoverFlag());
                    baseGraphic.setThumb_media_id(this.uploadPhoto(newItem.getImagePath(), groupMessageNewsTemplate.getAccountId(), request));
                    baseGraphic.setTitle(newItem.getTitle());
                    baseGraphicList.add(baseGraphic);
                    ++i;
                }
                UploadGraphic graphic = new UploadGraphic();
                graphic.setArticles(baseGraphicList);
                JSONObject resultJson = this.groupMessageTemplateService.uploadGroupNewsTemplate(graphic);
                if (resultJson.containsKey((Object)"media_id")) {
                    groupMessageNewsTemplate.setMedia_id(resultJson.getString("media_id"));
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    groupMessageNewsTemplate.setAddTime(sdf.format(new Date()));
                    groupMessageNewsTemplate.setIsUpload("1");
                    this.groupMessageTemplateService.updateEntitie((Object)groupMessageNewsTemplate);
                } else {
                    this.message = "\u5206\u7ec4\u7fa4\u53d1\u56fe\u6587\u6d88\u606f\u540c\u6b65\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f" + resultJson.toString();
                }
            } else {
                this.message = "\u8be5\u56fe\u6587\u6a21\u677f\u5c1a\u672a\u6dfb\u52a0\u56fe\u6587\u6d88\u606f\uff01";
            }
        }
        j.setMsg(this.message);
        j.setSuccess(true);
        return j;
    }

    @RequestMapping(params={"doBatchUploadWx"})
    @ResponseBody
    public AjaxJson doBatchUploadWx(HttpServletRequest request, HttpServletResponse response, String ids) {
        AjaxJson j = new AjaxJson();
        String[] idArray = ids.split(",");
        int succ = 0;
        int error = 0;
        String[] stringArray = idArray;
        int n = idArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            GroupMessageNewsTemplate groupMessageNewsTemplate = (GroupMessageNewsTemplate)((Object)this.groupMessageTemplateService.getEntity(GroupMessageNewsTemplate.class, (Serializable)((Object)id)));
            List sucais = this.systemService.findByQueryString("from GroupMessageNewsTemplate where code='" + groupMessageNewsTemplate.getCode() + "' and postcode like '" + groupMessageNewsTemplate.getPostcode() + "%'");
            for (GroupMessageNewsTemplate sc : sucais) {
                if (sc == null) continue;
                String hql = "from GroupMessageNews where groupMessageNewsTemplate.id='" + sc.getId() + "'";
                LogUtil.info((Object)("...hql..." + hql));
                List weixinnewsitem = this.systemService.findByQueryString(hql);
                int size = weixinnewsitem.size();
                if (size > 0) {
                    ArrayList<BaseGraphic> baseGraphicList = new ArrayList<BaseGraphic>();
                    int i = 0;
                    while (i < size) {
                        GroupMessageNews newItem = (GroupMessageNews)((Object)weixinnewsitem.get(i));
                        BaseGraphic baseGraphic = new BaseGraphic();
                        baseGraphic.setAuthor(newItem.getAuthor());
                        baseGraphic.setContent(newItem.getContent());
                        String content_source_url = String.valueOf(this.bundle.getString("domain")) + "/groupMessageNewsController.do?newscontent&id=" + newItem.getId();
                        baseGraphic.setContent_source_url(content_source_url);
                        baseGraphic.setDigest(newItem.getDescription());
                        baseGraphic.setShow_cover_pic(newItem.getDisplayCoverFlag());
                        baseGraphic.setThumb_media_id(this.uploadPhoto(newItem.getImagePath(), sc.getAccountId(), request));
                        baseGraphic.setTitle(newItem.getTitle());
                        baseGraphicList.add(baseGraphic);
                        ++i;
                    }
                    UploadGraphic graphic = new UploadGraphic();
                    graphic.setArticles(baseGraphicList);
                    JSONObject resultJson = this.groupMessageTemplateService.uploadGroupNewsTemplate(graphic, sc.getAccountId());
                    if (resultJson != null && resultJson.containsKey((Object)"media_id")) {
                        sc.setMedia_id(resultJson.getString("media_id"));
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        sc.setAddTime(sdf.format(new Date()));
                        sc.setIsUpload("1");
                        this.groupMessageTemplateService.updateEntitie((Object)sc);
                        ++succ;
                        continue;
                    }
                    if (resultJson != null) {
                        this.message = "\u5206\u7ec4\u7fa4\u53d1\u56fe\u6587\u6d88\u606f\u540c\u6b65\u51fa\u9519\uff0c\u9519\u8bef\u4fe1\u606f" + resultJson.toString();
                    }
                    ++error;
                    continue;
                }
                this.message = "\u8be5\u56fe\u6587\u6a21\u677f\u5c1a\u672a\u6dfb\u52a0\u56fe\u6587\u6d88\u606f\uff01";
                ++error;
            }
            ++n2;
        }
        this.message = "\u64cd\u4f5c\u5b8c\u6210";
        if (succ > 0) {
            this.message = String.valueOf(this.message) + "\uff0c\u6210\u529f\u4e0a\u4f20" + succ + "\u4e2a";
        }
        if (error > 0) {
            this.message = String.valueOf(this.message) + "\uff0c\u5931\u8d25\u4e0a\u4f20" + error + "\u4e2a";
        }
        j.setMsg(this.message);
        j.setSuccess(true);
        return j;
    }

    @RequestMapping(params={"getAllUploadNewsTemplate"})
    public ModelAndView getAllUploadNewsTemplate(HttpServletRequest request) {
        String symbol = request.getParameter("symbol");
        if ("simple".equals(symbol)) {
            String type = request.getParameter("type");
            LogUtil.info((Object)("....type..." + type));
            request.setAttribute("type", (Object)type);
            if ("image".equals(type)) {
                String accountId = ResourceUtil.getShangJiaAccountId();
                String hql = "from WeixinPhotosucaiEntity where accountId='" + accountId + "' and synchFlag = 'true'";
                List templateList = this.systemService.findByQueryString(hql);
                request.setAttribute("templateList", (Object)templateList);
                return new ModelAndView("weixin/guanjia/weixinnewstemplate/showGroupMessageImage");
            }
            if ("video".equals(type)) {
                String accountId = ResourceUtil.getShangJiaAccountId();
                String hql = "from WeixinVideosucaiEntity where accountId='" + accountId + "' and synchFlag = 'true'";
                List templateList = this.systemService.findByQueryString(hql);
                request.setAttribute("templateList", (Object)templateList);
                return new ModelAndView("weixin/guanjia/weixinnewstemplate/showGroupMessageVideo");
            }
            String accountId = ResourceUtil.getShangJiaAccountId();
            String hql = "from WeixinAudiosucaiEntity where accountId='" + accountId + "' and synchFlag = 'true'";
            List templateList = this.systemService.findByQueryString(hql);
            request.setAttribute("templateList", (Object)templateList);
            return new ModelAndView("weixin/guanjia/weixinnewstemplate/showGroupMessageVoice");
        }
        String accountId = ResourceUtil.getShangJiaAccountId();
        String hql = "from GroupMessageNewsTemplate where accountId='" + accountId + "' and isUpload='1'";
        List groupMessageNewsTemplateList = this.groupMessageTemplateService.findByQueryString(hql);
        request.setAttribute("groupMessageNewsTemplateList", (Object)groupMessageNewsTemplateList);
        return new ModelAndView("weixin/guanjia/weixinnewstemplate/showGroupMessageNews");
    }

    @RequestMapping(params={"getGroupMessageNewsByMedia"})
    @ResponseBody
    public JSONArray getGroupMessageNewsByMedia(HttpServletRequest request) {
        String mediaId = request.getParameter("mediaId");
        String hql = "from GroupMessageNews where groupMessageNewsTemplate.media_id='" + mediaId + "' order by orders asc";
        List groupMessageList = this.systemService.findByQueryString(hql);
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.setExcludes(new String[]{"groupMessageNewsTemplate", "content"});
        JSONArray jsonArray = JSONArray.fromObject((Object)groupMessageList, (JsonConfig)jsonConfig);
        LogUtil.info((Object)("...jsonArray...." + jsonArray.toString()));
        return jsonArray;
    }

    public String uploadPhoto(String realpath, String accountid, HttpServletRequest request) {
        String media_id = "";
        String accessToken = this.weixinAccountService.getAccessToken(accountid);
        String url = String.valueOf(request.getSession().getServletContext().getRealPath("")) + System.getProperty("file.separator") + realpath;
        JSONObject jsonObj = WeixinUtil.sendMedia("image", url, accessToken);
        if (jsonObj != null) {
            if (jsonObj.containsKey((Object)"errcode")) {
                String errcode = jsonObj.getString("errcode");
                String errmsg = jsonObj.getString("errmsg");
                System.out.println("\u56fe\u7247\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u5931\u8d25\u3010errcode=" + errcode + "\u3011\u3010errmsg=" + errmsg + "\u3011");
            } else {
                System.out.println("\u56fe\u7247\u7d20\u6750\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u6210\u529f");
                media_id = jsonObj.getString("media_id");
            }
        }
        return media_id;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

