/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.core.wxRule.impl;

import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.core.wxRule.base.RemoteWeixinMethodBase;
import weixin.guanjia.core.wxRule.impl.RemoteWeixinMethodI;
import weixin.guanjia.core.wxRule.pojo.oauth2.Oauth2CodePojo;
import weixin.guanjia.core.wxRule.pojo.templateMsg.TemplateMsgPojo;
import weixin.idea.oauth2.util.OAuth2Util;

@Service
public class RemoteWeixinMethod
extends RemoteWeixinMethodBase
implements RemoteWeixinMethodI {
    @Autowired
    private WeixinAccountServiceI weixinAccountService;

    @Override
    public Map<String, Object> callWeixinTemplateMsg(String url, TemplateMsgPojo pojo) {
        return this.callWeixinRemoteMethod(url, pojo);
    }

    @Override
    public String callWeixinAuthor2(HttpServletRequest request, String accountId, String tagetUrl) {
        String openId = ResourceUtil.getOpenid((HttpServletRequest)request);
        if (oConvertUtils.isNullOrEmpty((Object)openId)) {
            openId = ResourceUtil.getUserOpenId();
        }
        if (StringUtil.isEmpty((String)openId)) {
            WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountId));
            String code = request.getParameter("code");
            LogUtil.info((Object)("code\u7684\u503c=" + code));
            if (StringUtil.isEmpty((String)code)) {
                LogUtil.info((Object)("targetURL\u7684\u503c=" + tagetUrl));
                if (!oConvertUtils.isNullOrEmpty((Object)account.getCustomCallbackDomain()) && account.getCustomCallbackDomain().indexOf("http://") == -1) {
                    tagetUrl = "http://" + account.getCustomCallbackDomain() + "?jeewxUrl=" + tagetUrl;
                    return "redirect:" + tagetUrl;
                }
                String redirectURL = OAuth2Util.obtainWeixinOAuth2Url(tagetUrl, account.getAccountappid(), "snsapi_base");
                return "redirect:" + redirectURL;
            }
            if (!"authdeny".equals(code)) {
                Map<String, Object> map = new RemoteWeixinMethod().getOauth2AccessToken(new Oauth2CodePojo(account.getAccountappid(), account.getAccountappsecret(), code));
                openId = (String)map.get("openid");
            }
            request.getSession().setAttribute("USER_OPENID", (Object)openId);
        }
        if (StringUtil.isEmpty((String)openId)) {
            request.setAttribute("msg", (Object)"\u8bf7\u8054\u7cfb\u5546\u5bb6\uff0c\u68c0\u67e5\u5fae\u4fe1\u516c\u4f17\u53f7\u7684\u914d\u7f6e");
            return "weixin/idea/huodong2/zp/zhuanpanover";
        }
        return null;
    }

    public String callWeixinAuthor2ReturnUrl(HttpServletRequest request, String accountId, String tagetUrl) {
        String openId = ResourceUtil.getOpenid((HttpServletRequest)request);
        if (oConvertUtils.isNullOrEmpty((Object)openId)) {
            openId = ResourceUtil.getUserOpenId();
        }
        if (StringUtil.isEmpty((String)openId)) {
            WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountId));
            String code = request.getParameter("code");
            LogUtil.info((Object)("-----author2.0--------code\u7684\u503c--------------" + code));
            if (StringUtil.isEmpty((String)code)) {
                LogUtil.info((Object)("-----------author2.0-------------targetURL\u7684\u503c-------------" + tagetUrl));
                if (!oConvertUtils.isNullOrEmpty((Object)account.getCustomCallbackDomain()) && account.getCustomCallbackDomain().indexOf("http://") == -1) {
                    tagetUrl = "http://" + account.getCustomCallbackDomain() + "?jeewxUrl=" + tagetUrl;
                }
                String redirectURL = OAuth2Util.obtainWeixinOAuth2Url(tagetUrl, account.getAccountappid(), "snsapi_base");
                return redirectURL;
            }
            if (!"authdeny".equals(code)) {
                Map<String, Object> map = new RemoteWeixinMethod().getOauth2AccessToken(new Oauth2CodePojo(account.getAccountappid(), account.getAccountappsecret(), code));
                openId = (String)map.get("openid");
            }
            request.getSession().setAttribute("USER_OPENID", (Object)openId);
        }
        return null;
    }

    @Override
    public Map<String, Object> getOauth2AccessToken(Oauth2CodePojo oauth2CodePojo) {
        String requestUrl = WeixinUtil.web_oauth_accesstoken_url;
        requestUrl = requestUrl.replace("APPID", oauth2CodePojo.getAppId());
        requestUrl = requestUrl.replace("SECRET", oauth2CodePojo.getAppSecret());
        requestUrl = requestUrl.replace("CODE", oauth2CodePojo.getCode());
        return this.callWeixinRemoteMethod(requestUrl, oauth2CodePojo);
    }
}

