/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.core.util;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.oConvertUtils;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import weixin.guanjia.core.util.MyX509TrustManager;

public class WeixinUtil {
    public static final String access_token_url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";
    public static String menu_create_url = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=ACCESS_TOKEN";
    public static String send_message_url = "https://api.weixin.qq.com/cgi-bin/message/custom/send?access_token=ACCESS_TOKEN";
    public static String qrcode_ticket_url = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=ACCESS_TOKEN";
    public static String get_qrcode_url = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=TICKET";
    public static String web_oauth_url = "https://open.weixin.qq.com/connect/oauth2/authorize?appid=APPID&redirect_uri=REDIRECT_URI&response_type=code&scope=SCOPE&state=STATE#wechat_redirect";
    public static String web_oauth_accesstoken_url = "https://api.weixin.qq.com/sns/oauth2/access_token?appid=APPID&secret=SECRET&code=CODE&grant_type=authorization_code";
    public static String web_oauth_userinfo_url = "https://api.weixin.qq.com/sns/userinfo?access_token=ACCESS_TOKEN&openid=OPENID";
    public static String get_callbackip_url = "https://api.weixin.qq.com/cgi-bin/getcallbackip?access_token=ACCESS_TOKEN";
    public static final String jsapi_ticket_url = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi";

    public static JSONObject httpRequest(String requestUrl, String requestMethod, String outputStr) {
        JSONObject jsonObject = null;
        StringBuffer buffer = new StringBuffer();
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            HttpsURLConnection httpUrlConn = (HttpsURLConnection)url.openConnection();
            httpUrlConn.setSSLSocketFactory(ssf);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }
            if (outputStr != null) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
            jsonObject = JSONObject.fromObject((Object)buffer.toString());
        }
        catch (ConnectException ce) {
            LogUtil.info((Object)"Weixin server connection timed out.");
        }
        catch (Exception e) {
            LogUtil.info((Object)("https request error:{}" + e.getMessage()));
        }
        return jsonObject;
    }

    public static String httpCommonRequest(String requestUrl, String requestMethod, String outputStr) {
        StringBuffer buffer = new StringBuffer();
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory ssf = sslContext.getSocketFactory();
            URL url = new URL(requestUrl);
            HttpURLConnection httpUrlConn = (HttpURLConnection)url.openConnection();
            httpUrlConn.setConnectTimeout(4500);
            httpUrlConn.setReadTimeout(4500);
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            if ("GET".equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }
            if (outputStr != null) {
                OutputStream outputStream = httpUrlConn.getOutputStream();
                outputStream.write(outputStr.getBytes("UTF-8"));
                outputStream.close();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "utf-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String str = null;
            while ((str = bufferedReader.readLine()) != null) {
                if (!oConvertUtils.isNotEmpty((Object)str) || !oConvertUtils.isNotEmpty((Object)str.trim()) || "\ufeff ".equals(str)) continue;
                str = String.valueOf(str.trim()) + "\n";
                buffer.append(str);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            inputStream = null;
            httpUrlConn.disconnect();
        }
        catch (ConnectException ce) {
            LogUtil.info((Object)"Weixin server connection timed out.");
        }
        catch (Exception e) {
            LogUtil.info((Object)("https request error:{}" + e.getMessage()));
        }
        return buffer.toString().trim();
    }

    public static void saveHttpImage(String requestUrl, String requestMethod, String outputStr, File target) {
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod(requestMethod);
            conn.setConnectTimeout(5000);
            InputStream inStream = conn.getInputStream();
            byte[] data = WeixinUtil.readInputStream(inStream);
            FileOutputStream outStream = new FileOutputStream(target);
            outStream.write(data);
            outStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String encode(byte[] bstr) {
        return new BASE64Encoder().encode(bstr);
    }

    public static byte[] decode(String str) {
        byte[] bt = null;
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            bt = decoder.decodeBuffer(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bt;
    }

    public static JSONObject sendMedia(String fileType, String filePath, String token) {
        String result = null;
        JSONObject jsonobject = new JSONObject();
        jsonobject = null;
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            jsonobject = null;
            LogUtil.info((Object)"------------\u6587\u4ef6\u4e0d\u5b58\u5728------------------------");
        } else {
            try {
                String requestUrl = "http://file.api.weixin.qq.com/cgi-bin/media/upload?access_token=" + token + "&type=" + fileType;
                LogUtil.info((Object)("------------------requestUr------------" + requestUrl));
                URL urlObj = new URL(requestUrl);
                HttpURLConnection con = (HttpURLConnection)urlObj.openConnection();
                con.setRequestMethod("POST");
                con.setDoInput(true);
                con.setDoOutput(true);
                con.setUseCaches(false);
                con.setRequestProperty("Connection", "Keep-Alive");
                con.setRequestProperty("Charset", "UTF-8");
                String BOUNDARY = "----------" + System.currentTimeMillis();
                con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + BOUNDARY);
                StringBuilder sb = new StringBuilder();
                sb.append("--");
                sb.append(BOUNDARY);
                sb.append("\r\n");
                sb.append("Content-Disposition: form-data;name=\"file\";filename=\"" + file.getName() + "\"\r\n");
                sb.append("Content-Type:application/octet-stream\r\n\r\n");
                byte[] head = sb.toString().getBytes("utf-8");
                DataOutputStream out = new DataOutputStream(con.getOutputStream());
                ((OutputStream)out).write(head);
                DataInputStream in = new DataInputStream(new FileInputStream(file));
                int bytes = 0;
                byte[] bufferOut = new byte[1024];
                while ((bytes = in.read(bufferOut)) != -1) {
                    ((OutputStream)out).write(bufferOut, 0, bytes);
                }
                in.close();
                byte[] foot = ("\r\n--" + BOUNDARY + "--\r\n").getBytes("utf-8");
                ((OutputStream)out).write(foot);
                ((OutputStream)out).flush();
                ((OutputStream)out).close();
                StringBuffer buffer = new StringBuffer();
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
                        String line = null;
                        while ((line = reader.readLine()) != null) {
                            buffer.append(line);
                        }
                        result = buffer.toString();
                    }
                    catch (IOException e) {
                        LogUtil.info((Object)("\u53d1\u9001POST\u8bf7\u6c42\u51fa\u73b0\u5f02\u5e38\uff01" + e));
                        e.printStackTrace();
                        throw new IOException("\u6570\u636e\u8bfb\u53d6\u5f02\u5e38");
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                jsonobject = JSONObject.fromObject((Object)result);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return jsonobject;
    }

    private static byte[] readInputStream(InputStream inStream) throws Exception {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = inStream.read(buffer)) != -1) {
            outstream.write(buffer, 0, len);
        }
        outstream.close();
        inStream.close();
        return outstream.toByteArray();
    }

    public static String getRequestUrlWithParams(HttpServletRequest request) {
        String backurl = String.valueOf(request.getScheme()) + "://" + request.getServerName() + request.getRequestURI() + "?" + request.getQueryString();
        return backurl;
    }
}

