/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.core.service.impl;

import com.google.gson.Gson;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.jeecgframework.core.util.DataUtils;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MutiLangUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.cgform.engine.FreemarkerHelper;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.audiosucai.entity.WeixinAudiosucaiEntity;
import weixin.guanjia.base.entity.Subscribe;
import weixin.guanjia.base.entity.WeixinExpandconfigEntity;
import weixin.guanjia.base.service.SubscribeServiceI;
import weixin.guanjia.base.service.WeixinExpandconfigServiceI;
import weixin.guanjia.core.dao.WechatDao;
import weixin.guanjia.core.entity.message.resp.Article;
import weixin.guanjia.core.entity.message.resp.Image;
import weixin.guanjia.core.entity.message.resp.ImageMessageResp;
import weixin.guanjia.core.entity.message.resp.LinkMessageResp;
import weixin.guanjia.core.entity.message.resp.NewsMessageResp;
import weixin.guanjia.core.entity.message.resp.TextMessageResp;
import weixin.guanjia.core.entity.message.resp.Video;
import weixin.guanjia.core.entity.message.resp.VideoMessageResp;
import weixin.guanjia.core.entity.message.resp.Voice;
import weixin.guanjia.core.entity.message.resp.VoiceMessageResp;
import weixin.guanjia.core.util.MessageUtil;
import weixin.guanjia.core.util.SendMsgUtils;
import weixin.guanjia.core.util.WeixinUtil;
import weixin.guanjia.gzuserinfo.entity.GzUserInfoYw;
import weixin.guanjia.gzuserinfo.service.GzUserInfoService;
import weixin.guanjia.linksucai.entity.WeixinLinksucaiEntity;
import weixin.guanjia.linksucai.service.WeixinLinksucaiServiceI;
import weixin.guanjia.location.entity.LocationEntity;
import weixin.guanjia.menu.entity.MenuEntity;
import weixin.guanjia.message.entity.AutoResponse;
import weixin.guanjia.message.entity.AutoResponseDefaultEntity;
import weixin.guanjia.message.entity.NewsItem;
import weixin.guanjia.message.entity.NewsTemplate;
import weixin.guanjia.message.entity.ReceiveText;
import weixin.guanjia.message.entity.TextTemplate;
import weixin.guanjia.message.service.AutoResponseServiceI;
import weixin.guanjia.message.service.NewsItemServiceI;
import weixin.guanjia.message.service.NewsTemplateServiceI;
import weixin.guanjia.message.service.ReceiveTextServiceI;
import weixin.guanjia.message.service.TextTemplateServiceI;
import weixin.guanjia.photosucai.entity.WeixinPhotosucaiEntity;
import weixin.guanjia.tj.service.GzUserTotalServiceI;
import weixin.guanjia.tj.service.MenuclickTotalServiceI;
import weixin.guanjia.videosucai.entity.WeixinVideosucaiEntity;
import weixin.idea.extend.function.KeyServiceI;
import weixin.idea.qrcode.entity.WeixinQrcodeEntity;
import weixin.idea.qrcode.entity.WeixinQrcodeScanRecord;
import weixin.idea.qrcode.entity.WeixinQrcodeSceneEntity;
import weixin.idea.qrcode.service.WeixinQrcodeScanRecordServiceI;
import weixin.idea.qrcode.service.WeixinQrcodeSceneServiceI;
import weixin.idea.qrcode.service.WeixinQrcodeServiceI;
import weixin.idea.votepk.service.WeixinVotePKService;
import weixin.util.DateUtils;
import weixin.vip.entity.WeixinVipMemberEntity;
import weixin.vip.entity.WeixinVipMemberOprEntity;
import weixin.vip.entity.WeixinVipMemberValidCodeEntity;
import weixin.wall.entity.WeixinWallMessageEntity;
import weixin.wall.entity.WeixinWallStatus;
import weixin.wall.service.WeixinWallStatusService;

@Service(value="wechatService")
public class WechatService {
    @Autowired
    private WechatDao wechatDao;
    @Autowired
    private AutoResponseServiceI autoResponseService;
    @Autowired
    private TextTemplateServiceI textTemplateService;
    @Autowired
    private NewsTemplateServiceI newsTemplateService;
    @Autowired
    private ReceiveTextServiceI receiveTextService;
    @Autowired
    private NewsItemServiceI newsItemService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private SubscribeServiceI subscribeService;
    @Autowired
    private WeixinExpandconfigServiceI weixinExpandconfigService;
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private WeixinQrcodeServiceI weixinQrcodeService;
    @Autowired
    private WeixinQrcodeSceneServiceI weixinQrcodeSceneService;
    @Autowired
    private WeixinQrcodeScanRecordServiceI weixinQrcodeScanRecordService;
    @Autowired
    private GzUserInfoService gzUserInfoService;
    @Autowired
    private WeixinVotePKService weixinVotePKService;
    @Autowired
    private WeixinWallStatusService weixinWallStatusService;
    @Autowired
    private MenuclickTotalServiceI menuclickTotalService;
    @Autowired
    private GzUserTotalServiceI gzUserTotalService;
    @Autowired
    private WeixinLinksucaiServiceI weixinLinksucaiService;
    ResourceBundle bundler = ResourceBundle.getBundle("sysConfig");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String coreService(HttpServletRequest request) {
        String respMessage;
        block24: {
            respMessage = null;
            try {
                AutoResponseDefaultEntity isWorkResponse;
                String respContent = "\u8bf7\u6c42\u5904\u7406\u5f02\u5e38\uff0c\u8bf7\u7a0d\u5019\u5c1d\u8bd5\uff01";
                Map<String, String> requestMap = MessageUtil.parseXml(request);
                String fromUserName = requestMap.get("FromUserName");
                String toUserName = requestMap.get("ToUserName");
                String msgType = requestMap.get("MsgType");
                String msgId = requestMap.get("MsgId");
                String content = requestMap.get("Content");
                String mediaId = requestMap.get("MediaId");
                String sys_accountId = this.weixinAccountService.findByToUsername(toUserName).getId();
                LogUtil.info((Object)("------------\u5fae\u4fe1\u5ba2\u6237\u7aef\u53d1\u9001\u8bf7\u6c42---------------------   |   fromUserName:" + fromUserName + "   |   ToUserName:" + toUserName + "   |   msgType:" + msgType + "   |   msgId:" + msgId + "   |   content:" + content + "   |  sys_accountId:" + sys_accountId));
                TextMessageResp textMessage = new TextMessageResp();
                textMessage.setToUserName(fromUserName);
                textMessage.setFromUserName(toUserName);
                textMessage.setCreateTime(new Date().getTime());
                textMessage.setMsgType("text");
                textMessage.setContent(WechatService.getMainMenu());
                respMessage = MessageUtil.textMessageToXml(textMessage);
                String hql = "from AutoResponseDefaultEntity where accountid='" + sys_accountId + "' and iswork='1' and msgTriggerType = '" + msgType + "'";
                List autoResponseDefaultList = this.autoResponseService.findByQueryString(hql);
                LogUtil.info((Object)("....size of autoResponseDefaultList.1.." + autoResponseDefaultList.size()));
                if (autoResponseDefaultList != null && autoResponseDefaultList.size() > 0) {
                    isWorkResponse = (AutoResponseDefaultEntity)autoResponseDefaultList.get(0);
                    respMessage = this.getRespMessage(content, isWorkResponse.getMsgtype(), isWorkResponse.getTemplateid(), textMessage, this.bundler, toUserName, fromUserName, sys_accountId);
                } else {
                    hql = "from AutoResponseDefaultEntity where accountid='" + sys_accountId + "' and iswork='1'";
                    autoResponseDefaultList = this.autoResponseService.findByQueryString(hql);
                    LogUtil.info((Object)("....size of autoResponseDefaultList.2.." + autoResponseDefaultList.size()));
                    if (autoResponseDefaultList != null && autoResponseDefaultList.size() > 0) {
                        isWorkResponse = (AutoResponseDefaultEntity)autoResponseDefaultList.get(0);
                        respMessage = this.getRespMessage(content, isWorkResponse.getMsgtype(), isWorkResponse.getTemplateid(), textMessage, this.bundler, toUserName, fromUserName, sys_accountId);
                    }
                }
                this.saveReceiveTextService(content, toUserName, textMessage, this.bundler, sys_accountId, respMessage, fromUserName, request, msgId, msgType, mediaId);
                if (msgType.equals("text")) {
                    LogUtil.info((Object)"------------\u5fae\u4fe1\u5ba2\u6237\u7aef\u53d1\u9001\u8bf7\u6c42------------------\u3010\u5fae\u4fe1\u89e6\u53d1\u7c7b\u578b\u3011\u6587\u672c\u6d88\u606f---");
                    respMessage = this.doTextResponse(content, toUserName, textMessage, this.bundler, sys_accountId, respMessage, fromUserName, request, msgId, msgType);
                    break block24;
                }
                if (msgType.equals("image")) {
                    respContent = "\u60a8\u53d1\u9001\u7684\u662f\u56fe\u7247\u6d88\u606f\uff01";
                    break block24;
                }
                if (msgType.equals("location")) {
                    respContent = "\u60a8\u53d1\u9001\u7684\u662f\u5730\u7406\u4f4d\u7f6e\u6d88\u606f\uff01";
                    break block24;
                }
                if (msgType.equals("link")) {
                    respContent = "\u60a8\u53d1\u9001\u7684\u662f\u94fe\u63a5\u6d88\u606f\uff01";
                    break block24;
                }
                if (msgType.equals("voice")) {
                    if (requestMap.containsKey("Recognition")) {
                        content = requestMap.get("Recognition");
                        respMessage = this.doTextResponse(content, toUserName, textMessage, this.bundler, sys_accountId, respMessage, fromUserName, request, msgId, msgType);
                    } else {
                        respContent = "\u60a8\u53d1\u9001\u7684\u662f\u97f3\u9891\u6d88\u606f\uff01";
                    }
                    break block24;
                }
                if (!msgType.equals("event")) break block24;
                LogUtil.info((Object)"------------\u5fae\u4fe1\u5ba2\u6237\u7aef\u53d1\u9001\u8bf7\u6c42------------------\u3010\u5fae\u4fe1\u89e6\u53d1\u7c7b\u578b\u3011\u4e8b\u4ef6\u63a8\u9001---");
                String eventType = requestMap.get("Event");
                if (eventType.equals("subscribe")) {
                    respMessage = this.doDingYueEventResponse(requestMap, textMessage, this.bundler, respMessage, toUserName, fromUserName, respContent, sys_accountId);
                    break block24;
                }
                if (eventType.equals("SCAN")) {
                    respMessage = this.doScanEventResponse(requestMap, textMessage, this.bundler, respMessage, toUserName, fromUserName, respContent, sys_accountId);
                    break block24;
                }
                if (eventType.equals("unsubscribe")) {
                    String string = fromUserName;
                    synchronized (string) {
                        this.gzUserTotalService.dealTotalRecord(false, sys_accountId);
                        GzUserInfoYw yw = this.gzUserInfoService.getLocalUserinfoSubscribe(fromUserName, this.weixinAccountService.findByToUsername(toUserName).getId());
                        if (yw != null) {
                            yw.setSubscribe("0");
                            this.systemService.updateEntitie((Object)yw);
                        }
                        break block24;
                    }
                }
                if (eventType.equals("LOCATION")) {
                    LocationEntity location = (LocationEntity)this.systemService.findUniqueByProperty(LocationEntity.class, "openid", (Object)fromUserName);
                    String latitude = requestMap.get("Latitude");
                    String longitude = requestMap.get("Longitude");
                    Date nowTime = new Date();
                    if (location == null) {
                        location = new LocationEntity();
                        String precision = requestMap.get("Precision");
                        location.setAccountid(sys_accountId);
                        location.setOpenid(fromUserName);
                        location.setLatitude(latitude);
                        location.setLongitude(longitude);
                        location.setPrecision(precision);
                        location.setAddtime(nowTime);
                        this.systemService.save((Object)location);
                    } else {
                        location.setLongitude(longitude);
                        location.setLatitude(latitude);
                        location.setAddtime(nowTime);
                        this.systemService.updateEntitie((Object)location);
                    }
                    respMessage = "";
                } else if (eventType.equals("CLICK")) {
                    respMessage = this.doMyMenuEvent(requestMap, textMessage, this.bundler, respMessage, toUserName, fromUserName, respContent, sys_accountId, request);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return respMessage;
    }

    public static String getTranslateUsage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\u5fae\u8bd1\u4f7f\u7528\u6307\u5357").append("\n\n");
        buffer.append("\u5fae\u8bd1\u4e3a\u7528\u6237\u63d0\u4f9b\u4e13\u4e1a\u7684\u591a\u8bed\u8a00\u7ffb\u8bd1\u670d\u52a1\uff0c\u76ee\u524d\u652f\u6301\u4ee5\u4e0b\u7ffb\u8bd1\u65b9\u5411\uff1a").append("\n");
        buffer.append("    \u4e2d -> \u82f1").append("\n");
        buffer.append("    \u82f1 -> \u4e2d").append("\n");
        buffer.append("    \u65e5 -> \u4e2d").append("\n\n");
        buffer.append("\u4f7f\u7528\u793a\u4f8b\uff1a").append("\n");
        buffer.append("    \u7ffb\u8bd1\u6211\u662f\u4e2d\u56fd\u4eba").append("\n");
        buffer.append("    \u7ffb\u8bd1dream").append("\n");
        buffer.append("    \u7ffb\u8bd1\u3055\u3088\u3046\u306a\u3089").append("\n\n");
        buffer.append("\u56de\u590d\u201c?\u201d\u663e\u793a\u4e3b\u83dc\u5355");
        return buffer.toString();
    }

    private AutoResponse findKey(String content, String toUsername) {
        String sys_accountId = this.weixinAccountService.findByToUsername(toUsername).getId();
        List autoResponses = this.autoResponseService.findByProperty(AutoResponse.class, "accountId", sys_accountId);
        LogUtil.info((Object)("---------sys_accountId----\u5173\u952e\u5b57\u67e5\u8be2\u7ed3\u679c\u6761\u6570\uff1a----" + autoResponses != null ? autoResponses.size() : 0));
        for (AutoResponse r : autoResponses) {
            String[] allkw;
            String kw = r.getKeyWord();
            String[] stringArray = allkw = kw.split(",");
            int n = allkw.length;
            int n2 = 0;
            while (n2 < n) {
                String k = stringArray[n2];
                if (k.equalsIgnoreCase(content)) {
                    LogUtil.info((Object)("---------sys_accountId----\u67e5\u8be2\u7ed3\u679c----" + (Object)((Object)r)));
                    return r;
                }
                ++n2;
            }
        }
        return null;
    }

    String doTextResponse(String content, String toUserName, TextMessageResp textMessage, ResourceBundle bundler, String sys_accountId, String respMessage, String fromUserName, HttpServletRequest request, String msgId, String msgType) throws Exception {
        WeixinAccountEntity weixinAccount = (WeixinAccountEntity)this.systemService.findUniqueByProperty(WeixinAccountEntity.class, "weixinOriginalAccountid", (Object)toUserName);
        if (oConvertUtils.isNotEmpty((Object)(respMessage = this.callTelephoneBangDing(content, toUserName, textMessage, bundler, sys_accountId, respMessage, fromUserName, request, msgId, msgType)))) {
            return respMessage;
        }
        if (oConvertUtils.isNotEmpty((Object)(respMessage = this.callWeiXinQiang(content, toUserName, textMessage, bundler, sys_accountId, respMessage, fromUserName, request, msgId, msgType, weixinAccount)))) {
            return respMessage;
        }
        LogUtil.info((Object)"------------\u5fae\u4fe1\u5ba2\u6237\u7aef\u53d1\u9001\u8bf7\u6c42--------------Step.1 \u5224\u65ad\u5173\u952e\u5b57\u4fe1\u606f\u4e2d\u662f\u5426\u7ba1\u7406\u8be5\u6587\u672c\u5185\u5bb9\u3002\u6709\u7684\u8bdd\u4f18\u5148\u91c7\u7528\u6570\u636e\u5e93\u4e2d\u7684\u56de\u590d---");
        AutoResponse autoResponse = this.findKey(content, toUserName);
        if (autoResponse != null) {
            String resMsgType = autoResponse.getMsgType();
            respMessage = this.getRespMessage(content, resMsgType, autoResponse.getResContent(), textMessage, bundler, toUserName, fromUserName, sys_accountId);
        } else {
            LogUtil.info((Object)"------------\u5fae\u4fe1\u5ba2\u6237\u7aef\u53d1\u9001\u8bf7\u6c42--------------Step.2  \u901a\u8fc7\u5fae\u4fe1\u6269\u5c55\u63a5\u53e3\uff08\u652f\u6301\u4e8c\u6b21\u5f00\u53d1\uff0c\u4f8b\u5982\uff1a\u7ffb\u8bd1\uff0c\u5929\u6c14\uff09---");
            boolean findflag = true;
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("keyword", content);
            params.put("accountid", sys_accountId);
            params.put("keywordtype", "1");
            List<WeixinExpandconfigEntity> weixinExpandconfigEntityLst = this.keywordMatch(sys_accountId, params);
            if (weixinExpandconfigEntityLst == null || weixinExpandconfigEntityLst.size() == 0) {
                findflag = false;
            } else {
                WeixinExpandconfigEntity wec = weixinExpandconfigEntityLst.get(0);
                if ("2".equals(wec.getRespmodle())) {
                    respMessage = this.createWeixinNew(wec, fromUserName, toUserName);
                } else if ("3".equals(wec.getRespmodle())) {
                    respMessage = this.createOutWeixinTxt(content, wec, fromUserName, toUserName);
                } else if ("4".equals(wec.getRespmodle())) {
                    respMessage = this.createOutDynWeixinNew(content, wec, fromUserName, toUserName);
                } else {
                    String className = wec.getClassname();
                    KeyServiceI keyService = (KeyServiceI)Class.forName(className.trim()).newInstance();
                    String faceImageUrl = wec.getFaceImgUrl();
                    respMessage = keyService.excute(wec.getName(), wec.getContent(), faceImageUrl, fromUserName, toUserName, content);
                }
            }
            if (!findflag) {
                String hql = "from AutoResponseDefaultEntity where accountid='" + sys_accountId + "' and iswork='1'";
                List autoResponseDefaultList = this.autoResponseService.findByQueryString(hql);
                LogUtil.info((Object)("....size of autoResponseDefaultList..." + autoResponseDefaultList.size()));
                if (autoResponseDefaultList.size() > 0) {
                    AutoResponseDefaultEntity isWorkResponse = (AutoResponseDefaultEntity)autoResponseDefaultList.get(0);
                    respMessage = this.getRespMessage(content, isWorkResponse.getMsgtype(), isWorkResponse.getTemplateid(), textMessage, bundler, toUserName, fromUserName, sys_accountId);
                }
            }
        }
        if (oConvertUtils.isEmpty((Object)respMessage)) {
            textMessage.setToUserName(fromUserName);
            textMessage.setFromUserName(toUserName);
            textMessage.setCreateTime(new Date().getTime());
            textMessage.setMsgType("text");
            textMessage.setContent(WechatService.getMainMenu());
            respMessage = MessageUtil.textMessageToXml(textMessage);
        }
        return respMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doDingYueEventResponse(Map<String, String> requestMap, TextMessageResp textMessage, ResourceBundle bundler, String respMessage, String toUserName, String fromUserName, String respContent, String sys_accountId) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String string = fromUserName;
        synchronized (string) {
            this.gzUserInfoService.saveGzUserInfoByOpenId(fromUserName, toUserName);
            this.gzUserTotalService.dealTotalRecord(true, sys_accountId);
            respContent = "\u8c22\u8c22\u60a8\u7684\u5173\u6ce8\uff01\u56de\u590d\"?\"\u8fdb\u5165\u4e3b\u83dc\u5355\u3002";
            List lst = this.subscribeService.findByProperty(Subscribe.class, "accountid", sys_accountId);
            if (lst.size() != 0) {
                Subscribe subscribe = (Subscribe)((Object)lst.get(0));
                respMessage = this.getRespMessage(null, subscribe.getMsgType(), subscribe.getTemplateId(), textMessage, bundler, toUserName, fromUserName, sys_accountId);
            }
            if (requestMap.containsKey("Ticket")) {
                String sceneid = requestMap.get("EventKey").split("_")[1];
                List weixinQrcodeList = this.weixinQrcodeService.findByProperty(WeixinQrcodeEntity.class, "sceneId", Integer.parseInt(sceneid));
                if (weixinQrcodeList.size() != 0) {
                    List weixinQrcodeScenelist = this.weixinQrcodeSceneService.findByProperty(WeixinQrcodeSceneEntity.class, "scenekey", Integer.parseInt(sceneid));
                    WeixinQrcodeScanRecord weixinQrcodeScanRecord = new WeixinQrcodeScanRecord();
                    weixinQrcodeScanRecord.setImageurl(((WeixinQrcodeEntity)weixinQrcodeList.get(0)).getImageurl());
                    weixinQrcodeScanRecord.setNickname("");
                    weixinQrcodeScanRecord.setOpenid(fromUserName);
                    weixinQrcodeScanRecord.setScantime(new Date());
                    weixinQrcodeScanRecord.setScenekey(((WeixinQrcodeEntity)weixinQrcodeList.get(0)).getSceneId().toString());
                    if (weixinQrcodeScenelist.size() != 0) {
                        weixinQrcodeScanRecord.setScenevalue(((WeixinQrcodeSceneEntity)weixinQrcodeScenelist.get(0)).getScenevalue());
                    }
                    weixinQrcodeScanRecord.setAccountid(this.weixinAccountService.findByToUsername(toUserName).getId());
                    this.weixinQrcodeScanRecordService.save(weixinQrcodeScanRecord);
                }
                this.weixinVotePKService.updateVoteCount(Integer.parseInt(sceneid), sys_accountId, fromUserName, "2", 1);
            }
            this.weixinVotePKService.toSuccessUnsubscribeVoteCount(sys_accountId, fromUserName);
            return respMessage;
        }
    }

    private String doMyMenuEvent(Map<String, String> requestMap, TextMessageResp textMessage, ResourceBundle bundler, String respMessage, String toUserName, String fromUserName, String respContent, String sys_accountId, HttpServletRequest request) throws Exception {
        String key = requestMap.get("EventKey");
        String hql = "from MenuEntity where menuKey = '" + key + "'and accountId = '" + sys_accountId + "'";
        List ls = this.systemService.findByQueryString(hql);
        MenuEntity menuEntity = (MenuEntity)((Object)ls.get(0));
        this.menuclickTotalService.saveClickRecord(menuEntity, sys_accountId);
        if (menuEntity != null && oConvertUtils.isNotEmpty((Object)menuEntity.getTemplateId())) {
            respMessage = this.getRespMessage(null, menuEntity.getMsgType(), menuEntity.getTemplateId(), textMessage, bundler, toUserName, fromUserName, sys_accountId);
        }
        return respMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doScanEventResponse(Map<String, String> requestMap, TextMessageResp textMessage, ResourceBundle bundler, String respMessage, String toUserName, String fromUserName, String respContent, String sys_accountId) {
        String string = fromUserName;
        synchronized (string) {
            String sceneid = requestMap.get("EventKey");
            List weixinQrcodeList = this.weixinQrcodeService.findByProperty(WeixinQrcodeEntity.class, "sceneId", Integer.parseInt(sceneid));
            WeixinQrcodeEntity qrcode = (WeixinQrcodeEntity)weixinQrcodeList.get(0);
            if (weixinQrcodeList.size() != 0) {
                List weixinQrcodeScenelist = this.weixinQrcodeSceneService.findByProperty(WeixinQrcodeSceneEntity.class, "scenekey", Integer.parseInt(sceneid));
                WeixinQrcodeScanRecord weixinQrcodeScanRecord = new WeixinQrcodeScanRecord();
                weixinQrcodeScanRecord.setImageurl(((WeixinQrcodeEntity)weixinQrcodeList.get(0)).getImageurl());
                weixinQrcodeScanRecord.setNickname("");
                weixinQrcodeScanRecord.setOpenid(fromUserName);
                weixinQrcodeScanRecord.setScantime(new Date());
                weixinQrcodeScanRecord.setScenekey(((WeixinQrcodeEntity)weixinQrcodeList.get(0)).getSceneId().toString());
                if (weixinQrcodeScenelist.size() != 0) {
                    weixinQrcodeScanRecord.setScenevalue(((WeixinQrcodeSceneEntity)weixinQrcodeScenelist.get(0)).getScenevalue());
                }
                weixinQrcodeScanRecord.setAccountid(this.weixinAccountService.findByToUsername(toUserName).getId());
                this.weixinQrcodeScanRecordService.save(weixinQrcodeScanRecord);
                int qrCodeScan = qrcode.getQrcodeScan() == null ? 0 : qrcode.getQrcodeScan();
                qrcode.setQrcodeScan(qrCodeScan + 1);
                this.weixinQrcodeService.saveOrUpdate(qrcode);
                respMessage = this.weixinQrcodeService.scanResponse(qrcode, textMessage, respMessage, toUserName, fromUserName, respContent, sys_accountId);
            }
            this.weixinVotePKService.updateVoteCount(Integer.parseInt(sceneid), sys_accountId, fromUserName, "2", 1);
            return respMessage;
        }
    }

    public static String getMainMenu() {
        String html = new FreemarkerHelper().parseTemplate("/weixin/welcome.ftl", null);
        return html;
    }

    private String getRespMessage(String wxcontent, String resp_message_type, String templateId, TextMessageResp textMessage, ResourceBundle bundler, String toUserName, String fromUserName, String sys_accountId) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String respMessage = "";
        if ("text".equals(resp_message_type)) {
            TextTemplate textTemplate = (TextTemplate)((Object)this.textTemplateService.getEntity(TextTemplate.class, (Serializable)((Object)templateId)));
            String content = textTemplate.getContent();
            textMessage.setContent(content);
            respMessage = MessageUtil.textMessageToXml(textMessage);
        } else if ("news".equals(resp_message_type)) {
            String hql = "from NewsItem where newsTemplate.id = '" + templateId + "'" + "order by orders asc";
            List newsList = this.newsItemService.findByQueryString(hql);
            ArrayList<Article> articleList = new ArrayList<Article>();
            NewsTemplate newsTemplate = (NewsTemplate)((Object)this.newsTemplateService.getEntity(NewsTemplate.class, (Serializable)((Object)templateId)));
            for (NewsItem news : newsList) {
                Article article = new Article();
                article.setTitle(news.getTitle());
                if (news.getImagePath() != null && news.getImagePath().indexOf("http://") != -1) {
                    article.setPicUrl(news.getImagePath());
                } else {
                    article.setPicUrl(String.valueOf(bundler.getString("domain")) + "/" + news.getImagePath());
                }
                String url = "";
                url = oConvertUtils.isEmpty((Object)news.getUrl()) ? String.valueOf(bundler.getString("domain")) + "/newsItemController.do?goContent&id=" + news.getId() + "&accountid=" + sys_accountId + "&openid=" + fromUserName : news.getUrl();
                article.setUrl(url);
                article.setDescription(news.getDescription());
                articleList.add(article);
            }
            NewsMessageResp newsResp = new NewsMessageResp();
            newsResp.setCreateTime(new Date().getTime());
            newsResp.setFromUserName(toUserName);
            newsResp.setToUserName(fromUserName);
            newsResp.setMsgType("news");
            newsResp.setArticleCount(newsList.size());
            newsResp.setArticles(articleList);
            respMessage = MessageUtil.newsMessageToXml(newsResp);
        } else if ("expand".equals(resp_message_type)) {
            LogUtil.info((Object)(".....getTemplateId...." + templateId));
            WeixinExpandconfigEntity wec = (WeixinExpandconfigEntity)this.weixinExpandconfigService.getEntity(WeixinExpandconfigEntity.class, (Serializable)((Object)templateId));
            LogUtil.info((Object)(".....\u6269\u5c55\u63a5\u53e3\u7c7b/URL...." + wec.getClassname()));
            if ("2".equals(wec.getRespmodle())) {
                respMessage = this.createWeixinNew(wec, fromUserName, toUserName);
            } else if ("3".equals(wec.getRespmodle())) {
                respMessage = this.createOutWeixinTxt(wxcontent, wec, fromUserName, toUserName);
            } else if ("4".equals(wec.getRespmodle())) {
                respMessage = this.createOutDynWeixinNew(wxcontent, wec, fromUserName, toUserName);
            } else {
                String className = wec.getClassname();
                KeyServiceI keyService = (KeyServiceI)Class.forName(className.trim()).newInstance();
                String faceImageUrl = wec.getFaceImgUrl();
                respMessage = keyService.excute(wec.getName(), wec.getContent(), faceImageUrl, fromUserName, toUserName, null);
            }
            LogUtil.info((Object)("....respMessage..." + respMessage));
        } else if ("voice".equals(resp_message_type)) {
            WeixinAudiosucaiEntity template = (WeixinAudiosucaiEntity)this.systemService.getEntity(WeixinAudiosucaiEntity.class, (Serializable)((Object)templateId));
            if (!"true".equals(template.getSynchFlag()) || StringUtils.isEmpty((CharSequence)template.getMediaId())) {
                return this.getRespMessageNullMedia(textMessage);
            }
            Voice voice = new Voice();
            voice.setMediaId(template.getMediaId());
            VoiceMessageResp voiceResp = new VoiceMessageResp();
            voiceResp.setCreateTime(new Date().getTime());
            voiceResp.setFromUserName(toUserName);
            voiceResp.setToUserName(fromUserName);
            voiceResp.setMsgType("voice");
            voiceResp.setVoice(voice);
            respMessage = MessageUtil.messageToXml(voiceResp);
        } else if ("image".equals(resp_message_type)) {
            WeixinPhotosucaiEntity template = (WeixinPhotosucaiEntity)this.systemService.getEntity(WeixinPhotosucaiEntity.class, (Serializable)((Object)templateId));
            if (!"true".equals(template.getSynchFlag()) || StringUtils.isEmpty((CharSequence)template.getMediaId())) {
                return this.getRespMessageNullMedia(textMessage);
            }
            Image image = new Image();
            image.setMediaId(template.getMediaId());
            ImageMessageResp imageResp = new ImageMessageResp();
            imageResp.setCreateTime(new Date().getTime());
            imageResp.setFromUserName(toUserName);
            imageResp.setToUserName(fromUserName);
            imageResp.setMsgType("image");
            imageResp.setImage(image);
            respMessage = MessageUtil.messageToXml(imageResp);
        } else if ("video".equals(resp_message_type)) {
            WeixinVideosucaiEntity template = (WeixinVideosucaiEntity)this.systemService.getEntity(WeixinVideosucaiEntity.class, (Serializable)((Object)templateId));
            if (!"true".equals(template.getSynchFlag()) || StringUtils.isEmpty((CharSequence)template.getMediaId())) {
                return this.getRespMessageNullMedia(textMessage);
            }
            Video video = new Video();
            video.setMediaId(template.getMediaId());
            VideoMessageResp videoResp = new VideoMessageResp();
            videoResp.setCreateTime(new Date().getTime());
            videoResp.setFromUserName(toUserName);
            videoResp.setToUserName(fromUserName);
            videoResp.setMsgType("video");
            videoResp.setVideo(video);
            respMessage = MessageUtil.messageToXml(videoResp);
        } else if ("link".equals(resp_message_type)) {
            WeixinLinksucaiEntity linkEntity = (WeixinLinksucaiEntity)this.systemService.getEntity(WeixinLinksucaiEntity.class, (Serializable)((Object)templateId));
            String outUrl = linkEntity.getOuterLink();
            String outer_link_deal = this.weixinLinksucaiService.installOuterLinkWithSysParams(outUrl, ResourceUtil.getUserOpenId(), sys_accountId, wxcontent);
            LinkMessageResp linkResp = new LinkMessageResp();
            linkResp.setCreateTime(new Date().getTime());
            linkResp.setFromUserName(toUserName);
            linkResp.setToUserName(fromUserName);
            linkResp.setMsgType("link");
            linkResp.setTitle(linkEntity.getName());
            linkResp.setUrl(outer_link_deal);
            linkResp.setDescription(linkEntity.getContent());
            respMessage = MessageUtil.linkMessageToXml(linkResp);
        }
        return respMessage;
    }

    private String getRespMessageNullMedia(TextMessageResp textMessage) {
        textMessage.setContent("\u8be5\u591a\u5a92\u4f53\u7d20\u6750\u6ca1\u6709\u540c\u6b65\u5fae\u4fe1\u670d\u52a1\u5668\u6216\u8005\u5df2\u7ecf\u5931\u6548");
        return MessageUtil.textMessageToXml(textMessage);
    }

    private String callTelephoneBangDing(String content, String toUserName, TextMessageResp textMessage, ResourceBundle bundler, String sys_accountId, String respMessage, String fromUserName, HttpServletRequest request, String msgId, String msgType) {
        List codeEntities;
        WeixinVipMemberEntity memberEntity = (WeixinVipMemberEntity)this.systemService.findUniqueByProperty(WeixinVipMemberEntity.class, "openid", (Object)fromUserName);
        if (memberEntity == null) {
            memberEntity = new WeixinVipMemberEntity();
            memberEntity.setCreateTime(new Date());
            memberEntity.setMemberIntegral(0);
            memberEntity.setBindingMemberPhoneStatus("");
            memberEntity.setOpenid(fromUserName);
            memberEntity.setMemberPhoto("template/vip/default/css/new/images/defaulthead.png");
            memberEntity.setAccountid(sys_accountId);
            this.systemService.saveOrUpdate((Object)memberEntity);
        }
        if (SendMsgUtils.isMobile(content) && !"Y".equals(memberEntity.getBindingMemberPhoneStatus())) {
            LogUtil.info((Object)"step.2.1.1 \u8bbe\u7f6e\u624b\u673a\u7ed1\u5b9a\u6a21\u5f0f");
            if ("V".equals(memberEntity.getBindingMemberPhoneStatus())) {
                textMessage.setContent(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.sms.binding_phone.code.canel_bd"));
                respMessage = MessageUtil.textMessageToXml(textMessage);
                return respMessage;
            }
            memberEntity.setBindingMemberPhoneStatus("V");
            this.systemService.saveOrUpdate((Object)memberEntity);
            String telphone = content;
            String validCode = String.valueOf((int)(Math.random() * 9000.0 + 1000.0));
            LogUtil.info((Object)("\u624b\u673a\u7ed1\u5b9a\u9a8c\u8bc1\u7801: " + validCode + "\uff0c\u5df2\u53d1\u9001\u5230\u624b\u673a\u53f7\uff1a" + telphone));
            SendMsgUtils.sendSMS(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.sms.binding_phone.code.msg", (String)validCode), telphone);
            WeixinVipMemberValidCodeEntity validCodeEntity = new WeixinVipMemberValidCodeEntity();
            validCodeEntity.setValidCode(validCode);
            validCodeEntity.setEfficientTime(DataUtils.getDateAfterSecond((Date)new Date(), (int)600));
            validCodeEntity.setOpenid(fromUserName);
            validCodeEntity.setVipMemberId(memberEntity.getId());
            this.systemService.saveOrUpdate((Object)validCodeEntity);
            memberEntity.setMemberMobile(telphone);
            this.systemService.saveOrUpdate((Object)memberEntity);
            textMessage.setContent(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.sms.binding_phone.back", (String)telphone));
            respMessage = MessageUtil.textMessageToXml(textMessage);
            return respMessage;
        }
        if (SendMsgUtils.isMobile(content) && "Y".equals(memberEntity.getBindingMemberPhoneStatus())) {
            String telphone = memberEntity.getMemberMobile();
            textMessage.setContent(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.sms.binding_phone.exist", (String)telphone));
            respMessage = MessageUtil.textMessageToXml(textMessage);
            return respMessage;
        }
        if ("\u9000\u51fa\u7ed1\u5b9a".equals(content)) {
            LogUtil.info((Object)"step.2.1 \u8bbe\u7f6e\u624b\u673a\u7ed1\u5b9a\u6a21\u5f0f\u4e3a\u9000\u51fa\u7ed1\u5b9a\u6a21\u5f0f 1");
            if ("V".equals(memberEntity.getBindingMemberPhoneStatus())) {
                LogUtil.info((Object)"step.2.1 \u8bbe\u7f6e\u624b\u673a\u7ed1\u5b9a\u6a21\u5f0f\u4e3a\u9000\u51fa\u7ed1\u5b9a\u6a21\u5f0f 2");
                memberEntity.setBindingMemberPhoneStatus("");
                memberEntity.setBindingMemberPhoneDate(null);
                this.systemService.saveOrUpdate((Object)memberEntity);
                LogUtil.info((Object)"step.2.1 \u8bbe\u7f6e\u624b\u673a\u7ed1\u5b9a\u6a21\u5f0f\u4e3a\u9000\u51fa\u7ed1\u5b9a\u6a21\u5f0f 3");
                this.systemService.executeSql("update weixin_vip_member_valid_code set efficient_time = ? where openid = ?", new Object[]{DataUtils.getDateAfterSecond((Date)new Date(), (int)-600), memberEntity.getOpenid()});
                LogUtil.info((Object)"step.2.1 \u8bbe\u7f6e\u624b\u673a\u7ed1\u5b9a\u6a21\u5f0f\u4e3a\u9000\u51fa\u7ed1\u5b9a\u6a21\u5f0f 4");
                textMessage.setContent(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.sms.binding_phone.code.canel_bd.msg"));
                respMessage = MessageUtil.textMessageToXml(textMessage);
                return respMessage;
            }
            textMessage.setContent(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.sms.binding_phone.code.canel_bd.exit.msg"));
            respMessage = MessageUtil.textMessageToXml(textMessage);
            return respMessage;
        }
        if (content.equals(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.sms.binding_phone.key.canel"))) {
            LogUtil.info((Object)"step.4 \u5224\u65ad\u5f53\u524d\u7528\u6237\u5df2\u7ecf\u7ed1\u5b9a\u624b\u673a\uff0c\u5e76\u4e14\u7528\u6237\u8f93\u5165\u4e86\u53d6\u6d88\u7ed1\u5b9a\u7684\u5173\u952e\u5b57\uff0c\u5219\u53d6\u6d88\u7ed1\u5b9a");
            memberEntity = (WeixinVipMemberEntity)this.systemService.findUniqueByProperty(WeixinVipMemberEntity.class, "openid", (Object)fromUserName);
            if (memberEntity != null && "Y".equals(memberEntity.getBindingMemberPhoneStatus())) {
                String memberMobile = memberEntity.getMemberMobile();
                memberEntity.setBindingMemberPhoneStatus("N");
                memberEntity.setMemberMobile("");
                memberEntity.setBindingMemberPhoneDate(new Date());
                this.systemService.saveOrUpdate((Object)memberEntity);
                WeixinVipMemberOprEntity weixinVipMemberLogEntity = new WeixinVipMemberOprEntity();
                weixinVipMemberLogEntity.setOprType(1);
                weixinVipMemberLogEntity.setAccountid(memberEntity.getId());
                weixinVipMemberLogEntity.setSysAccountid(sys_accountId);
                weixinVipMemberLogEntity.setBindingMemberPhoneDate(memberEntity.getBindingMemberPhoneDate());
                weixinVipMemberLogEntity.setMembermobile(memberMobile);
                weixinVipMemberLogEntity.setOpenid(memberEntity.getOpenid());
                weixinVipMemberLogEntity.setRemark("\u89e3\u9664\u7ed1\u5b9a");
                weixinVipMemberLogEntity.setVersion(1);
                this.systemService.save((Object)weixinVipMemberLogEntity);
                textMessage.setContent(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.sms.binding_phone.key.canel.success", (String)memberMobile));
                respMessage = MessageUtil.textMessageToXml(textMessage);
                return respMessage;
            }
        }
        if ("V".equals(memberEntity.getBindingMemberPhoneStatus()) && (codeEntities = this.systemService.findHql("from WeixinVipMemberValidCodeEntity where vipMemberId = ? and openid= ? and efficientTime>= ? ORDER BY efficientTime desc", new Object[]{memberEntity.getId(), fromUserName, new Date()})).size() > 0) {
            WeixinVipMemberValidCodeEntity codeEntity = (WeixinVipMemberValidCodeEntity)codeEntities.get(0);
            if (content.equals(codeEntity.getValidCode())) {
                memberEntity.setBindingMemberPhoneDate(new Date());
                memberEntity.setWxSyncStatus("0");
                memberEntity.setBindingMemberPhoneStatus("Y");
                this.systemService.saveOrUpdate((Object)memberEntity);
                this.systemService.executeSql("update weixin_vip_member_valid_code set efficient_time = ? where openid = ?", new Object[]{DataUtils.getDateAfterSecond((Date)new Date(), (int)-600), memberEntity.getOpenid()});
                WeixinVipMemberOprEntity weixinVipMemberLogEntity = new WeixinVipMemberOprEntity();
                weixinVipMemberLogEntity.setOprType(0);
                weixinVipMemberLogEntity.setAccountid(memberEntity.getId());
                weixinVipMemberLogEntity.setSysAccountid(sys_accountId);
                weixinVipMemberLogEntity.setBindingMemberPhoneDate(memberEntity.getBindingMemberPhoneDate());
                weixinVipMemberLogEntity.setMembermobile(memberEntity.getMemberMobile());
                weixinVipMemberLogEntity.setOpenid(memberEntity.getOpenid());
                weixinVipMemberLogEntity.setRemark("\u7ed1\u5b9a\u624b\u673a");
                weixinVipMemberLogEntity.setVersion(1);
                this.systemService.save((Object)weixinVipMemberLogEntity);
                textMessage.setContent(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.sms.binding_phone.success"));
                respMessage = MessageUtil.textMessageToXml(textMessage);
                return respMessage;
            }
            textMessage.setContent(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.sms.binding_phone.code.error"));
            respMessage = MessageUtil.textMessageToXml(textMessage);
            return respMessage;
        }
        return null;
    }

    private String callWeiXinQiang(String content, String toUserName, TextMessageResp textMessage, ResourceBundle bundler, String sys_accountId, String respMessage, String fromUserName, HttpServletRequest request, String msgId, String msgType, WeixinAccountEntity weixinAccount) {
        WeixinWallStatus ostatus = this.weixinWallStatusService.getStatus(fromUserName, this.weixinAccountService.findByToUsername(toUserName).getId());
        if (content.equals(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.wall.key.out"))) {
            WeixinWallStatus status = this.weixinWallStatusService.getStatus(fromUserName, this.weixinAccountService.findByToUsername(toUserName).getId());
            if (status != null && status.getStatus() == 1) {
                status.setStatus(0);
                this.weixinWallStatusService.updateEntitie(status);
                textMessage.setContent(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.wall.key.out.success"));
                respMessage = MessageUtil.textMessageToXml(textMessage);
            } else {
                textMessage.setContent(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.wall.key.in.msg"));
                respMessage = MessageUtil.textMessageToXml(textMessage);
            }
            return respMessage;
        }
        if (ostatus != null && ostatus.getStatus() == 1) {
            WeixinWallMessageEntity messageEntity = new WeixinWallMessageEntity();
            messageEntity.setContent(content);
            messageEntity.setAccountid(weixinAccount.getId());
            messageEntity.setCreatetime(new Date());
            messageEntity.setOpenid(fromUserName);
            this.systemService.save((Object)messageEntity);
            textMessage.setContent(MutiLangUtil.getMutiKeyValueByZH((String)"weixin.wall.sendmessage.success"));
            respMessage = MessageUtil.textMessageToXml(textMessage);
            return respMessage;
        }
        return null;
    }

    private void saveReceiveTextService(String content, String toUserName, TextMessageResp textMessage, ResourceBundle bundler, String sys_accountId, String respMessage, String fromUserName, HttpServletRequest request, String msgId, String msgType, String mediaId) {
        List userInfoList;
        if (msgType.equals("event")) {
            return;
        }
        WeixinAccountEntity weixinAccount = (WeixinAccountEntity)this.systemService.findUniqueByProperty(WeixinAccountEntity.class, "weixinOriginalAccountid", (Object)toUserName);
        ReceiveText receiveText = new ReceiveText();
        receiveText.setContent(content);
        Timestamp temp = Timestamp.valueOf(DateUtils.getDate("yyyy-MM-dd HH:mm:ss"));
        receiveText.setCreateTime(temp);
        receiveText.setFromUserName(fromUserName);
        if (weixinAccount != null && (userInfoList = this.systemService.findByProperty(GzUserInfoYw.class, "openid", (Object)fromUserName)).size() > 0) {
            String nickName = ((GzUserInfoYw)((Object)userInfoList.get(0))).getNickname();
            receiveText.setNickName(nickName);
        }
        receiveText.setToUserName(toUserName);
        receiveText.setMsgId(msgId);
        receiveText.setMsgType(msgType);
        receiveText.setResponse("0");
        receiveText.setAccountId(sys_accountId);
        receiveText.setMediaId(mediaId);
        this.receiveTextService.save(receiveText);
    }

    private String createWeixinNew(WeixinExpandconfigEntity weixinExpandconfigEntity, String fromUserName, String toUserName) {
        WeixinAccountServiceI weixinAccountService = (WeixinAccountServiceI)ApplicationContextUtil.getContext().getBean("weixinAccountService");
        String accountid = weixinAccountService.findByToUsername(toUserName).getId();
        ArrayList<Article> articleList = new ArrayList<Article>();
        Article article = new Article();
        article.setTitle(weixinExpandconfigEntity.getName());
        article.setDescription(weixinExpandconfigEntity.getContent());
        String faceImageUrl = weixinExpandconfigEntity.getFaceImgUrl();
        if (oConvertUtils.isNotEmpty((Object)faceImageUrl) && faceImageUrl.indexOf("http://") != -1) {
            article.setPicUrl(faceImageUrl);
        } else {
            article.setPicUrl(String.valueOf(this.bundler.getString("domain")) + "/" + faceImageUrl);
        }
        String url = weixinExpandconfigEntity.getClassname();
        url = this.weixinLinksucaiService.installOuterLinkWithSysParams(url, fromUserName, accountid, null);
        if (oConvertUtils.isNotEmpty((Object)url) && url.indexOf("http://") != -1) {
            article.setUrl(url);
        } else {
            article.setUrl(String.valueOf(this.bundler.getString("domain")) + "/" + url);
        }
        articleList.add(article);
        NewsMessageResp newsMessage = new NewsMessageResp();
        newsMessage.setToUserName(fromUserName);
        newsMessage.setFromUserName(toUserName);
        newsMessage.setCreateTime(new Date().getTime());
        newsMessage.setMsgType("news");
        newsMessage.setArticleCount(articleList.size());
        newsMessage.setArticles(articleList);
        return MessageUtil.newsMessageToXml(newsMessage);
    }

    private String createOutWeixinTxt(String wxcontent, WeixinExpandconfigEntity weixinExpandconfigEntity, String fromUserName, String toUserName) {
        WeixinAccountServiceI weixinAccountService = (WeixinAccountServiceI)ApplicationContextUtil.getContext().getBean("weixinAccountService");
        String accountid = weixinAccountService.findByToUsername(toUserName).getId();
        String url = weixinExpandconfigEntity.getClassname();
        url = this.weixinLinksucaiService.installOuterLinkWithSysParams(url, fromUserName, accountid, wxcontent);
        String content = WeixinUtil.httpCommonRequest(url, "GET", "");
        TextMessageResp textMessage = new TextMessageResp();
        textMessage.setToUserName(fromUserName);
        textMessage.setFromUserName(toUserName);
        textMessage.setCreateTime(new Date().getTime());
        textMessage.setMsgType("text");
        textMessage.setContent(content);
        return MessageUtil.textMessageToXml(textMessage);
    }

    private String createDynWeixinNew(String title, String description, String faceImageUrl, String url, String fromUserName, String toUserName) {
        WeixinAccountServiceI weixinAccountService = (WeixinAccountServiceI)ApplicationContextUtil.getContext().getBean("weixinAccountService");
        String accountid = weixinAccountService.findByToUsername(toUserName).getId();
        ArrayList<Article> articleList = new ArrayList<Article>();
        Article article = new Article();
        article.setTitle(title);
        article.setDescription(description);
        if (oConvertUtils.isNotEmpty((Object)faceImageUrl) && faceImageUrl.indexOf("http://") != -1) {
            article.setPicUrl(faceImageUrl);
        } else {
            article.setPicUrl(String.valueOf(this.bundler.getString("domain")) + "/" + faceImageUrl);
        }
        url = this.weixinLinksucaiService.installOuterLinkWithSysParams(url, fromUserName, accountid, null);
        if (oConvertUtils.isNotEmpty((Object)url) && url.indexOf("http://") != -1) {
            article.setUrl(url);
        } else {
            article.setUrl(String.valueOf(this.bundler.getString("domain")) + "/" + url);
        }
        articleList.add(article);
        NewsMessageResp newsMessage = new NewsMessageResp();
        newsMessage.setToUserName(fromUserName);
        newsMessage.setFromUserName(toUserName);
        newsMessage.setCreateTime(new Date().getTime());
        newsMessage.setMsgType("news");
        newsMessage.setArticleCount(articleList.size());
        newsMessage.setArticles(articleList);
        return MessageUtil.newsMessageToXml(newsMessage);
    }

    private String createOutDynWeixinNew(String wxcontent, WeixinExpandconfigEntity wec, String fromUserName, String toUserName) {
        WeixinAccountServiceI weixinAccountService = (WeixinAccountServiceI)ApplicationContextUtil.getContext().getBean("weixinAccountService");
        String accountid = weixinAccountService.findByToUsername(toUserName).getId();
        String url = wec.getClassname();
        url = this.weixinLinksucaiService.installOuterLinkWithSysParams(url, fromUserName, accountid, wxcontent);
        url = wxcontent.indexOf("&") != -1 || wxcontent.indexOf("?") != -1 ? String.valueOf(url) + "&wxcontent=" + wxcontent : String.valueOf(url) + "?wxcontent=" + wxcontent;
        String jsonStr = WeixinUtil.httpCommonRequest(url, "GET", "");
        Map mp = new HashMap();
        if (!oConvertUtils.isNotEmpty((Object)jsonStr)) {
            return null;
        }
        Gson gson = new Gson();
        mp = (Map)gson.fromJson(jsonStr, Map.class);
        String title = (String)mp.get("title");
        String description = (String)mp.get("desc");
        String faceImageUrl = (String)mp.get("imageurl");
        String wz_url = (String)mp.get("url");
        return this.createDynWeixinNew(title, description, faceImageUrl, wz_url, fromUserName, toUserName);
    }

    private List<WeixinExpandconfigEntity> keywordMatch(String sys_accountId, Map<String, Object> params) {
        List<WeixinExpandconfigEntity> weixinExpandconfigEntityLst = this.wechatDao.findKeyExtendInterface(params);
        if (weixinExpandconfigEntityLst == null || weixinExpandconfigEntityLst.size() == 0) {
            List allRegExpandconfigEntityLst = this.systemService.findHql("FROM WeixinExpandconfigEntity WHERE accountid=? AND keywordType=?", new Object[]{sys_accountId, "2"});
            String keyWord = "";
            Pattern p = null;
            try {
                for (WeixinExpandconfigEntity expandconfig : allRegExpandconfigEntityLst) {
                    keyWord = expandconfig.getKeyword();
                    if (StringUtils.isEmpty((CharSequence)keyWord) || !(p = Pattern.compile(keyWord)).matcher((String)params.get("keyword")).matches()) continue;
                    weixinExpandconfigEntityLst = new ArrayList<WeixinExpandconfigEntity>();
                    weixinExpandconfigEntityLst.add(expandconfig);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return weixinExpandconfigEntityLst;
    }
}

