/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.base.controller;

import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.base.entity.WeixinExpandconfigEntity;
import weixin.guanjia.base.service.WeixinExpandconfigServiceI;

@Controller
@RequestMapping(value={"/weixinExpandconfigController"})
public class WeixinExpandconfigController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinExpandconfigController.class);
    @Autowired
    private WeixinExpandconfigServiceI weixinExpandconfigService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinExpandconfig"})
    public ModelAndView weixinExpandconfig(HttpServletRequest request) {
        return new ModelAndView("weixin/guanjia/base/expandconfig/weixinExpandconfigList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinExpandconfigEntity weixinExpandconfig, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinExpandconfigEntity.class, dataGrid);
        String accountId = ResourceUtil.getShangJiaAccountId();
        if (StringUtil.isNotEmpty((Object)accountId)) {
            cq.eq("accountid", (Object)accountId);
        } else {
            cq.isNull("accountid");
        }
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinExpandconfig, (Map)request.getParameterMap());
        cq.add();
        this.weixinExpandconfigService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinExpandconfigEntity weixinExpandconfig, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinExpandconfig = (WeixinExpandconfigEntity)this.systemService.getEntity(WeixinExpandconfigEntity.class, (Serializable)((Object)weixinExpandconfig.getId()));
        this.message = "\u6269\u5c55\u63a5\u53e3\u7ba1\u7406\u5220\u9664\u6210\u529f";
        try {
            this.weixinExpandconfigService.delete(weixinExpandconfig);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6269\u5c55\u63a5\u53e3\u7ba1\u7406\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6269\u5c55\u63a5\u53e3\u7ba1\u7406\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinExpandconfigEntity weixinExpandconfig = (WeixinExpandconfigEntity)this.systemService.getEntity(WeixinExpandconfigEntity.class, (Serializable)((Object)id));
                this.weixinExpandconfigService.delete(weixinExpandconfig);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6269\u5c55\u63a5\u53e3\u7ba1\u7406\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinExpandconfigEntity weixinExpandconfig, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6269\u5c55\u63a5\u53e3\u7ba1\u7406\u6dfb\u52a0\u6210\u529f";
        try {
            weixinExpandconfig.setAccountid(ResourceUtil.getShangJiaAccountId());
            weixinExpandconfig.setKeyword(weixinExpandconfig.getKeyword().toLowerCase());
            this.weixinExpandconfigService.save(weixinExpandconfig);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6269\u5c55\u63a5\u53e3\u7ba1\u7406\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinExpandconfigEntity weixinExpandconfig, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6269\u5c55\u63a5\u53e3\u7ba1\u7406\u66f4\u65b0\u6210\u529f";
        WeixinExpandconfigEntity t = (WeixinExpandconfigEntity)this.weixinExpandconfigService.get(WeixinExpandconfigEntity.class, (Serializable)((Object)weixinExpandconfig.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinExpandconfig, (Object)t);
            t.setKeyword(t.getKeyword().toLowerCase());
            this.weixinExpandconfigService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6269\u5c55\u63a5\u53e3\u7ba1\u7406\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinExpandconfigEntity weixinExpandconfig, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinExpandconfig.getId())) {
            weixinExpandconfig = (WeixinExpandconfigEntity)this.weixinExpandconfigService.getEntity(WeixinExpandconfigEntity.class, (Serializable)((Object)weixinExpandconfig.getId()));
            req.setAttribute("weixinExpandconfigPage", (Object)weixinExpandconfig);
        }
        return new ModelAndView("weixin/guanjia/base/expandconfig/weixinExpandconfig-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinExpandconfigEntity weixinExpandconfig, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinExpandconfig.getId())) {
            weixinExpandconfig = (WeixinExpandconfigEntity)this.weixinExpandconfigService.getEntity(WeixinExpandconfigEntity.class, (Serializable)((Object)weixinExpandconfig.getId()));
            req.setAttribute("weixinExpandconfigPage", (Object)weixinExpandconfig);
        }
        return new ModelAndView("weixin/guanjia/base/expandconfig/weixinExpandconfig-update");
    }
}

