/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.base.controller;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.base.entity.Subscribe;
import weixin.guanjia.base.service.SubscribeServiceI;

@Controller
@RequestMapping(value={"/subscribeController"})
public class SubscribeController {
    @Autowired
    private SystemService systemService;
    @Autowired
    private SubscribeServiceI subscribeService;
    private String message;

    @RequestMapping(params={"list"})
    public ModelAndView list() {
        return new ModelAndView("weixin/guanjia/gz/gzList");
    }

    @RequestMapping(params={"datagrid"})
    @ResponseBody
    public void datagrid(Subscribe subscribe, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(Subscribe.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)((Object)subscribe));
        this.subscribeService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson deleteSmsGroup(Subscribe subscribe, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        subscribe = (Subscribe)((Object)this.subscribeService.getEntity(Subscribe.class, (Serializable)((Object)subscribe.getId())));
        this.subscribeService.delete(subscribe);
        this.message = "\u5220\u9664{\u6b22\u8fce\u5173\u6ce8\u8bed}\u4fe1\u606f\u6570\u636e\u6210\u529f\uff01";
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"jumpSuView"})
    public ModelAndView jumpSuView(HttpServletRequest req) {
        String id = req.getParameter("id");
        LogUtil.info((Object)("...id..." + id));
        req.setAttribute("id", (Object)id);
        List textList = this.subscribeService.findByQueryString("from TextTemplate t where t.accountId = '" + ResourceUtil.getShangJiaAccountId() + "'");
        List newsList = this.subscribeService.findByQueryString("from NewsTemplate t where t.accountId = '" + ResourceUtil.getShangJiaAccountId() + "'");
        req.setAttribute("textList", (Object)textList);
        req.setAttribute("newsList", (Object)newsList);
        if (StringUtil.isNotEmpty((Object)id)) {
            Subscribe subscribe = (Subscribe)((Object)this.subscribeService.getEntity(Subscribe.class, (Serializable)((Object)id)));
            String lx = subscribe.getMsgType();
            String templateId = subscribe.getTemplateId();
            req.setAttribute("lx", (Object)lx);
            req.setAttribute("templateId", (Object)templateId);
            req.setAttribute("subscribe", (Object)subscribe);
        }
        return new ModelAndView("weixin/guanjia/gz/gz");
    }

    @RequestMapping(params={"su"})
    @ResponseBody
    public AjaxJson su(Subscribe subscribe, HttpServletRequest req) {
        String accountId = ResourceUtil.getShangJiaAccountId();
        AjaxJson j = new AjaxJson();
        String id = subscribe.getId();
        if (StringUtil.isNotEmpty((Object)id)) {
            Subscribe tempAutoResponse = (Subscribe)((Object)this.subscribeService.getEntity(Subscribe.class, (Serializable)((Object)subscribe.getId())));
            this.message = "\u4fee\u6539\u5173\u6587\u672c\u6a21\u677f\u6210\u529f\uff01";
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)((Object)subscribe), (Object)((Object)tempAutoResponse));
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            int size = this.subscribeService.findByProperty(Subscribe.class, "accountid", accountId).size();
            if (size != 0) {
                j.setSuccess(false);
                j.setMsg("\u6bcf\u4e2a\u516c\u4f17\u5e10\u53f7\u53ea\u80fd\u914d\u7f6e\u4e00\u4e2a\u6b22\u8fce\u8bed\u3002");
                return j;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            subscribe.setAddTime(sdf.format(new Date()));
            subscribe.setAccountid(ResourceUtil.getShangJiaAccountId());
            if (!"-1".equals(accountId)) {
                this.subscribeService.save(subscribe);
            } else {
                j.setSuccess(false);
                j.setMsg("\u8bf7\u6dfb\u52a0\u4e00\u4e2a\u516c\u4f17\u5e10\u53f7\u3002");
            }
        }
        return j;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

