/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.account.service.impl;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.util.DateUtil;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeewx.api.report.datacube.JwDataCubeAPI;
import org.jeewx.api.report.datacube.model.WxDataCubeStreamMsgInfo;
import org.jeewx.api.report.datastatistics.graphicanalysis.JwGraphicAnalysisAPI;
import org.jeewx.api.report.datastatistics.graphicanalysis.model.GraphicAnalysisRtnInfo;
import org.jeewx.api.report.datastatistics.useranalysis.JwUserAnalysisAPI;
import org.jeewx.api.report.datastatistics.useranalysis.model.UserAnalysisRtnInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.account.service.WeixinReportServiceI;
import weixin.guanjia.tj.entity.GzUsertotalEntity;
import weixin.guanjia.tj.entity.WeixinDataBindingPhoneEntity;
import weixin.guanjia.tj.entity.WeixinDataGraphicAnalysisEntity;
import weixin.guanjia.tj.entity.WeixinDataGraphicTotalEntity;
import weixin.util.DateUtils;
import weixin.vip.entity.WeixinVipMemberOprEntity;

@Service(value="weixinReportService")
@Transactional
public class WeixinReportServiceImpl
extends CommonServiceImpl
implements WeixinReportServiceI {
    @Autowired
    private WeixinAccountServiceI weixinAccountService;

    @Override
    public int saveOneDayArticleSummaryLocalDB(String accountId, String queryDate) throws Exception {
        String accessToken = this.weixinAccountService.getAccessToken(accountId);
        List graphicAnalysisRtnInfoList = JwGraphicAnalysisAPI.getArticleSummary((String)accessToken, (String)queryDate, (String)queryDate);
        if (!oConvertUtils.isNullOrEmpty((Object)graphicAnalysisRtnInfoList)) {
            for (GraphicAnalysisRtnInfo graphicAnalysisRtnInfo : graphicAnalysisRtnInfoList) {
                WeixinDataGraphicAnalysisEntity tjGraphicAnalysisEntity = new WeixinDataGraphicAnalysisEntity();
                tjGraphicAnalysisEntity.setAddToFavCount(graphicAnalysisRtnInfo.getAdd_to_fav_count());
                tjGraphicAnalysisEntity.setAddToFavUser(graphicAnalysisRtnInfo.getAdd_to_fav_user());
                tjGraphicAnalysisEntity.setIntPageReadCount(graphicAnalysisRtnInfo.getInt_page_read_count());
                tjGraphicAnalysisEntity.setIntPageReadUser(graphicAnalysisRtnInfo.getInt_page_read_user());
                tjGraphicAnalysisEntity.setMsgid(graphicAnalysisRtnInfo.getMsgid());
                tjGraphicAnalysisEntity.setOriPageReadCount(graphicAnalysisRtnInfo.getOri_page_read_count());
                tjGraphicAnalysisEntity.setOriPageReadUser(graphicAnalysisRtnInfo.getOri_page_read_user());
                tjGraphicAnalysisEntity.setRefDate(DateUtils.str2Date(graphicAnalysisRtnInfo.getRef_date(), DateUtils.date_sdf));
                tjGraphicAnalysisEntity.setShareCount(graphicAnalysisRtnInfo.getShare_count());
                tjGraphicAnalysisEntity.setShareUser(graphicAnalysisRtnInfo.getShare_user());
                tjGraphicAnalysisEntity.setTargetUser(graphicAnalysisRtnInfo.getTarget_user());
                tjGraphicAnalysisEntity.setTitle(graphicAnalysisRtnInfo.getTitle());
                tjGraphicAnalysisEntity.setAccountId(accountId);
                this.save(tjGraphicAnalysisEntity);
            }
        }
        return graphicAnalysisRtnInfoList != null ? graphicAnalysisRtnInfoList.size() : 0;
    }

    @Override
    public int saveOneDayUserDataLocalDB(java.util.Date date, String accountId) throws Exception {
        String accessToken = this.weixinAccountService.getAccessToken(accountId);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        String dateStr = DateUtil.formatDate((java.util.Date)cal.getTime(), (String)"yyyy-MM-dd");
        List cubeStreamMsgInfos = JwDataCubeAPI.getWxDataCubeStreamMsgInfo((String)accessToken, (String)dateStr, (String)dateStr);
        String sql = "";
        if (oConvertUtils.isNotEmpty((Object)cubeStreamMsgInfos) && cubeStreamMsgInfos.size() > 0) {
            String delSql = "delete from weixin_data_cube_day where account_id = '" + accountId + "' and ref_date = '" + dateStr + "'";
            this.executeSql(delSql, new Object[0]);
            for (WxDataCubeStreamMsgInfo wxDataCubeStreamMsgInfo : cubeStreamMsgInfos) {
                sql = "INSERT INTO weixin_data_cube_day (ID, account_id, msg_type, msg_user, msg_count, ref_date) VALUES (replace(uuid(),'-',''), '" + accountId + "', '" + wxDataCubeStreamMsgInfo.getMsg_type() + "', '" + wxDataCubeStreamMsgInfo.getMsg_user() + "', '" + wxDataCubeStreamMsgInfo.getMsg_count() + "', '" + dateStr + "')";
                this.executeSql(sql, new Object[0]);
            }
        }
        return cubeStreamMsgInfos != null ? cubeStreamMsgInfos.size() : 0;
    }

    @Override
    public int saveOneDayFocusUserDataLocalDB(java.util.Date date, String accountId) throws Exception {
        List dataList;
        String sql;
        WeixinAccountEntity weixinAccountEntity = (WeixinAccountEntity)this.get(WeixinAccountEntity.class, (Serializable)((Object)accountId));
        String accessToken = this.weixinAccountService.getAccessToken(accountId);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, 1);
        String dateStr = DateUtil.formatDate((java.util.Date)cal.getTime(), (String)"yyyy-MM-dd");
        List rtnInfoList = JwUserAnalysisAPI.getUserCumulate((String)accessToken, (String)dateStr, (String)dateStr);
        if (oConvertUtils.isNotEmpty((Object)rtnInfoList) && rtnInfoList.size() > 0) {
            for (UserAnalysisRtnInfo info : rtnInfoList) {
                int cumulate = info.getCumulate_user();
                sql = "update weixin_gzuser_total t set cancelnum='" + info.getCancel_user() + "' ,num='" + info.getNew_user() + "' ,t.cumulate_num='" + cumulate + "' where t.accountid='" + accountId + "' and t.time='" + dateStr + "'";
                int count = this.executeSql(sql, new Object[0]);
                if (count != 0) continue;
                GzUsertotalEntity gzUsertotalEntity = new GzUsertotalEntity();
                gzUsertotalEntity.setCancelnum("" + info.getCancel_user());
                gzUsertotalEntity.setNum("" + info.getNew_user());
                gzUsertotalEntity.setCumulateNum(String.valueOf(cumulate));
                gzUsertotalEntity.setAccountId(accountId);
                gzUsertotalEntity.setTime(new Date(date.getTime()));
                this.saveOrUpdate(gzUsertotalEntity);
            }
        }
        if (oConvertUtils.isNotEmpty((Object)(dataList = JwUserAnalysisAPI.getUserSummary((String)accessToken, (String)dateStr, (String)dateStr))) && dataList.size() > 0) {
            for (UserAnalysisRtnInfo info : dataList) {
                sql = "update weixin_gzuser_total t set cancelnum=cancelnum+" + info.getCancel_user() + " ,num=num+" + info.getNew_user() + " where t.accountid='" + accountId + "' and t.time='" + dateStr + "'";
                int n = this.executeSql(sql, new Object[0]);
            }
        }
        return rtnInfoList != null ? rtnInfoList.size() : 0;
    }

    @Override
    public int saveArticleTotalLocalDB(String accountId, String queryDate) throws Exception {
        List otherAddSummaryList;
        int countSql = 0;
        String accessToken = this.weixinAccountService.getAccessToken(accountId);
        List graphicAnalysisRtnInfoList = JwGraphicAnalysisAPI.getArticleTotal((String)accessToken, (String)queryDate, (String)queryDate);
        if (!oConvertUtils.isNullOrEmpty((Object)graphicAnalysisRtnInfoList)) {
            for (GraphicAnalysisRtnInfo graphicAnalysisRtnInfo : graphicAnalysisRtnInfoList) {
                java.util.Date refDate = DateUtils.str2Date(graphicAnalysisRtnInfo.getRef_date(), DateUtils.date_sdf);
                String msgid = graphicAnalysisRtnInfo.getMsgid();
                List tempList = this.findHql(" from WeixinDataGraphicTotalEntity  where refDate = ?  and msgid =? and accountId=?", new Object[]{refDate, msgid, accountId});
                WeixinDataGraphicTotalEntity tjGraphicTotalEntity = null;
                tjGraphicTotalEntity = !oConvertUtils.isNullOrEmpty((Object)tempList) ? (WeixinDataGraphicTotalEntity)tempList.get(0) : new WeixinDataGraphicTotalEntity();
                tjGraphicTotalEntity.setRefDate(refDate);
                tjGraphicTotalEntity.setMsgid(msgid);
                tjGraphicTotalEntity.setTitle(graphicAnalysisRtnInfo.getTitle());
                tjGraphicTotalEntity.setAccountId(accountId);
                List statList = graphicAnalysisRtnInfo.getDetails();
                if (oConvertUtils.isNullOrEmpty((Object)statList)) continue;
                GraphicAnalysisRtnInfo statGraphicAnalysis = (GraphicAnalysisRtnInfo)statList.get(statList.size() - 1);
                tjGraphicTotalEntity.setAddToFavCount(statGraphicAnalysis.getAdd_to_fav_count());
                tjGraphicTotalEntity.setAddToFavUser(statGraphicAnalysis.getAdd_to_fav_user());
                tjGraphicTotalEntity.setIntPageReadCount(statGraphicAnalysis.getInt_page_read_count());
                tjGraphicTotalEntity.setIntPageReadUser(statGraphicAnalysis.getInt_page_read_user());
                tjGraphicTotalEntity.setOriPageReadCount(statGraphicAnalysis.getOri_page_read_count());
                tjGraphicTotalEntity.setOriPageReadUser(statGraphicAnalysis.getOri_page_read_user());
                tjGraphicTotalEntity.setShareCount(statGraphicAnalysis.getShare_count());
                tjGraphicTotalEntity.setShareUser(statGraphicAnalysis.getShare_user());
                tjGraphicTotalEntity.setTargetUser(statGraphicAnalysis.getTarget_user());
                tjGraphicTotalEntity.setStatDate(DateUtils.str2Date(statGraphicAnalysis.getStat_date(), DateUtils.date_sdf));
                ++countSql;
                this.save(tjGraphicTotalEntity);
            }
        }
        if (!oConvertUtils.isNullOrEmpty((Object)(otherAddSummaryList = JwGraphicAnalysisAPI.getArticleSummary((String)accessToken, (String)queryDate, (String)queryDate)))) {
            for (GraphicAnalysisRtnInfo tempGraphic : otherAddSummaryList) {
                java.util.Date tempRefDate = DateUtils.str2Date(tempGraphic.getRef_date(), DateUtils.date_sdf);
                String msgid2 = tempGraphic.getMsgid();
                WeixinDataGraphicTotalEntity increaseGraphicTotal = null;
                List tempList2 = this.findHql(" from WeixinDataGraphicTotalEntity  where  msgid =? and accountId=?", new Object[]{msgid2, accountId});
                if (!oConvertUtils.isNullOrEmpty((Object)tempList2)) {
                    increaseGraphicTotal = (WeixinDataGraphicTotalEntity)tempList2.get(0);
                    if (!increaseGraphicTotal.getStatDate().before(tempRefDate)) continue;
                    increaseGraphicTotal.setMsgid(msgid2);
                    increaseGraphicTotal.setTitle(tempGraphic.getTitle());
                    increaseGraphicTotal.setAccountId(accountId);
                    increaseGraphicTotal.setAddToFavCount(increaseGraphicTotal.getAddToFavCount() + tempGraphic.getAdd_to_fav_count());
                    increaseGraphicTotal.setAddToFavUser(increaseGraphicTotal.getAddToFavUser() + tempGraphic.getAdd_to_fav_user());
                    increaseGraphicTotal.setIntPageReadCount(increaseGraphicTotal.getIntPageReadCount() + tempGraphic.getInt_page_read_count());
                    increaseGraphicTotal.setIntPageReadUser(increaseGraphicTotal.getIntPageReadUser() + tempGraphic.getInt_page_read_user());
                    increaseGraphicTotal.setOriPageReadCount(increaseGraphicTotal.getOriPageReadCount() + tempGraphic.getOri_page_read_count());
                    increaseGraphicTotal.setOriPageReadUser(increaseGraphicTotal.getOriPageReadUser() + tempGraphic.getOri_page_read_user());
                    increaseGraphicTotal.setShareCount(increaseGraphicTotal.getShareCount() + tempGraphic.getShare_count());
                    increaseGraphicTotal.setShareUser(increaseGraphicTotal.getShareUser() + tempGraphic.getShare_user());
                    increaseGraphicTotal.setTargetUser(increaseGraphicTotal.getTargetUser() + (oConvertUtils.isEmpty((Object)tempGraphic.getTarget_user()) ? 0 : tempGraphic.getTarget_user()));
                    increaseGraphicTotal.setStatDate(tempRefDate);
                    ++countSql;
                    this.updateEntitie(increaseGraphicTotal);
                    continue;
                }
                increaseGraphicTotal = new WeixinDataGraphicTotalEntity();
                increaseGraphicTotal.setRefDate(tempRefDate);
                increaseGraphicTotal.setMsgid(msgid2);
                increaseGraphicTotal.setTitle(tempGraphic.getTitle());
                increaseGraphicTotal.setAccountId(accountId);
                increaseGraphicTotal.setAddToFavCount(tempGraphic.getAdd_to_fav_count());
                increaseGraphicTotal.setAddToFavUser(tempGraphic.getAdd_to_fav_user());
                increaseGraphicTotal.setIntPageReadCount(tempGraphic.getInt_page_read_count());
                increaseGraphicTotal.setIntPageReadUser(tempGraphic.getInt_page_read_user());
                increaseGraphicTotal.setOriPageReadCount(tempGraphic.getOri_page_read_count());
                increaseGraphicTotal.setOriPageReadUser(tempGraphic.getOri_page_read_user());
                increaseGraphicTotal.setShareCount(tempGraphic.getShare_count());
                increaseGraphicTotal.setShareUser(tempGraphic.getShare_user());
                increaseGraphicTotal.setTargetUser(oConvertUtils.isEmpty((Object)tempGraphic.getTarget_user()) ? 0 : tempGraphic.getTarget_user());
                increaseGraphicTotal.setStatDate(tempRefDate);
                ++countSql;
                this.save(increaseGraphicTotal);
            }
        }
        return countSql;
    }

    @Override
    public WeixinDataBindingPhoneEntity saveWeixinDataBindingPhoneDB(java.util.Date date, String accountId) throws Exception {
        String minDate = DateUtils.datetoStr(date, "yyyy-MM-dd");
        String maxDate = DateUtils.datetoStr(DateUtils.getAddDate(date, 1), "yyyy-MM-dd");
        String newBindingCountSql = "select count(*) from  weixin_vip_member_opr t where t.sys_accountid='" + accountId + "' and t.binding_member_phone_date>='" + minDate + "' and t.binding_member_phone_date<'" + maxDate + "' and t.opr_type = 0";
        Long newBindingCount = this.getCountForJdbc(newBindingCountSql);
        String cancleBindingCountSql = "select count(*) from  weixin_vip_member_opr t where t.sys_accountid='" + accountId + "' and t.binding_member_phone_date>='" + minDate + "' and t.binding_member_phone_date<'" + maxDate + "' and t.opr_type = 1";
        Long cancleBindingCount = this.getCountForJdbc(cancleBindingCountSql);
        String sumBindingCountSql = "select count(*) from  weixin_vip_member_opr t where t.sys_accountid='" + accountId + "' and t.binding_member_phone_date<'" + maxDate + "' and t.opr_type = 0";
        Long sumBindingCount = this.getCountForJdbc(sumBindingCountSql);
        String sumCancleBindingCountSql = "select count(*) from  weixin_vip_member_opr t where t.sys_accountid='" + accountId + "' and t.binding_member_phone_date<'" + maxDate + "' and t.opr_type = 1";
        Long sumCancleBindingCount = this.getCountForJdbc(sumCancleBindingCountSql);
        WeixinDataBindingPhoneEntity weixinDataBindingPhoneEntity = new WeixinDataBindingPhoneEntity();
        weixinDataBindingPhoneEntity.setCancleBindingCount(cancleBindingCount.intValue());
        weixinDataBindingPhoneEntity.setIncreaseBindingCount(newBindingCount.intValue() - cancleBindingCount.intValue());
        weixinDataBindingPhoneEntity.setNewBindingCount(newBindingCount.intValue());
        weixinDataBindingPhoneEntity.setRefDate(date);
        weixinDataBindingPhoneEntity.setSumBindingCount(sumBindingCount.intValue() - sumCancleBindingCount.intValue());
        weixinDataBindingPhoneEntity.setSysAccountid(accountId);
        this.save(weixinDataBindingPhoneEntity);
        return weixinDataBindingPhoneEntity;
    }

    @Override
    public int loadWeixinVipMemberOprDB(String accountId, int pageSize, String endDate) throws Exception {
        String vipMemberCountSql = "select count(*) from  weixin_vip_member t where t.accountid='" + accountId + "' and t.binding_member_phone_date is not null and t.binding_member_phone_date < '" + endDate + "'";
        Long total = this.getCountForJdbc(vipMemberCountSql);
        if (total > 0L) {
            int loop = pageSize == -1 ? 1 : (total % (long)pageSize > 0L ? Math.round(total / (long)pageSize) + 1 : Math.round(total / (long)pageSize));
            int index = 1;
            while (index <= loop) {
                List tempList = this.findForJdbcParam(" select id,accountid,binding_member_phone_status,memberMobile,openid,binding_member_phone_date from weixin_vip_member where accountid= ? and binding_member_phone_date is not null and binding_member_phone_date < ? ", index, pageSize, new Object[]{accountId, endDate});
                for (Map memberEntity : tempList) {
                    WeixinVipMemberOprEntity weixinVipMemberLogEntity;
                    if ("Y".equals((String)memberEntity.get("binding_member_phone_status"))) {
                        weixinVipMemberLogEntity = new WeixinVipMemberOprEntity();
                        weixinVipMemberLogEntity.setOprType(0);
                        weixinVipMemberLogEntity.setAccountid((String)memberEntity.get("id"));
                        weixinVipMemberLogEntity.setSysAccountid((String)memberEntity.get("accountid"));
                        weixinVipMemberLogEntity.setBindingMemberPhoneDate(new java.util.Date(((Timestamp)memberEntity.get("binding_member_phone_date")).getTime()));
                        weixinVipMemberLogEntity.setMembermobile((String)memberEntity.get("memberMobile"));
                        weixinVipMemberLogEntity.setOpenid((String)memberEntity.get("openid"));
                        weixinVipMemberLogEntity.setRemark("\u7ed1\u5b9a\u624b\u673a");
                        weixinVipMemberLogEntity.setVersion(0);
                        this.save(weixinVipMemberLogEntity);
                        continue;
                    }
                    if (!"N".equals((String)memberEntity.get("binding_member_phone_status"))) continue;
                    weixinVipMemberLogEntity = new WeixinVipMemberOprEntity();
                    weixinVipMemberLogEntity.setOprType(0);
                    weixinVipMemberLogEntity.setAccountid((String)memberEntity.get("id"));
                    weixinVipMemberLogEntity.setSysAccountid((String)memberEntity.get("accountid"));
                    weixinVipMemberLogEntity.setBindingMemberPhoneDate(new java.util.Date(((Timestamp)memberEntity.get("binding_member_phone_date")).getTime()));
                    weixinVipMemberLogEntity.setMembermobile((String)memberEntity.get("memberMobile"));
                    weixinVipMemberLogEntity.setOpenid((String)memberEntity.get("openid"));
                    weixinVipMemberLogEntity.setRemark("\u7ed1\u5b9a\u624b\u673a");
                    weixinVipMemberLogEntity.setVersion(0);
                    this.save(weixinVipMemberLogEntity);
                    weixinVipMemberLogEntity = new WeixinVipMemberOprEntity();
                    weixinVipMemberLogEntity.setOprType(1);
                    weixinVipMemberLogEntity.setAccountid((String)memberEntity.get("id"));
                    weixinVipMemberLogEntity.setSysAccountid((String)memberEntity.get("accountid"));
                    weixinVipMemberLogEntity.setBindingMemberPhoneDate(new java.util.Date(((Timestamp)memberEntity.get("binding_member_phone_date")).getTime()));
                    weixinVipMemberLogEntity.setMembermobile((String)memberEntity.get("memberMobile"));
                    weixinVipMemberLogEntity.setOpenid((String)memberEntity.get("openid"));
                    weixinVipMemberLogEntity.setRemark("\u89e3\u9664\u7ed1\u5b9a");
                    weixinVipMemberLogEntity.setVersion(0);
                    this.save(weixinVipMemberLogEntity);
                }
                ++index;
            }
        }
        return total.intValue();
    }
}

