/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.account.service.impl;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.UUID;
import net.sf.json.JSONObject;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.service.impl.CommonServiceImpl;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.jeewx.api.core.exception.WexinReqException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import weixin.guanjia.account.dao.WxAccountDao;
import weixin.guanjia.account.entity.JsapiTicket;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.entity.WeixinAccountUserRelation;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.base.entity.WeixinExpandconfigBaseEntity;
import weixin.guanjia.base.entity.WeixinExpandconfigEntity;
import weixin.guanjia.core.def.WeixinDef;
import weixin.guanjia.core.util.WeixinUtil;

@Service(value="weixinAccountService")
@Transactional
public class WeixinAccountServiceImpl
extends CommonServiceImpl
implements WeixinAccountServiceI {
    @Autowired
    private WxAccountDao wxAccountDao;
    @Autowired
    private SystemService systemService;

    @Override
    public <T> void delete(T entity) {
        super.delete(entity);
        this.doDelSql((WeixinAccountEntity)entity);
    }

    @Override
    public <T> Serializable save(T entity) {
        Serializable t = super.save(entity);
        this.doAddSql((WeixinAccountEntity)entity);
        return t;
    }

    @Override
    public <T> void saveOrUpdate(T entity) {
        super.saveOrUpdate(entity);
        this.doUpdateSql((WeixinAccountEntity)entity);
    }

    @Override
    public boolean doAddSql(WeixinAccountEntity t) {
        return true;
    }

    @Override
    public boolean doUpdateSql(WeixinAccountEntity t) {
        return true;
    }

    @Override
    public boolean doDelSql(WeixinAccountEntity t) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getAccessToken() {
        String token = "";
        WeixinAccountEntity account = (WeixinAccountEntity)this.get(WeixinAccountEntity.class, (Serializable)((Object)ResourceUtil.getShangJiaAccountId()));
        token = account.getAccountaccesstoken();
        LogUtil.info((Object)("---------------------------------\u83b7\u53d6-------token-----------\uff1a{" + token));
        if (token != null && !"".equals(token)) {
            LogUtil.info((Object)"-----------------------------\u8d85\u8fc72\u5c0f\u65f6\u91cd\u65b0\u83b7\u53d6------token-----");
            Date end = new Date();
            Date start = new Date(account.getAddtoekntime().getTime());
            if (!((double)((end.getTime() - start.getTime()) / 1000L / 3600L) >= 1.9)) return account.getAccountaccesstoken();
            String requestUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET".replace("APPID", account.getAccountappid()).replace("APPSECRET", account.getAccountappsecret());
            JSONObject jsonObject = WeixinUtil.httpRequest(requestUrl, "GET", null);
            this.systemService.addLog("===================\u83b7\u53d6\u5728\u7ebf\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + account.getAccountname() + "\u3011Token===================" + jsonObject.toString(), Globals.Log_Type_WX_TOKEN, Globals.Log_Leavel_INFO);
            try {
                token = jsonObject.getString("access_token");
                LogUtil.info((Object)("-----------------------------\u8d85\u8fc72\u5c0f\u65f6\u91cd\u65b0\u83b7\u53d6------token-----\uff1a{" + token));
                account.setAccountaccesstoken(token);
                account.setAddtoekntime(new Date());
                this.saveOrUpdate(account);
                return token;
            }
            catch (Exception e) {
                token = null;
                String string = "\u83b7\u53d6token\u5931\u8d25 errcode:{} errmsg:{}" + jsonObject.getInt("errcode") + jsonObject.getString("errmsg");
            }
            return token;
        }
        String requestUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET".replace("APPID", account.getAccountappid()).replace("APPSECRET", account.getAccountappsecret());
        LogUtil.info((Object)("---------------------------\u4e3a\u7a7a\u7684\u60c5\u51b5\u91cd\u65b0\u83b7\u53d6------requestUrl-----{" + requestUrl));
        JSONObject jsonObject = WeixinUtil.httpRequest(requestUrl, "GET", null);
        this.systemService.addLog("===================\u83b7\u53d6\u5728\u7ebf\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + account.getAccountname() + "\u3011Token===================" + jsonObject.toString(), Globals.Log_Type_WX_TOKEN, Globals.Log_Leavel_INFO);
        try {
            token = jsonObject.getString("access_token");
            LogUtil.info((Object)("---------------------------\u4e3a\u7a7a\u7684\u60c5\u51b5\u91cd\u65b0\u83b7\u53d6------token-----{" + token));
            account.setAccountaccesstoken(token);
            account.setAddtoekntime(new Date());
            this.saveOrUpdate(account);
            return token;
        }
        catch (Exception e) {
            token = null;
            String string = "\u83b7\u53d6token\u5931\u8d25 errcode:{} errmsg:{}" + jsonObject.getInt("errcode") + jsonObject.getString("errmsg");
        }
        return token;
    }

    @Override
    public AjaxJson resetAccessToken(String accountid) throws WexinReqException {
        AjaxJson json = new AjaxJson();
        String token = "";
        WeixinAccountEntity account = (WeixinAccountEntity)this.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
        token = account.getAccountaccesstoken();
        String requestUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET".replace("APPID", account.getAccountappid()).replace("APPSECRET", account.getAccountappsecret());
        JSONObject jsonObject = WeixinUtil.httpRequest(requestUrl, "GET", null);
        this.systemService.addLog("===================\u91cd\u7f6e\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + account.getAccountname() + "\u3011Token===================" + jsonObject.toString(), Globals.Log_Type_WX_TOKEN, Globals.Log_Leavel_INFO);
        if (jsonObject.getInt("errcode") != 0) {
            json.setMsg(jsonObject.toString());
            json.setSuccess(false);
            return json;
        }
        try {
            token = jsonObject.getString("access_token");
            account.setAccountaccesstoken(token);
            account.setAddtoekntime(new Date());
            this.saveOrUpdate(account);
        }
        catch (Exception e) {
            token = null;
            String wrongMessage = "\u83b7\u53d6token\u5931\u8d25 errcode:{} errmsg:{}" + jsonObject.getInt("errcode") + jsonObject.getString("errmsg");
            json.setMsg(wrongMessage);
            json.setSuccess(false);
            return json;
        }
        json.setSuccess(true);
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getAccessToken(String accountId) {
        WeixinAccountEntity weixinAccountEntity = (WeixinAccountEntity)this.findUniqueByProperty(WeixinAccountEntity.class, "id", accountId);
        if (weixinAccountEntity == null) {
            return null;
        }
        String token = weixinAccountEntity.getAccountaccesstoken();
        if (oConvertUtils.isNotEmpty((Object)token)) {
            Date end = new Date();
            Date start = new Date(weixinAccountEntity.getAddtoekntime().getTime());
            if ((end.getTime() - start.getTime()) / 1000L / 3600L >= 2L) {
                String requestUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET".replace("APPID", weixinAccountEntity.getAccountappid()).replace("APPSECRET", weixinAccountEntity.getAccountappsecret());
                JSONObject jsonObject = WeixinUtil.httpRequest(requestUrl, "GET", null);
                this.systemService.addLog("===================\u8d85\u8fc72\u5c0f\u65f6\uff0c\u91cd\u65b0\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + weixinAccountEntity.getAccountname() + "\u3011Token===================" + jsonObject.toString(), Globals.Log_Type_WX_TOKEN, Globals.Log_Leavel_INFO);
                try {
                    token = jsonObject.getString("access_token");
                    weixinAccountEntity.setAccountaccesstoken(token);
                    weixinAccountEntity.setAddtoekntime(new Date());
                    this.saveOrUpdate(weixinAccountEntity);
                    return token;
                }
                catch (Exception e) {
                    token = null;
                    String string = "\u83b7\u53d6token\u5931\u8d25 errcode:{} errmsg:{}" + jsonObject.getInt("errcode") + jsonObject.getString("errmsg");
                }
                return token;
            }
            token = weixinAccountEntity.getAccountaccesstoken();
            String requestUrl = weixinAccountEntity.getId();
            synchronized (requestUrl) {
                return this.checkWeiXinToken(token, weixinAccountEntity.getAccountappid(), weixinAccountEntity.getAccountappsecret(), weixinAccountEntity.getId(), weixinAccountEntity.getAccountname());
            }
        }
        String requestUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET".replace("APPID", weixinAccountEntity.getAccountappid()).replace("APPSECRET", weixinAccountEntity.getAccountappsecret());
        JSONObject jsonObject = WeixinUtil.httpRequest(requestUrl, "GET", null);
        this.systemService.addLog("===================\u9996\u6b21\uff0c\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + weixinAccountEntity.getAccountname() + "\u3011Token===================" + jsonObject.toString(), Globals.Log_Type_WX_TOKEN, Globals.Log_Leavel_INFO);
        try {
            token = jsonObject.getString("access_token");
            weixinAccountEntity.setAccountaccesstoken(token);
            weixinAccountEntity.setAddtoekntime(new Date());
            this.saveOrUpdate(weixinAccountEntity);
            return token;
        }
        catch (Exception e) {
            token = null;
            String string = "\u83b7\u53d6token\u5931\u8d25 errcode:{} errmsg:{}" + jsonObject.getInt("errcode") + jsonObject.getString("errmsg");
        }
        return token;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getAccessTokenNoCheck(String accountId) {
        WeixinAccountEntity weixinAccountEntity = (WeixinAccountEntity)this.findUniqueByProperty(WeixinAccountEntity.class, "id", accountId);
        String token = weixinAccountEntity.getAccountaccesstoken();
        if (oConvertUtils.isNotEmpty((Object)token)) {
            Date end = new Date();
            Date start = new Date(weixinAccountEntity.getAddtoekntime().getTime());
            if ((end.getTime() - start.getTime()) / 1000L / 3600L < 2L) return weixinAccountEntity.getAccountaccesstoken();
            String requestUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET".replace("APPID", weixinAccountEntity.getAccountappid()).replace("APPSECRET", weixinAccountEntity.getAccountappsecret());
            JSONObject jsonObject = WeixinUtil.httpRequest(requestUrl, "GET", null);
            this.systemService.addLog("===================\u8d85\u8fc72\u5c0f\u65f6\uff0c\u91cd\u65b0\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + weixinAccountEntity.getAccountname() + "\u3011Token===================" + jsonObject.toString(), Globals.Log_Type_WX_TOKEN, Globals.Log_Leavel_INFO);
            try {
                token = jsonObject.getString("access_token");
                weixinAccountEntity.setAccountaccesstoken(token);
                weixinAccountEntity.setAddtoekntime(new Date());
                this.saveOrUpdate(weixinAccountEntity);
                return token;
            }
            catch (Exception e) {
                token = null;
                String string = "\u83b7\u53d6token\u5931\u8d25 errcode:{} errmsg:{}" + jsonObject.getInt("errcode") + jsonObject.getString("errmsg");
            }
            return token;
        }
        String requestUrl = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET".replace("APPID", weixinAccountEntity.getAccountappid()).replace("APPSECRET", weixinAccountEntity.getAccountappsecret());
        JSONObject jsonObject = WeixinUtil.httpRequest(requestUrl, "GET", null);
        this.systemService.addLog("===================\u9996\u6b21\uff0c\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + weixinAccountEntity.getAccountname() + "\u3011Token===================" + jsonObject.toString(), Globals.Log_Type_WX_TOKEN, Globals.Log_Leavel_INFO);
        try {
            token = jsonObject.getString("access_token");
            weixinAccountEntity.setAccountaccesstoken(token);
            weixinAccountEntity.setAddtoekntime(new Date());
            this.saveOrUpdate(weixinAccountEntity);
            return token;
        }
        catch (Exception e) {
            token = null;
            String string = "\u83b7\u53d6token\u5931\u8d25 errcode:{} errmsg:{}" + jsonObject.getInt("errcode") + jsonObject.getString("errmsg");
        }
        return token;
    }

    @Override
    public WeixinAccountEntity findLoginWeixinAccount() {
        WeixinAccountEntity weixinAccountEntity;
        TSUser user = ResourceUtil.getSessionUserName();
        List acclst = this.findByProperty(WeixinAccountEntity.class, "userName", user.getUserName());
        WeixinAccountEntity weixinAccountEntity2 = weixinAccountEntity = acclst.size() != 0 ? (WeixinAccountEntity)acclst.get(0) : null;
        if (weixinAccountEntity != null) {
            return weixinAccountEntity;
        }
        weixinAccountEntity = new WeixinAccountEntity();
        weixinAccountEntity.setWeixinOriginalAccountid("-1");
        weixinAccountEntity.setId("-1");
        return weixinAccountEntity;
    }

    @Override
    public List<WeixinAccountEntity> findByUsername(String username) {
        List acclst = this.findByProperty(WeixinAccountEntity.class, "userName", username);
        return acclst;
    }

    @Override
    public WeixinAccountEntity findByToUsername(String toUserName) {
        return (WeixinAccountEntity)this.findUniqueByProperty(WeixinAccountEntity.class, "weixinOriginalAccountid", toUserName);
    }

    public String replaceVal(String sql, WeixinAccountEntity t) {
        sql = sql.replace("#{id}", String.valueOf(t.getId()));
        sql = sql.replace("#{accountname}", String.valueOf(t.getAccountname()));
        sql = sql.replace("#{accounttoken}", String.valueOf(t.getAccounttoken()));
        sql = sql.replace("#{accountnumber}", String.valueOf(t.getAccountnumber()));
        sql = sql.replace("#{accounttype}", String.valueOf(t.getAccounttype()));
        sql = sql.replace("#{accountemail}", String.valueOf(t.getAccountemail()));
        sql = sql.replace("#{accountdesc}", String.valueOf(t.getAccountdesc()));
        sql = sql.replace("#{accountappid}", String.valueOf(t.getAccountappid()));
        sql = sql.replace("#{accountappsecret}", String.valueOf(t.getAccountappsecret()));
        sql = sql.replace("#{accountaccesstoken}", String.valueOf(t.getAccountaccesstoken()));
        sql = sql.replace("#{addtoekntime}", String.valueOf(t.getAddtoekntime()));
        sql = sql.replace("#{UUID}", UUID.randomUUID().toString());
        return sql;
    }

    @Override
    public boolean checkAccountRelation(String accountid, String userid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinAccountUserRelation.class);
        WeixinAccountUserRelation relation = new WeixinAccountUserRelation();
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)relation);
        cq.eq("user.id", (Object)userid);
        cq.eq("account.id", (Object)accountid);
        cq.add();
        List rlist = this.getListByCriteriaQuery(cq, false);
        return rlist.size() != 0;
    }

    @Override
    @Transactional
    public boolean saveUserWeixinAccountRelation(List<WeixinAccountUserRelation> accountUserRelations, String userId) {
        boolean r;
        try {
            this.deleteAllEntitie(this.findByProperty(WeixinAccountUserRelation.class, "user.id", userId));
            this.batchSave(accountUserRelations);
            r = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            r = false;
        }
        return r;
    }

    @Override
    public synchronized String getMaxLocalPostCode(String parentCode) {
        if (oConvertUtils.isEmpty((Object)parentCode)) {
            parentCode = "";
        }
        int localCodeLength = parentCode.length() + 5;
        String returnCode = this.wxAccountDao.getMaxPostCode(parentCode, localCodeLength);
        return returnCode;
    }

    @Override
    public boolean checkMenuBitIsExist(String accountid, String menuid, String orders) {
        String id = this.wxAccountDao.findMenuBitByAcccountId(accountid, menuid, orders);
        return oConvertUtils.isNotEmpty((Object)id);
    }

    private String checkWeiXinToken(String accessTocken, String appid, String appsecret, String accountid, String accountname) {
        String get_callbackip_url = "https://api.weixin.qq.com/cgi-bin/getcallbackip?access_token=ACCESS_TOKEN";
        String access_token_url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=APPID&secret=APPSECRET";
        String requestUrl = get_callbackip_url.replace("ACCESS_TOKEN", accessTocken);
        JSONObject jsonObject = WeixinUtil.httpRequest(requestUrl, "GET", null);
        if (jsonObject != null && jsonObject.has("ip_list")) {
            return accessTocken;
        }
        requestUrl = access_token_url.replace("APPID", appid).replace("APPSECRET", appsecret);
        jsonObject = WeixinUtil.httpRequest(requestUrl, "GET", null);
        this.systemService.addLog("==================Token\u6821\u9a8c\u65e0\u6548\uff0c\u91cd\u65b0\u83b7\u53d6\u5fae\u4fe1\u516c\u4f17\u53f7\u3010" + accountname + "\u3011Token===================" + jsonObject.toString(), Globals.Log_Type_WX_TOKEN, Globals.Log_Leavel_INFO);
        try {
            WeixinAccountEntity account = (WeixinAccountEntity)this.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
            String token = jsonObject.getString("access_token");
            account.setAccountaccesstoken(token);
            account.setAddtoekntime(new Date());
            this.saveOrUpdate(account);
            return token;
        }
        catch (Exception e) {
            String wrongMessage = "\u83b7\u53d6token\u5931\u8d25 errcode:{} errmsg:{}" + jsonObject.getInt("errcode") + jsonObject.getString("errmsg");
            LogUtil.info((Object)wrongMessage);
            return null;
        }
    }

    @Override
    public void saveWeixinExpandconfigInit(String accountId) {
        List list = this.systemService.findHql(" from WeixinExpandconfigBaseEntity where isDefault = ?", new Object[]{WeixinDef.ISDEFAULT_Y});
        for (WeixinExpandconfigBaseEntity baseEntity : list) {
            WeixinExpandconfigEntity expandconfigEntity = new WeixinExpandconfigEntity();
            expandconfigEntity.setAccountid(accountId);
            expandconfigEntity.setClassname(baseEntity.getClassname());
            expandconfigEntity.setContent(baseEntity.getContent());
            expandconfigEntity.setFaceImgUrl(baseEntity.getFaceImgUrl());
            expandconfigEntity.setKeyword(baseEntity.getKeyword());
            expandconfigEntity.setKeywordType(baseEntity.getKeywordType());
            expandconfigEntity.setName(baseEntity.getName());
            expandconfigEntity.setRespmodle(baseEntity.getRespmodle());
            expandconfigEntity.setShowImgUrl(baseEntity.getShowImgUrl());
            expandconfigEntity.setShowAddress(baseEntity.getShowAddress());
            expandconfigEntity.setSort(baseEntity.getSort());
            this.systemService.saveOrUpdate((Object)expandconfigEntity);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public WeixinAccountEntity doGetJsapiticket(WeixinAccountEntity account) {
        String jsapiticket = "";
        jsapiticket = account.getJsapiticket();
        LogUtil.info((Object)("---------------------------------\u4f18\u5316\u83b7\u53d6\u7f13\u5b58----jsapi\u51ed\u8bc1-----------\uff1a{" + jsapiticket));
        if (oConvertUtils.isNotEmpty((Object)jsapiticket)) {
            Date end = new Date();
            Date start = new Date(account.getJsapitickettime().getTime());
            if (!((double)((end.getTime() - start.getTime()) / 1000L / 3600L) >= 1.9)) return account;
            String accessToken = this.getAccessToken(account.getId());
            String requestUrl = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi".replace("ACCESS_TOKEN", accessToken);
            JSONObject jsonObject = WeixinUtil.httpRequest(requestUrl, "GET", null);
            if (jsonObject == null) return account;
            try {
                jsapiticket = jsonObject.getString("ticket");
                LogUtil.info((Object)("-----------------------------\u8d85\u8fc72\u5c0f\u65f6\u91cd\u65b0\u83b7\u53d6------jsapi\u51ed\u8bc1-----\uff1a{" + jsapiticket));
                account.setJsapiticket(jsapiticket);
                account.setJsapitickettime(new Date());
                this.saveOrUpdate(account);
                return account;
            }
            catch (Exception e) {
                jsapiticket = null;
                String string = "\u83b7\u53d6jsapi\u51ed\u8bc1\u5931\u8d25 errcode:{} errmsg:{}" + jsonObject.getInt("errcode") + jsonObject.getString("errmsg");
            }
            return account;
        }
        String accessToken = this.getAccessToken(account.getId());
        String requestUrl = "https://api.weixin.qq.com/cgi-bin/ticket/getticket?access_token=ACCESS_TOKEN&type=jsapi".replace("ACCESS_TOKEN", accessToken);
        JSONObject jsonObject = WeixinUtil.httpRequest(requestUrl, "GET", null);
        if (jsonObject == null) return account;
        try {
            jsapiticket = jsonObject.getString("ticket");
            LogUtil.info((Object)("-----------------------------\u8d85\u8fc72\u5c0f\u65f6\u91cd\u65b0\u83b7\u53d6------jsapi\u51ed\u8bc1-----\uff1a{" + jsapiticket));
            account.setJsapiticket(jsapiticket);
            account.setJsapitickettime(new Date());
            this.saveOrUpdate(account);
            return account;
        }
        catch (Exception e) {
            jsapiticket = null;
            String string = "\u83b7\u53d6jsapi\u51ed\u8bc1\u5931\u8d25 errcode:{} errmsg:{}" + jsonObject.getInt("errcode") + jsonObject.getString("errmsg");
        }
        return account;
    }

    @Override
    public JsapiTicket getJsapiticket(String accountId, String url) {
        WeixinAccountEntity weixinAccountEntity = (WeixinAccountEntity)this.findUniqueByProperty(WeixinAccountEntity.class, "id", accountId);
        return this.JsapiTicketSignature(weixinAccountEntity, url);
    }

    private JsapiTicket JsapiTicketSignature(WeixinAccountEntity weixinAccountEntity, String url) {
        JsapiTicket jsapiTicket = new JsapiTicket();
        String jsapi_ticket = this.doGetJsapiticket(weixinAccountEntity).getJsapiticket();
        String nonce_str = WeixinAccountServiceImpl.create_nonce_str();
        String timestamp = WeixinAccountServiceImpl.create_timestamp();
        String signature = "";
        String string1 = "jsapi_ticket=" + jsapi_ticket + "&noncestr=" + nonce_str + "&timestamp=" + timestamp + "&url=" + url;
        System.out.println(string1);
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(string1.getBytes("UTF-8"));
            signature = WeixinAccountServiceImpl.byteToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        jsapiTicket.setUrl(url);
        jsapiTicket.setAppId(weixinAccountEntity.getAccountappid());
        jsapiTicket.setJsapi_ticket(jsapi_ticket);
        jsapiTicket.setNonceStr(nonce_str);
        jsapiTicket.setTimestamp(timestamp);
        jsapiTicket.setSignature(signature);
        return jsapiTicket;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        byte[] byArray = hash;
        int n = hash.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            formatter.format("%02x", b);
            ++n2;
        }
        String result = formatter.toString();
        formatter.close();
        return result;
    }

    private static String create_nonce_str() {
        return UUID.randomUUID().toString();
    }

    private static String create_timestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }
}

