/*
 * Decompiled with CFR 0.152.
 */
package weixin.guanjia.account.controller;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.common.model.json.TreeGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.LogUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.YouBianCodeUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.easyui.TreeGridModel;
import org.jeecgframework.web.system.pojo.base.TSUser;
import org.jeecgframework.web.system.service.SystemService;
import org.jeewx.api.core.exception.WexinReqException;
import org.jeewx.api.report.datacube.JwDataCubeAPI;
import org.jeewx.api.report.datacube.model.WxDataCubeStreamMsgInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.guanjia.account.dao.WxAccountDao;
import weixin.guanjia.account.entity.WeixinAccountEntity;
import weixin.guanjia.account.entity.WeixinAccountUserRelation;
import weixin.guanjia.account.service.WeixinAccountServiceI;
import weixin.guanjia.base.entity.WeixinExpandconfigBaseEntity;
import weixin.guanjia.base.entity.WeixinExpandconfigEntity;
import weixin.guanjia.core.def.WeixinDef;
import weixin.guanjia.task.JwDataCubeTask;
import weixin.util.WeixinConfigUtil;

@Controller
@RequestMapping(value={"/weixinAccountController"})
public class WeixinAccountController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinAccountController.class);
    @Autowired
    private WeixinAccountServiceI weixinAccountService;
    @Autowired
    private WxAccountDao wxAccountDao;
    @Autowired
    private SystemService systemService;
    private String message;
    @Autowired
    JwDataCubeTask jwDataCubeTask;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"accountTree"})
    @ResponseBody
    public List<Map<String, String>> accountTree(String accountid, HttpServletRequest request) {
        ArrayList<WeixinAccountEntity> all = new ArrayList<WeixinAccountEntity>();
        List accountlist = new ArrayList();
        ArrayList<Map<String, String>> mlist = new ArrayList<Map<String, String>>();
        accountlist = this.weixinAccountService.findByProperty(WeixinAccountEntity.class, "parentAccount.id", accountid);
        for (WeixinAccountEntity ac : accountlist) {
            all.add(ac);
            this.getChildAccount(ac.getId(), all);
        }
        WeixinAccountEntity acc = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
        String menuflag = request.getParameter("menuflag");
        if (StringUtil.isEmpty((String)menuflag)) {
            all.add(acc);
        }
        for (WeixinAccountEntity ac : all) {
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("id", ac.getId());
            m.put("pid", ac.getParentAccount() != null ? ac.getParentAccount().getId() : "");
            m.put("title", ac.getAccountname());
            m.put("oriaccountid", ac.getWeixinOriginalAccountid());
            m.put("accountnumber", ac.getAccountnumber());
            mlist.add(m);
        }
        return mlist;
    }

    private void getChildAccount(String accountid, List<WeixinAccountEntity> all) {
        List accountlist = new ArrayList();
        accountlist = this.weixinAccountService.findByProperty(WeixinAccountEntity.class, "parentAccount.id", accountid);
        for (WeixinAccountEntity ac : accountlist) {
            all.add(ac);
            this.getChildAccount(ac.getId(), all);
        }
    }

    @RequestMapping(params={"manageAccountList"})
    public ModelAndView manageAccountList(HttpServletRequest request, String accountid) {
        return new ModelAndView("weixin/guanjia/account/manageAccountList");
    }

    @RequestMapping(params={"changeAccount"})
    @ResponseBody
    public AjaxJson changeAccount(HttpServletRequest request, String accountid, String relationid) {
        AjaxJson json = new AjaxJson();
        WeixinAccountEntity account = new WeixinAccountEntity();
        if (!StringUtil.isEmpty((String)relationid)) {
            WeixinAccountUserRelation relation = (WeixinAccountUserRelation)this.weixinAccountService.get(WeixinAccountUserRelation.class, (Serializable)((Object)relationid));
            account = relation.getAccount();
            request.getSession().setAttribute("WEIXIN_ACCOUNT", (Object)account);
        }
        if (!StringUtil.isEmpty((String)accountid)) {
            account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
            request.getSession().setAttribute("WEIXIN_ACCOUNT", (Object)account);
        }
        TSUser user = ResourceUtil.getSessionUserName();
        user = (TSUser)this.systemService.getEntity(TSUser.class, (Serializable)((Object)user.getId()));
        user.setDefaultWeixinAccountId(account.getId());
        this.systemService.saveOrUpdate((Object)user);
        ResourceUtil.setSessionUserName((TSUser)user);
        json.setSuccess(true);
        return json;
    }

    @RequestMapping(params={"doResetAccessToken"})
    @ResponseBody
    public AjaxJson doResetAccessToken(HttpServletRequest request, String accountid, String relationid) throws Exception {
        return this.weixinAccountService.resetAccessToken(accountid);
    }

    @RequestMapping(params={"goSetUser"})
    public ModelAndView goSetUser(HttpServletRequest request, String accountid) {
        WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
        request.setAttribute("account", (Object)account);
        return new ModelAndView("weixin/guanjia/account/setUser");
    }

    @RequestMapping(params={"doSetUser"})
    @ResponseBody
    public AjaxJson doSetUser(String accountid, String userids, HttpServletRequest request) {
        String[] useridsarray;
        AjaxJson json = new AjaxJson();
        WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)accountid));
        String[] stringArray = useridsarray = userids.split(",");
        int n = useridsarray.length;
        int n2 = 0;
        while (n2 < n) {
            String uid = stringArray[n2];
            WeixinAccountUserRelation ur = new WeixinAccountUserRelation();
            if (!this.weixinAccountService.checkAccountRelation(accountid, uid)) {
                TSUser user = (TSUser)this.systemService.get(TSUser.class, (Serializable)((Object)uid));
                ur.setAccount(account);
                ur.setCreateUserId(ResourceUtil.getSessionUserName().getId());
                ur.setUser(user);
                this.systemService.save((Object)ur);
            }
            ++n2;
        }
        json.setMsg("\u6267\u884c\u6210\u529f");
        json.setSuccess(true);
        return json;
    }

    @RequestMapping(params={"doRemoveUser"})
    @ResponseBody
    public AjaxJson doRemoveUser(String id, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u7ba1\u7406\u7528\u6237\u5220\u9664\u6210\u529f";
        try {
            WeixinAccountUserRelation relation = (WeixinAccountUserRelation)this.systemService.getEntity(WeixinAccountUserRelation.class, (Serializable)((Object)id));
            this.systemService.delete((Object)relation);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u7ba1\u7406\u7528\u6237\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"weixinExpandconfigList"})
    public ModelAndView weixinExpandconfigList(HttpServletRequest request, WeixinAccountEntity account) {
        return new ModelAndView("weixin/guanjia/account/weixinExpandconfigList");
    }

    @RequestMapping(params={"weixinExpandconfigListData"})
    @ResponseBody
    public AjaxJson weixinExpandconfigListData(String accountId, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            String SQL = "SELECT case when t2.id is null then 'false' else 'true' END checked,'true' as open, 'plug-in/zTree_v3/css/zTreeStyle/img/diy/4.png' as  icon, '-1' as pId,t1.ID as id,t1.name as name FROM weixin_expandconfig_base t1 LEFT JOIN weixin_expandconfig t2 ON t1.classname = t2.classname AND  t2.ACCOUNTID = ?";
            j.setObj((Object)this.systemService.findForJdbc(SQL, new Object[]{accountId}));
            j.setSuccess(true);
            j.setMsg("\u83b7\u53d6\u914d\u7f6e\u6269\u5c55\u63a5\u53e3\u6570\u636e\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            j.setMsg("\u83b7\u53d6\u914d\u7f6e\u6269\u5c55\u63a5\u53e3\u6570\u636e\u6210\u529f");
            throw new BusinessException(e.getMessage());
        }
        return j;
    }

    @RequestMapping(params={"saveWeixinExpandconfig"})
    @ResponseBody
    public AjaxJson saveWeixinExpandconfig(String accountId, String weixinExpandconfigCheckStr, String weixinExpandconfigCheckStrNew, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            WeixinExpandconfigBaseEntity baseEntity;
            String[] weixinExpandconfigCheckArr = weixinExpandconfigCheckStr.split(",");
            String[] weixinExpandconfigCheckArrNew = weixinExpandconfigCheckStrNew.split(",");
            List<String> weixinExpandconfigCheckList = Arrays.asList(weixinExpandconfigCheckArr);
            List<String> weixinExpandconfigCheckNewList = Arrays.asList(weixinExpandconfigCheckArrNew);
            for (String newCheck : weixinExpandconfigCheckNewList) {
                if (oConvertUtils.isEmpty((Object)newCheck) || weixinExpandconfigCheckList.contains(newCheck)) continue;
                baseEntity = (WeixinExpandconfigBaseEntity)this.systemService.getEntity(WeixinExpandconfigBaseEntity.class, (Serializable)((Object)newCheck));
                WeixinExpandconfigEntity expandconfigEntity = new WeixinExpandconfigEntity();
                expandconfigEntity.setAccountid(accountId);
                expandconfigEntity.setClassname(baseEntity.getClassname());
                expandconfigEntity.setContent(baseEntity.getContent());
                expandconfigEntity.setFaceImgUrl(baseEntity.getFaceImgUrl());
                expandconfigEntity.setKeyword(baseEntity.getKeyword());
                expandconfigEntity.setKeywordType(baseEntity.getKeywordType());
                expandconfigEntity.setName(baseEntity.getName());
                expandconfigEntity.setRespmodle(baseEntity.getRespmodle());
                expandconfigEntity.setShowAddress(baseEntity.getShowAddress());
                expandconfigEntity.setShowImgUrl(baseEntity.getShowImgUrl());
                expandconfigEntity.setSort(baseEntity.getSort());
                this.systemService.saveOrUpdate((Object)expandconfigEntity);
            }
            for (String oldCheck : weixinExpandconfigCheckList) {
                List list;
                if (oConvertUtils.isEmpty((Object)oldCheck) || weixinExpandconfigCheckNewList.contains(oldCheck) || (list = this.systemService.findHql(" from WeixinExpandconfigEntity where classname = ? and accountid = ? ", new Object[]{(baseEntity = (WeixinExpandconfigBaseEntity)this.systemService.getEntity(WeixinExpandconfigBaseEntity.class, (Serializable)((Object)oldCheck))).getClassname(), accountId})).size() <= 0) continue;
                this.systemService.delete((Object)((WeixinExpandconfigEntity)list.get(0)));
            }
            j.setSuccess(true);
            j.setMsg("\u914d\u7f6e\u6269\u5c55\u63a5\u53e3\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u914d\u7f6e\u6269\u5c55\u63a5\u53e3\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"saveWeixinExpandconfigAccount"})
    @ResponseBody
    public AjaxJson saveWeixinExpandconfigAccount(String accountId, String weixinExpandconfigCheckStr, String weixinExpandconfigCheckStrNew, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            WeixinExpandconfigBaseEntity baseEntity;
            String[] weixinExpandconfigCheckArr = weixinExpandconfigCheckStr.split(",");
            String[] weixinExpandconfigCheckArrNew = weixinExpandconfigCheckStrNew.split(",");
            List<String> weixinExpandconfigCheckList = Arrays.asList(weixinExpandconfigCheckArr);
            List<String> weixinExpandconfigCheckNewList = Arrays.asList(weixinExpandconfigCheckArrNew);
            for (String newCheck : weixinExpandconfigCheckNewList) {
                if (oConvertUtils.isEmpty((Object)newCheck) || weixinExpandconfigCheckList.contains(newCheck)) continue;
                baseEntity = (WeixinExpandconfigBaseEntity)this.systemService.getEntity(WeixinExpandconfigBaseEntity.class, (Serializable)((Object)newCheck));
                WeixinExpandconfigEntity expandconfigEntity = new WeixinExpandconfigEntity();
                expandconfigEntity.setAccountid(accountId);
                expandconfigEntity.setClassname(baseEntity.getClassname());
                expandconfigEntity.setContent(baseEntity.getContent());
                expandconfigEntity.setFaceImgUrl(baseEntity.getFaceImgUrl());
                expandconfigEntity.setKeyword(baseEntity.getKeyword());
                expandconfigEntity.setKeywordType(baseEntity.getKeywordType());
                expandconfigEntity.setName(baseEntity.getName());
                expandconfigEntity.setRespmodle(baseEntity.getRespmodle());
                expandconfigEntity.setShowAddress(baseEntity.getShowAddress());
                expandconfigEntity.setShowImgUrl(baseEntity.getShowImgUrl());
                expandconfigEntity.setSort(baseEntity.getSort());
                this.systemService.saveOrUpdate((Object)expandconfigEntity);
            }
            for (String oldCheck : weixinExpandconfigCheckList) {
                List list;
                if (oConvertUtils.isEmpty((Object)oldCheck) || weixinExpandconfigCheckNewList.contains(oldCheck) || (list = this.systemService.findHql(" from WeixinExpandconfigEntity where classname = ? and accountid = ? ", new Object[]{(baseEntity = (WeixinExpandconfigBaseEntity)this.systemService.getEntity(WeixinExpandconfigBaseEntity.class, (Serializable)((Object)oldCheck))).getClassname(), accountId})).size() <= 0) continue;
                this.systemService.delete((Object)((WeixinExpandconfigEntity)list.get(0)));
            }
            j.setSuccess(true);
            j.setMsg("\u914d\u7f6e\u6269\u5c55\u63a5\u53e3\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u914d\u7f6e\u6269\u5c55\u63a5\u53e3\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"saveWeixinExpandconfigAndAccount"})
    @ResponseBody
    public AjaxJson saveWeixinExpandconfigAndAccount(String weixinAccountIds, String weixinExpandconfigs, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        try {
            String[] weixinExpandconfigCheckArrNew = weixinExpandconfigs.split(",");
            String[] weixinAccountIdsArray = weixinAccountIds.split(",");
            List<String> weixinExpandconfigCheckNewList = Arrays.asList(weixinExpandconfigCheckArrNew);
            List<String> weixinAccountIdsList = Arrays.asList(weixinAccountIdsArray);
            for (String newCheck : weixinExpandconfigCheckNewList) {
                if (oConvertUtils.isEmpty((Object)newCheck)) continue;
                for (String accountId : weixinAccountIdsList) {
                    WeixinExpandconfigBaseEntity baseEntity = (WeixinExpandconfigBaseEntity)this.systemService.getEntity(WeixinExpandconfigBaseEntity.class, (Serializable)((Object)newCheck));
                    WeixinExpandconfigEntity expandconfigEntity = new WeixinExpandconfigEntity();
                    expandconfigEntity.setAccountid(accountId);
                    expandconfigEntity.setClassname(baseEntity.getClassname());
                    expandconfigEntity.setContent(baseEntity.getContent());
                    expandconfigEntity.setFaceImgUrl(baseEntity.getFaceImgUrl());
                    expandconfigEntity.setKeyword(baseEntity.getKeyword());
                    expandconfigEntity.setKeywordType(baseEntity.getKeywordType());
                    expandconfigEntity.setName(baseEntity.getName());
                    expandconfigEntity.setShowAddress(baseEntity.getShowAddress());
                    expandconfigEntity.setShowImgUrl(baseEntity.getShowImgUrl());
                    expandconfigEntity.setRespmodle(baseEntity.getRespmodle());
                    expandconfigEntity.setSort(baseEntity.getSort());
                    List list = this.systemService.findHql(" from WeixinExpandconfigEntity where classname = ? and accountid = ? ", new Object[]{baseEntity.getClassname(), accountId});
                    if (list.size() != 0) continue;
                    this.systemService.saveOrUpdate((Object)expandconfigEntity);
                }
            }
            j.setSuccess(true);
            j.setMsg("\u914d\u7f6e\u6269\u5c55\u63a5\u53e3\u6210\u529f");
        }
        catch (Exception e) {
            j.setSuccess(false);
            j.setMsg("\u914d\u7f6e\u6269\u5c55\u63a5\u53e3\u5931\u8d25");
            e.printStackTrace();
        }
        return j;
    }

    @RequestMapping(params={"userList"})
    public ModelAndView userList(HttpServletRequest request, WeixinAccountEntity account) {
        account = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)account.getId()));
        request.setAttribute("account", (Object)account);
        return new ModelAndView("weixin/guanjia/account/userList");
    }

    @RequestMapping(params={"manageAccountDataGrid"})
    @ResponseBody
    public Map<String, Object> manageAccountDataGrid(WeixinAccountUserRelation relation, String accountid, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        Map<String, Object> map2;
        String sql = "SELECT tt.id,tt.parent_accountid as _parentId, tt.accountnumber,tt.accountname as name,'open' as state , 'false' as nocheck,'plug-in/zTree_v3/css/zTreeStyle/img/weixin.png' as icon from weixin_account_user_relation t LEFT JOIN weixin_account tt on t.accountid = tt.id where t.userid = ?";
        String sql2 = " select tt.id,tt.parent_accountid as _parentId, tt.accountnumber,tt.accountname as name,'open' as state, 'false' as nocheck,'plug-in/zTree_v3/css/zTreeStyle/img/weixin.png' as icon from weixin_account tt where tt.id in ( SELECT tt.parent_accountid from weixin_account_user_relation t LEFT JOIN weixin_account tt on t.accountid = tt.id where t.userid = ? )";
        String userid = ResourceUtil.getSessionUserName().getId();
        List list = this.weixinAccountService.findForJdbc(sql, new Object[]{userid});
        List list2 = this.weixinAccountService.findForJdbc(sql2, new Object[]{userid});
        for (Map map2 : list2) {
            if (list.contains(map2)) continue;
            map2.put("nocheck", "true");
            list.add(map2);
        }
        for (Map<String, Object> map2 : list) {
            String _parentId = (String)map2.get("_parentId");
            boolean f = false;
            for (Map map22 : list) {
                String id = (String)map22.get("id");
                if (!id.equals(_parentId)) continue;
                f = true;
                break;
            }
            if (f) continue;
            map2.put("_parentId", null);
        }
        map2 = new HashMap();
        map2.put("rows", list);
        return map2;
    }

    @RequestMapping(params={"userDataGrid"})
    public void userDataGrid(TSUser user, String accountid, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinAccountUserRelation.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)user);
        cq.eq("account.id", (Object)accountid);
        cq.add();
        this.systemService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"goSelect"})
    public ModelAndView goSelect(HttpServletRequest request) {
        String sql = "SELECT tt.id,tt.parent_accountid as pId, tt.accountname as name,'false' as open , 'false' as nocheck,'plug-in/zTree_v3/css/zTreeStyle/img/weixin.png' as icon from weixin_account_user_relation t LEFT JOIN weixin_account tt on t.accountid = tt.id where t.userid = ?";
        String sql2 = " select tt.id,tt.parent_accountid as pId, tt.accountname as name,'false' as open, 'false' as nocheck,'plug-in/zTree_v3/css/zTreeStyle/img/weixin.png' as icon from weixin_account tt where tt.id in ( SELECT tt.parent_accountid from weixin_account_user_relation t LEFT JOIN weixin_account tt on t.accountid = tt.id where t.userid = ? )";
        String userid = ResourceUtil.getSessionUserName().getId();
        List list = this.weixinAccountService.findForJdbc(sql, new Object[]{userid});
        List list2 = this.weixinAccountService.findForJdbc(sql2, new Object[]{userid});
        for (Map map2 : list2) {
            if (list.contains(map2)) continue;
            map2.put("nocheck", "true");
            list.add(map2);
        }
        String treeJSONData = JSON.toJSONString((Object)list);
        request.setAttribute("treeJSONData", (Object)treeJSONData);
        return new ModelAndView("weixin/guanjia/account/selectdefaultaccount");
    }

    @RequestMapping(params={"doSelect"})
    @ResponseBody
    public AjaxJson doSelect(WeixinAccountEntity account, HttpServletRequest request) {
        AjaxJson json = new AjaxJson();
        WeixinAccountEntity sessionaccount = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)account.getId()));
        request.getSession().setAttribute("WEIXIN_ACCOUNT", (Object)sessionaccount);
        TSUser user = ResourceUtil.getSessionUserName();
        user = (TSUser)this.systemService.getEntity(TSUser.class, (Serializable)((Object)user.getId()));
        user.setDefaultWeixinAccountId(account.getId());
        this.systemService.saveOrUpdate((Object)user);
        ResourceUtil.setSessionUserName((TSUser)user);
        json.setSuccess(true);
        return json;
    }

    @RequestMapping(params={"checkAccount"})
    @ResponseBody
    public AjaxJson checkAccount(HttpServletRequest request) {
        AjaxJson json = new AjaxJson();
        String accountid = ResourceUtil.getShangJiaAccountId();
        List list = this.weixinAccountService.findByProperty(WeixinAccountUserRelation.class, "user.id", ResourceUtil.getSessionUserName().getId());
        if (accountid == null && list.size() > 1) {
            json.setSuccess(false);
            json.setMsg("2");
        }
        if (list.size() == 0) {
            json.setSuccess(false);
            json.setMsg("0");
        }
        if (list.size() == 1) {
            WeixinAccountEntity account = ((WeixinAccountUserRelation)list.get(0)).getAccount();
            request.getSession().setAttribute("WEIXIN_ACCOUNT", (Object)account);
            json.setSuccess(true);
            json.setMsg("1");
        }
        return json;
    }

    @RequestMapping(params={"weixinAccount"})
    public ModelAndView weixinAccount(HttpServletRequest request) {
        return new ModelAndView("weixin/guanjia/account/weixinAccountList");
    }

    @RequestMapping(params={"treegrid"})
    @ResponseBody
    public List<TreeGrid> datagrid(TreeGrid treegrid, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinAccountEntity.class);
        if (treegrid.getId() != null) {
            cq.eq("parentAccount.id", (Object)treegrid.getId());
        } else {
            cq.isNull("parentAccount");
        }
        int i = this.wxAccountDao.getRoleByRoleNameAndUser(WeixinConfigUtil.getConfigByName("allAuthorWeixinAcount"), ResourceUtil.getSessionUserName().getId());
        if (i == 0) {
            cq.eq("userName", (Object)ResourceUtil.getSessionUserName().getUserName());
        }
        cq.add();
        List menuList = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("accountname");
        treeGridModel.setIcon("accountnumber");
        treeGridModel.setOrder("accounttype");
        treeGridModel.setSrc("accountappid");
        treeGridModel.setParentId("accountappsecret");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("accountlist");
        treeGrids = this.systemService.treegrid(menuList, treeGridModel);
        return treeGrids;
    }

    @RequestMapping(params={"treedata"})
    @ResponseBody
    public List<TreeGrid> treedata(TreeGrid treegrid, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinAccountEntity.class);
        if (treegrid.getId() != null) {
            cq.eq("parentAccount.id", (Object)treegrid.getId());
        } else {
            cq.isNull("parentAccount");
        }
        cq.eq("userName", (Object)ResourceUtil.getSessionUserName().getUserName());
        cq.add();
        List menuList = this.systemService.getListByCriteriaQuery(cq, Boolean.valueOf(false));
        ArrayList<TreeGrid> treeGrids = new ArrayList();
        TreeGridModel treeGridModel = new TreeGridModel();
        treeGridModel.setTextField("accountname");
        treeGridModel.setParentText("parentAccount_accountname");
        treeGridModel.setParentId("parentAccount_id");
        treeGridModel.setSrc("");
        treeGridModel.setIdField("id");
        treeGridModel.setChildList("accountlist");
        treeGrids = this.systemService.treegrid(menuList, treeGridModel);
        return treeGrids;
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinAccountEntity weixinAccount, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinAccountEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinAccount, (Map)request.getParameterMap());
        cq.eq("userName", (Object)ResourceUtil.getSessionUserName().getUserName());
        cq.add();
        this.weixinAccountService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinAccountEntity weixinAccount, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinAccount = (WeixinAccountEntity)this.systemService.getEntity(WeixinAccountEntity.class, (Serializable)((Object)weixinAccount.getId()));
        this.message = "\u5fae\u4fe1\u516c\u4f17\u5e10\u53f7:{0}\uff0c\u4fe1\u606f\u5220\u9664\u6210\u529f\uff0c\u64cd\u4f5c\u4eba\uff1a{1}";
        try {
            List rlist = this.weixinAccountService.findByProperty(WeixinAccountUserRelation.class, "account.id", weixinAccount.getId());
            this.weixinAccountService.deleteAllEntitie(rlist);
            this.weixinAccountService.delete(weixinAccount);
            this.message = MessageFormat.format(this.message, weixinAccount.getAccountname(), ResourceUtil.getSessionUserName().getRealName());
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u4fe1\u516c\u4f17\u5e10\u53f7\u4fe1\u606f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u4fe1\u516c\u4f17\u5e10\u53f7\u4fe1\u606f\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinAccountEntity weixinAccount = (WeixinAccountEntity)this.systemService.getEntity(WeixinAccountEntity.class, (Serializable)((Object)id));
                this.weixinAccountService.delete(weixinAccount);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u4fe1\u516c\u4f17\u5e10\u53f7\u4fe1\u606f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinAccountEntity weixinAccount, HttpServletRequest request, HttpServletResponse response) {
        weixinAccount.setInitDataFlag(WeixinDef.initDataFlag_0);
        AjaxJson j = new AjaxJson();
        WeixinAccountEntity taccount = this.weixinAccountService.findByToUsername(weixinAccount.getWeixinOriginalAccountid());
        if (taccount != null) {
            j.setMsg("\u8be5\u5fae\u4fe1\u516c\u4f17\u5e10\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e");
            j.setSuccess(false);
            return j;
        }
        this.message = "\u5fae\u4fe1\u516c\u4f17\u5e10\u53f7\u4fe1\u606f\u6dfb\u52a0\u6210\u529f";
        try {
            weixinAccount.setUserName(ResourceUtil.getSessionUserName().getUserName());
            if (weixinAccount.getParentAccount() != null && StringUtil.isEmpty((String)weixinAccount.getParentAccount().getId())) {
                weixinAccount.setParentAccount(null);
                String localMaxPostCode = this.weixinAccountService.getMaxLocalPostCode(null);
                weixinAccount.setPostCode(YouBianCodeUtil.getNextYouBianCode((String)localMaxPostCode));
                this.weixinAccountService.save(weixinAccount);
            } else {
                WeixinAccountEntity parentAccount = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)weixinAccount.getParentAccount().getId()));
                String string = parentAccount.getPostCode();
                synchronized (string) {
                    String localMaxPostCode = this.weixinAccountService.getMaxLocalPostCode(parentAccount.getPostCode());
                    weixinAccount.setPostCode(YouBianCodeUtil.getSubYouBianCode((String)parentAccount.getPostCode(), (String)localMaxPostCode));
                    this.weixinAccountService.save(weixinAccount);
                }
            }
            WeixinAccountUserRelation accountUserRelation = new WeixinAccountUserRelation();
            accountUserRelation.setUser((TSUser)this.systemService.get(TSUser.class, (Serializable)((Object)ResourceUtil.getSessionUserName().getId())));
            accountUserRelation.setCreateUserId(ResourceUtil.getSessionUserName().getId());
            accountUserRelation.setAccount(weixinAccount);
            this.systemService.save((Object)accountUserRelation);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
            if (ResourceUtil.onlineShangJiaAccountIdIsNull()) {
                request.getSession().setAttribute("WEIXIN_ACCOUNT", (Object)weixinAccount);
            }
            this.weixinAccountService.saveWeixinExpandconfigInit(weixinAccount.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u4fe1\u516c\u4f17\u5e10\u53f7\u4fe1\u606f\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinAccountEntity weixinAccount, HttpServletRequest request) {
        WeixinAccountEntity taccount;
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u4fe1\u516c\u4f17\u5e10\u53f7\u4fe1\u606f\u66f4\u65b0\u6210\u529f";
        WeixinAccountEntity t = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)weixinAccount.getId()));
        if (!t.getWeixinOriginalAccountid().equals(weixinAccount.getWeixinOriginalAccountid()) && (taccount = this.weixinAccountService.findByToUsername(weixinAccount.getWeixinOriginalAccountid())) != null) {
            j.setMsg("\u8be5\u5fae\u4fe1\u516c\u4f17\u5e10\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e");
            j.setSuccess(false);
            return j;
        }
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinAccount, (Object)t);
            t.setParentAccount(weixinAccount.getParentAccount());
            if (StringUtil.isEmpty((String)t.getParentAccount().getId())) {
                t.setParentAccount(null);
            }
            this.weixinAccountService.saveOrUpdate(t);
            String oldParentAccountId = request.getParameter("oldParentAccountId");
            String oldCode = t.getPostCode();
            if (t.getParentAccount() == null) {
                if (StringUtil.isNotEmpty((Object)oldParentAccountId)) {
                    String newCode = YouBianCodeUtil.getNextYouBianCode((String)this.weixinAccountService.getMaxLocalPostCode(null));
                    this.updatePostCode(oldCode, newCode);
                }
            } else if (!StringUtil.equals((String)oldParentAccountId, (String)t.getParentAccount().getId())) {
                WeixinAccountEntity parentAccount = (WeixinAccountEntity)this.systemService.get(WeixinAccountEntity.class, (Serializable)((Object)t.getParentAccount().getId()));
                String string = parentAccount.getPostCode();
                synchronized (string) {
                    String localMaxPostCode = this.weixinAccountService.getMaxLocalPostCode(parentAccount.getPostCode());
                    String newCode = YouBianCodeUtil.getSubYouBianCode((String)parentAccount.getPostCode(), (String)localMaxPostCode);
                    this.updatePostCode(oldCode, newCode);
                }
            }
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u4fe1\u516c\u4f17\u5e10\u53f7\u4fe1\u606f\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        WeixinAccountEntity weixinAccountEntity = ResourceUtil.getShangJiaAccount();
        if (weixinAccountEntity.getId().equals(t.getId())) {
            weixinAccountEntity = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)t.getId()));
        }
        request.getSession().setAttribute("WEIXIN_ACCOUNT", (Object)weixinAccountEntity);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinAccountEntity weixinAccount, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinAccount.getId())) {
            weixinAccount = (WeixinAccountEntity)this.weixinAccountService.getEntity(WeixinAccountEntity.class, (Serializable)((Object)weixinAccount.getId()));
        }
        if (weixinAccount.getParentAccount() != null && !StringUtil.isEmpty((String)weixinAccount.getParentAccount().getId())) {
            WeixinAccountEntity parent = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)weixinAccount.getParentAccount().getId()));
            req.setAttribute("parent", (Object)parent);
        }
        req.setAttribute("weixinAccountPage", (Object)weixinAccount);
        return new ModelAndView("weixin/guanjia/account/weixinAccount-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinAccountEntity weixinAccount, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinAccount.getId())) {
            weixinAccount = (WeixinAccountEntity)this.weixinAccountService.getEntity(WeixinAccountEntity.class, (Serializable)((Object)weixinAccount.getId()));
            req.setAttribute("weixinAccountPage", (Object)weixinAccount);
        }
        return new ModelAndView("weixin/guanjia/account/weixinAccount-update");
    }

    @RequestMapping(params={"toUpdateCustomDomain"})
    public ModelAndView toUpdateCustomDomain(WeixinAccountEntity weixinAccount, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinAccount.getId())) {
            weixinAccount = (WeixinAccountEntity)this.weixinAccountService.getEntity(WeixinAccountEntity.class, (Serializable)((Object)weixinAccount.getId()));
            req.setAttribute("weixinAccountPage", (Object)weixinAccount);
        }
        return new ModelAndView("weixin/guanjia/account/weixinAccount-customDomain");
    }

    @RequestMapping(params={"doUpdateCustomDomain"})
    @ResponseBody
    public AjaxJson doUpdateCustomDomain(WeixinAccountEntity weixinAccount, HttpServletRequest req) {
        AjaxJson j = new AjaxJson();
        WeixinAccountEntity updateWeixinAccount = (WeixinAccountEntity)this.weixinAccountService.get(WeixinAccountEntity.class, (Serializable)((Object)weixinAccount.getId()));
        updateWeixinAccount.setCustomCallbackDomain(weixinAccount.getCustomCallbackDomain());
        boolean r = this.weixinAccountService.doUpdateSql(updateWeixinAccount);
        j.setSuccess(r);
        return j;
    }

    @RequestMapping(params={"userWeixinAccount"})
    public ModelAndView userWeixinAccount(HttpServletRequest request) {
        String sql = "SELECT tt.id,tt.parent_accountid as pId, accountname as name,'true' as open, case when t.id is null then 'false' else 'true' end as checked, 'plug-in/zTree_v3/css/zTreeStyle/img/weixin.png' as icon FROM weixin_account tt LEFT JOIN weixin_account_user_relation t on t.accountid = tt.id and t.userid = ?";
        String userid = request.getParameter("userid");
        List list = this.weixinAccountService.findForJdbc(sql, new Object[]{userid});
        String treeJSONData = JSON.toJSONString((Object)list);
        request.setAttribute("treeJSONData", (Object)treeJSONData);
        return new ModelAndView("system/user/userWeixinAccount");
    }

    private boolean updatePostCode(String oldCode, String newCode) {
        boolean result = false;
        try {
            String[] tableArray;
            String tableNames = "weixin_account,weixin_menuentity,weixin_newstemplate,weixin_texttemplate,weixin_audiosucai,weixin_videosucai,weixin_photosucai,weixin_groupmessagenewstempalte";
            String[] stringArray = tableArray = tableNames.split(",");
            int n = tableArray.length;
            int n2 = 0;
            while (n2 < n) {
                String tableName = stringArray[n2];
                String sql = "update " + tableName + " t set t.post_code = REPLACE(CONCAT('_',t.post_code),CONCAT('_','" + oldCode + "'),'" + newCode + "') where t.post_code like '" + oldCode + "%'";
                int updateCount = this.systemService.updateBySqlString(sql);
                LogUtil.info((Object)(String.valueOf(tableName) + "\u66f4\u65b0\u4e86" + updateCount + "\u6761\u6570\u636e\u3002"));
                ++n2;
            }
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @RequestMapping(params={"saveUserWeixinAccountRelation"})
    @ResponseBody
    public AjaxJson saveUserWeixinAccountRelation(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String AccountIds = request.getParameter("AccountIds");
        String[] AccountIdArr = AccountIds.split(",");
        String userId = request.getParameter("userId");
        TSUser user = (TSUser)this.weixinAccountService.getEntity(TSUser.class, (Serializable)((Object)userId));
        ArrayList<WeixinAccountUserRelation> accountUserRelations = new ArrayList<WeixinAccountUserRelation>();
        int i = 0;
        while (i < AccountIdArr.length) {
            String AccountId = AccountIdArr[i];
            WeixinAccountUserRelation accountUserRelation = new WeixinAccountUserRelation();
            WeixinAccountEntity account = (WeixinAccountEntity)this.weixinAccountService.getEntity(WeixinAccountEntity.class, (Serializable)((Object)AccountId));
            accountUserRelation.setAccount(account);
            accountUserRelation.setUser(user);
            accountUserRelation.setCreateUserId(ResourceUtil.getSessionUserName().getId());
            accountUserRelations.add(accountUserRelation);
            ++i;
        }
        boolean r = this.weixinAccountService.saveUserWeixinAccountRelation(accountUserRelations, userId);
        j.setSuccess(r);
        return j;
    }

    @RequestMapping(params={"jwDataCubeTaskTest"})
    @ResponseBody
    public AjaxJson jwDataCubeTaskTest(HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String accesstoken = "Ah8oz_tPVk9lI-3jwcR-d_KsG9ZGFYXQA50uuHxJ9-zSuNXBrOEd8xdK9ytsfqN4eJXw6fKDZI5t2hZGQkydPt1PRK9gM1eKOg4_z1Y_n64";
        Calendar cal = Calendar.getInstance();
        int i = 0;
        while (i < 100) {
            System.out.println("\u83b7\u53d6" + DateUtil.formatDate((Date)cal.getTime(), (String)"yyyy-MM-dd") + "\u65e5\u6570\u636e");
            this.getDayData(cal.getTime(), accesstoken, "402881e8461795c201461795c2e90000");
            cal.add(5, -1);
            ++i;
        }
        return j;
    }

    private void getDayData(Date date, String accessToken, String accountId) {
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(5, -1);
            String dateStr = DateUtil.formatDate((Date)cal.getTime(), (String)"yyyy-MM-dd");
            List cubeStreamMsgInfos = JwDataCubeAPI.getWxDataCubeStreamMsgInfo((String)accessToken, (String)dateStr, (String)dateStr);
            String sql = "";
            String delSql = " delete from weixin_data_cube_day where account_id = '" + accountId + "' and ref_date = '" + dateStr + "'";
            this.systemService.executeSql(delSql, new Object[0]);
            if (oConvertUtils.isNotEmpty((Object)cubeStreamMsgInfos) && cubeStreamMsgInfos.size() > 0) {
                for (WxDataCubeStreamMsgInfo wxDataCubeStreamMsgInfo : cubeStreamMsgInfos) {
                    sql = "INSERT INTO weixin_data_cube_day (ID, account_id, msg_type, msg_user, msg_count, ref_date) VALUES (replace(uuid(),'-',''), '" + accountId + "', '" + wxDataCubeStreamMsgInfo.getMsg_type() + "', '" + wxDataCubeStreamMsgInfo.getMsg_user() + "', '" + wxDataCubeStreamMsgInfo.getMsg_count() + "', '" + dateStr + "')";
                }
            } else {
                LogUtil.info((Object)("===================" + dateStr + "," + accountId + "\u6ca1\u6709\u83b7\u53d6\u5230\u6570\u636e==================="));
                sql = "INSERT INTO weixin_data_cube_day (ID, account_id, msg_type, msg_user, msg_count, ref_date) VALUES (replace(uuid(),'-',''), '" + accountId + "', '0', '0', '0', '" + dateStr + "')";
            }
            this.systemService.executeSql(sql, new Object[0]);
        }
        catch (WexinReqException e) {
            e.printStackTrace();
        }
    }
}

