/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.util;

import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateModel;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.jeewx.api.core.common.util.StringTemplateLoader;
import weixin.cms.util.MutiLangTag;

public class CmsFreemarkerHelper {
    private static final Configuration _tplConfig = new Configuration();

    public CmsFreemarkerHelper() {
        _tplConfig.setClassForTemplateLoading(this.getClass(), "/");
        _tplConfig.setNumberFormat("0.#####################");
        MutiLangTag tag = new MutiLangTag();
        _tplConfig.setSharedVariable("MutiLang", (TemplateModel)tag);
    }

    public String parseTemplate(String tplName, String encoding, Map<String, Object> paras) {
        try {
            StringWriter swriter = new StringWriter();
            Template mytpl = _tplConfig.getTemplate(tplName, encoding);
            mytpl.process(paras, (Writer)swriter);
            return swriter.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.toString();
        }
    }

    public boolean isExistTemplate(String tplName) {
        try {
            Template mytpl = _tplConfig.getTemplate(tplName, "UTF-8");
            return mytpl != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void parseTemplate(String tplName, String encoding, Map<String, Object> paras, FileWriter swriter) {
        try {
            Template mytpl = _tplConfig.getTemplate(tplName);
            mytpl.process(paras, (Writer)swriter);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String parseTemplate(String tplName, Map<String, Object> paras) {
        return this.parseTemplate(tplName, "utf-8", paras);
    }

    public String parseTemplateContent(String tplContent, Map<String, Object> paras, String encoding) {
        Configuration cfg = new Configuration();
        StringWriter writer = new StringWriter();
        cfg.setTemplateLoader((TemplateLoader)new StringTemplateLoader(tplContent));
        encoding = encoding == null ? "UTF-8" : encoding;
        cfg.setDefaultEncoding(encoding);
        try {
            Template template = cfg.getTemplate("");
            template.process(paras, (Writer)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public String parseTemplateContent(String tplContent, Map<String, Object> paras) {
        Configuration cfg = new Configuration();
        StringWriter writer = new StringWriter();
        cfg.setTemplateLoader((TemplateLoader)new StringTemplateLoader(tplContent));
        cfg.setDefaultEncoding("UTF-8");
        try {
            Template template = cfg.getTemplate("");
            template.process(paras, (Writer)writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    public void genStaticPage(String tplPath, String tplName, Map<String, Object> paras) {
        block12: {
            Writer out = null;
            try {
                try {
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(tplName), "UTF-8");
                    Template mytpl = null;
                    mytpl = _tplConfig.getTemplate(tplPath, "UTF-8");
                    mytpl.process(paras, out);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (out == null) break block12;
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

