/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Fragmenter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleFragmenter;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.apache.lucene.store.NoSuchDirectoryException;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Version;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import weixin.cms.bean.IndexBean;
import weixin.cms.service.LuceneContentService;
import weixin.cms.service.impl.LuceneContent;

@Service(value="luceneContentService")
public class LuceneContentServiceImpl
implements LuceneContentService {
    @Autowired
    private SystemService systemService;

    @Override
    public void createIndex(String path, String indexTime, String lang) throws Exception {
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(path));
        this.createIndex((Directory)dir, indexTime, lang);
    }

    public void createIndex(Directory dir, String indexTime, String lang) throws Exception {
        boolean exist = IndexReader.indexExists((Directory)dir);
        IndexWriter writer = null;
        ArrayList<IndexBean> ibs = new ArrayList<IndexBean>();
        try {
            try {
                writer = this.createIndexWriter(dir, exist);
                if (indexTime == null) {
                    indexTime = "2014-01-01 00:00:00";
                    List articles = this.systemService.findForJdbc("select id,title,summary,DATE_FORMAT(create_date,'%Y-%m-%d %H:%i:%s') as create_date from weixin_cms_article where create_date > '" + indexTime + "' and lang = '" + lang + "'", null);
                    this.bindIndexBean(ibs, articles, "article");
                    List activitys = this.systemService.findForJdbc("select id,title,summary,DATE_FORMAT(create_date,'%Y-%m-%d %H:%i:%s') as create_date from weixin_ms_activity where create_date > '" + indexTime + "' and lang = '" + lang + "'", null);
                    this.bindIndexBean(ibs, activitys, "msActivityArticle");
                    for (IndexBean ib : ibs) {
                        writer.addDocument(LuceneContent.createDocument(ib));
                    }
                } else {
                    List articles = this.systemService.findForJdbc("select id,title,summary,DATE_FORMAT(create_date,'%Y-%m-%d %H:%i:%s') as create_date from weixin_cms_article where create_date > '" + indexTime + "' and lang = '" + lang + "'", null);
                    this.bindIndexBean(ibs, articles, "article");
                    List activitys = this.systemService.findForJdbc("select id,title,summary,DATE_FORMAT(create_date,'%Y-%m-%d %H:%i:%s') as create_date from weixin_ms_activity where create_date > '" + indexTime + "' and lang = '" + lang + "'", null);
                    this.bindIndexBean(ibs, activitys, "msActivityArticle");
                    List sarticles = this.systemService.findForJdbc("select id,title,summary,DATE_FORMAT(create_date,'%Y-%m-%d %H:%i:%s') as create_date from weixin_cms_article where update_date > '" + indexTime + "' and lang = '" + lang + "'", null);
                    this.bindIndexBean(ibs, sarticles, "article");
                    List sactivitys = this.systemService.findForJdbc("select id,title,summary,DATE_FORMAT(create_date,'%Y-%m-%d %H:%i:%s') as create_date from weixin_ms_activity where update_date > '" + indexTime + "' and lang = '" + lang + "'", null);
                    this.bindIndexBean(ibs, sactivitys, "msActivityArticle");
                    for (IndexBean ib : ibs) {
                        LuceneContent.delete(ib.getId(), writer);
                        writer.addDocument(LuceneContent.createDocument(ib));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void bindIndexBean(List<IndexBean> ibs, List<Map<String, Object>> results, String entityName) {
        for (Map<String, Object> result : results) {
            IndexBean indexBean = new IndexBean();
            indexBean.setId(result.get("id").toString());
            indexBean.setTitle(result.get("title").toString());
            indexBean.setSummary(result.get("summary").toString());
            indexBean.setEntityName(entityName);
            indexBean.setTime((String)result.get("create_date"));
            ibs.add(indexBean);
        }
    }

    private IndexWriter createIndexWriter(Directory dir, boolean exist) throws IOException {
        IndexWriter indexWriter = null;
        try {
            indexWriter = new IndexWriter(dir, (Analyzer)new StandardAnalyzer(Version.LUCENE_30), !exist, IndexWriter.MaxFieldLength.LIMITED);
        }
        catch (LockObtainFailedException e) {
            IndexWriter.unlock((Directory)dir);
            indexWriter = new IndexWriter(dir, (Analyzer)new StandardAnalyzer(Version.LUCENE_30), !exist, IndexWriter.MaxFieldLength.LIMITED);
        }
        return indexWriter;
    }

    public static void main(String[] args) throws Exception {
        LuceneContentServiceImpl s = new LuceneContentServiceImpl();
        s.searchFulltext("D:/workspace/jeewx-pcweb/jeecg-framework/src/main/webapp/template/cms/meishu/fulltext/ZH", "\u54c8\u54c8");
    }

    @Override
    public List<IndexBean> searchFulltext(String path, String keyword) throws Exception {
        SimpleFSDirectory dir = new SimpleFSDirectory(new File(path));
        return this.searchPage((Directory)dir, keyword);
    }

    public List<IndexBean> searchPage(Directory dir, String queryString) throws Exception {
        ArrayList<IndexBean> ibs = new ArrayList<IndexBean>();
        if (queryString == null || "".equals(queryString.trim())) {
            return ibs;
        }
        IndexSearcher searcher = null;
        try {
            try {
                searcher = new IndexSearcher(dir);
                StandardAnalyzer analyzer = new StandardAnalyzer(Version.LUCENE_30);
                Query query = LuceneContent.createQuery(queryString, (Analyzer)analyzer);
                TopDocs docs = searcher.search(query, 10);
                ScoreDoc[] hits = docs.scoreDocs;
                int i = 0;
                while (i < hits.length) {
                    Document d = searcher.doc(hits[i].doc);
                    IndexBean ib = new IndexBean();
                    ib.setId(d.get("ID"));
                    ib.setTitle(this.getHighLighter((Analyzer)analyzer, query, d.get("TITLE")));
                    ib.setSummary(this.getHighLighter((Analyzer)analyzer, query, d.get("SUMMARY")));
                    ib.setEntityName(d.get("ENTITY_NAME"));
                    ib.setTime(d.get("time"));
                    ibs.add(ib);
                    ++i;
                }
            }
            catch (NoSuchDirectoryException noSuchDirectoryException) {
                if (searcher != null) {
                    searcher.close();
                }
            }
        }
        finally {
            if (searcher != null) {
                searcher.close();
            }
        }
        return ibs;
    }

    private String getHighLighter(Analyzer analyzer, Query query, String txt) throws Exception {
        TokenStream tokenStream = analyzer.tokenStream("content", (Reader)new StringReader(txt));
        SimpleHTMLFormatter simpleHTMLFormatter = new SimpleHTMLFormatter("<font color=\"red\">", "</font>");
        Highlighter highlighter = new Highlighter((Formatter)simpleHTMLFormatter, (Scorer)new QueryScorer(query));
        highlighter.setTextFragmenter((Fragmenter)new SimpleFragmenter(100));
        String result = highlighter.getBestFragments(tokenStream, txt, 5, "....");
        if (result == null || result.equals("")) {
            return txt;
        }
        return result;
    }
}

