/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.service.impl;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import weixin.cms.bean.IndexBean;

public class LuceneContent {
    public static final String TITLE = "TITLE";
    public static final String SUMMARY = "SUMMARY";
    public static final String[] QUERY_FIELD = new String[]{"TITLE", "SUMMARY"};
    public static final BooleanClause.Occur[] QUERY_FLAGS = new BooleanClause.Occur[]{BooleanClause.Occur.SHOULD, BooleanClause.Occur.SHOULD};

    public static Document createDocument(IndexBean indexBean) {
        Document doc = new Document();
        doc.add((Fieldable)new Field("ID", indexBean.getId(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field(TITLE, indexBean.getTitle(), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field(SUMMARY, indexBean.getSummary(), Field.Store.YES, Field.Index.ANALYZED));
        doc.add((Fieldable)new Field("ENTITY_NAME", indexBean.getEntityName(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add((Fieldable)new Field("TIME", indexBean.getTime(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        return doc;
    }

    public static Query createQuery(String queryString, Analyzer analyzer) throws ParseException {
        BooleanQuery bq = new BooleanQuery();
        if (!StringUtils.isBlank((String)queryString)) {
            Query q = MultiFieldQueryParser.parse((Version)Version.LUCENE_30, (String)queryString, (String[])QUERY_FIELD, (BooleanClause.Occur[])QUERY_FLAGS, (Analyzer)analyzer);
            bq.add(q, BooleanClause.Occur.MUST);
        }
        return bq;
    }

    public static void delete(String id, IndexWriter writer) throws CorruptIndexException, IOException, ParseException {
        writer.deleteDocuments(new Term("ID", id));
    }
}

