/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.controller;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.tools.zip.ZipEntry;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.ZipUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSDocument;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.entity.WeixinCmsStyleEntity;
import weixin.cms.service.WeixinCmsStyleServiceI;
import weixin.util.DateUtils;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinCmsStyleController"})
public class WeixinCmsStyleController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinCmsStyleController.class);
    @Autowired
    private WeixinCmsStyleServiceI weixinCmsStyleService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinCmsStyle"})
    public ModelAndView weixinCmsStyle(HttpServletRequest request) {
        return new ModelAndView("weixin/cms/style/weixinCmsStyleList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinCmsStyleEntity weixinCmsStyle, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinCmsStyleEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinCmsStyle, (Map)request.getParameterMap());
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        this.weixinCmsStyleService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinCmsStyleEntity weixinCmsStyle, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinCmsStyle = (WeixinCmsStyleEntity)this.systemService.getEntity(WeixinCmsStyleEntity.class, (Serializable)((Object)weixinCmsStyle.getId()));
        this.message = "\u5fae\u7ad9\u70b9\u6a21\u677f\u5220\u9664\u6210\u529f";
        try {
            this.weixinCmsStyleService.delete(weixinCmsStyle);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u7ad9\u70b9\u6a21\u677f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u7ad9\u70b9\u6a21\u677f\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinCmsStyleEntity weixinCmsStyle = (WeixinCmsStyleEntity)this.systemService.getEntity(WeixinCmsStyleEntity.class, (Serializable)((Object)id));
                this.weixinCmsStyleService.delete(weixinCmsStyle);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u7ad9\u70b9\u6a21\u677f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinCmsStyleEntity weixinCmsStyle, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)weixinCmsStyle.getId())) {
            this.message = "\u5fae\u7ad9\u70b9\u6a21\u677f\u66f4\u65b0\u6210\u529f";
            WeixinCmsStyleEntity t = (WeixinCmsStyleEntity)this.weixinCmsStyleService.get(WeixinCmsStyleEntity.class, (Serializable)((Object)weixinCmsStyle.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinCmsStyle, (Object)t);
                this.weixinCmsStyleService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u7ad9\u70b9\u6a21\u677f\u66f4\u65b0\u5931\u8d25";
                throw new BusinessException(e.getMessage());
            }
        }
        this.message = "\u5fae\u7ad9\u70b9\u6a21\u677f\u6dfb\u52a0\u6210\u529f";
        try {
            weixinCmsStyle.setTemplateUrl(weixinCmsStyle.getTemplateName());
            this.weixinCmsStyleService.save(weixinCmsStyle);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u7ad9\u70b9\u6a21\u677f\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        j.setObj((Object)weixinCmsStyle);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinCmsStyleEntity weixinCmsStyle, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u7ad9\u70b9\u6a21\u677f\u66f4\u65b0\u6210\u529f";
        WeixinCmsStyleEntity t = (WeixinCmsStyleEntity)this.weixinCmsStyleService.get(WeixinCmsStyleEntity.class, (Serializable)((Object)weixinCmsStyle.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinCmsStyle, (Object)t);
            this.weixinCmsStyleService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u7ad9\u70b9\u6a21\u677f\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        j.setObj((Object)weixinCmsStyle);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinCmsStyleEntity weixinCmsStyle, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinCmsStyle.getId())) {
            weixinCmsStyle = (WeixinCmsStyleEntity)this.weixinCmsStyleService.getEntity(WeixinCmsStyleEntity.class, (Serializable)((Object)weixinCmsStyle.getId()));
            req.setAttribute("weixinCmsStylePage", (Object)weixinCmsStyle);
        }
        return new ModelAndView("weixin/cms/style/weixinCmsStyle-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinCmsStyleEntity weixinCmsStyle, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinCmsStyle.getId())) {
            weixinCmsStyle = (WeixinCmsStyleEntity)this.weixinCmsStyleService.getEntity(WeixinCmsStyleEntity.class, (Serializable)((Object)weixinCmsStyle.getId()));
            req.setAttribute("weixinCmsStylePage", (Object)weixinCmsStyle);
        }
        return new ModelAndView("weixin/cms/style/weixinCmsStyle-update");
    }

    @RequestMapping(params={"doupload"})
    public ModelAndView doupload(HttpServletRequest req) {
        return new ModelAndView("weixin/cms/style/weixinCmsStyleUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinCmsStyleEntity weixinCmsStyle, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5fae\u7ad9\u70b9\u6a21\u677f";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinCmsStyleEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinCmsStyle, (Map)request.getParameterMap());
                List weixinCmsStyles = this.weixinCmsStyleService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5fae\u7ad9\u70b9\u6a21\u677f\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinCmsStyleEntity.class, (Collection)weixinCmsStyles);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinCmsStyleEntity weixinCmsStyle, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5fae\u7ad9\u70b9\u6a21\u677f";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5fae\u7ad9\u70b9\u6a21\u677f\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinCmsStyleEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinCmsStyleEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinCmsStyleEntity.class, (ImportParams)params);
                    for (WeixinCmsStyleEntity weixinCmsStyle : listWeixinCmsStyleEntitys) {
                        this.weixinCmsStyleService.save(weixinCmsStyle);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }

    @RequestMapping(params={"upload"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson upload(MultipartHttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        String id = request.getParameter("id");
        HashMap<String, String> attributes = new HashMap<String, String>();
        TSTypegroup tsTypegroup = this.systemService.getTypeGroup("fieltype", "\u6587\u6863\u5206\u7c7b");
        TSType tsType = this.systemService.getType("files", "\u9644\u4ef6", tsTypegroup);
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String documentTitle = oConvertUtils.getString((String)request.getParameter("documentTitle"));
        TSDocument document = new TSDocument();
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            document.setId(fileKey);
            document = (TSDocument)this.systemService.getEntity(TSDocument.class, (Serializable)((Object)fileKey));
            document.setDocumentTitle(documentTitle);
        }
        document.setSubclassname(MyClassLoader.getPackPath((Object)document));
        document.setCreatedate(DateUtils.gettimestamp());
        document.setTSType(tsType);
        UploadFile uploadFile = new UploadFile((HttpServletRequest)request, (Object)document);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        document = (TSDocument)this.systemService.uploadFile(uploadFile);
        WeixinCmsStyleEntity weixinCmsStyle = (WeixinCmsStyleEntity)this.weixinCmsStyleService.getEntity(WeixinCmsStyleEntity.class, (Serializable)((Object)id));
        String requestPath = WeixinCmsStyleController.tplRealPath("template/cms");
        String realpath = String.valueOf(requestPath) + "/" + weixinCmsStyle.getAccountid() + "/" + weixinCmsStyle.getTemplateUrl() + "/";
        File tempfolder = new File(realpath);
        if (!tempfolder.exists()) {
            tempfolder.mkdirs();
        }
        this.weixinCmsStyleService.updateEntitie(weixinCmsStyle);
        try {
            String path = String.valueOf(request.getSession().getServletContext().getRealPath("/")) + document.getRealpath();
            ZipUtil.unZip((String)path, (String)(String.valueOf(tempfolder.getAbsolutePath()) + "/"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        attributes.put("url", document.getRealpath());
        attributes.put("fileKey", document.getId());
        attributes.put("name", document.getAttachmenttitle());
        attributes.put("viewhref", "commonController.do?openViewFile&fileid=" + document.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + document.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"downloadTemplate"})
    public void downloadTemplate(HttpServletRequest request, HttpServletResponse response, String id) {
        String url = "default";
        WeixinCmsStyleEntity style = (WeixinCmsStyleEntity)this.weixinCmsStyleService.get(WeixinCmsStyleEntity.class, (Serializable)((Object)id));
        if (style != null) {
            url = style.getTemplateUrl();
        }
        String path = "template/cms/" + ResourceUtil.getShangJiaAccountId() + "/" + url;
        String sourceSrc = WeixinCmsStyleController.tplRealPath(path);
        String downloadSrc = String.valueOf(sourceSrc) + ".zip";
        String fileName = String.valueOf(style.getTemplateName()) + ".zip";
        try {
            WeixinCmsStyleController.compress(sourceSrc, downloadSrc);
            response.reset();
            response.setContentType("APPLICATION/OCTET-STREAM");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-disposition", "attachment;filename=" + new String(fileName.getBytes("utf-8"), "ISO8859-1"));
            FileInputStream inStream = new FileInputStream(downloadSrc);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ((InputStream)inStream).read(buffer, 0, 8192)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytesRead);
            }
            ((OutputStream)out).write(buffer);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            ((InputStream)inStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(params={"downloadDefaultTemplate"})
    public void downloadDefaultTemplate(HttpServletRequest request, HttpServletResponse response) {
        String path = "template/cms/default/";
        String sourceSrc = WeixinCmsStyleController.tplRealPath(path);
        String downloadSrc = String.valueOf(sourceSrc) + ".zip";
        try {
            WeixinCmsStyleController.compress(sourceSrc, downloadSrc);
            String fileName = "jeewx_default.zip";
            response.reset();
            response.setContentType("APPLICATION/OCTET-STREAM");
            BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-disposition", "attachment;filename=" + new String(fileName.getBytes("utf-8"), "ISO8859-1"));
            FileInputStream inStream = new FileInputStream(downloadSrc);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = ((InputStream)inStream).read(buffer, 0, 8192)) != -1) {
                ((OutputStream)out).write(buffer, 0, bytesRead);
            }
            ((OutputStream)out).write(buffer);
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            ((InputStream)inStream).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void compress(String source, String destinct) throws IOException {
        List fileList = WeixinCmsStyleController.loadFilename(new File(source));
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(new File(destinct)));
        byte[] buffere = new byte[8192];
        int i = 0;
        while (i < fileList.size()) {
            int length;
            File file = (File)fileList.get(i);
            zos.putNextEntry((java.util.zip.ZipEntry)new ZipEntry(WeixinCmsStyleController.getEntryName(source, file)));
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            while ((length = bis.read(buffere)) != -1) {
                zos.write(buffere, 0, length);
            }
            bis.close();
            zos.closeEntry();
            ++i;
        }
        zos.close();
    }

    private static String getEntryName(String base, File file) {
        File baseFile = new File(base);
        String filename = file.getPath();
        String entryName = null;
        entryName = baseFile.getParentFile().getParentFile() == null ? filename.substring(baseFile.getParent().length()) : filename.substring(baseFile.getParent().length() + 1);
        int pos = entryName.indexOf(System.getProperty("file.separator"));
        if (pos != -1) {
            entryName = entryName.substring(pos + 1, entryName.length());
        }
        return entryName;
    }

    private static List loadFilename(File file) {
        ArrayList<File> filenameList = new ArrayList<File>();
        if (file.isFile()) {
            filenameList.add(file);
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                filenameList.addAll(WeixinCmsStyleController.loadFilename(f));
                ++n2;
            }
        }
        return filenameList;
    }

    private static String tplRealPath(String refPath) {
        String requestPath = "";
        try {
            if (StringUtils.isEmpty((CharSequence)refPath)) {
                refPath = "";
            }
            requestPath = String.valueOf(WeixinCmsStyleController.class.getClassLoader().getResource("").toURI().getRawPath()) + refPath;
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
        return requestPath;
    }
}

