/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.controller;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.pojo.base.TSDocument;
import org.jeecgframework.web.system.pojo.base.TSType;
import org.jeecgframework.web.system.pojo.base.TSTypegroup;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.common.CmsDataContent;
import weixin.cms.entity.WeixinCmsSiteEntity;
import weixin.cms.entity.WeixinCmsStyleEntity;
import weixin.cms.service.LuceneContentService;
import weixin.cms.service.WeixinCmsSiteServiceI;
import weixin.shop.base.entity.WeixinShopTempletEntity;
import weixin.util.DateUtils;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinCmsSiteController"})
public class WeixinCmsSiteController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinCmsSiteController.class);
    @Autowired
    private WeixinCmsSiteServiceI weixinCmsSiteService;
    @Autowired
    private SystemService systemService;
    @Autowired
    private LuceneContentService luceneContentService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinCmsSite"})
    public ModelAndView weixinCmsSite(HttpServletRequest request) {
        ModelAndView mv = new ModelAndView();
        mv.addObject("lang", (Object)(request.getParameter("lang") == null ? "ZH" : request.getParameter("lang")));
        mv.setViewName("weixin/cms/site/weixinCmsSiteList");
        return mv;
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinCmsSiteEntity weixinCmsSite, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinCmsSiteEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinCmsSite, (Map)request.getParameterMap());
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        cq.add();
        this.weixinCmsSiteService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinCmsSiteEntity weixinCmsSite, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinCmsSite = (WeixinCmsSiteEntity)this.systemService.getEntity(WeixinCmsSiteEntity.class, (Serializable)((Object)weixinCmsSite.getId()));
        this.message = "\u5fae\u7ad9\u70b9\u4fe1\u606f\u5220\u9664\u6210\u529f";
        try {
            this.weixinCmsSiteService.delete(weixinCmsSite);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u7ad9\u70b9\u4fe1\u606f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u7ad9\u70b9\u4fe1\u606f\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinCmsSiteEntity weixinCmsSite = (WeixinCmsSiteEntity)this.systemService.getEntity(WeixinCmsSiteEntity.class, (Serializable)((Object)id));
                this.weixinCmsSiteService.delete(weixinCmsSite);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u7ad9\u70b9\u4fe1\u606f\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinCmsSiteEntity weixinCmsSite, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String lang = request.getParameter("lang");
        List lst = this.weixinCmsSiteService.findByQueryString("from WeixinCmsSiteEntity where lang ='" + lang + "' and accountid = '" + ResourceUtil.getShangJiaAccountId() + "'");
        if (lst.size() != 0) {
            this.message = "\u6bcf\u4e2a\u7528\u6237\u53ea\u80fd\u6dfb\u52a0\u4e00\u4e2a\u5fae\u4fe1\u7ad9\u70b9";
            j.setSuccess(false);
        } else {
            this.message = "\u5fae\u7ad9\u70b9\u4fe1\u606f\u6dfb\u52a0\u6210\u529f";
            try {
                this.weixinCmsSiteService.save(weixinCmsSite);
                this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u5fae\u7ad9\u70b9\u4fe1\u606f\u6dfb\u52a0\u5931\u8d25";
                throw new BusinessException(e.getMessage());
            }
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinCmsSiteEntity weixinCmsSite, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5fae\u7ad9\u70b9\u4fe1\u606f\u66f4\u65b0\u6210\u529f";
        WeixinCmsSiteEntity t = (WeixinCmsSiteEntity)this.weixinCmsSiteService.get(WeixinCmsSiteEntity.class, (Serializable)((Object)weixinCmsSite.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinCmsSite, (Object)t);
            this.weixinCmsSiteService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5fae\u7ad9\u70b9\u4fe1\u606f\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinCmsSiteEntity weixinCmsSite, HttpServletRequest req) {
        ModelAndView mv = new ModelAndView();
        if (StringUtil.isNotEmpty((Object)weixinCmsSite.getId())) {
            weixinCmsSite = (WeixinCmsSiteEntity)this.weixinCmsSiteService.getEntity(WeixinCmsSiteEntity.class, (Serializable)((Object)weixinCmsSite.getId()));
            req.setAttribute("weixinCmsSitePage", (Object)weixinCmsSite);
        }
        mv.addObject("lang", (Object)req.getParameter("lang"));
        ArrayList sharetemplateList = this.systemService.findHql("from WeixinShopTempletEntity where publiced=1 and tpltype=2", null);
        ArrayList selfttemplateList = this.systemService.findHql("from WeixinShopTempletEntity where accountid=? and tpltype=2", new Object[]{ResourceUtil.getShangJiaAccountId()});
        if (oConvertUtils.isEmpty((Object)sharetemplateList)) {
            sharetemplateList = new ArrayList();
        }
        if (oConvertUtils.isEmpty((Object)selfttemplateList)) {
            selfttemplateList = new ArrayList();
        }
        sharetemplateList.addAll(selfttemplateList);
        ArrayList<WeixinShopTempletEntity> templateList = new ArrayList<WeixinShopTempletEntity>();
        HashMap<String, String> container = new HashMap<String, String>();
        for (WeixinShopTempletEntity tpl : sharetemplateList) {
            if (container.containsKey(tpl.getId())) continue;
            container.put(tpl.getId(), "1");
            templateList.add(tpl);
        }
        req.setAttribute("templateList", templateList);
        mv.setViewName("weixin/cms/site/weixinCmsSite-add");
        return mv;
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinCmsSiteEntity weixinCmsSite, HttpServletRequest req) {
        ModelAndView mv = new ModelAndView();
        if (StringUtil.isNotEmpty((Object)weixinCmsSite.getId())) {
            weixinCmsSite = (WeixinCmsSiteEntity)this.weixinCmsSiteService.getEntity(WeixinCmsSiteEntity.class, (Serializable)((Object)weixinCmsSite.getId()));
            req.setAttribute("weixinCmsSitePage", (Object)weixinCmsSite);
        }
        mv.addObject("lang", (Object)req.getParameter("lang"));
        ArrayList sharetemplateList = this.systemService.findHql("from WeixinShopTempletEntity where publiced=1 and tpltype=2", null);
        ArrayList selfttemplateList = this.systemService.findHql("from WeixinShopTempletEntity where accountid=? and tpltype=2", new Object[]{ResourceUtil.getShangJiaAccountId()});
        if (oConvertUtils.isEmpty((Object)sharetemplateList)) {
            sharetemplateList = new ArrayList();
        }
        if (oConvertUtils.isEmpty((Object)selfttemplateList)) {
            selfttemplateList = new ArrayList();
        }
        sharetemplateList.addAll(selfttemplateList);
        ArrayList<WeixinShopTempletEntity> templateList = new ArrayList<WeixinShopTempletEntity>();
        HashMap<String, String> container = new HashMap<String, String>();
        for (WeixinShopTempletEntity tpl : sharetemplateList) {
            if (container.containsKey(tpl.getId())) continue;
            container.put(tpl.getId(), "1");
            templateList.add(tpl);
        }
        req.setAttribute("templateList", templateList);
        mv.setViewName("weixin/cms/site/weixinCmsSite-update");
        return mv;
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/cms/site/weixinCmsSiteUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinCmsSiteEntity weixinCmsSite, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5fae\u7ad9\u70b9\u4fe1\u606f";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinCmsSiteEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinCmsSite, (Map)request.getParameterMap());
                List weixinCmsSites = this.weixinCmsSiteService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5fae\u7ad9\u70b9\u4fe1\u606f\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinCmsSiteEntity.class, (Collection)weixinCmsSites);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinCmsSiteEntity weixinCmsSite, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u5fae\u7ad9\u70b9\u4fe1\u606f";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u5fae\u7ad9\u70b9\u4fe1\u606f\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinCmsSiteEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinCmsSiteEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinCmsSiteEntity.class, (ImportParams)params);
                    for (WeixinCmsSiteEntity weixinCmsSite : listWeixinCmsSiteEntitys) {
                        this.weixinCmsSiteService.save(weixinCmsSite);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }

    @RequestMapping(params={"upload"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson upload(MultipartHttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        TSTypegroup tsTypegroup = this.systemService.getTypeGroup("fieltype", "\u6587\u6863\u5206\u7c7b");
        TSType tsType = this.systemService.getType("files", "\u9644\u4ef6", tsTypegroup);
        String fileKey = oConvertUtils.getString((String)request.getParameter("fileKey"));
        String documentTitle = oConvertUtils.getString((String)request.getParameter("documentTitle"));
        TSDocument document = new TSDocument();
        if (StringUtil.isNotEmpty((Object)fileKey)) {
            document.setId(fileKey);
            document = (TSDocument)this.systemService.getEntity(TSDocument.class, (Serializable)((Object)fileKey));
            document.setDocumentTitle(documentTitle);
        }
        document.setSubclassname(MyClassLoader.getPackPath((Object)document));
        document.setCreatedate(DateUtils.gettimestamp());
        document.setTSType(tsType);
        UploadFile uploadFile = new UploadFile((HttpServletRequest)request, (Object)document);
        uploadFile.setCusPath("files");
        uploadFile.setSwfpath("swfpath");
        document = (TSDocument)this.systemService.uploadFile(uploadFile);
        attributes.put("url", document.getRealpath());
        attributes.put("fileKey", document.getId());
        attributes.put("name", document.getAttachmenttitle());
        attributes.put("viewhref", "commonController.do?openViewFile&fileid=" + document.getId());
        attributes.put("delurl", "commonController.do?delObjFile&fileKey=" + document.getId());
        j.setMsg("\u6587\u4ef6\u6dfb\u52a0\u6210\u529f");
        j.setAttributes(attributes);
        return j;
    }

    @RequestMapping(params={"clearStaticDir"})
    @ResponseBody
    public AjaxJson clearStaticDir(WeixinCmsSiteEntity weixinCmsSite, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u9759\u6001\u9875\u5220\u9664\u6210\u529f";
        try {
            String rootUrl = request.getSession().getServletContext().getRealPath("/template/cms");
            String accountId = request.getParameter("accountid");
            accountId = StringUtils.isEmpty((CharSequence)accountId) ? ResourceUtil.getShangJiaAccountId() : accountId;
            String styleUrl = null;
            WeixinCmsSiteEntity weixinCmsSiteEntity = null;
            String lang = request.getParameter("lang");
            List list = this.weixinCmsSiteService.findByQueryString("from WeixinCmsSiteEntity where lang ='" + lang + "' and accountid = '" + accountId + "'");
            if (list != null && list.size() > 0) {
                weixinCmsSiteEntity = (WeixinCmsSiteEntity)list.get(0);
            }
            WeixinCmsStyleEntity weixinCmsStyleEntity = null;
            if (weixinCmsSiteEntity != null) {
                CmsDataContent.put("title", weixinCmsSiteEntity.getSiteName());
                CmsDataContent.put("logo", weixinCmsSiteEntity.getSiteLogo());
                if (weixinCmsSiteEntity.getSiteTemplateStyle() != null) {
                    weixinCmsStyleEntity = (WeixinCmsStyleEntity)this.weixinCmsSiteService.get(WeixinCmsStyleEntity.class, (Serializable)((Object)weixinCmsSiteEntity.getSiteTemplateStyle()));
                }
                styleUrl = weixinCmsStyleEntity != null ? String.valueOf(rootUrl) + "/" + ResourceUtil.getShangJiaAccountId() + "/" + weixinCmsStyleEntity.getTemplateUrl() + "/html/" : String.valueOf(rootUrl) + "/meishu/html/";
            } else {
                styleUrl = String.valueOf(rootUrl) + "/meishu/html/";
            }
            String staticDir = String.valueOf(styleUrl) + "static" + "/" + lang + "/";
            File file = new File(staticDir);
            if (file.exists()) {
                WeixinCmsSiteController.deleteDir(file);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u9759\u6001\u9875\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    private static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            int i = 0;
            while (i < children.length) {
                boolean success = WeixinCmsSiteController.deleteDir(new File(dir, children[i]));
                if (!success) {
                    return false;
                }
                ++i;
            }
        } else {
            dir.delete();
        }
        return true;
    }

    @RequestMapping(params={"doIndex"})
    @ResponseBody
    public AjaxJson doIndex(WeixinCmsSiteEntity weixinCmsSite, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u5168\u6587\u7d22\u5f15\u6210\u529f";
        try {
            Date indexTime = null;
            String rootUrl = request.getSession().getServletContext().getRealPath("/template/cms");
            String accountId = request.getParameter("accountid");
            String styleUrl = null;
            WeixinCmsSiteEntity weixinCmsSiteEntity = null;
            String lang = request.getParameter("lang");
            weixinCmsSiteEntity = (WeixinCmsSiteEntity)this.weixinCmsSiteService.get(WeixinCmsSiteEntity.class, (Serializable)((Object)weixinCmsSite.getId()));
            WeixinCmsStyleEntity weixinCmsStyleEntity = null;
            if (weixinCmsSiteEntity != null) {
                CmsDataContent.put("title", weixinCmsSiteEntity.getSiteName());
                CmsDataContent.put("logo", weixinCmsSiteEntity.getSiteLogo());
                if (weixinCmsSiteEntity.getSiteTemplateStyle() != null) {
                    weixinCmsStyleEntity = (WeixinCmsStyleEntity)this.weixinCmsSiteService.get(WeixinCmsStyleEntity.class, (Serializable)((Object)weixinCmsSiteEntity.getSiteTemplateStyle()));
                }
                styleUrl = weixinCmsStyleEntity != null ? String.valueOf(rootUrl) + "/" + ResourceUtil.getShangJiaAccountId() + "/" + weixinCmsStyleEntity.getTemplateUrl() + "/html/" : String.valueOf(rootUrl) + "/meishu/html/";
                indexTime = weixinCmsSiteEntity.getIndexTime();
            } else {
                styleUrl = String.valueOf(rootUrl) + "/meishu/html/";
            }
            String indexDir = String.valueOf(styleUrl) + "fullText" + "/" + lang + "/";
            String date = null;
            date = indexTime == null ? null : DateUtils.date2Str(indexTime, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            this.luceneContentService.createIndex(indexDir, date, lang);
            weixinCmsSiteEntity.setIndexTime(new Date());
            this.weixinCmsSiteService.updateEntitie(weixinCmsSiteEntity);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u5168\u6587\u7d22\u5f15\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }
}

