/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.controller;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.MyClassLoader;
import org.jeecgframework.core.util.ReflectHelper;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.core.util.oConvertUtils;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.entity.WeixinCmsShareFilesEntity;
import weixin.cms.service.WeixinCmsShareFilesServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinCmsShareFilesController"})
public class WeixinCmsShareFilesController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinCmsShareFilesController.class);
    @Autowired
    private WeixinCmsShareFilesServiceI weixinCmsShareFilesService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinCmsShareFiles"})
    public ModelAndView weixinCmsShareFiles(HttpServletRequest request) {
        request.setAttribute("subclassname", (Object)"WeixinCmsShareFiles");
        ModelAndView mv = new ModelAndView();
        mv.addObject("lang", (Object)(request.getParameter("lang") == null ? "ZH" : request.getParameter("lang")));
        mv.setViewName("weixin/cms/sharefiles/weixinCmsShareFilesList");
        return mv;
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinCmsShareFilesEntity weixinCmsShareFiles, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinCmsShareFilesEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinCmsShareFiles, (Map)request.getParameterMap());
        this.weixinCmsShareFilesService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"datagridwx"})
    public void datagridwx(WeixinCmsShareFilesEntity weixinCmsShareFiles, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinCmsShareFilesEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinCmsShareFiles, (Map)request.getParameterMap());
        this.weixinCmsShareFilesService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinCmsShareFilesEntity weixinCmsShareFiles, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinCmsShareFiles = (WeixinCmsShareFilesEntity)this.systemService.getEntity(WeixinCmsShareFilesEntity.class, (Serializable)((Object)weixinCmsShareFiles.getId()));
        this.message = "\u8d44\u6599\u5206\u4eab\u5220\u9664\u6210\u529f";
        this.weixinCmsShareFilesService.delete(weixinCmsShareFiles);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinCmsShareFilesEntity weixinCmsShareFiles, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)weixinCmsShareFiles.getId())) {
            this.message = "\u8d44\u6599\u5206\u4eab\u66f4\u65b0\u6210\u529f";
            WeixinCmsShareFilesEntity t = (WeixinCmsShareFilesEntity)this.weixinCmsShareFilesService.get(WeixinCmsShareFilesEntity.class, (Serializable)((Object)weixinCmsShareFiles.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinCmsShareFiles, (Object)t);
                this.weixinCmsShareFilesService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u8d44\u6599\u5206\u4eab\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u8d44\u6599\u5206\u4eab\u6dfb\u52a0\u6210\u529f";
            this.weixinCmsShareFilesService.save(weixinCmsShareFiles);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("fileId", weixinCmsShareFiles.getId());
        j.setAttributes(attr);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinCmsShareFilesEntity weixinCmsShareFiles, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinCmsShareFiles.getId())) {
            weixinCmsShareFiles = (WeixinCmsShareFilesEntity)this.weixinCmsShareFilesService.getEntity(WeixinCmsShareFilesEntity.class, (Serializable)((Object)weixinCmsShareFiles.getId()));
            req.setAttribute("weixinCmsShareFilesPage", (Object)weixinCmsShareFiles);
        }
        ModelAndView mv = new ModelAndView();
        mv.addObject("lang", (Object)req.getParameter("lang"));
        mv.setViewName("weixin/cms/sharefiles/weixinCmsShareFiles");
        return mv;
    }

    @RequestMapping(params={"uploadFile"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson uploadFile(HttpServletRequest request, HttpServletResponse response, WeixinCmsShareFilesEntity weixinCmsShareFiles) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String fileId = request.getParameter("fileId");
        WeixinCmsShareFilesEntity tmp = (WeixinCmsShareFilesEntity)this.systemService.getEntity(WeixinCmsShareFilesEntity.class, (Serializable)((Object)fileId));
        UploadFile uploadFile = new UploadFile(request, (Object)tmp);
        uploadFile.setCusPath("files");
        uploadFile.setByteField(null);
        weixinCmsShareFiles = (WeixinCmsShareFilesEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", weixinCmsShareFiles.getId());
        return j;
    }

    @RequestMapping(params={"viewFile"})
    public void viewFile(HttpServletRequest request, HttpServletResponse response) {
        String fileid = oConvertUtils.getString((String)request.getParameter("fileid"));
        String subclassname = oConvertUtils.getString((String)request.getParameter("subclassname"), (String)"com.jeecg.base.pojo.TSAttachment");
        Class fileClass = MyClassLoader.getClassByScn((String)subclassname);
        Object fileobj = this.systemService.getEntity(fileClass, (Serializable)((Object)fileid));
        ReflectHelper reflectHelper = new ReflectHelper(fileobj);
        UploadFile uploadFile = new UploadFile(request, response);
        String contentfield = oConvertUtils.getString((String)request.getParameter("contentfield"), (String)uploadFile.getByteField());
        byte[] content = (byte[])reflectHelper.getMethodValue(contentfield);
        String path = oConvertUtils.getString((Object)reflectHelper.getMethodValue("realpath"));
        String extend = oConvertUtils.getString((Object)reflectHelper.getMethodValue("extend"));
        String attachmenttitle = oConvertUtils.getString((Object)reflectHelper.getMethodValue("attachmenttitle"));
        uploadFile.setExtend(extend);
        uploadFile.setTitleField(attachmenttitle);
        uploadFile.setRealPath(path);
        uploadFile.setContent(content);
        this.systemService.viewOrDownloadFile(uploadFile);
    }
}

