/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.controller;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.exception.BusinessException;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.BrowserUtils;
import org.jeecgframework.core.util.ExceptionUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.poi.excel.ExcelExportUtil;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExcelTitle;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.tag.vo.datatable.SortDirection;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.entity.WeixinCmsDataCollectEntity;
import weixin.cms.service.WeixinCmsDataCollectServiceI;
import weixin.cms.util.CmsCollectExcutor;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinCmsDataCollectController"})
public class WeixinCmsDataCollectController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinCmsDataCollectController.class);
    @Autowired
    private WeixinCmsDataCollectServiceI weixinCmsDataCollectService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinCmsDataCollect"})
    public ModelAndView weixinCmsDataCollect(HttpServletRequest request) {
        return new ModelAndView("weixin/cms/collect/weixinCmsDataCollectList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinCmsDataCollectEntity weixinCmsDataCollect, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinCmsDataCollectEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinCmsDataCollect, (Map)request.getParameterMap());
        try {
            cq.addOrder("module", SortDirection.asc);
        }
        catch (Exception e) {
            throw new BusinessException(e.getMessage());
        }
        cq.add();
        this.weixinCmsDataCollectService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"doFresh"})
    @ResponseBody
    public AjaxJson doFresh(WeixinCmsDataCollectEntity weixinCmsDataCollect, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6570\u636e\u6536\u96c6\u5668\u7f13\u5b58\u66f4\u65b0\u6210\u529f";
        try {
            CmsCollectExcutor.freshAllDataCollect();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6570\u636e\u6536\u96c6\u5668\u7f13\u5b58\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doDel"})
    @ResponseBody
    public AjaxJson doDel(WeixinCmsDataCollectEntity weixinCmsDataCollect, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinCmsDataCollect = (WeixinCmsDataCollectEntity)this.systemService.getEntity(WeixinCmsDataCollectEntity.class, (Serializable)((Object)weixinCmsDataCollect.getId()));
        this.message = "\u6570\u636e\u6536\u96c6\u5668\u7ba1\u7406\u5220\u9664\u6210\u529f";
        try {
            this.weixinCmsDataCollectService.delete(weixinCmsDataCollect);
            this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6570\u636e\u6536\u96c6\u5668\u7ba1\u7406\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doBatchDel"})
    @ResponseBody
    public AjaxJson doBatchDel(String ids, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6570\u636e\u6536\u96c6\u5668\u7ba1\u7406\u5220\u9664\u6210\u529f";
        try {
            String[] stringArray = ids.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                WeixinCmsDataCollectEntity weixinCmsDataCollect = (WeixinCmsDataCollectEntity)this.systemService.getEntity(WeixinCmsDataCollectEntity.class, (Serializable)((Object)id));
                this.weixinCmsDataCollectService.delete(weixinCmsDataCollect);
                this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6570\u636e\u6536\u96c6\u5668\u7ba1\u7406\u5220\u9664\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doAdd"})
    @ResponseBody
    public AjaxJson doAdd(WeixinCmsDataCollectEntity weixinCmsDataCollect, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6570\u636e\u6536\u96c6\u5668\u7ba1\u7406\u6dfb\u52a0\u6210\u529f";
        try {
            this.weixinCmsDataCollectService.save(weixinCmsDataCollect);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6570\u636e\u6536\u96c6\u5668\u7ba1\u7406\u6dfb\u52a0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"doUpdate"})
    @ResponseBody
    public AjaxJson doUpdate(WeixinCmsDataCollectEntity weixinCmsDataCollect, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        this.message = "\u6570\u636e\u6536\u96c6\u5668\u7ba1\u7406\u66f4\u65b0\u6210\u529f";
        WeixinCmsDataCollectEntity t = (WeixinCmsDataCollectEntity)this.weixinCmsDataCollectService.get(WeixinCmsDataCollectEntity.class, (Serializable)((Object)weixinCmsDataCollect.getId()));
        try {
            MyBeanUtils.copyBeanNotNull2Bean((Object)weixinCmsDataCollect, (Object)t);
            this.weixinCmsDataCollectService.saveOrUpdate(t);
            this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.message = "\u6570\u636e\u6536\u96c6\u5668\u7ba1\u7406\u66f4\u65b0\u5931\u8d25";
            throw new BusinessException(e.getMessage());
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"goAdd"})
    public ModelAndView goAdd(WeixinCmsDataCollectEntity weixinCmsDataCollect, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinCmsDataCollect.getId())) {
            weixinCmsDataCollect = (WeixinCmsDataCollectEntity)this.weixinCmsDataCollectService.getEntity(WeixinCmsDataCollectEntity.class, (Serializable)((Object)weixinCmsDataCollect.getId()));
            req.setAttribute("weixinCmsDataCollectPage", (Object)weixinCmsDataCollect);
        }
        return new ModelAndView("weixin/cms/collect/weixinCmsDataCollect-add");
    }

    @RequestMapping(params={"goUpdate"})
    public ModelAndView goUpdate(WeixinCmsDataCollectEntity weixinCmsDataCollect, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinCmsDataCollect.getId())) {
            weixinCmsDataCollect = (WeixinCmsDataCollectEntity)this.weixinCmsDataCollectService.getEntity(WeixinCmsDataCollectEntity.class, (Serializable)((Object)weixinCmsDataCollect.getId()));
            req.setAttribute("weixinCmsDataCollectPage", (Object)weixinCmsDataCollect);
        }
        return new ModelAndView("weixin/cms/collect/weixinCmsDataCollect-update");
    }

    @RequestMapping(params={"upload"})
    public ModelAndView upload(HttpServletRequest req) {
        return new ModelAndView("weixin/cms/collect/weixinCmsDataCollectUpload");
    }

    @RequestMapping(params={"exportXls"})
    public void exportXls(WeixinCmsDataCollectEntity weixinCmsDataCollect, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u6570\u636e\u6536\u96c6\u5668\u7ba1\u7406";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                CriteriaQuery cq = new CriteriaQuery(WeixinCmsDataCollectEntity.class, dataGrid);
                HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinCmsDataCollect, (Map)request.getParameterMap());
                List weixinCmsDataCollects = this.weixinCmsDataCollectService.getListByCriteriaQuery(cq, false);
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u6570\u636e\u6536\u96c6\u5668\u7ba1\u7406\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinCmsDataCollectEntity.class, (Collection)weixinCmsDataCollects);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"exportXlsByT"})
    public void exportXlsByT(WeixinCmsDataCollectEntity weixinCmsDataCollect, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        response.setContentType("application/vnd.ms-excel");
        String codedFileName = null;
        OutputStream fOut = null;
        try {
            try {
                codedFileName = "\u6570\u636e\u6536\u96c6\u5668\u7ba1\u7406";
                if (BrowserUtils.isIE((HttpServletRequest)request)) {
                    response.setHeader("content-disposition", "attachment;filename=" + URLEncoder.encode(codedFileName, "UTF-8") + ".xls");
                } else {
                    String newtitle = new String(codedFileName.getBytes("UTF-8"), "ISO8859-1");
                    response.setHeader("content-disposition", "attachment;filename=" + newtitle + ".xls");
                }
                HSSFWorkbook workbook = null;
                workbook = ExcelExportUtil.exportExcel((ExcelTitle)new ExcelTitle("\u6570\u636e\u6536\u96c6\u5668\u7ba1\u7406\u5217\u8868", "\u5bfc\u51fa\u4eba:" + ResourceUtil.getSessionUserName().getRealName(), "\u5bfc\u51fa\u4fe1\u606f"), WeixinCmsDataCollectEntity.class, null);
                fOut = response.getOutputStream();
                workbook.write(fOut);
            }
            catch (Exception exception) {
                try {
                    fOut.flush();
                    fOut.close();
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                fOut.flush();
                fOut.close();
            }
            catch (IOException iOException) {}
        }
    }

    @RequestMapping(params={"importExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson importExcel(HttpServletRequest request, HttpServletResponse response) {
        AjaxJson j = new AjaxJson();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setSecondTitleRows(1);
            params.setNeedSave(true);
            try {
                try {
                    List listWeixinCmsDataCollectEntitys = (List)ExcelImportUtil.importExcelByIs((InputStream)file.getInputStream(), WeixinCmsDataCollectEntity.class, (ImportParams)params);
                    for (WeixinCmsDataCollectEntity weixinCmsDataCollect : listWeixinCmsDataCollectEntitys) {
                        this.weixinCmsDataCollectService.save(weixinCmsDataCollect);
                    }
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u6210\u529f\uff01");
                }
                catch (Exception e) {
                    j.setMsg("\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                    logger.error((Object)ExceptionUtil.getExceptionMessage((Exception)e));
                    try {
                        file.getInputStream().close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                file.getInputStream().close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return j;
    }
}

