/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.controller;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.common.LocaleUtil;
import weixin.cms.entity.WeixinCmsArticleCommentEntity;
import weixin.cms.service.WeixinCmsArticleCommentServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/weixinCmsArticleCommentController"})
public class WeixinCmsArticleCommentController
extends BaseController {
    private static final Logger logger = Logger.getLogger(WeixinCmsArticleCommentController.class);
    @Autowired
    private WeixinCmsArticleCommentServiceI weixinCmsArticleCommentService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"weixinCmsArticleComment"})
    public ModelAndView weixinCmsArticleComment(HttpServletRequest request) {
        return new ModelAndView("weixin/cms/articlecomment/weixinCmsArticleCommentList");
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(WeixinCmsArticleCommentEntity weixinCmsArticleComment, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(WeixinCmsArticleCommentEntity.class, dataGrid);
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)weixinCmsArticleComment, (Map)request.getParameterMap());
        this.weixinCmsArticleCommentService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(WeixinCmsArticleCommentEntity weixinCmsArticleComment, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        weixinCmsArticleComment = (WeixinCmsArticleCommentEntity)this.systemService.getEntity(WeixinCmsArticleCommentEntity.class, (Serializable)((Object)weixinCmsArticleComment.getId()));
        this.message = "\u6587\u7ae0\u8bc4\u8bba\u5220\u9664\u6210\u529f";
        this.weixinCmsArticleCommentService.delete(weixinCmsArticleComment);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(WeixinCmsArticleCommentEntity weixinCmsArticleComment, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)weixinCmsArticleComment.getId())) {
            this.message = "\u6587\u7ae0\u8bc4\u8bba\u66f4\u65b0\u6210\u529f";
            WeixinCmsArticleCommentEntity t = (WeixinCmsArticleCommentEntity)this.weixinCmsArticleCommentService.get(WeixinCmsArticleCommentEntity.class, (Serializable)((Object)weixinCmsArticleComment.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)weixinCmsArticleComment, (Object)t);
                this.weixinCmsArticleCommentService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u6587\u7ae0\u8bc4\u8bba\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u6587\u7ae0\u8bc4\u8bba\u6dfb\u52a0\u6210\u529f";
            this.weixinCmsArticleCommentService.save(weixinCmsArticleComment);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"cmsCommentsSave"})
    @ResponseBody
    public AjaxJson cmsCommentsSave(WeixinCmsArticleCommentEntity weixinCmsArticleComment, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        String lang = LocaleUtil.getLocaleLang();
        try {
            this.message = "EN".equals(lang) ? "Comments submitted" : ("ZH".equals(lang) ? "\u8bc4\u8bba\u63d0\u4ea4\u6210\u529f" : "\u8bc4\u8bba\u63d0\u4ea4\u6210\u529f");
            weixinCmsArticleComment.setCommentTime(new Date());
            weixinCmsArticleComment.setStatus(2);
            weixinCmsArticleComment.setAuditor("system");
            weixinCmsArticleComment.setAuditTime(new Date());
            this.weixinCmsArticleCommentService.save(weixinCmsArticleComment);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
            j.setSuccess(false);
            this.message = "EN".equals(lang) ? "Comment submit failed" : ("ZH".equals(lang) ? "\u8bc4\u8bba \u63d0\u4ea4\u5931\u8d25" : "\u8bc4\u8bba \u63d0\u4ea4\u5931\u8d25");
        }
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(WeixinCmsArticleCommentEntity weixinCmsArticleComment, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)weixinCmsArticleComment.getId())) {
            weixinCmsArticleComment = (WeixinCmsArticleCommentEntity)this.weixinCmsArticleCommentService.getEntity(WeixinCmsArticleCommentEntity.class, (Serializable)((Object)weixinCmsArticleComment.getId()));
            req.setAttribute("weixinCmsArticleCommentPage", (Object)weixinCmsArticleComment);
        }
        return new ModelAndView("weixin/cms/articlecomment/weixinCmsArticleComment");
    }
}

