/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.controller;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecgframework.core.util.ApplicationContextUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.LocaleResolver;
import weixin.cms.common.CmsDataContent;
import weixin.cms.common.LocaleUtil;
import weixin.cms.entity.CmsArticleEntity;
import weixin.cms.service.CmsArticleServiceI;
import weixin.cms.service.CmsMenuServiceI;

@Controller
@RequestMapping(value={"/global"})
public class GlobalController {
    @Autowired
    private CmsMenuServiceI cmsMenuService;
    @Autowired
    private CmsArticleServiceI cmsArticelService;
    @Autowired
    private LocaleResolver localeResolver;

    @RequestMapping(params={"changeLocale"})
    public String changeLocal(@RequestParam(value="langType", defaultValue="ZH") String langType, HttpServletRequest request, HttpServletResponse response) {
        if ("ZH".equals(langType)) {
            Locale locale = new Locale("ZH", "CN");
            this.localeResolver.setLocale(request, response, locale);
            List<Map<String, Object>> meunListMap = this.cmsMenuService.listMap(null);
            CmsDataContent.put("menuList", meunListMap);
            CmsArticleServiceI cmsArticelService = (CmsArticleServiceI)ApplicationContextUtil.getContext().getBean("cmsArticleService");
            String lang = LocaleUtil.getLocaleLang();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("lang", lang);
            List<CmsArticleEntity> listArticle = cmsArticelService.getMaxView(params);
            CmsDataContent.put("hotArticle", listArticle);
        } else if ("EN".equals(langType)) {
            Locale locale = new Locale("EN", "US");
            this.localeResolver.setLocale(request, response, locale);
            List<Map<String, Object>> meunListMap = this.cmsMenuService.listMap(null);
            CmsDataContent.put("menuList", meunListMap);
            String lang = LocaleUtil.getLocaleLang();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("lang", lang);
            List<CmsArticleEntity> listArticle = this.cmsArticelService.getMaxView(params);
        } else {
            this.localeResolver.setLocale(request, response, LocaleContextHolder.getLocale());
        }
        return "redirect:rest/cmsController/page/index";
    }
}

