/*
 * Decompiled with CFR 0.152.
 */
package weixin.cms.controller;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jeecgframework.core.common.controller.BaseController;
import org.jeecgframework.core.common.hibernate.qbc.CriteriaQuery;
import org.jeecgframework.core.common.model.common.UploadFile;
import org.jeecgframework.core.common.model.json.AjaxJson;
import org.jeecgframework.core.common.model.json.DataGrid;
import org.jeecgframework.core.constant.Globals;
import org.jeecgframework.core.extend.hqlsearch.HqlGenerateUtil;
import org.jeecgframework.core.util.MyBeanUtils;
import org.jeecgframework.core.util.ResourceUtil;
import org.jeecgframework.core.util.StringUtil;
import org.jeecgframework.tag.core.easyui.TagUtil;
import org.jeecgframework.web.system.service.SystemService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import weixin.cms.entity.FriendlyLinkEntity;
import weixin.cms.service.FriendlyLinkServiceI;

@Scope(value="prototype")
@Controller
@RequestMapping(value={"/friendlyLinkController"})
public class FriendlyLinkController
extends BaseController {
    private static final Logger logger = Logger.getLogger(FriendlyLinkController.class);
    @Autowired
    private FriendlyLinkServiceI friendlyLinkService;
    @Autowired
    private SystemService systemService;
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @RequestMapping(params={"friendlyLink"})
    public ModelAndView friendlyLink(HttpServletRequest request) {
        ModelAndView mv = new ModelAndView();
        mv.addObject("lang", (Object)(request.getParameter("lang") == null ? "ZH" : request.getParameter("lang")));
        mv.setViewName("weixin/cms/friendly/friendlyLinkList");
        return mv;
    }

    @RequestMapping(params={"datagrid"})
    public void datagrid(FriendlyLinkEntity friendlyLink, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
        CriteriaQuery cq = new CriteriaQuery(FriendlyLinkEntity.class, dataGrid);
        cq.eq("accountid", (Object)ResourceUtil.getShangJiaAccountId());
        HqlGenerateUtil.installHql((CriteriaQuery)cq, (Object)friendlyLink, (Map)request.getParameterMap());
        this.friendlyLinkService.getDataGridReturn(cq, true);
        TagUtil.datagrid((HttpServletResponse)response, (DataGrid)dataGrid);
    }

    @RequestMapping(params={"del"})
    @ResponseBody
    public AjaxJson del(FriendlyLinkEntity friendlyLink, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        friendlyLink = (FriendlyLinkEntity)this.systemService.getEntity(FriendlyLinkEntity.class, (Serializable)((Object)friendlyLink.getId()));
        this.message = "\u53cb\u60c5\u94fe\u63a5\u5220\u9664\u6210\u529f";
        this.friendlyLinkService.delete(friendlyLink);
        this.systemService.addLog(this.message, Globals.Log_Type_DEL, Globals.Log_Leavel_INFO);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"save"})
    @ResponseBody
    public AjaxJson save(FriendlyLinkEntity friendlyLink, HttpServletRequest request) {
        AjaxJson j = new AjaxJson();
        if (StringUtil.isNotEmpty((Object)friendlyLink.getId())) {
            this.message = "\u53cb\u60c5\u94fe\u63a5\u66f4\u65b0\u6210\u529f";
            FriendlyLinkEntity t = (FriendlyLinkEntity)this.friendlyLinkService.get(FriendlyLinkEntity.class, (Serializable)((Object)friendlyLink.getId()));
            try {
                MyBeanUtils.copyBeanNotNull2Bean((Object)friendlyLink, (Object)t);
                this.friendlyLinkService.saveOrUpdate(t);
                this.systemService.addLog(this.message, Globals.Log_Type_UPDATE, Globals.Log_Leavel_INFO);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.message = "\u53cb\u60c5\u94fe\u63a5\u66f4\u65b0\u5931\u8d25";
            }
        } else {
            this.message = "\u53cb\u60c5\u94fe\u63a5\u6dfb\u52a0\u6210\u529f";
            friendlyLink.setLinkCount(0);
            this.friendlyLinkService.save(friendlyLink);
            this.systemService.addLog(this.message, Globals.Log_Type_INSERT, Globals.Log_Leavel_INFO);
        }
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("friendlyLinkId", friendlyLink.getId());
        j.setAttributes(attr);
        j.setMsg(this.message);
        return j;
    }

    @RequestMapping(params={"uploadImg"}, method={RequestMethod.POST})
    @ResponseBody
    public AjaxJson uploadImg(HttpServletRequest request, HttpServletResponse response, FriendlyLinkEntity friendlyLink) {
        AjaxJson j = new AjaxJson();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String friendLinkId = request.getParameter("friendlyLinkId");
        FriendlyLinkEntity tmp = (FriendlyLinkEntity)this.systemService.getEntity(FriendlyLinkEntity.class, (Serializable)((Object)friendLinkId));
        UploadFile uploadFile = new UploadFile(request, (Object)tmp);
        uploadFile.setCusPath("files");
        uploadFile.setByteField(null);
        friendlyLink = (FriendlyLinkEntity)this.systemService.uploadFile(uploadFile);
        attributes.put("fileKey", friendlyLink.getId());
        return j;
    }

    @RequestMapping(params={"addorupdate"})
    public ModelAndView addorupdate(FriendlyLinkEntity friendlyLink, HttpServletRequest req) {
        if (StringUtil.isNotEmpty((Object)friendlyLink.getId())) {
            friendlyLink = (FriendlyLinkEntity)this.friendlyLinkService.getEntity(FriendlyLinkEntity.class, (Serializable)((Object)friendlyLink.getId()));
            req.setAttribute("friendlyLinkPage", (Object)friendlyLink);
        }
        ModelAndView mv = new ModelAndView();
        mv.addObject("lang", (Object)req.getParameter("lang"));
        mv.setViewName("weixin/cms/friendly/friendlyLink");
        return mv;
    }
}

